/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzake;
import com.google.android.gms.internal.ads.zzakf;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzauk;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;

@zzaer
public final class zzakd {
    private final AtomicReference<ThreadPoolExecutor> zzcqz = new AtomicReference<Object>(null);
    private final Object zzcra = new Object();
    @GuardedBy(value="mGmpAppIdLock")
    @Nullable
    private String zzcrb = null;
    @GuardedBy(value="mGmpAppIdLock")
    @Nullable
    private String zzcrc = null;
    @VisibleForTesting
    private final AtomicBoolean zzcrd = new AtomicBoolean(false);
    @VisibleForTesting
    private final AtomicInteger zzcre = new AtomicInteger(-1);
    private final AtomicReference<Object> zzcrf = new AtomicReference<Object>(null);
    private final AtomicReference<Object> zzcrg = new AtomicReference<Object>(null);
    private ConcurrentMap<String, Method> zzcrh = new ConcurrentHashMap<String, Method>(9);
    private final AtomicReference<zzauk> zzcri = new AtomicReference<Object>(null);
    @GuardedBy(value="proxyReference")
    private final List<FutureTask> zzcrj = new ArrayList<FutureTask>();

    /*
     * Unable to fully structure code
     */
    public final boolean zzu(Context var1_1) {
        block4: {
            var2_2 = zznw.zzbat;
            if (!((Boolean)zzkd.zzjd().zzd(var2_2)).booleanValue() || this.zzcrd.get()) {
                return false;
            }
            var2_2 = zznw.zzbbc;
            if (((Boolean)zzkd.zzjd().zzd(var2_2)).booleanValue()) {
                return true;
            }
            if (this.zzcre.get() != -1) break block4;
            zzkd.zziz();
            var3_3 = var1_1;
            if (zzaoa.zzc((Context)var3_3, (int)12451000)) ** GOTO lbl-1000
            zzkd.zziz();
            if (zzaoa.zzbg((Context)var1_1)) {
                zzalg.zzdp((String)"Google Play Service is out of date, the Google Mobile Ads SDK will not integrate with Firebase. Admob/Firebase integration requires updated Google Play Service.");
                this.zzcre.set(0);
            } else lbl-1000:
            // 2 sources

            {
                this.zzcre.set(1);
            }
        }
        return this.zzcre.get() == 1;
    }

    public final void zzc(Context context, String string2) {
        if (!this.zzu(context)) {
            return;
        }
        this.zzb(context, string2, "beginAdUnitExposure");
    }

    public final void zzd(Context context, String string2) {
        if (!this.zzu(context)) {
            return;
        }
        this.zzb(context, string2, "endAdUnitExposure");
    }

    public final String zzv(Context context) {
        if (!this.zzu(context)) {
            return "";
        }
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzcrf, true)) {
            return "";
        }
        try {
            String string2 = (String)this.zzj(context, "getCurrentScreenName").invoke(this.zzcrf.get(), new Object[0]);
            if (string2 == null) {
                string2 = (String)this.zzj(context, "getCurrentScreenClass").invoke(this.zzcrf.get(), new Object[0]);
            }
            if (string2 != null) {
                return string2;
            }
            return "";
        }
        catch (Exception exception) {
            this.zza(exception, "getCurrentScreenName", false);
            return "";
        }
    }

    public final void zze(Context context, String string2) {
        if (!this.zzu(context)) {
            return;
        }
        if (!(context instanceof Activity)) {
            return;
        }
        if (!this.zza(context, "com.google.firebase.analytics.FirebaseAnalytics", this.zzcrg, false)) {
            return;
        }
        Method method = this.zzk(context, "setCurrentScreen");
        try {
            Activity activity = (Activity)context;
            method.invoke(this.zzcrg.get(), activity, string2, context.getPackageName());
            return;
        }
        catch (Exception exception) {
            this.zza(exception, "setCurrentScreen", false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzw(Context context) {
        if (!this.zzu(context)) {
            return null;
        }
        Object object = this.zzcra;
        synchronized (object) {
            if (this.zzcrb != null) {
                return this.zzcrb;
            }
            this.zzcrb = (String)this.zza("getGmpAppId", context);
            return this.zzcrb;
        }
    }

    @Nullable
    public final String zzx(Context context) {
        if (!this.zzu(context)) {
            return null;
        }
        zznl zznl2 = zznw.zzbay;
        long l = (Long)zzkd.zzjd().zzd(zznl2);
        if (l < 0L) {
            return (String)this.zza("getAppInstanceId", context);
        }
        zzakd zzakd2 = this;
        if (zzakd2.zzcqz.get() == null) {
            Object object = zznw.zzbaz;
            int n = (Integer)zzkd.zzjd().zzd(object);
            object = zznw.zzbaz;
            int n2 = (Integer)zzkd.zzjd().zzd(object);
            object = zzakd2;
            zzakd2.zzcqz.compareAndSet(null, new ThreadPoolExecutor(n, n2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), new zzakf((zzakd)object)));
        }
        Future future = zzakd2.zzcqz.get().submit(new zzake(this, context));
        try {
            return (String)future.get(l, TimeUnit.MILLISECONDS);
        }
        catch (Exception exception) {
            future.cancel(true);
            if (exception instanceof TimeoutException) {
                return "TIME_OUT";
            }
            return null;
        }
    }

    @Nullable
    public final String zzy(Context context) {
        if (!this.zzu(context)) {
            return null;
        }
        Object object = this.zza("generateEventId", context);
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String zzz(Context context) {
        if (!this.zzu(context)) {
            return null;
        }
        Object object = this.zzcra;
        synchronized (object) {
            if (this.zzcrc != null) {
                return this.zzcrc;
            }
            this.zzcrc = "fa";
            return this.zzcrc;
        }
    }

    public final void zzf(Context context, String string2) {
        this.zza(context, "_ac", string2);
    }

    public final void zzg(Context context, String string2) {
        this.zza(context, "_ai", string2);
    }

    public final void zzh(Context context, String string2) {
        this.zza(context, "_aq", string2);
    }

    public final void zza(Context context, String string2, String string3, String string4, int n) {
        if (!this.zzu(context)) {
            return;
        }
        Bundle bundle = zzakd.zzd(string2, false);
        bundle.putString("_ai", string3);
        bundle.putString("type", string4);
        bundle.putInt("value", n);
        this.zzb(context, "_ar", bundle);
        zzalg.v(new StringBuilder(75 + String.valueOf(string4).length()).append("Log a Firebase reward video event, reward type: ").append(string4).append(", reward value: ").append(n).toString());
    }

    public final void zza(Context context, String string2, String string3) {
        if (!this.zzu(context)) {
            return;
        }
        Bundle bundle = zzakd.zzd(string3, "_ac".equals(string2));
        this.zzb(context, string2, bundle);
    }

    private final void zzb(Context context, String string2, Bundle bundle) {
        if (!this.zzu(context)) {
            return;
        }
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzcrf, true)) {
            return;
        }
        Method method = this.zzaa(context);
        try {
            method.invoke(this.zzcrf.get(), "am", string2, bundle);
            return;
        }
        catch (Exception exception) {
            this.zza(exception, "logEventInternal", true);
            return;
        }
    }

    private static Bundle zzd(String string2, boolean bl) {
        Bundle bundle = new Bundle();
        try {
            bundle.putLong("_aeid", Long.parseLong(string2));
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            String string3 = String.valueOf(string2);
            zzalg.zzb((String)(string3.length() != 0 ? "Invalid event ID: ".concat(string3) : new String("Invalid event ID: ")), (Throwable)runtimeException);
        }
        if (bl) {
            bundle.putInt("_r", 1);
        }
        return bundle;
    }

    private final Method zzaa(Context context) {
        Method method = (Method)this.zzcrh.get("logEventInternal");
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod("logEventInternal", String.class, String.class, Bundle.class);
            this.zzcrh.put("logEventInternal", method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, "logEventInternal", true);
            return null;
        }
    }

    private final Method zzi(Context context, String string2) {
        Method method = (Method)this.zzcrh.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod(string2, String.class);
            this.zzcrh.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final Method zzj(Context context, String string2) {
        Method method = (Method)this.zzcrh.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.android.gms.measurement.AppMeasurement").getDeclaredMethod(string2, new Class[0]);
            this.zzcrh.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final Method zzk(Context context, String string2) {
        Method method = (Method)this.zzcrh.get(string2);
        if (method != null) {
            return method;
        }
        try {
            method = context.getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics").getDeclaredMethod(string2, Activity.class, String.class, String.class);
            this.zzcrh.put(string2, method);
            return method;
        }
        catch (Exception exception) {
            this.zza(exception, string2, false);
            return null;
        }
    }

    private final void zzb(Context context, String string2, String string3) {
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzcrf, true)) {
            return;
        }
        Method method = this.zzi(context, string3);
        try {
            method.invoke(this.zzcrf.get(), string2);
            zzalg.v(new StringBuilder(37 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Invoke Firebase method ").append(string3).append(", Ad Unit Id: ").append(string2).toString());
            return;
        }
        catch (Exception exception) {
            this.zza(exception, string3, false);
            return;
        }
    }

    private final Object zza(String string2, Context context) {
        Object object = null;
        if (!this.zza(context, "com.google.android.gms.measurement.AppMeasurement", this.zzcrf, true)) {
            return null;
        }
        Method method = this.zzj(context, string2);
        try {
            object = method.invoke(this.zzcrf.get(), new Object[0]);
        }
        catch (Exception exception) {
            this.zza(exception, string2, true);
        }
        return object;
    }

    private final void zza(Exception exception, String string2, boolean bl) {
        if (!this.zzcrd.get()) {
            zzalg.zzdp((String)new StringBuilder(30 + String.valueOf(string2).length()).append("Invoke Firebase method ").append(string2).append(" error.").toString());
            if (bl) {
                zzalg.zzdp((String)"The Google Mobile Ads SDK will not integrate with Firebase. Admob/Firebase integration requires the latest Firebase SDK jar, but Firebase SDK is either missing or out of date");
                this.zzcrd.set(true);
            }
        }
    }

    private final boolean zza(Context context, String string2, AtomicReference<Object> atomicReference, boolean bl) {
        if (atomicReference.get() == null) {
            try {
                Method method = context.getClassLoader().loadClass(string2).getDeclaredMethod("getInstance", Context.class);
                atomicReference.compareAndSet(null, method.invoke(null, context));
            }
            catch (Exception exception) {
                this.zza(exception, "getInstance", bl);
                return false;
            }
        }
        return true;
    }

    final /* synthetic */ String zzab(Context context) throws Exception {
        return (String)this.zza("getAppInstanceId", context);
    }
}

