/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzarc;
import com.google.android.gms.internal.ads.zzard;
import javax.annotation.concurrent.GuardedBy;

@zzaer
final class zzarb
implements SensorEventListener {
    private final SensorManager zzdcl;
    private final Object zzdcm;
    private final Display zzdcn;
    private final float[] zzdco;
    private final float[] zzdcp;
    @GuardedBy(value="mSensorThreadLock")
    private float[] zzdcq;
    private Handler zzdcr;
    private zzard zzdcs;

    zzarb(Context context) {
        this.zzdcl = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzdcn = windowManager.getDefaultDisplay();
        this.zzdco = new float[9];
        this.zzdcp = new float[9];
        this.zzdcm = new Object();
    }

    final void start() {
        if (this.zzdcr != null) {
            return;
        }
        Sensor sensor = this.zzdcl.getDefaultSensor(11);
        if (sensor == null) {
            zzalg.e((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzdcr = new Handler(handlerThread.getLooper());
        if (!this.zzdcl.registerListener((SensorEventListener)this, sensor, 0, this.zzdcr)) {
            zzalg.e((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzdcr == null) {
            return;
        }
        this.zzdcl.unregisterListener((SensorEventListener)this);
        this.zzdcr.post((Runnable)new zzarc(this));
        this.zzdcr = null;
    }

    final void zza(zzard zzard2) {
        this.zzdcs = zzard2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzarb zzarb2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzarb2.zzdcm;
            synchronized (object) {
                if (zzarb2.zzdcq == null) {
                    zzarb2.zzdcq = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzarb2.zzdco, (float[])fArray);
            switch (zzarb2.zzdcn.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzarb2.zzdco, (int)2, (int)129, (float[])zzarb2.zzdcp);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzarb2.zzdco, (int)129, (int)130, (float[])zzarb2.zzdcp);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzarb2.zzdco, (int)130, (int)1, (float[])zzarb2.zzdcp);
                    break;
                }
                default: {
                    System.arraycopy(zzarb2.zzdco, 0, zzarb2.zzdcp, 0, 9);
                }
            }
            zzarb2.zzg(1, 3);
            zzarb2.zzg(2, 6);
            zzarb2.zzg(5, 7);
            Object object2 = zzarb2.zzdcm;
            synchronized (object2) {
                System.arraycopy(zzarb2.zzdcp, 0, zzarb2.zzdcq, 0, 9);
            }
            if (zzarb2.zzdcs != null) {
                zzarb2.zzdcs.zzoy();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzdcm;
        synchronized (object) {
            if (this.zzdcq == null) {
                return false;
            }
            System.arraycopy(this.zzdcq, 0, fArray, 0, this.zzdcq.length);
            return true;
        }
    }

    private final void zzg(int n, int n2) {
        float f = this.zzdcp[n];
        this.zzdcp[n] = this.zzdcp[n2];
        this.zzdcp[n2] = f;
    }
}

