/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.os.SystemClock;
import android.text.TextUtils;
import android.view.MotionEvent;
import com.google.android.gms.ads.internal.gmsg.zzu;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzany;
import com.google.android.gms.internal.ads.zzaoa;
import com.google.android.gms.internal.ads.zzaqr;
import com.google.android.gms.internal.ads.zzaqx;
import com.google.android.gms.internal.ads.zzarf;
import com.google.android.gms.internal.ads.zzarg;
import com.google.android.gms.internal.ads.zzasw;
import com.google.android.gms.internal.ads.zzkd;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@zzaer
public final class zzarm
implements zzu<zzarg> {
    private boolean zzdeu;

    private static int zza(Context context, Map<String, String> map, String string2, int n) {
        String string3 = map.get(string2);
        int n2 = n;
        if (string3 != null) {
            try {
                zzkd.zziz();
                n2 = zzaoa.zza((Context)context, (int)Integer.parseInt(string3));
            }
            catch (NumberFormatException numberFormatException) {
                zzalg.zzdp((String)new StringBuilder(34 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Could not parse ").append(string2).append(" in a video GMSG: ").append(string3).toString());
            }
        }
        return n2;
    }

    private static void zza(zzaqr zzaqr2, Map<String, String> map) {
        String string2 = map.get("minBufferMs");
        String string3 = map.get("maxBufferMs");
        String string4 = map.get("bufferForPlaybackMs");
        String string5 = map.get("bufferForPlaybackAfterRebufferMs");
        try {
            if (string2 != null) {
                Integer.parseInt(string2);
            }
            if (string3 != null) {
                Integer.parseInt(string3);
            }
            if (string4 != null) {
                Integer.parseInt(string4);
            }
            if (string5 != null) {
                Integer.parseInt(string5);
            }
            return;
        }
        catch (NumberFormatException numberFormatException) {
            zzalg.zzdp((String)String.format("Could not parse buffer parameters in loadControl video GMSG: (%s, %s)", string2, string3));
            return;
        }
    }

    @Override
    public final /* synthetic */ void zza(Object object, Map map) {
        Object object2;
        Object object3;
        Object object4;
        Map map2 = map;
        zzarg zzarg2 = (zzarg)object;
        zzarm zzarm2 = this;
        String string2 = (String)map2.get("action");
        if (string2 == null) {
            zzalg.zzdp((String)"Action missing from video GMSG.");
            return;
        }
        if (zzalg.isLoggable((int)3)) {
            object4 = new JSONObject(map2);
            object4.remove("google.afma.Notify_dt");
            object3 = object4.toString();
            zzalg.zzco((String)new StringBuilder(13 + String.valueOf(string2).length() + String.valueOf(object3).length()).append("Video GMSG: ").append(string2).append(" ").append((String)object3).toString());
        }
        if ("background".equals(string2)) {
            object4 = (String)map2.get("color");
            if (TextUtils.isEmpty((CharSequence)object4)) {
                zzalg.zzdp((String)"Color parameter missing from color video GMSG.");
                return;
            }
            try {
                int n = Color.parseColor((String)object4);
                zzarg2.setBackgroundColor(n);
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                zzalg.zzdp((String)"Invalid color parameter in video GMSG.");
                return;
            }
        }
        if ("decoderProps".equals(string2)) {
            object4 = (String)map2.get("mimeTypes");
            if (object4 == null) {
                zzalg.zzdp((String)"No MIME types specified for decoder properties inspection.");
                zzaqr.zza(zzarg2, "missingMimeTypes");
                return;
            }
            if (Build.VERSION.SDK_INT < 16) {
                zzalg.zzdp((String)"Video decoder properties available on API versions >= 16.");
                zzaqr.zza(zzarg2, "deficientApiVersion");
                return;
            }
            object3 = new HashMap();
            for (String string3 : ((String)object4).split(",")) {
                object3.put(string3, zzany.zzdi(string3.trim()));
            }
            zzaqr.zza(zzarg2, (Map<String, List<Map<String, Object>>>)object3);
            return;
        }
        object4 = zzarg2.zzuz();
        if (object4 == null) {
            zzalg.zzdp((String)"Could not get underlay container for a video GMSG.");
            return;
        }
        boolean bl = "new".equals(string2);
        boolean bl2 = "position".equals(string2);
        if (bl || bl2) {
            int n;
            Context context = zzarg2.getContext();
            int n2 = zzarm.zza(context, map2, "x", 0);
            int n3 = zzarm.zza(context, map2, "y", 0);
            int n4 = zzarm.zza(context, map2, "w", -1);
            int n5 = zzarm.zza(context, map2, "h", -1);
            n4 = Math.min(n4, zzarg2.zzvh() - n2);
            n5 = Math.min(n5, zzarg2.zzvg() - n3);
            try {
                n = Integer.parseInt((String)map2.get("player"));
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
            boolean bl3 = Boolean.parseBoolean((String)map2.get("spherical"));
            if (bl && ((zzaqx)object4).zzuv() == null) {
                zzarf zzarf2 = new zzarf((String)map2.get("flags"));
                ((zzaqx)object4).zza(n2, n3, n4, n5, n, bl3, zzarf2);
                zzaqr zzaqr2 = ((zzaqx)object4).zzuv();
                if (zzaqr2 != null) {
                    zzarm.zza(zzaqr2, map2);
                }
                return;
            }
            ((zzaqx)object4).zze(n2, n3, n4, n5);
            return;
        }
        zzasw zzasw2 = zzarg2.zzva();
        if (zzasw2 != null) {
            if ("timeupdate".equals(string2)) {
                object2 = (String)map2.get("currentTime");
                if (object2 == null) {
                    zzalg.zzdp((String)"currentTime parameter missing from timeupdate video GMSG.");
                    return;
                }
                try {
                    float f = Float.parseFloat((String)object2);
                    zzasw2.zzb(f);
                }
                catch (NumberFormatException numberFormatException) {
                    String string4 = String.valueOf(object2);
                    zzalg.zzdp((String)(string4.length() != 0 ? "Could not parse currentTime parameter from timeupdate video GMSG: ".concat(string4) : new String("Could not parse currentTime parameter from timeupdate video GMSG: ")));
                }
            } else if ("skip".equals(string2)) {
                zzasw2.zzxg();
            }
        }
        if ((object2 = ((zzaqx)object4).zzuv()) == null) {
            zzaqr.zza(zzarg2);
            return;
        }
        if ("click".equals(string2)) {
            Context context = zzarg2.getContext();
            int n = zzarm.zza(context, map2, "x", 0);
            int n6 = zzarm.zza(context, map2, "y", 0);
            long l = SystemClock.uptimeMillis();
            MotionEvent motionEvent = MotionEvent.obtain((long)l, (long)l, (int)0, (float)n, (float)n6, (int)0);
            ((zzaqr)object2).zzf(motionEvent);
            motionEvent.recycle();
            return;
        }
        if ("currentTime".equals(string2)) {
            String string5 = (String)map2.get("time");
            if (string5 == null) {
                zzalg.zzdp((String)"Time parameter missing from currentTime video GMSG.");
                return;
            }
            try {
                int n = (int)(Float.parseFloat(string5) * 1000.0f);
                ((zzaqr)object2).seekTo(n);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string6 = String.valueOf(string5);
                zzalg.zzdp((String)(string6.length() != 0 ? "Could not parse time parameter from currentTime video GMSG: ".concat(string6) : new String("Could not parse time parameter from currentTime video GMSG: ")));
                return;
            }
        }
        if ("hide".equals(string2)) {
            object2.setVisibility(4);
            return;
        }
        if ("load".equals(string2)) {
            ((zzaqr)object2).zzuo();
            return;
        }
        if ("loadControl".equals(string2)) {
            zzarm.zza((zzaqr)object2, map2);
            return;
        }
        if ("muted".equals(string2)) {
            if (Boolean.parseBoolean((String)map2.get("muted"))) {
                ((zzaqr)object2).zzup();
                return;
            }
            ((zzaqr)object2).zzuq();
            return;
        }
        if ("pause".equals(string2)) {
            ((zzaqr)object2).pause();
            return;
        }
        if ("play".equals(string2)) {
            ((zzaqr)object2).play();
            return;
        }
        if ("show".equals(string2)) {
            object2.setVisibility(0);
            return;
        }
        if ("src".equals(string2)) {
            ((zzaqr)object2).zzds((String)map2.get("src"));
            return;
        }
        if ("touchMove".equals(string2)) {
            Context context = zzarg2.getContext();
            int n = zzarm.zza(context, map2, "dx", 0);
            int n7 = zzarm.zza(context, map2, "dy", 0);
            ((zzaqr)object2).zza(n, n7);
            if (!zzarm2.zzdeu) {
                zzarg2.zzpa();
                zzarm2.zzdeu = true;
            }
            return;
        }
        if ("volume".equals(string2)) {
            String string7 = (String)map2.get("volume");
            if (string7 == null) {
                zzalg.zzdp((String)"Level parameter missing from volume video GMSG.");
                return;
            }
            try {
                float f = Float.parseFloat(string7);
                ((zzaqr)object2).setVolume(f);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                String string8 = String.valueOf(string7);
                zzalg.zzdp((String)(string8.length() != 0 ? "Could not parse volume parameter from volume video GMSG: ".concat(string8) : new String("Could not parse volume parameter from volume video GMSG: ")));
                return;
            }
        }
        if ("watermark".equals(string2)) {
            ((zzaqr)object2).zzur();
            return;
        }
        String string9 = String.valueOf(string2);
        zzalg.zzdp((String)(string9.length() != 0 ? "Unknown video action: ".concat(string9) : new String("Unknown video action: ")));
    }
}

