/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import com.google.android.gms.internal.ads.zzcp;
import com.google.android.gms.internal.ads.zzdb;
import com.google.android.gms.internal.ads.zzdi;
import com.google.android.gms.internal.ads.zzdl;
import com.google.android.gms.internal.ads.zzdm;
import java.lang.ref.WeakReference;

public final class zzdk
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final Handler zztc = new Handler(Looper.getMainLooper());
    private final Context zztd;
    private Application zzro;
    private final PowerManager zzte;
    private final KeyguardManager zztf;
    private final zzdb zzpw;
    private BroadcastReceiver zztg;
    private WeakReference<ViewTreeObserver> zzth;
    private WeakReference<View> zzti;
    private zzcp zztj;
    private boolean zztk = false;
    private int zztl = -1;
    private long zztm = -3L;

    public zzdk(zzdb zzdb2, View view) {
        this.zzpw = zzdb2;
        this.zztd = zzdb2.zzrx;
        this.zzte = (PowerManager)this.zztd.getSystemService("power");
        this.zztf = (KeyguardManager)this.zztd.getSystemService("keyguard");
        if (this.zztd instanceof Application) {
            this.zzro = (Application)this.zztd;
            this.zztj = new zzcp((Application)this.zztd, this);
        }
        this.zzd(view);
    }

    final void zzd(View view) {
        View view2 = this.zzti != null ? (View)this.zzti.get() : null;
        if (view2 != null) {
            view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzf(view2);
        }
        this.zzti = new WeakReference<View>(view);
        if (view != null) {
            View view3 = view;
            if (view3.getWindowToken() != null || view3.getWindowVisibility() != 8) {
                this.zze(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zztm = -2L;
            return;
        }
        this.zztm = -3L;
    }

    private final void zzao() {
        zztc.post((Runnable)new zzdl(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zztl = -1;
        this.zze(view);
        this.zzaq();
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zztl = -1;
        this.zzaq();
        this.zzao();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzti == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzti.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zztl = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzaq();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzaq();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzaq();
        this.zzao();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzaq();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzaq();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzaq();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzaq();
    }

    public final void onGlobalLayout() {
        this.zzaq();
    }

    public final void onScrollChanged() {
        this.zzaq();
    }

    public final long zzap() {
        if (this.zztm == -2L && this.zzti.get() == null) {
            this.zztm = -3L;
        }
        return this.zztm;
    }

    private final void zzaq() {
        boolean bl;
        Window window;
        WindowManager.LayoutParams layoutParams;
        View view;
        Activity activity;
        if (this.zzti == null) {
            return;
        }
        View view2 = (View)this.zzti.get();
        if (view2 == null) {
            this.zztm = -3L;
            this.zztk = false;
            return;
        }
        boolean bl2 = view2.getGlobalVisibleRect(new Rect());
        boolean bl3 = view2.getLocalVisibleRect(new Rect());
        boolean bl4 = this.zzpw.zzai() || this.zztf.inKeyguardRestrictedInputMode() && (activity = zzdi.zzc(view = view2)) != null && (layoutParams = (window = activity.getWindow()) == null ? null : window.getAttributes()) != null && (layoutParams.flags & 0x80000) != 0;
        int n = view2.getWindowVisibility();
        int n2 = this.zztl != -1 ? this.zztl : n;
        boolean bl5 = bl = view2.getVisibility() == 0 && view2.isShown() && this.zzte.isScreenOn() && bl4 && bl3 && bl2 && n2 == 0;
        if (this.zztk != bl) {
            this.zztm = bl ? SystemClock.elapsedRealtime() : -2L;
            this.zztk = bl;
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzth = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzdk zzdk2 = this;
        if (zzdk2.zztg == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzdk2.zztg = new zzdm(zzdk2);
            zzdk2.zztd.registerReceiver(zzdk2.zztg, intentFilter);
        }
        if (this.zzro != null) {
            try {
                this.zzro.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zztj);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzth != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzth.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzth = null;
            }
        }
        catch (Exception exception) {}
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {}
        zzdk zzdk2 = this;
        if (zzdk2.zztg != null) {
            try {
                zzdk2.zztd.unregisterReceiver(zzdk2.zztg);
            }
            catch (Exception exception) {}
            zzdk2.zztg = null;
        }
        if (this.zzro != null) {
            try {
                this.zzro.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zztj);
                return;
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ void zza(zzdk zzdk2) {
        zzdk2.zzaq();
    }
}

