/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import com.google.android.gms.ads.internal.zzbv;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaer;
import com.google.android.gms.internal.ads.zzalg;
import com.google.android.gms.internal.ads.zzasg;
import com.google.android.gms.internal.ads.zzgh;
import com.google.android.gms.internal.ads.zzgi;
import com.google.android.gms.internal.ads.zzgo;
import com.google.android.gms.internal.ads.zzgp;
import com.google.android.gms.internal.ads.zzgr;
import com.google.android.gms.internal.ads.zzkd;
import com.google.android.gms.internal.ads.zznl;
import com.google.android.gms.internal.ads.zznw;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@zzaer
@ParametersAreNonnullByDefault
@TargetApi(value=14)
public final class zzgn
extends Thread {
    private boolean mStarted = false;
    private boolean zzaiq = false;
    private boolean zzbm = false;
    private final Object mLock;
    private final zzgi zzair;
    private final int zzais;
    private final int zzahp;
    private final int zzait;
    private final int zzahr;
    private final int zzaiu;
    private final int zzaiv;
    private final int zzaiw;
    private final int zzaix;
    private final String zzaiy;
    private final boolean zzaiz;

    public zzgn() {
        this(new zzgi());
    }

    @VisibleForTesting
    private zzgn(zzgi zzgi2) {
        this.zzair = zzgi2;
        this.mLock = new Object();
        zznl zznl2 = zznw.zzbae;
        this.zzahp = (Integer)zzkd.zzjd().zzd(zznl2);
        zznl2 = zznw.zzbaf;
        this.zzait = (Integer)zzkd.zzjd().zzd(zznl2);
        zznl2 = zznw.zzbag;
        this.zzahr = (Integer)zzkd.zzjd().zzd(zznl2);
        zznl2 = zznw.zzbah;
        this.zzaiu = (Integer)zzkd.zzjd().zzd(zznl2);
        zznl2 = zznw.zzbaj;
        this.zzaiv = (Integer)zzkd.zzjd().zzd(zznl2);
        zznl2 = zznw.zzbak;
        this.zzaiw = (Integer)zzkd.zzjd().zzd(zznl2);
        zznl2 = zznw.zzbal;
        this.zzaix = (Integer)zzkd.zzjd().zzd(zznl2);
        zznl2 = zznw.zzbai;
        this.zzais = (Integer)zzkd.zzjd().zzd(zznl2);
        zznl2 = zznw.zzban;
        this.zzaiy = (String)zzkd.zzjd().zzd(zznl2);
        zznl2 = zznw.zzbao;
        this.zzaiz = (Boolean)zzkd.zzjd().zzd(zznl2);
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzgw() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mStarted) {
                zzalg.zzco((String)"Content hash thread already started, quiting...");
                return;
            }
            this.mStarted = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzgn.zzgx()) {
                    object = zzbv.zzen().getActivity();
                    if (object == null) {
                        zzalg.zzco((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzgz();
                    } else {
                        Activity activity = object;
                        zzgn zzgn2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzbv.zzeo().zza(exception, "ContentFetchTask.extractContent");
                                zzalg.zzco((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                View view2 = view;
                                zzgn zzgn3 = zzgn2;
                                if (view2 != null) {
                                    view2.post((Runnable)new zzgo(zzgn3, view2));
                                }
                            }
                        }
                    }
                } else {
                    zzalg.zzco((String)"ContentFetchTask: sleeping");
                    this.zzgz();
                }
                Thread.sleep(this.zzais * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzalg.zzb((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzalg.zzb((String)"Error in ContentFetchTask", (Throwable)exception);
                zzbv.zzeo().zza(exception, "ContentFetchTask.run");
            }
            object = this.mLock;
            synchronized (object) {
                while (this.zzaiq) {
                    try {
                        zzalg.zzco((String)"ContentFetchTask: waiting");
                        this.mLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @VisibleForTesting
    final void zzk(View view) {
        try {
            zzgh zzgh2 = new zzgh(this.zzahp, this.zzait, this.zzahr, this.zzaiu, this.zzaiv, this.zzaiw, this.zzaix);
            Context context = zzbv.zzen().getContext();
            if (context != null && !TextUtils.isEmpty((CharSequence)this.zzaiy)) {
                zznl zznl2 = zznw.zzbam;
                int n = context.getResources().getIdentifier((String)zzkd.zzjd().zzd(zznl2), "id", context.getPackageName());
                String string2 = (String)view.getTag(n);
                if (string2 != null && string2.equals(this.zzaiy)) {
                    return;
                }
            }
            zzgr zzgr2 = this.zza(view, zzgh2);
            zzgh2.zzgt();
            if (zzgr2.zzajh == 0 && zzgr2.zzaji == 0) {
                return;
            }
            if (zzgr2.zzaji == 0 && zzgh2.zzgu() == 0) {
                return;
            }
            if (zzgr2.zzaji == 0 && this.zzair.zza(zzgh2)) {
                return;
            }
            this.zzair.zzc(zzgh2);
            return;
        }
        catch (Exception exception) {
            zzalg.zzb((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            zzbv.zzeo().zza(exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    @VisibleForTesting
    private static boolean zzgx() {
        try {
            Context context = zzbv.zzen().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzbv.zzeo().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    @VisibleForTesting
    private final zzgr zza(@Nullable View view, zzgh zzgh2) {
        if (view == null) {
            return new zzgr(this, 0, 0);
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzgh2.zzb(string2, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzgr(this, 1, 0);
            }
            return new zzgr(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzasg)) {
            boolean bl2;
            zzgh2.zzgs();
            zzgh zzgh3 = zzgh2;
            WebView webView = (WebView)view;
            zzgn zzgn2 = this;
            if (!PlatformVersion.isAtLeastKitKat()) {
                bl2 = false;
            } else {
                zzgh3.zzgs();
                webView.post((Runnable)new zzgp(zzgn2, zzgh3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzgr(this, 0, 1);
            }
            return new zzgr(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzgr zzgr2 = this.zza(viewGroup.getChildAt(i), zzgh2);
                n += zzgr2.zzajh;
                n2 += zzgr2.zzaji;
            }
            return new zzgr(this, n, n2);
        }
        return new zzgr(this, 0, 0);
    }

    @VisibleForTesting
    final void zza(zzgh zzgh2, WebView webView, String string2, boolean bl) {
        zzgh2.zzgr();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzaiz && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzgh2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzgh2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzgh2.zzgm()) {
                this.zzair.zzb(zzgh2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzalg.zzco((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzalg.zza((String)"Failed to get webview content.", (Throwable)throwable);
            zzbv.zzeo().zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzgh zzgy() {
        return this.zzair.zzgv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.mLock;
        synchronized (object) {
            this.zzaiq = false;
            this.mLock.notifyAll();
            zzalg.zzco((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzgz() {
        Object object = this.mLock;
        synchronized (object) {
            boolean bl = this.zzaiq = true;
            zzalg.zzco((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzha() {
        return this.zzaiq;
    }
}

