/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzu;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzyt;

@zzard
public final class zza {
    public static boolean zza(Context context, zzc zzc2, zzu zzu2) {
        String[] stringArray;
        if (zzc2 == null) {
            zzawz.zzep((String)"No intent data for launcher overlay.");
            return false;
        }
        zzacu.initialize((Context)context);
        if (zzc2.intent != null) {
            return zza.zza(context, zzc2.intent, zzu2);
        }
        Intent intent = new Intent();
        if (TextUtils.isEmpty((CharSequence)zzc2.url)) {
            zzawz.zzep((String)"Open GMSG did not contain a URL.");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.mimeType)) {
            intent.setDataAndType(Uri.parse((String)zzc2.url), zzc2.mimeType);
        } else {
            intent.setData(Uri.parse((String)zzc2.url));
        }
        intent.setAction("android.intent.action.VIEW");
        if (!TextUtils.isEmpty((CharSequence)zzc2.packageName)) {
            intent.setPackage(zzc2.packageName);
        }
        if (!TextUtils.isEmpty((CharSequence)zzc2.zzdjh)) {
            stringArray = zzc2.zzdjh.split("/", 2);
            if (stringArray.length < 2) {
                String string2 = String.valueOf(zzc2.zzdjh);
                zzawz.zzep((String)(string2.length() != 0 ? "Could not parse component name from open GMSG: ".concat(string2) : new String("Could not parse component name from open GMSG: ")));
                return false;
            }
            intent.setClassName(stringArray[0], stringArray[1]);
        }
        stringArray = zzc2.zzdji;
        if (!TextUtils.isEmpty((CharSequence)zzc2.zzdji)) {
            int n = 0;
            try {
                n = Integer.parseInt((String)stringArray);
            }
            catch (NumberFormatException numberFormatException) {
                zzawz.zzep((String)"Could not parse intent flags.");
            }
            intent.addFlags(n);
        }
        zzacj zzacj2 = zzacu.zzctz;
        if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
            intent.addFlags(0x10000000);
            intent.putExtra("android.support.customtabs.extra.user_opt_out", true);
        } else {
            zzacj2 = zzacu.zzcty;
            if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
                zzk.zzlg();
                zzaxi.zzb(context, intent);
            }
        }
        return zza.zza(context, intent, zzu2);
    }

    private static boolean zza(Context context, Intent intent, zzu zzu2) {
        try {
            String string2 = String.valueOf(intent.toURI());
            zzawz.zzds(string2.length() != 0 ? "Launching an intent: ".concat(string2) : new String("Launching an intent: "));
            zzk.zzlg();
            zzaxi.zza(context, intent);
            if (zzu2 != null) {
                zzu2.zztq();
            }
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzawz.zzep((String)activityNotFoundException.getMessage());
            return false;
        }
        return true;
    }
}

