/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzads;
import com.google.android.gms.internal.ads.zzase;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzazt;
import com.google.android.gms.internal.ads.zzyt;
import java.util.Locale;

public final class zzasf {
    private int zzdpe;
    private boolean zzdpm;
    private boolean zzdpn;
    private int zzdpr;
    private int zzdpv;
    private int zzdpw;
    private String zzdph;
    private int zzdps;
    private int zzdpt;
    private int zzdpu;
    private boolean zzdpz;
    private int zzdqa;
    private double zzdpx;
    private boolean zzdpy;
    private String zzdqb;
    private String zzdqc;
    private boolean zzdpf;
    private boolean zzdpg;
    private String zzdpi;
    private boolean zzdpj;
    private final boolean zzdpk;
    private boolean zzdpl;
    private String zzdpo;
    private String zzdpp;
    private float zzbtx;
    private int zzdlt;
    private int zzdlu;
    private String zzdpq;
    private boolean zzdqd;

    public zzasf(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzp(context);
        this.zzq(context);
        this.zzr(context);
        Locale locale = Locale.getDefault();
        this.zzdpf = zzasf.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzdpg = zzasf.zza(packageManager, "http://www.google.com") != null;
        this.zzdpi = locale.getCountry();
        zzyt.zzpa();
        this.zzdpj = zzazt.zzwx();
        this.zzdpk = DeviceProperties.isLatchsky((Context)context);
        this.zzdpl = DeviceProperties.isSidewinder((Context)context);
        this.zzdpo = locale.getLanguage();
        this.zzdpp = zzasf.zza(context, packageManager);
        this.zzdpq = zzasf.zzs(context);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzbtx = displayMetrics.density;
        this.zzdlt = displayMetrics.widthPixels;
        this.zzdlu = displayMetrics.heightPixels;
    }

    public zzasf(Context context, zzase zzase2) {
        this.zzp(context);
        this.zzq(context);
        this.zzr(context);
        Context context2 = context;
        zzasf zzasf2 = this;
        this.zzdqb = Build.FINGERPRINT;
        zzasf2.zzdqc = Build.DEVICE;
        zzasf2.zzdqd = PlatformVersion.isAtLeastIceCreamSandwichMR1() && zzads.zzj(context2);
        this.zzdpf = zzase2.zzdpf;
        this.zzdpg = zzase2.zzdpg;
        this.zzdpi = zzase2.zzdpi;
        this.zzdpj = zzase2.zzdpj;
        this.zzdpk = zzase2.zzdpk;
        this.zzdpl = zzase2.zzdpl;
        this.zzdpo = zzase2.zzdpo;
        this.zzdpp = zzase2.zzdpp;
        this.zzdpq = zzase2.zzdpq;
        this.zzbtx = zzase2.zzbtx;
        this.zzdlt = zzase2.zzdlt;
        this.zzdlu = zzase2.zzdlu;
    }

    private final void zzp(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            try {
                this.zzdpe = audioManager.getMode();
                this.zzdpm = audioManager.isMusicActive();
                this.zzdpn = audioManager.isSpeakerphoneOn();
                this.zzdpr = audioManager.getStreamVolume(3);
                this.zzdpv = audioManager.getRingerMode();
                this.zzdpw = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzk.zzlk().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzdpe = -2;
        this.zzdpm = false;
        this.zzdpn = false;
        this.zzdpr = 0;
        this.zzdpv = 2;
        this.zzdpw = 0;
    }

    @TargetApi(value=16)
    private final void zzq(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzdph = telephonyManager.getNetworkOperator();
        this.zzdpt = telephonyManager.getNetworkType();
        this.zzdpu = telephonyManager.getPhoneType();
        this.zzdps = -2;
        this.zzdpz = false;
        this.zzdqa = -1;
        zzk.zzlg();
        if (zzaxi.zzp(context, "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzdps = networkInfo.getType();
                this.zzdqa = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzdps = -1;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.zzdpz = connectivityManager.isActiveNetworkMetered();
            }
        }
    }

    private final void zzr(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzdpx = (float)n2 / (float)n3;
            this.zzdpy = n == 2 || n == 5;
            return;
        }
        this.zzdpx = -1.0;
        this.zzdpy = false;
    }

    private static String zzs(Context context) {
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zza(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzasf.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzk.zzlk().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzase zzty() {
        return new zzase(this.zzdpe, this.zzdpf, this.zzdpg, this.zzdph, this.zzdpi, this.zzdpj, this.zzdpk, this.zzdpl, this.zzdpm, this.zzdpn, this.zzdpo, this.zzdpp, this.zzdpq, this.zzdpr, this.zzdps, this.zzdpt, this.zzdpu, this.zzdpv, this.zzdpw, this.zzbtx, this.zzdlt, this.zzdlu, this.zzdpx, this.zzdpy, this.zzdpz, this.zzdqa, this.zzdqb, this.zzdqd, this.zzdqc);
    }
}

