/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzaur;
import com.google.android.gms.internal.ads.zzaus;
import com.google.android.gms.internal.ads.zzaut;
import com.google.android.gms.internal.ads.zzauu;
import com.google.android.gms.internal.ads.zzauv;
import com.google.android.gms.internal.ads.zzauy;
import com.google.android.gms.internal.ads.zzava;
import com.google.android.gms.internal.ads.zzavb;
import com.google.android.gms.internal.ads.zzavd;
import com.google.android.gms.internal.ads.zzave;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxg;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzayu;
import com.google.android.gms.internal.ads.zzbai;
import com.google.android.gms.internal.ads.zzbar;
import com.google.android.gms.internal.ads.zzbbh;
import com.google.android.gms.internal.ads.zzbbm;
import com.google.android.gms.internal.ads.zzdrw;
import com.google.android.gms.internal.ads.zzdsj;
import com.google.android.gms.internal.ads.zzdsk;
import com.google.android.gms.internal.ads.zzdsl;
import com.google.android.gms.internal.ads.zzdsm;
import com.google.android.gms.internal.ads.zzdsp;
import com.google.android.gms.internal.ads.zzdsq;
import com.google.android.gms.internal.ads.zzyt;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@zzard
@ParametersAreNonnullByDefault
public final class zzauq
implements zzavb {
    private static List<Future<Void>> zzdqz = Collections.synchronizedList(new ArrayList());
    private static ScheduledExecutorService zzdra = Executors.newSingleThreadScheduledExecutor();
    @GuardedBy(value="lock")
    private final zzdsj zzdrb;
    @GuardedBy(value="lock")
    private final LinkedHashMap<String, zzdsp> zzdrc;
    @GuardedBy(value="lock")
    private final List<String> zzdrd = new ArrayList<String>();
    @GuardedBy(value="lock")
    private final List<String> zzdre = new ArrayList<String>();
    private final Context zzlj;
    private final zzavd zzdrf;
    @VisibleForTesting
    private boolean zzdrg;
    private final zzauy zzdoc;
    private final zzave zzdrh;
    private final Object lock = new Object();
    private HashSet<String> zzdri = new HashSet();
    private boolean zzdrj = false;
    private boolean zzdrk = false;
    private boolean zzdrl = false;

    public zzauq(Context context, zzbai zzbai2, zzauy zzauy2, String string2, zzavd zzavd2) {
        Preconditions.checkNotNull((Object)((Object)zzauy2), (Object)"SafeBrowsing config is not present.");
        this.zzlj = context.getApplicationContext() != null ? context.getApplicationContext() : context;
        this.zzdrc = new LinkedHashMap();
        this.zzdrf = zzavd2;
        this.zzdoc = zzauy2;
        for (String string3 : this.zzdoc.zzdrv) {
            this.zzdri.add(string3.toLowerCase(Locale.ENGLISH));
        }
        this.zzdri.remove("cookie".toLowerCase(Locale.ENGLISH));
        String string4 = string2;
        zzbai zzbai3 = zzbai2;
        zzauq zzauq2 = this;
        zzdsj zzdsj2 = new zzdsj();
        new zzdsj().zzhrv = 8;
        zzdsj2.url = string4;
        zzdsj2.zzhrx = string4;
        zzdsj2.zzhrz = new zzdsk();
        zzdsj2.zzhrz.zzdrr = zzauq2.zzdoc.zzdrr;
        zzdsq zzdsq2 = new zzdsq();
        new zzdsq().zzhte = zzbai3.zzbsx;
        zzdsq2.zzhtg = Wrappers.packageManager((Context)zzauq2.zzlj).isCallerInstantApp();
        long l = GoogleApiAvailabilityLight.getInstance().getApkVersion(zzauq2.zzlj);
        if (l > 0L) {
            zzdsq2.zzhtf = l;
        }
        zzdsj2.zzhsj = zzdsq2;
        this.zzdrb = zzdsj2;
        this.zzdrh = new zzave(this.zzlj, this.zzdoc.zzdry, this);
    }

    @Override
    public final zzauy zzuc() {
        return this.zzdoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzdk(String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzdrb.zzhsb = string2;
            return;
        }
    }

    @Override
    public final boolean zzud() {
        return PlatformVersion.isAtLeastKitKat() && this.zzdoc.zzdrt && !this.zzdrk;
    }

    @Override
    public final void zzj(View view) {
        if (!this.zzdoc.zzdrt) {
            return;
        }
        if (this.zzdrk) {
            return;
        }
        zzk.zzlg();
        Bitmap bitmap = zzaxi.zzl(view);
        if (bitmap == null) {
            zzava.zzdp("Failed to capture the webview bitmap.");
            return;
        }
        this.zzdrk = true;
        zzaxi.zzd(new zzaut(this, bitmap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(String string2, Map<String, String> map, int n) {
        Object object = this.lock;
        synchronized (object) {
            if (n == 3) {
                this.zzdrl = true;
            }
            if (this.zzdrc.containsKey(string2)) {
                if (n == 3) {
                    this.zzdrc.get((Object)string2).zzhtc = n;
                }
                return;
            }
            zzdsp zzdsp2 = new zzdsp();
            new zzdsp().zzhtc = n;
            zzdsp2.zzhsw = this.zzdrc.size();
            zzdsp2.url = string2;
            zzdsp2.zzhsx = new zzdsm();
            if (this.zzdri.size() > 0 && map != null) {
                ArrayList<zzdsl> arrayList = new ArrayList<zzdsl>();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    try {
                        String string3 = entry.getKey() != null ? entry.getKey() : "";
                        String string4 = entry.getValue() != null ? entry.getValue() : "";
                        String string5 = string3.toLowerCase(Locale.ENGLISH);
                        if (!this.zzdri.contains(string5)) continue;
                        zzdsl zzdsl2 = new zzdsl();
                        new zzdsl().zzhsn = string3.getBytes("UTF-8");
                        zzdsl2.zzhso = string4.getBytes("UTF-8");
                        arrayList.add(zzdsl2);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        zzava.zzdp("Cannot convert string to bytes, skip header.");
                    }
                }
                zzdsl[] zzdslArray = new zzdsl[arrayList.size()];
                arrayList.toArray(zzdslArray);
                zzdsp2.zzhsx.zzhsq = zzdslArray;
            }
            this.zzdrc.put(string2, zzdsp2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzdl(String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzdrd.add(string2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void zzdm(String string2) {
        Object object = this.lock;
        synchronized (object) {
            this.zzdre.add(string2);
            return;
        }
    }

    @Override
    public final String[] zza(String[] stringArray) {
        return this.zzdrh.zzb(stringArray).toArray(new String[0]);
    }

    @Override
    public final void zzue() {
        this.zzdrj = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final zzdsp zzdn(String string2) {
        Object object = this.lock;
        synchronized (object) {
            return this.zzdrc.get(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzuf() {
        Object object = this.lock;
        synchronized (object) {
            zzbbh zzbbh2 = zzbar.zza(this.zzdrf.zza(this.zzlj, this.zzdrc.keySet()), new zzaur(this), zzbbm.zzeaf);
            zzbbh zzbbh3 = zzbar.zza(zzbbh2, 10L, TimeUnit.SECONDS, zzdra);
            zzbar.zza(zzbbh2, new zzauu(this, zzbbh3), zzbbm.zzeaf);
            zzdqz.add(zzbbh3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final zzbbh<Void> zzug() {
        if (!(this.zzdrg && this.zzdoc.zzdrx || this.zzdrl && this.zzdoc.zzdrw || !this.zzdrg && this.zzdoc.zzdru)) {
            return zzbar.zzm(null);
        }
        Object object = this.lock;
        synchronized (object) {
            this.zzdrb.zzhsa = new zzdsp[this.zzdrc.size()];
            this.zzdrc.values().toArray(this.zzdrb.zzhsa);
            this.zzdrb.zzhsk = this.zzdrd.toArray(new String[0]);
            this.zzdrb.zzhsl = this.zzdre.toArray(new String[0]);
            if (zzava.isEnabled()) {
                zzdsp[] zzdspArray = this.zzdrb.url;
                String string2 = this.zzdrb.zzhsb;
                StringBuilder stringBuilder = new StringBuilder(new StringBuilder(53 + String.valueOf(zzdspArray).length() + String.valueOf(string2).length()).append("Sending SB report\n  url: ").append((String)zzdspArray).append("\n  clickUrl: ").append(string2).append("\n  resources: \n").toString());
                zzdspArray = this.zzdrb.zzhsa;
                int n = this.zzdrb.zzhsa.length;
                for (int i = 0; i < n; ++i) {
                    zzdsp zzdsp2 = zzdspArray[i];
                    stringBuilder.append("    [");
                    stringBuilder.append(zzdsp2.zzhtd.length);
                    stringBuilder.append("] ");
                    stringBuilder.append(zzdsp2.url);
                }
                zzava.zzdp(stringBuilder.toString());
            }
            String string3 = this.zzdoc.zzdrs;
            byte[] byArray = zzdrw.zza(this.zzdrb);
            zzauq zzauq2 = this;
            zzbbh<String> zzbbh2 = new zzayu(zzauq2.zzlj).zza(1, string3, null, byArray);
            if (zzava.isEnabled()) {
                zzbbh2.zza(new zzauv(zzauq2), zzaxg.zzdvp);
            }
            return zzbar.zza(zzbbh2, zzaus.zzdrn, zzbbm.zzeaf);
        }
    }

    static final /* synthetic */ Void zzdo(String string2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ zzbbh zzh(Map map) throws Exception {
        try {
            Map map2;
            Map map3 = map2 = map;
            zzauq zzauq2 = this;
            if (map3 != null) {
                for (String string2 : map3.keySet()) {
                    String string3 = (String)map3.get(string2);
                    JSONArray jSONArray = new JSONObject(string3).optJSONArray("matches");
                    if (jSONArray == null) continue;
                    Object object = zzauq2.lock;
                    synchronized (object) {
                        int n = jSONArray.length();
                        zzdsp zzdsp2 = zzauq2.zzdn(string2);
                        if (zzdsp2 == null) {
                            String string4 = String.valueOf(string2);
                            zzava.zzdp(string4.length() != 0 ? "Cannot find the corresponding resource object for ".concat(string4) : new String("Cannot find the corresponding resource object for "));
                            continue;
                        }
                        zzdsp2.zzhtd = new String[n];
                        for (int i = 0; i < n; ++i) {
                            zzdsp2.zzhtd[i] = jSONArray.getJSONObject(i).getString("threat_type");
                        }
                        zzauq2.zzdrg = zzauq2.zzdrg | n > 0;
                    }
                }
            }
            if (this.zzdrg) {
                Object object = this.lock;
                synchronized (object) {
                    this.zzdrb.zzhrv = 9;
                }
            }
            return this.zzug();
        }
        catch (JSONException jSONException) {
            JSONException jSONException2 = jSONException;
            String string5 = "Failed to get SafeBrowsing metadata";
            zzacj zzacj2 = zzacu.zzctj;
            if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
                zzawz.zzb((String)string5, (Throwable)jSONException2);
            }
            return zzbar.zzd(new Exception("Safebrowsing report transmission failed."));
        }
    }

    static /* synthetic */ Object zza(zzauq zzauq2) {
        return zzauq2.lock;
    }

    static /* synthetic */ zzdsj zzb(zzauq zzauq2) {
        return zzauq2.zzdrb;
    }

    static /* synthetic */ List zzuh() {
        return zzdqz;
    }
}

