/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzbbh;
import com.google.android.gms.internal.ads.zzbbi;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzard
@ParametersAreNonnullByDefault
public class zzbbr<T>
implements zzbbh<T> {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private T value;
    @GuardedBy(value="lock")
    private Throwable zzeal;
    @GuardedBy(value="lock")
    private boolean zzeam;
    @GuardedBy(value="lock")
    private boolean zzean;
    private final zzbbi zzdzy = new zzbbi();

    @Override
    public final void zza(Runnable runnable, Executor executor) {
        this.zzdzy.zza(runnable, executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void set(@Nullable T t) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzean) {
                return;
            }
            if (this.zzxf()) {
                zzk.zzlk().zzb(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.set");
                return;
            }
            this.zzeam = true;
            this.value = t;
            this.lock.notifyAll();
        }
        this.zzdzy.zzxd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(Throwable throwable) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzean) {
                return;
            }
            if (this.zzxf()) {
                zzk.zzlk().zzb(new IllegalStateException("Provided SettableFuture with multiple values."), "SettableFuture.setException");
                return;
            }
            this.zzeal = throwable;
            this.lock.notifyAll();
        }
        this.zzdzy.zzxd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() throws CancellationException, ExecutionException, InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.zzxf()) {
                this.lock.wait();
            }
            if (this.zzeal != null) {
                throw new ExecutionException(this.zzeal);
            }
            if (this.zzean) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long l, TimeUnit timeUnit) throws CancellationException, ExecutionException, InterruptedException, TimeoutException {
        Object object = this.lock;
        synchronized (object) {
            long l2 = timeUnit.toMillis(l);
            long l3 = System.currentTimeMillis();
            long l4 = l3 + l2;
            while (!this.zzxf() && l3 < l4) {
                this.lock.wait(l4 - l3);
                l3 = System.currentTimeMillis();
            }
            if (this.zzean) {
                throw new CancellationException("SettableFuture was cancelled.");
            }
            if (this.zzeal != null) {
                throw new ExecutionException(this.zzeal);
            }
            if (!this.zzeam) {
                throw new TimeoutException("SettableFuture timed out.");
            }
            return this.value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(boolean bl) {
        if (!bl) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.zzxf()) {
                return false;
            }
            this.zzean = true;
            this.zzeam = true;
            this.lock.notifyAll();
        }
        this.zzdzy.zzxd();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzean;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzxf();
        }
    }

    @GuardedBy(value="lock")
    private final boolean zzxf() {
        return this.zzeal != null || this.zzeam;
    }
}

