/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzadi;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzbbm;
import com.google.android.gms.internal.ads.zzbcn;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbcr;
import com.google.android.gms.internal.ads.zzbcs;
import com.google.android.gms.internal.ads.zzbct;
import com.google.android.gms.internal.ads.zzbcu;
import com.google.android.gms.internal.ads.zzbcv;
import com.google.android.gms.internal.ads.zzbde;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbdh;
import com.google.android.gms.internal.ads.zzyt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;

@zzard
@ParametersAreNonnullByDefault
public final class zzbcq
extends FrameLayout
implements zzbcn {
    private final zzbdf zzebt;
    private final FrameLayout zzebu;
    private final zzadi zzebv;
    private final zzbdh zzebw;
    private final long zzebx;
    @Nullable
    private zzbco zzeby;
    private boolean zzebz;
    private boolean zzeca;
    private boolean zzecb;
    private boolean zzecc;
    private long zzecd;
    private long zzece;
    private String zzecf;
    private String[] zzecg;
    private Bitmap zzech;
    private ImageView zzeci;
    private boolean zzecj;

    public static void zzb(zzbdf zzbdf2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "no_video_view");
        zzbdf2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzbdf zzbdf2, Map<String, List<Map<String, Object>>> map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("event", "decoderProps");
        hashMap.put("mimeTypes", map);
        zzbdf2.zza("onVideoEvent", hashMap);
    }

    public static void zza(zzbdf zzbdf2, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", "decoderProps");
        hashMap.put("error", string2);
        zzbdf2.zza("onVideoEvent", hashMap);
    }

    public zzbcq(Context context, zzbdf zzbdf2, int n, boolean bl, zzadi zzadi2, zzbde zzbde2) {
        super(context);
        zzacj zzacj2;
        this.zzebt = zzbdf2;
        this.zzebv = zzadi2;
        this.zzebu = new FrameLayout(context);
        this.addView((View)this.zzebu, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        Preconditions.checkNotNull((Object)zzbdf2.zzye());
        this.zzeby = zzbdf2.zzye().zzbqs.zza(context, zzbdf2, n, bl, zzadi2, zzbde2);
        if (this.zzeby != null) {
            this.zzebu.addView((View)this.zzeby, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
            zzacj2 = zzacu.zzcmd;
            if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
                this.zzxs();
            }
        }
        this.zzeci = new ImageView(context);
        zzacj2 = zzacu.zzcmh;
        this.zzebx = (Long)zzyt.zzpe().zzd(zzacj2);
        zzacj2 = zzacu.zzcmf;
        this.zzecc = (Boolean)zzyt.zzpe().zzd(zzacj2);
        if (this.zzebv != null) {
            this.zzebv.zzh("spinner_used", this.zzecc ? "1" : "0");
        }
        this.zzebw = new zzbdh(this);
        if (this.zzeby != null) {
            this.zzeby.zza(this);
        }
        if (this.zzeby == null) {
            this.zzl("AdVideoUnderlay Error", "Allocating player failed.");
        }
    }

    public final void zzd(int n, int n2, int n3, int n4) {
        if (n3 == 0 || n4 == 0) {
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(n3, n4);
        layoutParams.setMargins(n, n2, 0, 0);
        this.zzebu.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.requestLayout();
    }

    public final void zzc(String string2, String[] stringArray) {
        this.zzecf = string2;
        this.zzecg = stringArray;
    }

    public final void zza(float f, float f2) {
        if (this.zzeby != null) {
            this.zzeby.zza(f, f2);
        }
    }

    public final void zzfr() {
        if (this.zzeby == null) {
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzecf)) {
            this.zzeby.zzb(this.zzecf, this.zzecg);
            return;
        }
        this.zzd("no_src", new String[0]);
    }

    public final void pause() {
        if (this.zzeby == null) {
            return;
        }
        this.zzeby.pause();
    }

    public final void play() {
        if (this.zzeby == null) {
            return;
        }
        this.zzeby.play();
    }

    public final void seekTo(int n) {
        if (this.zzeby == null) {
            return;
        }
        this.zzeby.seekTo(n);
    }

    public final void zzxq() {
        if (this.zzeby == null) {
            return;
        }
        zzbco zzbco2 = this.zzeby;
        zzbco2.zzebs.setMuted(true);
        zzbco2.zzxk();
    }

    public final void zzxr() {
        if (this.zzeby == null) {
            return;
        }
        zzbco zzbco2 = this.zzeby;
        zzbco2.zzebs.setMuted(false);
        zzbco2.zzxk();
    }

    public final void setVolume(float f) {
        if (this.zzeby == null) {
            return;
        }
        float f2 = f;
        zzbco zzbco2 = this.zzeby;
        zzbco2.zzebs.setVolume(f2);
        zzbco2.zzxk();
    }

    public final void zzcy(int n) {
        this.zzeby.zzcy(n);
    }

    public final void zzcz(int n) {
        this.zzeby.zzcz(n);
    }

    public final void zzda(int n) {
        this.zzeby.zzda(n);
    }

    public final void zzdb(int n) {
        this.zzeby.zzdb(n);
    }

    public final void zzdc(int n) {
        this.zzeby.zzdc(n);
    }

    @TargetApi(value=14)
    public final void zze(MotionEvent motionEvent) {
        if (this.zzeby == null) {
            return;
        }
        this.zzeby.dispatchTouchEvent(motionEvent);
    }

    @TargetApi(value=14)
    public final void zzxs() {
        if (this.zzeby == null) {
            return;
        }
        Context context = this.zzeby.getContext();
        TextView textView = new TextView(context);
        String string2 = String.valueOf(this.zzeby.zzxg());
        textView.setText((CharSequence)(string2.length() != 0 ? "AdMob - ".concat(string2) : new String("AdMob - ")));
        textView.setTextColor(-65536);
        textView.setBackgroundColor(-256);
        this.zzebu.addView((View)textView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2, 17));
        this.zzebu.bringChildToFront((View)textView);
    }

    @Override
    public final void zzxl() {
        this.zzebw.resume();
        zzaxi.zzdvv.post((Runnable)new zzbct(this));
    }

    @Override
    public final void zzhd() {
        if (this.zzeby == null) {
            return;
        }
        if (this.zzece == 0L) {
            float f = (float)this.zzeby.getDuration() / 1000.0f;
            int n = this.zzeby.getVideoWidth();
            int n2 = this.zzeby.getVideoHeight();
            this.zzd("canplaythrough", "duration", String.valueOf(f), "videoWidth", String.valueOf(n), "videoHeight", String.valueOf(n2));
        }
    }

    @Override
    public final void zzxm() {
        zzbcq zzbcq2 = this;
        if (zzbcq2.zzebt.zzyd() != null && !zzbcq2.zzeca) {
            WindowManager.LayoutParams layoutParams = zzbcq2.zzebt.zzyd().getWindow().getAttributes();
            boolean bl = zzbcq2.zzecb = (layoutParams.flags & 0x80) != 0;
            if (!zzbcq2.zzecb) {
                zzbcq2.zzebt.zzyd().getWindow().addFlags(128);
                zzbcq2.zzeca = true;
            }
        }
        this.zzebz = true;
    }

    @Override
    public final void onPaused() {
        this.zzd("pause", new String[0]);
        this.zzxv();
        this.zzebz = false;
    }

    @Override
    public final void zzxn() {
        this.zzd("ended", new String[0]);
        this.zzxv();
    }

    @Override
    public final void zzl(String string2, @Nullable String string3) {
        this.zzd("error", "what", string2, "extra", string3);
    }

    @Override
    public final void zzxo() {
        zzbcq zzbcq2 = this;
        if (zzbcq2.zzecj && zzbcq2.zzech != null && !zzbcq2.zzxu()) {
            zzbcq2.zzeci.setImageBitmap(zzbcq2.zzech);
            zzbcq2.zzeci.invalidate();
            zzbcq2.zzebu.addView((View)zzbcq2.zzeci, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            zzbcq2.zzebu.bringChildToFront((View)zzbcq2.zzeci);
        }
        this.zzebw.pause();
        this.zzece = this.zzecd;
        zzaxi.zzdvv.post((Runnable)new zzbcu(this));
    }

    public final void destroy() {
        this.zzebw.pause();
        if (this.zzeby != null) {
            this.zzeby.stop();
        }
        this.zzxv();
    }

    public final void finalize() throws Throwable {
        try {
            this.zzebw.pause();
            if (this.zzeby != null) {
                zzbco zzbco2;
                zzbco zzbco3 = zzbco2 = this.zzeby;
                zzbco3.getClass();
                zzbbm.zzeae.execute(zzbcr.zza(zzbco3));
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    final void zzxt() {
        if (this.zzeby == null) {
            return;
        }
        long l = this.zzeby.getCurrentPosition();
        if (this.zzecd != l && l > 0L) {
            float f = (float)l / 1000.0f;
            this.zzd("timeupdate", "time", String.valueOf(f));
            this.zzecd = l;
        }
    }

    @Override
    public final void zzxp() {
        zzbcq zzbcq2;
        if (this.zzebz && (zzbcq2 = this).zzxu()) {
            zzbcq2.zzebu.removeView((View)zzbcq2.zzeci);
        }
        zzbcq2 = this;
        if (zzbcq2.zzech != null) {
            long l = zzk.zzln().elapsedRealtime();
            if (zzbcq2.zzeby.getBitmap(zzbcq2.zzech) != null) {
                zzbcq2.zzecj = true;
            }
            long l2 = zzk.zzln().elapsedRealtime() - l;
            if (zzawz.zzvj()) {
                zzawz.zzds(new StringBuilder(46).append("Spinner frame grab took ").append(l2).append("ms").toString());
            }
            if (l2 > zzbcq2.zzebx) {
                zzawz.zzep((String)"Spinner frame grab crossed jank threshold! Suspending spinner.");
                zzbcq2.zzecc = false;
                zzbcq2.zzech = null;
                if (zzbcq2.zzebv != null) {
                    zzbcq2.zzebv.zzh("spinner_jank", Long.toString(l2));
                }
            }
        }
    }

    @Override
    public final void zzk(int n, int n2) {
        int n3 = n2;
        int n4 = n;
        zzbcq zzbcq2 = this;
        if (zzbcq2.zzecc) {
            zzacj zzacj2 = zzacu.zzcmg;
            n4 = Math.max(n4 / (Integer)zzyt.zzpe().zzd(zzacj2), 1);
            zzacj2 = zzacu.zzcmg;
            n3 = Math.max(n3 / (Integer)zzyt.zzpe().zzd(zzacj2), 1);
            if (zzbcq2.zzech == null || zzbcq2.zzech.getWidth() != n4 || zzbcq2.zzech.getHeight() != n3) {
                zzbcq2.zzech = Bitmap.createBitmap((int)n4, (int)n3, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                zzbcq2.zzecj = false;
            }
        }
    }

    public final void onWindowFocusChanged(boolean bl) {
        super.onWindowFocusChanged(bl);
        if (bl) {
            this.zzebw.resume();
        } else {
            this.zzebw.pause();
            this.zzece = this.zzecd;
        }
        zzaxi.zzdvv.post((Runnable)new zzbcs(this, bl));
    }

    @Override
    public final void onWindowVisibilityChanged(int n) {
        boolean bl;
        super.onWindowVisibilityChanged(n);
        if (n == 0) {
            this.zzebw.resume();
            bl = true;
        } else {
            this.zzebw.pause();
            this.zzece = this.zzecd;
            bl = false;
        }
        zzaxi.zzdvv.post((Runnable)new zzbcv(this, bl));
    }

    private final boolean zzxu() {
        return this.zzeci.getParent() != null;
    }

    private final void zzd(String string2, String ... stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("event", string2);
        String string3 = null;
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string4 = stringArray2[i];
            if (string3 == null) {
                string3 = string4;
                continue;
            }
            hashMap.put(string3, string4);
            string3 = null;
        }
        this.zzebt.zza("onVideoEvent", hashMap);
    }

    private final void zzxv() {
        if (this.zzebt.zzyd() == null) {
            return;
        }
        if (this.zzeca && !this.zzecb) {
            this.zzebt.zzyd().getWindow().clearFlags(128);
            this.zzeca = false;
        }
    }

    final /* synthetic */ void zzan(boolean bl) {
        this.zzd("windowFocusChanged", "hasWindowFocus", String.valueOf(bl));
    }

    static /* synthetic */ void zza(zzbcq zzbcq2, String string2, String[] stringArray) {
        zzbcq2.zzd(string2, stringArray);
    }
}

