/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzbda;
import com.google.android.gms.internal.ads.zzbdc;
import com.google.android.gms.internal.ads.zzyt;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@zzard
@TargetApi(value=14)
public final class zzbdd
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzbdc {
    private static final float[] zzedd = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzbda zzede;
    private final float[] zzeda;
    private final float[] zzedf;
    private final float[] zzedg;
    private final float[] zzedh;
    private final float[] zzedi;
    private final float[] zzedj;
    private final float[] zzedk;
    private float zzedl;
    private float zzedm;
    private float zzedn;
    private int height;
    private int width;
    private SurfaceTexture zzedo;
    private SurfaceTexture zzedp;
    private int zzedq;
    private int zzedr;
    private int zzeds;
    private FloatBuffer zzedt = ByteBuffer.allocateDirect(zzedd.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzedu;
    private final Object zzedv;
    private EGL10 zzedw;
    private EGLDisplay zzedx;
    private EGLContext zzedy;
    private EGLSurface zzedz;
    private volatile boolean zzeea;
    private volatile boolean zzeeb;

    public zzbdd(Context context) {
        super("SphericalVideoProcessor");
        this.zzedt.put(zzedd).position(0);
        this.zzeda = new float[9];
        this.zzedf = new float[9];
        this.zzedg = new float[9];
        this.zzedh = new float[9];
        this.zzedi = new float[9];
        this.zzedj = new float[9];
        this.zzedk = new float[9];
        this.zzedl = Float.NaN;
        this.zzede = new zzbda(context);
        this.zzede.zza(this);
        this.zzedu = new CountDownLatch(1);
        this.zzedv = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.zzedp = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzm(int n, int n2) {
        Object object = this.zzedv;
        synchronized (object) {
            this.width = n;
            this.height = n2;
            this.zzeea = true;
            this.zzedv.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzxx() {
        Object object = this.zzedv;
        synchronized (object) {
            this.zzeeb = true;
            this.zzedp = null;
            this.zzedv.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zzxy() {
        if (this.zzedp == null) {
            return null;
        }
        try {
            this.zzedu.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzedo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzeds;
        Object object = this.zzedv;
        synchronized (object) {
            this.zzedv.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zztk() {
        Object object = this.zzedv;
        synchronized (object) {
            this.zzedv.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string2;
        zzacj zzacj2;
        Object object;
        Object[] objectArray;
        Object object2;
        boolean bl2;
        if (this.zzedp == null) {
            zzawz.zzen((String)"SphericalVideoProcessor started with no output texture.");
            this.zzedu.countDown();
            return;
        }
        zzbdd zzbdd2 = this;
        this.zzedw = (EGL10)EGLContext.getEGL();
        zzbdd2.zzedx = zzbdd2.zzedw.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzbdd2.zzedx == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzbdd2.zzedw.eglInitialize(zzbdd2.zzedx, nArray)) {
                bl2 = false;
            } else {
                object2 = zzbdd2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                objectArray = new int[1];
                object = ((zzbdd)object2).zzedw.eglChooseConfig(((zzbdd)object2).zzedx, nArray2, eGLConfigArray, 1, objectArray) && objectArray[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray3 = new int[]{12440, 2, 12344};
                    zzbdd2.zzedy = zzbdd2.zzedw.eglCreateContext(zzbdd2.zzedx, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray3);
                    if (zzbdd2.zzedy == null || zzbdd2.zzedy == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzbdd2.zzedz = zzbdd2.zzedw.eglCreateWindowSurface(zzbdd2.zzedx, (EGLConfig)object, (Object)zzbdd2.zzedp, null);
                        bl2 = zzbdd2.zzedz == null || zzbdd2.zzedz == EGL10.EGL_NO_SURFACE ? false : zzbdd2.zzedw.eglMakeCurrent(zzbdd2.zzedx, zzbdd2.zzedz, zzbdd2.zzedz, zzbdd2.zzedy);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzbdd2 = this;
        zzacj zzacj3 = zzacj2 = zzacu.zzcqe;
        if (!((String)zzyt.zzpe().zzd(zzacj3)).equals(zzacj2.zzqm())) {
            zzacj3 = zzacj2;
            string2 = (String)zzyt.zzpe().zzd(zzacj3);
        } else {
            string2 = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzbdd.zzd(35633, string2);
        if (n2 == 0) {
            n = 0;
        } else {
            String string3;
            zzacj3 = zzacj2 = zzacu.zzcqf;
            if (!((String)zzyt.zzpe().zzd(zzacj3)).equals(zzacj2.zzqm())) {
                zzacj3 = zzacj2;
                string3 = (String)zzyt.zzpe().zzd(zzacj3);
            } else {
                string3 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzbdd.zzd(35632, string3);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzbdd.zzes("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzbdd.zzes("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzbdd.zzes("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzbdd.zzes("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzbdd.zzes("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzbdd.zzes("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzbdd.zzes("validateProgram");
                    }
                }
                n = n4;
            }
        }
        this.zzedq = n;
        GLES20.glUseProgram((int)zzbdd2.zzedq);
        zzbdd.zzes("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzbdd2.zzedq, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzbdd2.zzedt);
        zzbdd.zzes("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzbdd.zzes("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzbdd.zzes("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzbdd.zzes("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzbdd.zzes("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzbdd.zzes("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzbdd.zzes("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzbdd.zzes("texParameteri");
        zzbdd2.zzedr = GLES20.glGetUniformLocation((int)zzbdd2.zzedq, (String)"uVMat");
        object2 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzbdd2.zzedr, (int)1, (boolean)false, (float[])object2, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzedq != 0;
        if (!bl3 || !bl) {
            String string4 = GLUtils.getEGLErrorString((int)this.zzedw.eglGetError());
            String string5 = String.valueOf(string4);
            String string6 = string5.length() != 0 ? "EGL initialization failed: ".concat(string5) : new String("EGL initialization failed: ");
            zzawz.zzen((String)string6);
            zzk.zzlk().zza(new Throwable(string6), "SphericalVideoProcessor.run.1");
            this.zzxz();
            this.zzedu.countDown();
            return;
        }
        this.zzedo = new SurfaceTexture(n7);
        this.zzedo.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzedu.countDown();
        this.zzede.start();
        try {
            this.zzeea = true;
            while (!this.zzeeb) {
                zzbdd2 = this;
                while (zzbdd2.zzeds > 0) {
                    zzbdd2.zzedo.updateTexImage();
                    --zzbdd2.zzeds;
                }
                if (zzbdd2.zzede.zza(zzbdd2.zzeda)) {
                    if (Float.isNaN(zzbdd2.zzedl)) {
                        float[] fArray = zzbdd2.zzeda;
                        objectArray = new float[]{0.0f, 1.0f, 0.0f};
                        object2 = zzbdd2.zzeda;
                        float[] fArray2 = new float[]{(float)(object2[0] * objectArray[0] + object2[1] * objectArray[1] + object2[2] * objectArray[2]), (float)(object2[3] * objectArray[0] + object2[4] * objectArray[1] + object2[5] * objectArray[2]), (float)(object2[6] * objectArray[0] + object2[7] * objectArray[1] + object2[8] * objectArray[2])};
                        zzbdd2.zzedl = -((float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f);
                    }
                    zzbdd.zzb(zzbdd2.zzedj, zzbdd2.zzedl + zzbdd2.zzedm);
                } else {
                    zzbdd.zza(zzbdd2.zzeda, -1.5707964f);
                    zzbdd.zzb(zzbdd2.zzedj, zzbdd2.zzedm);
                }
                zzbdd.zza(zzbdd2.zzedf, 1.5707964f);
                zzbdd.zza(zzbdd2.zzedg, zzbdd2.zzedj, zzbdd2.zzedf);
                zzbdd.zza(zzbdd2.zzedh, zzbdd2.zzeda, zzbdd2.zzedg);
                zzbdd.zza(zzbdd2.zzedi, zzbdd2.zzedn);
                zzbdd.zza(zzbdd2.zzedk, zzbdd2.zzedi, zzbdd2.zzedh);
                GLES20.glUniformMatrix3fv((int)zzbdd2.zzedr, (int)1, (boolean)false, (float[])zzbdd2.zzedk, (int)0);
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
                zzbdd.zzes("drawArrays");
                GLES20.glFinish();
                zzbdd2.zzedw.eglSwapBuffers(zzbdd2.zzedx, zzbdd2.zzedz);
                if (this.zzeea) {
                    zzbdd2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzbdd2.width, (int)zzbdd2.height);
                    zzbdd.zzes("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzbdd2.zzedq, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzbdd2.zzedq, (String)"uFOVy");
                    if (zzbdd2.width > zzbdd2.height) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzbdd2.height / (float)zzbdd2.width));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzbdd2.width / (float)zzbdd2.height));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzeea = false;
                }
                try {
                    Object object3 = this.zzedv;
                    synchronized (object3) {
                        if (!this.zzeeb && !this.zzeea && this.zzeds == 0) {
                            this.zzedv.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzawz.zzep((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzawz.zzc((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzk.zzlk().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzede.stop();
            this.zzedo.setOnFrameAvailableListener(null);
            this.zzedo = null;
            this.zzxz();
        }
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.width > this.height) {
            f4 = 1.7453293f * f / (float)this.width;
            f3 = 1.7453293f * f2 / (float)this.width;
        } else {
            f4 = 1.7453293f * f / (float)this.height;
            f3 = 1.7453293f * f2 / (float)this.height;
        }
        this.zzedm -= f4;
        this.zzedn -= f3;
        if (this.zzedn < -1.5707964f) {
            this.zzedn = -1.5707964f;
        }
        if (this.zzedn > 1.5707964f) {
            this.zzedn = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzd(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        zzbdd.zzes("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            zzbdd.zzes("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzbdd.zzes("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzbdd.zzes("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzbdd.zzes("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    @VisibleForTesting
    private final boolean zzxz() {
        boolean bl = false;
        if (this.zzedz != null && this.zzedz != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzedw.eglMakeCurrent(this.zzedx, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzedw.eglDestroySurface(this.zzedx, this.zzedz);
            this.zzedz = null;
        }
        if (this.zzedy != null) {
            bl |= this.zzedw.eglDestroyContext(this.zzedx, this.zzedy);
            this.zzedy = null;
        }
        if (this.zzedx != null) {
            bl |= this.zzedw.eglTerminate(this.zzedx);
            this.zzedx = null;
        }
        return bl;
    }

    private static void zzes(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

