/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzbbm;
import com.google.android.gms.internal.ads.zzbcn;
import com.google.android.gms.internal.ads.zzbco;
import com.google.android.gms.internal.ads.zzbdd;
import com.google.android.gms.internal.ads.zzbde;
import com.google.android.gms.internal.ads.zzbdf;
import com.google.android.gms.internal.ads.zzbdg;
import com.google.android.gms.internal.ads.zzbel;
import com.google.android.gms.internal.ads.zzbem;
import com.google.android.gms.internal.ads.zzben;
import com.google.android.gms.internal.ads.zzbeo;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzbeq;
import com.google.android.gms.internal.ads.zzber;
import com.google.android.gms.internal.ads.zzbes;
import com.google.android.gms.internal.ads.zzbet;
import com.google.android.gms.internal.ads.zzbeu;
import com.google.android.gms.internal.ads.zzbfa;
import com.google.android.gms.internal.ads.zzbfi;
import com.google.android.gms.internal.ads.zzbft;
import com.google.android.gms.internal.ads.zzbgo;
import com.google.android.gms.internal.ads.zzbgp;
import com.google.android.gms.internal.ads.zzkv;
import java.nio.ByteBuffer;
import java.util.Arrays;

@zzard
@TargetApi(value=16)
public final class zzbek
extends zzbco
implements TextureView.SurfaceTextureListener,
zzbfi {
    private final zzbdf zzebt;
    private final zzbdg zzeaw;
    private final boolean zzeax;
    private final zzbde zzefp;
    private zzbcn zzebk;
    private Surface zzaez;
    private zzbfa zzegj;
    private String zzefr;
    private String[] zzecg;
    private boolean zzefs;
    private int zzeft = 1;
    private zzbdd zzebh;
    private final boolean zzebi;
    private boolean zzefu;
    private boolean zzefv;
    private int zzebc;
    private int zzebd;
    private int zzebf;
    private int zzebg;
    private float zzefn;

    public zzbek(Context context, zzbdg zzbdg2, zzbdf zzbdf2, boolean bl, boolean bl2, zzbde zzbde2) {
        super(context);
        this.zzeax = bl2;
        this.zzebt = zzbdf2;
        this.zzeaw = zzbdg2;
        this.zzebi = bl;
        this.zzefp = zzbde2;
        this.setSurfaceTextureListener(this);
        this.zzeaw.zzb(this);
    }

    private final zzbfa zzzh() {
        return new zzbfa(this.zzebt.getContext(), this.zzefp);
    }

    private final String zzzi() {
        return zzk.zzlg().zzq(this.zzebt.getContext(), this.zzebt.zzyh().zzbsx);
    }

    private final boolean zzyv() {
        return this.zzegj != null && !this.zzefs;
    }

    private final boolean zzyw() {
        return this.zzyv() && this.zzeft != 1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzzj() {
        block9: {
            block10: {
                if (this.zzegj != null) {
                    return;
                }
                if (this.zzefr == null || this.zzaez == null) {
                    return;
                }
                if (!this.zzefr.startsWith("cache:")) break block10;
                zzbft zzbft2 = this.zzebt.zzet(this.zzefr);
                if (zzbft2 instanceof zzbgp) {
                    zzbgp zzbgp2 = (zzbgp)zzbft2;
                    this.zzegj = zzbgp2.zzaaa();
                    break block9;
                } else if (zzbft2 instanceof zzbgo) {
                    zzbgo zzbgo2 = (zzbgo)zzbft2;
                    String string2 = this.zzzi();
                    ByteBuffer byteBuffer = zzbgo2.getByteBuffer();
                    boolean bl = zzbgo2.zzzv();
                    String string3 = zzbgo2.getUrl();
                    if (string3 == null) {
                        zzawz.zzep((String)"Stream cache URL is null.");
                        return;
                    }
                    this.zzegj = this.zzzh();
                    this.zzegj.zza(new Uri[]{Uri.parse((String)string3)}, string2, byteBuffer, bl);
                    break block9;
                } else {
                    String string4 = String.valueOf(this.zzefr);
                    zzawz.zzep((String)(string4.length() != 0 ? "Stream cache miss: ".concat(string4) : new String("Stream cache miss: ")));
                    return;
                }
            }
            this.zzegj = this.zzzh();
            String string5 = this.zzzi();
            Uri[] uriArray = new Uri[this.zzecg.length];
            for (int i = 0; i < this.zzecg.length; ++i) {
                uriArray[i] = Uri.parse((String)this.zzecg[i]);
            }
            this.zzegj.zza(uriArray, string5);
        }
        this.zzegj.zza(this);
        this.zza(this.zzaez, false);
        this.zzeft = this.zzegj.zzzt().getPlaybackState();
        if (this.zzeft == 3) {
            this.zzyy();
        }
    }

    private final void zza(Surface surface, boolean bl) {
        if (this.zzegj != null) {
            this.zzegj.zza(surface, bl);
            return;
        }
        zzawz.zzep((String)"Trying to set surface before player is initalized.");
    }

    private final void zza(float f, boolean bl) {
        if (this.zzegj != null) {
            this.zzegj.zzb(f, bl);
            return;
        }
        zzawz.zzep((String)"Trying to set volume before player is initalized.");
    }

    @Override
    public final void zzxk() {
        this.zza(this.zzebs.getVolume(), false);
    }

    private final void zzyy() {
        if (this.zzefu) {
            return;
        }
        this.zzefu = true;
        zzaxi.zzdvv.post((Runnable)new zzbel(this));
        ((zzbco)this).zzxk();
        this.zzeaw.zzhd();
        if (this.zzefv) {
            ((zzbco)this).play();
        }
    }

    @Override
    public final String zzxg() {
        String string2 = String.valueOf("ExoPlayer/3");
        String string3 = String.valueOf(this.zzebi ? " spherical" : "");
        if (string3.length() != 0) {
            return string2.concat(string3);
        }
        return new String(string2);
    }

    @Override
    public final void zza(zzbcn zzbcn2) {
        this.zzebk = zzbcn2;
    }

    @Override
    public final void setVideoPath(String string2) {
        if (string2 != null) {
            this.zzefr = string2;
            this.zzecg = new String[]{string2};
            this.zzzj();
        }
    }

    @Override
    public final void zzb(String string2, String[] stringArray) {
        if (string2 != null) {
            if (stringArray == null) {
                ((zzbco)this).setVideoPath(string2);
            }
            this.zzefr = string2;
            this.zzecg = Arrays.copyOf(stringArray, stringArray.length);
            this.zzzj();
        }
    }

    @Override
    public final void play() {
        if (this.zzyw()) {
            if (this.zzefp.zzeec) {
                this.zzzl();
            }
            this.zzegj.zzzt().zzd(true);
            this.zzeaw.zzyl();
            this.zzebs.zzyl();
            this.zzebr.zzxm();
            zzaxi.zzdvv.post((Runnable)new zzbeo(this));
            return;
        }
        this.zzefv = true;
    }

    @Override
    public final void stop() {
        if (this.zzyv()) {
            this.zzegj.zzzt().stop();
            zzbek zzbek2 = this;
            if (zzbek2.zzegj != null) {
                zzbek2.zza(null, true);
                if (zzbek2.zzegj != null) {
                    zzbek2.zzegj.zza((zzbfi)null);
                    zzbek2.zzegj.release();
                    zzbek2.zzegj = null;
                }
                zzbek2.zzeft = 1;
                zzbek2.zzefs = false;
                zzbek2.zzefu = false;
                zzbek2.zzefv = false;
            }
        }
        this.zzeaw.zzym();
        this.zzebs.zzym();
        this.zzeaw.onStop();
    }

    @Override
    public final void pause() {
        if (this.zzyw()) {
            if (this.zzefp.zzeec) {
                this.zzzm();
            }
            this.zzegj.zzzt().zzd(false);
            this.zzeaw.zzym();
            this.zzebs.zzym();
            zzaxi.zzdvv.post((Runnable)new zzbep(this));
        }
    }

    @Override
    public final void seekTo(int n) {
        if (this.zzyw()) {
            this.zzegj.zzzt().seekTo(n);
        }
    }

    @Override
    public final void zzcy(int n) {
        if (this.zzegj != null) {
            this.zzegj.zzzu().zzdg(n);
        }
    }

    @Override
    public final void zzcz(int n) {
        if (this.zzegj != null) {
            this.zzegj.zzzu().zzdh(n);
        }
    }

    @Override
    public final void zzda(int n) {
        if (this.zzegj != null) {
            this.zzegj.zzzu().zzda(n);
        }
    }

    @Override
    public final void zzdb(int n) {
        if (this.zzegj != null) {
            this.zzegj.zzzu().zzdb(n);
        }
    }

    @Override
    public final void zzdc(int n) {
        if (this.zzegj != null) {
            this.zzegj.zzdc(n);
        }
    }

    @Override
    public final void zza(float f, float f2) {
        if (this.zzebh != null) {
            this.zzebh.zzb(f, f2);
        }
    }

    @Override
    public final int getCurrentPosition() {
        if (this.zzyw()) {
            return (int)this.zzegj.zzzt().zzdn();
        }
        return 0;
    }

    @Override
    public final int getDuration() {
        if (this.zzyw()) {
            return (int)this.zzegj.zzzt().getDuration();
        }
        return 0;
    }

    @Override
    public final int getVideoWidth() {
        return this.zzebc;
    }

    @Override
    public final int getVideoHeight() {
        return this.zzebd;
    }

    protected final void onMeasure(int n, int n2) {
        super.onMeasure(n, n2);
        int n3 = this.getMeasuredWidth();
        int n4 = this.getMeasuredHeight();
        if (this.zzefn != 0.0f && this.zzebh == null) {
            float f = (float)n3 / (float)n4;
            if (this.zzefn > f) {
                n4 = (int)((float)n3 / this.zzefn);
            }
            if (this.zzefn < f) {
                n3 = (int)((float)n4 * this.zzefn);
            }
        }
        this.setMeasuredDimension(n3, n4);
        if (this.zzebh != null) {
            this.zzebh.zzm(n3, n4);
        }
        if (Build.VERSION.SDK_INT == 16) {
            if (this.zzebf > 0 && this.zzebf != n3 || this.zzebg > 0 && this.zzebg != n4) {
                zzkv zzkv2;
                zzbek zzbek2 = this;
                if (zzbek2.zzeax && zzbek2.zzyv() && (zzkv2 = zzbek2.zzegj.zzzt()).zzdn() > 0L && !zzkv2.zzdm()) {
                    zzbek2.zza(0.0f, true);
                    zzkv2.zzd(true);
                    long l = zzkv2.zzdn();
                    long l2 = zzk.zzln().currentTimeMillis();
                    while (zzbek2.zzyv() && zzkv2.zzdn() == l && zzk.zzln().currentTimeMillis() - l2 <= 250L) {
                    }
                    zzkv2.zzd(false);
                    ((zzbco)zzbek2).zzxk();
                }
            }
            this.zzebf = n3;
            this.zzebg = n4;
        }
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzebi) {
            this.zzebh = new zzbdd(this.getContext());
            this.zzebh.zza(surfaceTexture, n, n2);
            this.zzebh.start();
            SurfaceTexture surfaceTexture2 = this.zzebh.zzxy();
            if (surfaceTexture2 != null) {
                surfaceTexture = surfaceTexture2;
            } else {
                this.zzebh.zzxx();
                this.zzebh = null;
            }
        }
        SurfaceTexture surfaceTexture3 = surfaceTexture;
        this.zzaez = new Surface(surfaceTexture3);
        if (this.zzegj == null) {
            this.zzzj();
        } else {
            this.zza(this.zzaez, true);
            if (!this.zzefp.zzeec) {
                this.zzzl();
            }
        }
        if (this.zzebc == 0 || this.zzebd == 0) {
            this.zzp(n, n2);
        } else {
            this.zzzk();
        }
        zzaxi.zzdvv.post((Runnable)new zzbeq(this));
    }

    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        if (this.zzebh != null) {
            this.zzebh.zzm(n, n2);
        }
        zzaxi.zzdvv.post((Runnable)new zzber(this, n, n2));
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzeaw.zzc(this);
        this.zzebr.zza(surfaceTexture, this.zzebk);
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        ((zzbco)this).pause();
        if (this.zzebh != null) {
            this.zzebh.zzxx();
            this.zzebh = null;
        }
        if (this.zzegj != null) {
            this.zzzm();
            if (this.zzaez != null) {
                this.zzaez.release();
            }
            this.zzaez = null;
            this.zza(null, true);
        }
        zzaxi.zzdvv.post((Runnable)new zzbes(this));
        return true;
    }

    protected final void onWindowVisibilityChanged(int n) {
        zzawz.zzds(new StringBuilder(57).append("AdExoPlayerView3 window visibility changed to ").append(n).toString());
        zzaxi.zzdvv.post((Runnable)new zzbet(this, n));
        super.onWindowVisibilityChanged(n);
    }

    @Override
    public final void zzd(boolean bl, long l) {
        if (this.zzebt != null) {
            zzbbm.zzeae.execute(new zzbeu(this, bl, l));
        }
    }

    @Override
    public final void zzde(int n) {
        if (this.zzeft != n) {
            this.zzeft = n;
            switch (n) {
                case 3: {
                    this.zzyy();
                    return;
                }
                case 4: {
                    zzbek zzbek2 = this;
                    if (zzbek2.zzefp.zzeec) {
                        zzbek2.zzzm();
                    }
                    zzbek2.zzeaw.zzym();
                    zzbek2.zzebs.zzym();
                    zzaxi.zzdvv.post((Runnable)new zzbem(zzbek2));
                }
            }
        }
    }

    @Override
    public final void zzo(int n, int n2) {
        this.zzebc = n;
        this.zzebd = n2;
        this.zzzk();
    }

    @Override
    public final void zza(String string2, Exception exception) {
        Exception exception2 = exception;
        String string3 = string2;
        zzbek zzbek2 = this;
        String string4 = exception2.getClass().getCanonicalName();
        String string5 = exception2.getMessage();
        String string6 = new StringBuilder(2 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string3).append("/").append(string4).append(":").append(string5).toString();
        String string7 = String.valueOf(string6);
        zzawz.zzep((String)(string7.length() != 0 ? "ExoPlayerAdapter error: ".concat(string7) : new String("ExoPlayerAdapter error: ")));
        zzbek2.zzefs = true;
        if (zzbek2.zzefp.zzeec) {
            zzbek2.zzzm();
        }
        zzaxi.zzdvv.post((Runnable)new zzben(zzbek2, string6));
    }

    private final void zzzk() {
        this.zzp(this.zzebc, this.zzebd);
    }

    private final void zzp(int n, int n2) {
        float f;
        float f2 = f = n2 > 0 ? (float)n / (float)n2 : 1.0f;
        if (this.zzefn != f) {
            this.zzefn = f;
            this.requestLayout();
        }
    }

    private final void zzzl() {
        if (this.zzegj != null) {
            this.zzegj.zzap(true);
        }
    }

    private final void zzzm() {
        if (this.zzegj != null) {
            this.zzegj.zzap(false);
        }
    }

    final /* synthetic */ void zze(boolean bl, long l) {
        this.zzebt.zza(bl, l);
    }

    final /* synthetic */ void zzdf(int n) {
        if (this.zzebk != null) {
            this.zzebk.onWindowVisibilityChanged(n);
        }
    }

    final /* synthetic */ void zzzn() {
        if (this.zzebk != null) {
            this.zzebk.zzxo();
        }
    }

    final /* synthetic */ void zzq(int n, int n2) {
        if (this.zzebk != null) {
            this.zzebk.zzk(n, n2);
        }
    }

    final /* synthetic */ void zzzo() {
        if (this.zzebk != null) {
            this.zzebk.zzxl();
        }
    }

    final /* synthetic */ void zzzp() {
        if (this.zzebk != null) {
            this.zzebk.onPaused();
        }
    }

    final /* synthetic */ void zzzq() {
        if (this.zzebk != null) {
            this.zzebk.zzxm();
        }
    }

    final /* synthetic */ void zzeu(String string2) {
        if (this.zzebk != null) {
            this.zzebk.zzl("ExoPlayerAdapter error", string2);
        }
    }

    final /* synthetic */ void zzzr() {
        if (this.zzebk != null) {
            this.zzebk.zzxn();
        }
    }

    final /* synthetic */ void zzzs() {
        if (this.zzebk != null) {
            this.zzebk.zzhd();
        }
    }
}

