/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.IOUtils;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzbey;
import com.google.android.gms.internal.ads.zzrv;
import com.google.android.gms.internal.ads.zzry;
import com.google.android.gms.internal.ads.zzsj;
import com.google.android.gms.internal.ads.zzvs;
import com.google.android.gms.internal.ads.zzvv;
import com.google.android.gms.internal.ads.zzwi;
import com.google.android.gms.internal.ads.zzyt;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@zzard
public final class zzbex
implements zzrv {
    private InputStream zzegc;
    private boolean isOpen;
    private final Context zzlj;
    private final zzrv zzegq;
    @Nullable
    private final zzsj<zzrv> zzegr;
    private final zzbey zzegs;
    private Uri uri;

    public zzbex(Context context, zzrv zzrv2, zzsj<zzrv> zzsj2, zzbey zzbey2) {
        this.zzlj = context;
        this.zzegq = zzrv2;
        this.zzegr = zzsj2;
        this.zzegs = zzbey2;
    }

    @Override
    public final void close() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to close an already closed CacheDataSource.");
        }
        this.isOpen = false;
        this.uri = null;
        if (this.zzegc != null) {
            IOUtils.closeQuietly((Closeable)this.zzegc);
            this.zzegc = null;
        } else {
            this.zzegq.close();
        }
        zzbex zzbex2 = this;
        if (zzbex2.zzegr != null) {
            zzbex2.zzegr.zze(zzbex2);
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public final long zza(zzry zzry2) throws IOException {
        if (this.isOpen) {
            throw new IOException("Attempt to open an already open CacheDataSource.");
        }
        this.isOpen = true;
        this.uri = zzry2.uri;
        zzry zzry3 = zzry2;
        zzbex zzbex2 = this;
        if (zzbex2.zzegr != null) {
            zzbex2.zzegr.zza(zzbex2, zzry3);
        }
        zzvv zzvv2 = zzvv.zze(zzry2.uri);
        zzbex2 = zzacu.zzcts;
        if (((Boolean)zzyt.zzpe().zzd((zzacj)zzbex2)).booleanValue()) {
            if (zzvv2 != null) {
                long l;
                Long l2;
                zzvv2.zzbwy = zzry2.zzahv;
                if (zzvv2.zzbwx) {
                    zzbex2 = zzacu.zzctu;
                    l2 = (Long)zzyt.zzpe().zzd((zzacj)zzbex2);
                } else {
                    zzbex2 = zzacu.zzctt;
                    l2 = (Long)zzyt.zzpe().zzd((zzacj)zzbex2);
                }
                long l3 = l2;
                long l4 = zzk.zzln().elapsedRealtime();
                zzk.zzma();
                Future<InputStream> future = zzwi.zza(this.zzlj, zzvv2);
                try {
                    this.zzegc = future.get(l3, TimeUnit.MILLISECONDS);
                    l = zzk.zzln().elapsedRealtime() - l4;
                    this.zzegs.zzd(true, l);
                }
                catch (ExecutionException | TimeoutException exception) {
                    future.cancel(true);
                }
                catch (InterruptedException interruptedException) {
                    future.cancel(true);
                    Thread.currentThread().interrupt();
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    long l5 = zzk.zzln().elapsedRealtime() - l4;
                    this.zzegs.zzd(false, l5);
                    zzawz.zzds(new StringBuilder(44).append("Cache connection took ").append(l5).append("ms").toString());
                }
                zzawz.zzds(new StringBuilder(44).append("Cache connection took ").append(l).append("ms").toString());
                return -1L;
            }
        } else {
            zzvs zzvs2 = null;
            if (zzvv2 != null) {
                zzvv2.zzbwy = zzry2.zzahv;
                zzvs2 = zzk.zzlm().zza(zzvv2);
            }
            if (zzvs2 != null && zzvs2.zznh()) {
                this.zzegc = zzvs2.zzni();
                return -1L;
            }
        }
        if (zzvv2 != null) {
            zzry2 = new zzry(Uri.parse((String)zzvv2.url), zzry2.zzbmd, zzry2.zzapg, zzry2.zzahv, zzry2.zzcd, zzry2.zzcc, zzry2.flags);
        }
        return this.zzegq.zza(zzry2);
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Attempt to read closed CacheDataSource.");
        }
        int n3 = this.zzegc != null ? this.zzegc.read(byArray, n, n2) : this.zzegq.read(byArray, n, n2);
        int n4 = n3;
        zzbex zzbex2 = this;
        if (zzbex2.zzegr != null) {
            zzbex2.zzegr.zzc(zzbex2, n4);
        }
        return n3;
    }

    @Override
    public final Uri getUri() {
        return this.uri;
    }
}

