/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.webkit.RenderProcessGoneDetail;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzm;
import com.google.android.gms.ads.internal.overlay.zzo;
import com.google.android.gms.ads.internal.overlay.zzu;
import com.google.android.gms.ads.internal.zzb;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzacf;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzagu;
import com.google.android.gms.internal.ads.zzagv;
import com.google.android.gms.internal.ads.zzagw;
import com.google.android.gms.internal.ads.zzagx;
import com.google.android.gms.internal.ads.zzagz;
import com.google.android.gms.internal.ads.zzaho;
import com.google.android.gms.internal.ads.zzahp;
import com.google.android.gms.internal.ads.zzahq;
import com.google.android.gms.internal.ads.zzahr;
import com.google.android.gms.internal.ads.zzahs;
import com.google.android.gms.internal.ads.zzapr;
import com.google.android.gms.internal.ads.zzaqa;
import com.google.android.gms.internal.ads.zzaqc;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzavb;
import com.google.android.gms.internal.ads.zzavx;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzazx;
import com.google.android.gms.internal.ads.zzbbm;
import com.google.android.gms.internal.ads.zzbgc;
import com.google.android.gms.internal.ads.zzbgz;
import com.google.android.gms.internal.ads.zzbhb;
import com.google.android.gms.internal.ads.zzbhc;
import com.google.android.gms.internal.ads.zzbhd;
import com.google.android.gms.internal.ads.zzbhe;
import com.google.android.gms.internal.ads.zzbii;
import com.google.android.gms.internal.ads.zzbij;
import com.google.android.gms.internal.ads.zzbik;
import com.google.android.gms.internal.ads.zzbil;
import com.google.android.gms.internal.ads.zzdh;
import com.google.android.gms.internal.ads.zzdi;
import com.google.android.gms.internal.ads.zzvs;
import com.google.android.gms.internal.ads.zzvv;
import com.google.android.gms.internal.ads.zzwj;
import com.google.android.gms.internal.ads.zzxr;
import com.google.android.gms.internal.ads.zzyt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzard
@ParametersAreNonnullByDefault
@VisibleForTesting
public class zzbha
extends WebViewClient
implements zzbii {
    private static final String[] zzejb = new String[]{"UNKNOWN", "HOST_LOOKUP", "UNSUPPORTED_AUTH_SCHEME", "AUTHENTICATION", "PROXY_AUTHENTICATION", "CONNECT", "IO", "TIMEOUT", "REDIRECT_LOOP", "UNSUPPORTED_SCHEME", "FAILED_SSL_HANDSHAKE", "BAD_URL", "FILE", "FILE_NOT_FOUND", "TOO_MANY_REQUESTS"};
    private static final String[] zzejc = new String[]{"NOT_YET_VALID", "EXPIRED", "ID_MISMATCH", "UNTRUSTED", "DATE_INVALID", "INVALID"};
    protected zzbgz zzdjm;
    @Nullable
    private final zzwj zzejd;
    private final HashMap<String, List<zzaho<? super zzbgz>>> zzeje = new HashMap();
    private final Object lock = new Object();
    private zzxr zzcgi;
    private zzo zzdkm;
    private zzbij zzejf;
    private zzbik zzejg;
    private zzagv zzczo;
    private zzagx zzczp;
    private zzbil zzejh;
    private boolean zzeji = false;
    @GuardedBy(value="lock")
    private boolean zzbsy;
    @GuardedBy(value="lock")
    private boolean zzejj;
    @GuardedBy(value="lock")
    private boolean zzejk;
    private zzu zzdkq;
    private final zzaqa zzejl;
    private zzb zzdaj;
    private zzapr zzdak;
    @Nullable
    protected zzavb zzejm;
    private boolean zzejn;
    private boolean zzejo;
    private int zzejp;
    private boolean zzdok;
    private View.OnAttachStateChangeListener zzejq;

    public zzbha(zzbgz zzbgz2, zzwj zzwj2, boolean bl) {
        this(zzbgz2, zzwj2, bl, new zzaqa(zzbgz2, zzbgz2.zzaad(), new zzacf(zzbgz2.getContext())), null);
    }

    @VisibleForTesting
    private zzbha(zzbgz zzbgz2, zzwj zzwj2, boolean bl, zzaqa zzaqa2, zzapr zzapr2) {
        this.zzejd = zzwj2;
        this.zzdjm = zzbgz2;
        this.zzbsy = bl;
        this.zzejl = zzaqa2;
        this.zzdak = null;
    }

    @Override
    public final void zza(int n, int n2, boolean bl) {
        this.zzejl.zzj(n, n2);
        if (this.zzdak != null) {
            this.zzdak.zza(n, n2, false);
        }
    }

    @Override
    public final void zza(zzxr zzxr2, zzagv zzagv2, zzo zzo2, zzagx zzagx2, zzu zzu2, boolean bl, @Nullable zzahp zzahp2, zzb zzb2, zzaqc zzaqc2, @Nullable zzavb zzavb2) {
        boolean bl2;
        if (zzb2 == null) {
            zzb2 = new zzb(this.zzdjm.getContext(), zzavb2, null);
        }
        this.zzdak = new zzapr(this.zzdjm, zzaqc2);
        this.zzejm = zzavb2;
        zzacj zzacj2 = zzacu.zzcov;
        if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
            this.zza("/adMetadata", new zzagu(zzagv2));
        }
        this.zza("/appEvent", new zzagw(zzagx2));
        this.zza("/backButton", zzagz.zzczz);
        this.zza("/refresh", zzagz.zzdaa);
        this.zza("/canOpenURLs", zzagz.zzczq);
        this.zza("/canOpenIntents", zzagz.zzczr);
        this.zza("/click", zzagz.zzczs);
        this.zza("/close", zzagz.zzczt);
        this.zza("/customClose", zzagz.zzczu);
        this.zza("/instrument", zzagz.zzdad);
        this.zza("/delayPageLoaded", zzagz.zzdaf);
        this.zza("/delayPageClosed", zzagz.zzdag);
        this.zza("/getLocationInfo", zzagz.zzdah);
        this.zza("/httpTrack", zzagz.zzczv);
        this.zza("/log", zzagz.zzczw);
        this.zza("/mraid", new zzahr(zzb2, this.zzdak, zzaqc2));
        this.zza("/mraidLoaded", this.zzejl);
        this.zza("/open", new zzahs(zzb2, this.zzdak));
        this.zza("/precache", new zzbgc());
        this.zza("/touch", zzagz.zzczy);
        this.zza("/video", zzagz.zzdab);
        this.zza("/videoMeta", zzagz.zzdac);
        if (zzk.zzme().zzx(this.zzdjm.getContext())) {
            this.zza("/logScionEvent", new zzahq(this.zzdjm.getContext()));
        }
        this.zzcgi = zzxr2;
        this.zzdkm = zzo2;
        this.zzczo = zzagv2;
        this.zzczp = zzagx2;
        this.zzdkq = zzu2;
        this.zzdaj = zzb2;
        this.zzeji = bl2 = bl;
    }

    @Override
    public final zzb zzaax() {
        return this.zzdaj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzaay() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzbsy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzaaz() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzejj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnGlobalLayoutListener zzaba() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ViewTreeObserver.OnScrollChangedListener zzabb() {
        Object object = this.lock;
        synchronized (object) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onPageFinished(WebView webView, String string2) {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdjm.isDestroyed()) {
                zzawz.zzds("Blank page loaded, 1...");
                this.zzdjm.zzaao();
                return;
            }
        }
        this.zzejn = true;
        zzbha zzbha2 = this;
        if (zzbha2.zzejg != null) {
            zzbha2.zzejg.zzrw();
            zzbha2.zzejg = null;
        }
        this.zzabh();
    }

    private final void zza(View view, zzavb zzavb2, int n) {
        if (zzavb2.zzud() && n > 0) {
            zzavb2.zzj(view);
            if (zzavb2.zzud()) {
                zzaxi.zzdvv.postDelayed((Runnable)new zzbhc(this, view, zzavb2, n), 100L);
            }
        }
    }

    private final void zzabc() {
        if (this.zzejq == null) {
            return;
        }
        this.zzdjm.getView().removeOnAttachStateChangeListener(this.zzejq);
    }

    @Override
    public final void zzabd() {
        zzavb zzavb2 = this.zzejm;
        if (zzavb2 != null) {
            WebView webView = this.zzdjm.getWebView();
            if (ViewCompat.isAttachedToWindow((View)webView)) {
                this.zza((View)webView, zzavb2, 10);
                return;
            }
            zzavb zzavb3 = zzavb2;
            zzbha zzbha2 = this;
            zzbha2.zzabc();
            zzbha2.zzejq = new zzbhd(zzbha2, zzavb3);
            zzbha2.zzdjm.getView().addOnAttachStateChangeListener(zzbha2.zzejq);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzabe() {
        Object object = this.lock;
        synchronized (object) {
            this.zzejk = true;
        }
        ++this.zzejp;
        this.zzabh();
    }

    @Override
    public final void zzabf() {
        --this.zzejp;
        this.zzabh();
    }

    @Override
    public final void zzabg() {
        this.zzejo = true;
        this.zzabh();
    }

    private final void zzabh() {
        if (this.zzejf != null && (this.zzejn && this.zzejp <= 0 || this.zzejo)) {
            this.zzejf.zzae(!this.zzejo);
            this.zzejf = null;
        }
        this.zzdjm.zzaas();
    }

    public final void zza(zzc zzc2) {
        boolean bl = this.zzdjm.zzaan();
        this.zza(new AdOverlayInfoParcel(zzc2, (zzxr)(bl && !this.zzdjm.zzaag().zzabx() ? null : this.zzcgi), bl ? null : this.zzdkm, this.zzdkq, this.zzdjm.zzyh()));
    }

    public final void zzc(boolean bl, int n) {
        boolean bl2 = this.zzdjm.zzaan();
        this.zza(new AdOverlayInfoParcel((zzxr)(bl2 && !this.zzdjm.zzaag().zzabx() ? null : this.zzcgi), this.zzdkm, this.zzdkq, this.zzdjm, bl, n, this.zzdjm.zzyh()));
    }

    public final void zza(boolean bl, int n, String string2) {
        boolean bl2 = this.zzdjm.zzaan();
        this.zza(new AdOverlayInfoParcel((zzxr)(bl2 && !this.zzdjm.zzaag().zzabx() ? null : this.zzcgi), bl2 ? null : new zzbhe(this.zzdjm, this.zzdkm), this.zzczo, this.zzczp, this.zzdkq, this.zzdjm, bl, n, string2, this.zzdjm.zzyh()));
    }

    public final void zza(boolean bl, int n, String string2, String string3) {
        boolean bl2 = this.zzdjm.zzaan();
        this.zza(new AdOverlayInfoParcel((zzxr)(bl2 && !this.zzdjm.zzaag().zzabx() ? null : this.zzcgi), bl2 ? null : new zzbhe(this.zzdjm, this.zzdkm), this.zzczo, this.zzczp, this.zzdkq, this.zzdjm, bl, n, string2, string3, this.zzdjm.zzyh()));
    }

    private final void zza(AdOverlayInfoParcel adOverlayInfoParcel) {
        boolean bl = false;
        if (this.zzdak != null) {
            bl = this.zzdak.zztb();
        }
        zzk.zzlf();
        zzm.zza(this.zzdjm.getContext(), adOverlayInfoParcel, !bl);
        if (this.zzejm != null) {
            String string2 = adOverlayInfoParcel.url;
            if (string2 == null && adOverlayInfoParcel.zzdkl != null) {
                string2 = adOverlayInfoParcel.zzdkl.url;
            }
            this.zzejm.zzdk(string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, zzaho<? super zzbgz> zzaho2) {
        Object object = this.lock;
        synchronized (object) {
            List<zzaho<? super zzbgz>> list = this.zzeje.get(string2);
            if (list == null) {
                list = new CopyOnWriteArrayList<zzaho<? super zzbgz>>();
                this.zzeje.put(string2, list);
            }
            list.add(zzaho2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(String string2, zzaho<? super zzbgz> zzaho2) {
        Object object = this.lock;
        synchronized (object) {
            List<zzaho<? super zzbgz>> list = this.zzeje.get(string2);
            if (list == null) {
                return;
            }
            list.remove(zzaho2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(String string2, Predicate<zzaho<? super zzbgz>> predicate) {
        Object object = this.lock;
        synchronized (object) {
            List<zzaho<? super zzbgz>> list = this.zzeje.get(string2);
            if (list == null) {
                return;
            }
            ArrayList<zzaho<? super zzbgz>> arrayList = new ArrayList<zzaho<? super zzbgz>>();
            for (zzaho<? super zzbgz> zzaho2 : list) {
                if (!predicate.apply(zzaho2)) continue;
                arrayList.add(zzaho2);
            }
            list.removeAll(arrayList);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reset() {
        if (this.zzejm != null) {
            this.zzejm.zzuf();
            this.zzejm = null;
        }
        this.zzabc();
        Object object = this.lock;
        synchronized (object) {
            this.zzeje.clear();
            this.zzcgi = null;
            this.zzdkm = null;
            this.zzejf = null;
            this.zzejg = null;
            this.zzczo = null;
            this.zzczp = null;
            this.zzeji = false;
            this.zzbsy = false;
            this.zzejj = false;
            this.zzejk = false;
            this.zzdkq = null;
            this.zzejh = null;
            if (this.zzdak != null) {
                this.zzdak.zzw(true);
                this.zzdak = null;
            }
            return;
        }
    }

    @Override
    public final void zza(zzbij zzbij2) {
        this.zzejf = zzbij2;
    }

    @Override
    public final void zza(zzbik zzbik2) {
        this.zzejg = zzbik2;
    }

    public final void onLoadResource(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzawz.zzds(string3.length() != 0 ? "Loading resource: ".concat(string3) : new String("Loading resource: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzh(uri);
        }
    }

    public final void onReceivedError(WebView webView, int n, String string2, String string3) {
        String string4 = n < 0 && -n - 1 < zzejb.length ? zzejb[-n - 1] : String.valueOf(n);
        this.zze(this.zzdjm.getContext(), "http_err", string4, string3);
        super.onReceivedError(webView, n, string2, string3);
    }

    public final void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
        if (sslError != null) {
            int n = sslError.getPrimaryError();
            String string2 = n >= 0 && n < zzejc.length ? zzejc[n] : String.valueOf(n);
            Context context = this.zzdjm.getContext();
            zzk.zzli();
            this.zze(context, "ssl_err", string2, sslError.getUrl());
        }
        super.onReceivedSslError(webView, sslErrorHandler, sslError);
    }

    private final void zze(Context context, String string2, String string3, String string4) {
        Uri uri;
        Object object = zzacu.zzcqo;
        if (!((Boolean)zzyt.zzpe().zzd(object)).booleanValue()) {
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("err", string2);
        bundle.putString("code", string3);
        object = string4;
        bundle.putString("host", !TextUtils.isEmpty((CharSequence)object) && (uri = Uri.parse((String)object)).getHost() != null ? uri.getHost() : "");
        zzk.zzlg().zza(context, this.zzdjm.zzyh().zzbsx, "gmob-apps", bundle, true);
    }

    public final boolean shouldOverrideUrlLoading(WebView webView, String string2) {
        String string3 = String.valueOf(string2);
        zzawz.zzds(string3.length() != 0 ? "AdWebView shouldOverrideUrlLoading: ".concat(string3) : new String("AdWebView shouldOverrideUrlLoading: "));
        Uri uri = Uri.parse((String)string2);
        if ("gmsg".equalsIgnoreCase(uri.getScheme()) && "mobileads.google.com".equalsIgnoreCase(uri.getHost())) {
            this.zzh(uri);
        } else {
            String string4;
            if (this.zzeji && webView == this.zzdjm.getWebView() && ("http".equalsIgnoreCase(string4 = uri.getScheme()) || "https".equalsIgnoreCase(string4))) {
                if (this.zzcgi != null) {
                    this.zzcgi.onAdClicked();
                    if (this.zzejm != null) {
                        this.zzejm.zzdk(string2);
                    }
                    this.zzcgi = null;
                }
                return super.shouldOverrideUrlLoading(webView, string2);
            }
            if (!this.zzdjm.getWebView().willNotDraw()) {
                try {
                    zzdh zzdh2 = this.zzdjm.zzaal();
                    if (zzdh2 != null && zzdh2.zzc(uri)) {
                        uri = zzdh2.zza(uri, this.zzdjm.getContext(), this.zzdjm.getView(), this.zzdjm.zzyd());
                    }
                }
                catch (zzdi zzdi2) {
                    String string5 = String.valueOf(string2);
                    zzawz.zzep((String)(string5.length() != 0 ? "Unable to append parameter to URL: ".concat(string5) : new String("Unable to append parameter to URL: ")));
                }
                if (this.zzdaj == null || this.zzdaj.zzkx()) {
                    this.zza(new zzc("android.intent.action.VIEW", uri.toString(), null, null, null, null, null));
                } else {
                    this.zzdaj.zzbk(string2);
                }
            } else {
                String string6 = String.valueOf(string2);
                zzawz.zzep((String)(string6.length() != 0 ? "AdWebView unable to handle URL: ".concat(string6) : new String("AdWebView unable to handle URL: ")));
            }
        }
        return true;
    }

    @TargetApi(value=11)
    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView webView, String string2) {
        return this.zzd(string2, Collections.emptyMap());
    }

    @Nullable
    protected final WebResourceResponse zzd(String string2, Map<String, String> map) {
        try {
            zzvs zzvs2;
            String string3 = zzavx.zzd(string2, this.zzdjm.getContext(), this.zzdok);
            if (!string3.equals(string2)) {
                return this.zze(string3, map);
            }
            zzvv zzvv2 = zzvv.zzbo(string2);
            if (zzvv2 != null && (zzvs2 = zzk.zzlm().zza(zzvv2)) != null && zzvs2.zznh()) {
                return new WebResourceResponse("", "", zzvs2.zzni());
            }
            if (zzazx.isEnabled()) {
                zzacj zzacj2 = zzacu.zzcqc;
                if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
                    return this.zze(string2, map);
                }
            }
            return null;
        }
        catch (Exception | NoClassDefFoundError throwable) {
            zzk.zzlk().zza(throwable, "AdWebViewClient.interceptRequest");
            return zzbha.zzabi();
        }
    }

    private static WebResourceResponse zzabi() {
        zzacj zzacj2 = zzacu.zzcom;
        if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
            return new WebResourceResponse("", "", (InputStream)new ByteArrayInputStream(new byte[0]));
        }
        return null;
    }

    private final WebResourceResponse zze(String string2, Map<String, String> map) throws IOException {
        URL uRL = new URL(string2);
        int n = 0;
        while (++n <= 20) {
            URLConnection uRLConnection = uRL.openConnection();
            uRLConnection.setConnectTimeout(10000);
            uRLConnection.setReadTimeout(10000);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                uRLConnection.addRequestProperty(entry.getKey(), entry.getValue());
            }
            if (!(uRLConnection instanceof HttpURLConnection)) {
                throw new IOException("Invalid protocol.");
            }
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            zzk.zzlg().zza(this.zzdjm.getContext(), this.zzdjm.zzyh().zzbsx, false, httpURLConnection);
            zzazx zzazx22 = new zzazx();
            zzazx22.zza(httpURLConnection, null);
            int n2 = httpURLConnection.getResponseCode();
            zzazx22.zza(httpURLConnection, n2);
            if (n2 >= 300 && n2 < 400) {
                String string3 = httpURLConnection.getHeaderField("Location");
                if (string3 == null) {
                    throw new IOException("Missing Location header in redirect");
                }
                String string4 = (uRL = new URL(uRL, string3)).getProtocol();
                if (string4 == null) {
                    zzawz.zzep((String)"Protocol is null");
                    return zzbha.zzabi();
                }
                if (!string4.equals("http") && !string4.equals("https")) {
                    String string5 = String.valueOf(string4);
                    zzawz.zzep((String)(string5.length() != 0 ? "Unsupported scheme: ".concat(string5) : new String("Unsupported scheme: ")));
                    return zzbha.zzabi();
                }
                String string6 = String.valueOf(string3);
                zzawz.zzdp((String)(string6.length() != 0 ? "Redirecting to ".concat(string6) : new String("Redirecting to ")));
                httpURLConnection.disconnect();
                continue;
            }
            zzk.zzlg();
            return zzaxi.zzd(httpURLConnection);
        }
        throw new IOException(new StringBuilder(32).append("Too many redirects (20)").toString());
    }

    public final void zzao(boolean bl) {
        this.zzeji = bl;
    }

    @Override
    public final zzavb zzabj() {
        return this.zzejm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzth() {
        Object object = this.lock;
        synchronized (object) {
            this.zzeji = false;
            this.zzbsy = true;
            zzbbm.zzeae.execute(new zzbhb(this));
            return;
        }
    }

    public final void zzat(boolean bl) {
        this.zzdok = bl;
    }

    @Override
    public final void zzi(int n, int n2) {
        if (this.zzdak != null) {
            this.zzdak.zzi(n, n2);
        }
    }

    public boolean shouldOverrideKeyEvent(WebView webView, KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 79: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 222: {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void zzh(Uri uri) {
        String string2 = uri.getPath();
        List<zzaho<? super zzbgz>> list = this.zzeje.get(string2);
        if (list != null) {
            zzk.zzlg();
            Map<String, String> map = zzaxi.zzi(uri);
            if (zzawz.isLoggable((int)2)) {
                String string3 = String.valueOf(string2);
                zzawz.zzds(string3.length() != 0 ? "Received GMSG: ".concat(string3) : new String("Received GMSG: "));
                for (String string4 : map.keySet()) {
                    String string5 = map.get(string4);
                    zzawz.zzds(new StringBuilder(4 + String.valueOf(string4).length() + String.valueOf(string5).length()).append("  ").append(string4).append(": ").append(string5).toString());
                }
            }
            Iterator<Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza(this.zzdjm, map);
            }
            return;
        }
        String string6 = String.valueOf(uri);
        zzawz.zzds(new StringBuilder(32 + String.valueOf(string6).length()).append("No GMSG handler found for GMSG: ").append(string6).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzau(boolean bl) {
        Object object = this.lock;
        synchronized (object) {
            this.zzejj = true;
            return;
        }
    }

    @TargetApi(value=26)
    public boolean onRenderProcessGone(WebView webView, RenderProcessGoneDetail renderProcessGoneDetail) {
        return this.zzdjm.zzb(renderProcessGoneDetail.didCrash(), renderProcessGoneDetail.rendererPriorityAtExit());
    }

    static /* synthetic */ void zza(zzbha zzbha2, View view, zzavb zzavb2, int n) {
        zzbha2.zza(view, zzavb2, n);
    }
}

