/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Canvas;
import android.net.Uri;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.webkit.DownloadListener;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.zzc;
import com.google.android.gms.ads.internal.overlay.zzd;
import com.google.android.gms.ads.internal.zza;
import com.google.android.gms.ads.internal.zzj;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.Predicate;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzadb;
import com.google.android.gms.internal.ads.zzadg;
import com.google.android.gms.internal.ads.zzadh;
import com.google.android.gms.internal.ads.zzadi;
import com.google.android.gms.internal.ads.zzadv;
import com.google.android.gms.internal.ads.zzadx;
import com.google.android.gms.internal.ads.zzaho;
import com.google.android.gms.internal.ads.zzajq;
import com.google.android.gms.internal.ads.zzajr;
import com.google.android.gms.internal.ads.zzaqb;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzaya;
import com.google.android.gms.internal.ads.zzazs;
import com.google.android.gms.internal.ads.zzazt;
import com.google.android.gms.internal.ads.zzbai;
import com.google.android.gms.internal.ads.zzbcw;
import com.google.android.gms.internal.ads.zzbfs;
import com.google.android.gms.internal.ads.zzbft;
import com.google.android.gms.internal.ads.zzbgz;
import com.google.android.gms.internal.ads.zzbhq;
import com.google.android.gms.internal.ads.zzbht;
import com.google.android.gms.internal.ads.zzbid;
import com.google.android.gms.internal.ads.zzbii;
import com.google.android.gms.internal.ads.zzbim;
import com.google.android.gms.internal.ads.zzbin;
import com.google.android.gms.internal.ads.zzbio;
import com.google.android.gms.internal.ads.zzbiw;
import com.google.android.gms.internal.ads.zzbix;
import com.google.android.gms.internal.ads.zzbiy;
import com.google.android.gms.internal.ads.zzbjb;
import com.google.android.gms.internal.ads.zzdh;
import com.google.android.gms.internal.ads.zzdob;
import com.google.android.gms.internal.ads.zzud;
import com.google.android.gms.internal.ads.zzwj;
import com.google.android.gms.internal.ads.zzwl;
import com.google.android.gms.internal.ads.zzwt;
import com.google.android.gms.internal.ads.zzxn;
import com.google.android.gms.internal.ads.zzyt;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONObject;

@zzard
@ParametersAreNonnullByDefault
@VisibleForTesting
final class zzbiv
extends zzbjb
implements ViewTreeObserver.OnGlobalLayoutListener,
DownloadListener,
zzajq,
zzbgz {
    private final zzbim zzekn;
    private final zzbio zzemn;
    @Nullable
    private final zzdh zzeko;
    private final zzbai zzbtc;
    private final zzj zzekp;
    private final zza zzekq;
    private final DisplayMetrics zzwb;
    private final zzwj zzejd;
    @GuardedBy(value="this")
    private zzd zzekv;
    @GuardedBy(value="this")
    private zzbin zzekx;
    @GuardedBy(value="this")
    private String zzaap;
    @GuardedBy(value="this")
    private boolean zzdko;
    @GuardedBy(value="this")
    private boolean zzekz;
    @GuardedBy(value="this")
    private boolean zzela;
    @GuardedBy(value="this")
    private int zzelb;
    @GuardedBy(value="this")
    private boolean zzelc = true;
    @GuardedBy(value="this")
    private boolean zzeld = false;
    @GuardedBy(value="this")
    private String zzdlx = "";
    @GuardedBy(value="this")
    private zzbhq zzele;
    @GuardedBy(value="this")
    private boolean zzelf;
    @GuardedBy(value="this")
    private boolean zzelg;
    @GuardedBy(value="this")
    private zzadx zzelh;
    @GuardedBy(value="this")
    private zzadv zzeli;
    @GuardedBy(value="this")
    private int zzelj;
    @GuardedBy(value="this")
    private int zzelk;
    private zzadg zzell;
    private zzadg zzeem;
    private zzadg zzelm;
    private zzadh zzeln;
    private WeakReference<View.OnClickListener> zzelo;
    @GuardedBy(value="this")
    private zzd zzelp;
    private zzazs zzelr;
    private final AtomicReference<IObjectWrapper> zzemo = new AtomicReference();
    private int zzdlu = -1;
    private int zzdlt = -1;
    private int maxWidth = -1;
    private int maxHeight = -1;
    private Map<String, zzbft> zzels;
    private final WindowManager zzbtf;

    @VisibleForTesting
    protected zzbiv(zzbim zzbim2, zzbio zzbio2, zzbin zzbin2, String string2, boolean bl, boolean bl2, @Nullable zzdh zzdh2, zzbai zzbai2, zzadi zzadi2, zzj zzj2, zza zza2, zzwj zzwj2) {
        super((Context)zzbim2, zzbio2);
        this.zzekn = zzbim2;
        this.zzemn = zzbio2;
        this.zzekx = zzbin2;
        this.zzaap = string2;
        this.zzekz = bl;
        this.zzelb = -1;
        this.zzeko = zzdh2;
        this.zzbtc = zzbai2;
        this.zzekp = zzj2;
        this.zzekq = zza2;
        this.zzbtf = (WindowManager)this.getContext().getSystemService("window");
        zzk.zzlg();
        this.zzwb = zzaxi.zza(this.zzbtf);
        this.zzejd = zzwj2;
        this.zzelr = new zzazs(this.zzekn.zzyd(), (View)this, this, null);
        zzk.zzlg().zza((Context)zzbim2, zzbai2.zzbsx, this.getSettings());
        this.setDownloadListener(this);
        this.zzabn();
        if (PlatformVersion.isAtLeastJellyBeanMR1()) {
            ((zzbiy)this).addJavascriptInterface(zzbht.zzc(this), "googleAdsJsInterface");
        }
        zzadi zzadi3 = zzadi2;
        zzbiv zzbiv2 = this;
        zzbiv2.zzabr();
        zzbiv2.zzeln = new zzadh(new zzadi(true, "make_wv", zzbiv2.zzaap));
        zzbiv2.zzeln.zzqw().zzc(zzadi3);
        zzbiv2.zzeem = zzadb.zzb(zzbiv2.zzeln.zzqw());
        zzbiv2.zzeln.zza("native:view_create", zzbiv2.zzeem);
        zzbiv2.zzelm = null;
        zzbiv2.zzell = null;
        zzk.zzli().zzay((Context)zzbim2);
    }

    @Override
    public final WebView getWebView() {
        return this;
    }

    @Override
    public final View getView() {
        return this;
    }

    @Override
    public final zza zzye() {
        return this.zzekq;
    }

    private final boolean zzabk() {
        int n;
        int n2;
        if (!this.zzemn.zzaay() && !this.zzemn.zzaaz()) {
            return false;
        }
        zzyt.zzpa();
        int n3 = zzazt.zzb((DisplayMetrics)this.zzwb, (int)this.zzwb.widthPixels);
        zzyt.zzpa();
        int n4 = zzazt.zzb((DisplayMetrics)this.zzwb, (int)this.zzwb.heightPixels);
        Activity activity = this.zzekn.zzyd();
        if (activity == null || activity.getWindow() == null) {
            n2 = n3;
            n = n4;
        } else {
            zzk.zzlg();
            int[] nArray = zzaxi.zzd(activity);
            zzyt.zzpa();
            n2 = zzazt.zzb((DisplayMetrics)this.zzwb, (int)nArray[0]);
            zzyt.zzpa();
            n = zzazt.zzb((DisplayMetrics)this.zzwb, (int)nArray[1]);
        }
        if (this.zzdlt == n3 && this.zzdlu == n4 && this.maxWidth == n2 && this.maxHeight == n) {
            return false;
        }
        boolean bl = this.zzdlt != n3 || this.zzdlu != n4;
        this.zzdlt = n3;
        this.zzdlu = n4;
        this.maxWidth = n2;
        this.maxHeight = n;
        new zzaqb(this).zza(n3, n4, n2, n, this.zzwb.density, this.zzbtf.getDefaultDisplay().getRotation());
        return bl;
    }

    @Override
    public final synchronized void zzb(String string2, String string3, @Nullable String string4) {
        zzacj zzacj2 = zzacu.zzcok;
        String string5 = (Boolean)zzyt.zzpe().zzd(zzacj2) != false ? zzbid.zzf(string3, zzbid.zzabt()) : string3;
        super.loadDataWithBaseURL(string2, string5, "text/html", "UTF-8", string4);
    }

    @Override
    public final synchronized void zzco(String string2) {
        if (!this.isDestroyed()) {
            super.zzco(string2);
            return;
        }
        zzawz.zzep((String)"The webview is destroyed. Ignoring action.");
    }

    @Override
    public final void zzaab() {
        this.zzabm();
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzbtc.zzbsx);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzajr.zza((zzajq)this, "onhide", hashMap2);
    }

    @Override
    public final void zzdi(int n) {
        if (n == 0) {
            zzbiv zzbiv2 = this;
            zzadb.zza(zzbiv2.zzeln.zzqw(), zzbiv2.zzeem, "aebb2");
        }
        this.zzabm();
        if (this.zzeln.zzqw() != null) {
            this.zzeln.zzqw().zzh("close_type", String.valueOf(n));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("closetype", String.valueOf(n));
        hashMap.put("version", this.zzbtc.zzbsx);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onhide";
        zzajr.zza((zzajq)this, "onhide", hashMap2);
    }

    private final void zzabm() {
        zzadb.zza(this.zzeln.zzqw(), this.zzeem, "aeh2");
    }

    @Override
    public final void zztl() {
        if (this.zzell == null) {
            zzadb.zza(this.zzeln.zzqw(), this.zzeem, "aes2");
            this.zzell = zzadb.zzb(this.zzeln.zzqw());
            this.zzeln.zza("native:view_show", this.zzell);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        hashMap.put("version", this.zzbtc.zzbsx);
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onshow";
        zzajr.zza((zzajq)this, "onshow", hashMap2);
    }

    @Override
    public final void zzaac() {
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        hashMap.put("app_muted", String.valueOf(zzk.zzll().zzpr()));
        hashMap.put("app_volume", String.valueOf(zzk.zzll().zzpq()));
        hashMap.put("device_volume", String.valueOf(zzaya.zzba(this.getContext())));
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "volume";
        zzajr.zza((zzajq)this, "volume", hashMap2);
    }

    @Override
    public final void zza(boolean bl, long l) {
        HashMap<String, String> hashMap = new HashMap<String, String>(2);
        hashMap.put("success", bl ? "1" : "0");
        hashMap.put("duration", Long.toString(l));
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onCacheAccessComplete";
        zzajr.zza((zzajq)this, "onCacheAccessComplete", hashMap2);
    }

    @Override
    public final synchronized zzd zzaae() {
        return this.zzekv;
    }

    @Override
    public final IObjectWrapper zzaam() {
        return this.zzemo.get();
    }

    @Override
    public final synchronized zzd zzaaf() {
        return this.zzelp;
    }

    @Override
    public final synchronized zzbin zzaag() {
        return this.zzekx;
    }

    @Override
    public final synchronized String zzaah() {
        return this.zzaap;
    }

    @Override
    public final WebViewClient zzaaj() {
        return this.zzemn;
    }

    @Override
    public final synchronized boolean zzaak() {
        return this.zzdko;
    }

    @Override
    public final zzdh zzaal() {
        return this.zzeko;
    }

    @Override
    public final zzbai zzyh() {
        return this.zzbtc;
    }

    @Override
    public final synchronized boolean zzaan() {
        return this.zzekz;
    }

    public final void onDownloadStart(String string2, String string3, String string4, String string5, long l) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setDataAndType(Uri.parse((String)string2), string5);
            zzk.zzlg();
            zzaxi.zza(this.getContext(), intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            zzawz.zzdp((String)new StringBuilder(51 + String.valueOf(string2).length() + String.valueOf(string5).length()).append("Couldn't find an Activity to view url/mimetype: ").append(string2).append(" / ").append(string5).toString());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.zzemn.zzaaz()) {
            zzbiv zzbiv2 = this;
            synchronized (zzbiv2) {
                if (this.zzelh != null) {
                    this.zzelh.zzc(motionEvent);
                }
            }
        } else if (this.zzeko != null) {
            this.zzeko.zza(motionEvent);
        }
        return super.onTouchEvent(motionEvent);
    }

    public final boolean onGenericMotionEvent(MotionEvent motionEvent) {
        float f = motionEvent.getAxisValue(9);
        float f2 = motionEvent.getAxisValue(10);
        if (motionEvent.getActionMasked() == 8 && (f > 0.0f && !this.canScrollVertically(-1) || f < 0.0f && !this.canScrollVertically(1) || f2 > 0.0f && !this.canScrollHorizontally(-1) || f2 < 0.0f && !this.canScrollHorizontally(1))) {
            return false;
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @SuppressLint(value={"DrawAllocation"})
    protected final synchronized void onMeasure(int n, int n2) {
        int n3;
        int n4;
        if (this.isDestroyed()) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.isInEditMode() || this.zzekz || this.zzekx.zzaby()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzekx.zzaca()) {
            super.onMeasure(n, n2);
            return;
        }
        if (this.zzekx.zzabz()) {
            zzacj zzacj2 = zzacu.zzcsk;
            if (((Boolean)zzyt.zzpe().zzd(zzacj2)).booleanValue()) {
                super.onMeasure(n, n2);
                return;
            }
            float f = 0.0f;
            zzbhq zzbhq2 = this.zzyb();
            if (zzbhq2 != null) {
                f = zzbhq2.getAspectRatio();
            }
            if (f == 0.0f) {
                super.onMeasure(n, n2);
                return;
            }
            int n5 = View.MeasureSpec.getSize((int)n);
            int n6 = View.MeasureSpec.getSize((int)n2);
            int n7 = (int)((float)n6 * f);
            int n8 = (int)((float)n5 / f);
            if (n6 == 0 && n8 != 0) {
                n6 = n8;
                n7 = (int)((float)n6 * f);
            } else if (n5 == 0 && n7 != 0) {
                n5 = n7;
                n8 = (int)((float)n5 / f);
            }
            int n9 = Math.min(n7, n5);
            int n10 = Math.min(n8, n6);
            this.setMeasuredDimension(n9, n10);
            return;
        }
        if (this.zzekx.isFluid()) {
            int n11;
            Object object = zzacu.zzcsn;
            if (((Boolean)zzyt.zzpe().zzd(object)).booleanValue() || !PlatformVersion.isAtLeastJellyBeanMR1()) {
                super.onMeasure(n, n2);
                return;
            }
            object = this;
            this.zza("/contentHeight", new zzbix((zzbiv)object));
            String string2 = "(function() {  var height = -1;  if (document.body) {    height = document.body.offsetHeight;  } else if (document.documentElement) {    height = document.documentElement.offsetHeight;  }  var url = 'gmsg://mobileads.google.com/contentHeight?';  url += 'height=' + height;  try {    window.googleAdsJsInterface.notify(url);  } catch (e) {    var frame = document.getElementById('afma-notify-fluid');    if (!frame) {      frame = document.createElement('IFRAME');      frame.id = 'afma-notify-fluid';      frame.style.display = 'none';      var body = document.body || document.documentElement;      body.appendChild(frame);    }    frame.src = url;  }})();";
            ((zzbiy)this).zzco(string2);
            int n12 = View.MeasureSpec.getSize((int)n);
            switch (this.zzelk) {
                case -1: {
                    n11 = View.MeasureSpec.getSize((int)n2);
                    break;
                }
                default: {
                    n11 = (int)((float)this.zzelk * this.zzwb.density);
                }
            }
            this.setMeasuredDimension(n12, n11);
            return;
        }
        if (this.zzekx.zzabx()) {
            this.setMeasuredDimension(this.zzwb.widthPixels, this.zzwb.heightPixels);
            return;
        }
        int n13 = View.MeasureSpec.getMode((int)n);
        int n14 = View.MeasureSpec.getSize((int)n);
        int n15 = View.MeasureSpec.getMode((int)n2);
        int n16 = View.MeasureSpec.getSize((int)n2);
        int n17 = Integer.MAX_VALUE;
        if (n13 == Integer.MIN_VALUE || n13 == 0x40000000) {
            n17 = n14;
        }
        int n18 = Integer.MAX_VALUE;
        if (n15 == Integer.MIN_VALUE || n15 == 0x40000000) {
            n18 = n16;
        }
        int n19 = this.zzekx.widthPixels > n17 || this.zzekx.heightPixels > n18 ? 1 : 0;
        zzacj zzacj3 = zzacu.zzcvg;
        if (((Boolean)zzyt.zzpe().zzd(zzacj3)).booleanValue()) {
            int n20 = n4 = !((float)this.zzekx.widthPixels / this.zzwb.density > (float)n17 / this.zzwb.density) && !((float)this.zzekx.heightPixels / this.zzwb.density > (float)n18 / this.zzwb.density) ? 1 : 0;
            n3 = n19 != 0 ? n4 : n19;
        } else {
            n3 = n19;
        }
        if (n3 != 0) {
            n4 = (int)((float)this.zzekx.widthPixels / this.zzwb.density);
            int n21 = (int)((float)this.zzekx.heightPixels / this.zzwb.density);
            int n22 = (int)((float)n14 / this.zzwb.density);
            int n23 = (int)((float)n16 / this.zzwb.density);
            zzawz.zzep((String)new StringBuilder(103).append("Not enough space to show ad. Needs ").append(n4).append("x").append(n21).append(" dp, but only has ").append(n22).append("x").append(n23).append(" dp.").toString());
            if (this.getVisibility() != 8) {
                this.setVisibility(4);
            }
            this.setMeasuredDimension(0, 0);
            return;
        }
        if (this.getVisibility() != 8) {
            this.setVisibility(0);
        }
        this.setMeasuredDimension(this.zzekx.widthPixels, this.zzekx.heightPixels);
    }

    public final void onGlobalLayout() {
        boolean bl = this.zzabk();
        zzd zzd2 = this.zzaae();
        if (zzd2 != null && bl) {
            zzd2.zztk();
        }
    }

    @Override
    public final synchronized void zza(zzd zzd2) {
        this.zzekv = zzd2;
    }

    @Override
    public final void zzam(IObjectWrapper iObjectWrapper) {
        this.zzemo.set(iObjectWrapper);
    }

    @Override
    public final synchronized void zzb(zzd zzd2) {
        this.zzelp = zzd2;
    }

    @Override
    public final synchronized void zza(zzbin zzbin2) {
        this.zzekx = zzbin2;
        this.requestLayout();
    }

    @Override
    public final synchronized void zzaq(boolean bl) {
        boolean bl2 = bl != this.zzekz;
        this.zzekz = bl;
        this.zzabn();
        if (bl2) {
            new zzaqb(this).zzdj(bl ? "expanded" : "default");
        }
    }

    @Override
    public final void zzaar() {
        this.zzelr.zzwt();
    }

    protected final synchronized void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isDestroyed()) {
            this.zzelr.onAttachedToWindow();
        }
        boolean bl = this.zzelf;
        if (this.zzemn != null && this.zzemn.zzaaz()) {
            bl = true;
            if (!this.zzelg) {
                this.zzemn.zzaba();
                this.zzemn.zzabb();
                this.zzelg = true;
            }
            this.zzabk();
        }
        this.zzav(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onDetachedFromWindow() {
        zzbiv zzbiv2 = this;
        synchronized (zzbiv2) {
            if (!this.isDestroyed()) {
                this.zzelr.onDetachedFromWindow();
            }
            super.onDetachedFromWindow();
            if (this.zzelg && this.zzemn != null && this.zzemn.zzaaz() && this.getViewTreeObserver() != null && this.getViewTreeObserver().isAlive()) {
                this.zzemn.zzaba();
                this.zzemn.zzabb();
                this.zzelg = false;
            }
        }
        this.zzav(false);
    }

    @Override
    public final void zzbn(Context context) {
        this.zzekn.setBaseContext(context);
        this.zzelr.zzh(this.zzekn.zzyd());
    }

    @Override
    public final synchronized void zzaf(boolean bl) {
        if (this.zzekv != null) {
            this.zzekv.zza(this.zzemn.zzaay(), bl);
            return;
        }
        this.zzdko = bl;
    }

    @Override
    public final void zzaao() {
    }

    @Override
    public final synchronized void setRequestedOrientation(int n) {
        this.zzelb = n;
        if (this.zzekv != null) {
            this.zzekv.setRequestedOrientation(this.zzelb);
        }
    }

    @Override
    public final Activity zzyd() {
        return this.zzekn.zzyd();
    }

    @Override
    public final Context zzaad() {
        return this.zzekn.zzaad();
    }

    private final synchronized void zzabn() {
        if (this.zzekz || this.zzekx.zzabx()) {
            zzawz.zzdp((String)"Enabling hardware acceleration on an overlay.");
            this.zzabp();
            return;
        }
        if (Build.VERSION.SDK_INT < 18) {
            zzawz.zzdp((String)"Disabling hardware acceleration on an AdView.");
            this.zzabo();
            return;
        }
        zzawz.zzdp((String)"Enabling hardware acceleration on an AdView.");
        this.zzabp();
    }

    private final synchronized void zzabo() {
        if (!this.zzela) {
            zzk.zzli();
            this.setLayerType(1, null);
        }
        this.zzela = true;
    }

    private final synchronized void zzabp() {
        if (this.zzela) {
            zzk.zzli();
            this.setLayerType(0, null);
        }
        this.zzela = false;
    }

    @Override
    protected final synchronized void zzaw(boolean bl) {
        if (!bl) {
            this.zzabr();
            this.zzelr.zzwu();
            if (this.zzekv != null) {
                this.zzekv.close();
                this.zzekv.onDestroy();
                this.zzekv = null;
            }
        }
        this.zzemo.set(null);
        this.zzemn.destroy();
        zzk.zzmc();
        zzbfs.zzc(this);
        this.zzabq();
    }

    @Override
    @TargetApi(value=21)
    protected final void onDraw(Canvas canvas) {
        if (Build.VERSION.SDK_INT == 21 && canvas.isHardwareAccelerated() && !this.isAttachedToWindow()) {
            return;
        }
        super.onDraw(canvas);
    }

    @Override
    public final void zzaas() {
        if (this.zzelm == null) {
            this.zzelm = zzadb.zzb(this.zzeln.zzqw());
            this.zzeln.zza("native:view_load", this.zzelm);
        }
    }

    @Override
    public final void onPause() {
        try {
            super.onPause();
            return;
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Could not pause webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void onResume() {
        try {
            super.onResume();
            return;
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Could not resume webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final void zzaav() {
        zzawz.zzds("Cannot add text view to inner AdWebView");
    }

    @Override
    public final void zzat(boolean bl) {
        this.zzemn.zzat(bl);
    }

    @Override
    public final void stopLoading() {
        try {
            super.stopLoading();
            return;
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Could not stop loading webview.", (Throwable)exception);
            return;
        }
    }

    @Override
    public final synchronized void zzar(boolean bl) {
        this.zzelc = bl;
    }

    @Override
    public final synchronized boolean zzaap() {
        return this.zzelc;
    }

    @Override
    public final synchronized void zzlc() {
        this.zzeld = true;
        if (this.zzekp != null) {
            this.zzekp.zzlc();
        }
    }

    @Override
    public final synchronized void zzld() {
        this.zzeld = false;
        if (this.zzekp != null) {
            this.zzekp.zzld();
        }
    }

    private final synchronized void zzabq() {
        if (this.zzels != null) {
            Iterator<zzbft> iterator = this.zzels.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().release();
            }
        }
        this.zzels = null;
    }

    @Override
    public final synchronized void zza(String string2, zzbft zzbft2) {
        if (this.zzels == null) {
            this.zzels = new HashMap<String, zzbft>();
        }
        this.zzels.put(string2, zzbft2);
    }

    @Override
    public final synchronized zzbft zzet(String string2) {
        if (this.zzels == null) {
            return null;
        }
        return this.zzels.get(string2);
    }

    @Override
    public final synchronized String zzyf() {
        return this.zzdlx;
    }

    @Override
    public final zzbcw zzya() {
        return null;
    }

    @Override
    public final zzadg zzyc() {
        return this.zzeem;
    }

    @Override
    public final zzadh zzyg() {
        return this.zzeln;
    }

    @Override
    public final void setOnClickListener(View.OnClickListener onClickListener) {
        this.zzelo = new WeakReference<View.OnClickListener>(onClickListener);
        super.setOnClickListener(onClickListener);
    }

    @Override
    public final synchronized void zza(zzadx zzadx2) {
        this.zzelh = zzadx2;
    }

    @Override
    public final synchronized zzadx zzaat() {
        return this.zzelh;
    }

    @Override
    public final synchronized void zzyk() {
        if (this.zzeli != null) {
            this.zzeli.zzre();
        }
    }

    @Override
    public final synchronized void zza(zzadv zzadv2) {
        this.zzeli = zzadv2;
    }

    @Override
    public final synchronized zzbhq zzyb() {
        return this.zzele;
    }

    @Override
    public final synchronized void zza(zzbhq zzbhq2) {
        if (this.zzele != null) {
            zzawz.zzen((String)"Attempt to create multiple AdWebViewVideoControllers.");
            return;
        }
        this.zzele = zzbhq2;
    }

    @Override
    public final synchronized boolean zzaaq() {
        return this.zzelj > 0;
    }

    @Override
    public final synchronized void zzas(boolean bl) {
        this.zzelj += bl ? 1 : -1;
        if (this.zzelj <= 0 && this.zzekv != null) {
            this.zzekv.zztn();
        }
    }

    private final void zzabr() {
        if (this.zzeln == null) {
            return;
        }
        zzadi zzadi2 = this.zzeln.zzqw();
        if (zzadi2 != null && zzk.zzlk().zzuw() != null) {
            zzk.zzlk().zzuw().zza(zzadi2);
        }
    }

    @Override
    public final void zzaau() {
        this.setBackgroundColor(0);
    }

    @Override
    public final void zzao(boolean bl) {
        this.zzemn.zzao(bl);
    }

    @Override
    public final void zztm() {
        zzd zzd2 = this.zzaae();
        if (zzd2 != null) {
            zzd2.zztm();
        }
    }

    @Override
    public final int zzyi() {
        return this.getMeasuredHeight();
    }

    @Override
    public final int zzyj() {
        return this.getMeasuredWidth();
    }

    @Override
    public final void zza(zzc zzc2) {
        this.zzemn.zza(zzc2);
    }

    @Override
    public final void zzc(boolean bl, int n) {
        this.zzemn.zzc(bl, n);
    }

    @Override
    public final void zza(boolean bl, int n, String string2) {
        this.zzemn.zza(bl, n, string2);
    }

    @Override
    public final void zza(boolean bl, int n, String string2, String string3) {
        this.zzemn.zza(bl, n, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(zzud zzud2) {
        zzbiv zzbiv2 = this;
        synchronized (zzbiv2) {
            this.zzelf = zzud2.zzbtk;
        }
        this.zzav(zzud2.zzbtk);
    }

    private final void zzav(boolean bl) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("isVisible", bl ? "1" : "0");
        HashMap<String, String> hashMap2 = hashMap;
        String string2 = "onAdVisibilityChanged";
        zzajr.zza((zzajq)this, "onAdVisibilityChanged", hashMap2);
    }

    @Override
    public final void zza(String string2, zzaho<? super zzbgz> zzaho2) {
        if (this.zzemn != null) {
            this.zzemn.zza(string2, zzaho2);
        }
    }

    @Override
    public final void zzb(String string2, zzaho<? super zzbgz> zzaho2) {
        if (this.zzemn != null) {
            this.zzemn.zzb(string2, zzaho2);
        }
    }

    @Override
    public final void zza(String string2, Predicate<zzaho<? super zzbgz>> predicate) {
        if (this.zzemn != null) {
            this.zzemn.zza(string2, predicate);
        }
    }

    @Override
    public final boolean zzb(boolean bl, int n) {
        this.destroy();
        this.zzejd.zza(new zzbiw(bl, n));
        this.zzejd.zza(zzwl.zza.zzb.zzbyy);
        return true;
    }

    @Override
    public final boolean zzaaw() {
        return false;
    }

    @Override
    public final /* synthetic */ zzbii zzaai() {
        return this.zzemn;
    }

    static final /* synthetic */ void zza(boolean bl, int n, zzxn zzxn2) {
        zzwt.zzv.zza zza2 = zzwt.zzv.zzop();
        if (zza2.zzoo() != bl) {
            zza2.zzr(bl);
        }
        zza2.zzcm(n);
        zzxn2.zzcfn = (zzwt.zzv)((zzdob)zza2.zzaya());
    }

    static /* synthetic */ int zza(zzbiv zzbiv2) {
        return zzbiv2.zzelk;
    }

    static /* synthetic */ int zza(zzbiv zzbiv2, int n) {
        zzbiv2.zzelk = n;
        return zzbiv2.zzelk;
    }

    @Override
    public final void zzb(String string2, JSONObject jSONObject) {
        zzajr.zza((zzajq)this, string2, jSONObject);
    }

    @Override
    public final void zzi(String string2, String string3) {
        zzajr.zza((zzajq)this, string2, string3);
    }

    @Override
    public final void zza(String string2, JSONObject jSONObject) {
        zzajr.zzb(this, string2, jSONObject);
    }

    public final void zza(String string2, Map map) {
        zzajr.zza((zzajq)this, string2, map);
    }
}

