/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.webkit.ValueCallback;
import android.webkit.WebViewClient;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzbbm;
import com.google.android.gms.internal.ads.zzbiy;
import com.google.android.gms.internal.ads.zzbiz;
import com.google.android.gms.internal.ads.zzbja;
import com.google.android.gms.internal.ads.zzbjc;
import com.google.android.gms.internal.ads.zzbje;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.GuardedBy;

@zzard
@ParametersAreNonnullByDefault
public class zzbjb
extends zzbiy
implements zzbje {
    private final zzbiz zzemr;
    @GuardedBy(value="this")
    private boolean zzeky;
    @GuardedBy(value="this")
    private boolean zzelq;

    public zzbjb(Context context, zzbiz zzbiz2) {
        super(context);
        zzk.zzlk().zzuz();
        this.zzemr = zzbiz2;
        super.setWebViewClient((WebViewClient)zzbiz2);
    }

    public final synchronized boolean isDestroyed() {
        return this.zzeky;
    }

    @GuardedBy(value="this")
    protected void zzaw(boolean bl) {
    }

    public synchronized void destroy() {
        if (this.zzeky) {
            return;
        }
        this.zzeky = true;
        this.zzemr.zza(this);
        this.zzaw(false);
        zzawz.zzds("Initiating WebView self destruct sequence in 3...");
        zzawz.zzds("Loading blank page in WebView, 2...");
        try {
            super.loadUrl("about:blank");
            return;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            zzk.zzlk().zza(unsatisfiedLinkError, "AdWebViewImpl.loadUrlUnsafe");
            zzawz.zze((String)"#007 Could not call remote method.", (Throwable)unsatisfiedLinkError);
            return;
        }
    }

    @Override
    public final synchronized void zza(zzbja zzbja2) {
        zzawz.zzds("Blank page loaded, 1...");
        this.zzaao();
    }

    @VisibleForTesting
    protected synchronized void zzaao() {
        zzawz.zzds("Destroying WebView!");
        this.zzva();
        zzbbm.zzeae.execute(new zzbjc(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            zzbjb zzbjb2 = this;
            synchronized (zzbjb2) {
                if (!this.isDestroyed()) {
                    this.zzaw(true);
                }
                this.zzva();
            }
            return;
        }
        finally {
            super.finalize();
        }
    }

    private final synchronized void zzva() {
        if (!this.zzelq) {
            this.zzelq = true;
            zzk.zzlk().zzva();
        }
    }

    @TargetApi(value=19)
    public synchronized void evaluateJavascript(String string2, ValueCallback<String> valueCallback) {
        if (this.isDestroyed()) {
            zzawz.zzep((String)"#004 The webview is destroyed. Ignoring action.");
            if (valueCallback != null) {
                valueCallback.onReceiveValue(null);
            }
            return;
        }
        super.evaluateJavascript(string2, valueCallback);
    }

    @Override
    public synchronized void loadUrl(String string2) {
        if (!this.isDestroyed()) {
            super.loadUrl(string2);
            return;
        }
        zzawz.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public synchronized void loadData(String string2, String string3, String string4) {
        if (!this.isDestroyed()) {
            super.loadData(string2, string3, string4);
            return;
        }
        zzawz.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public synchronized void loadDataWithBaseURL(String string2, String string3, String string4, String string5, String string6) {
        if (!this.isDestroyed()) {
            super.loadDataWithBaseURL(string2, string3, string4, string5, string6);
            return;
        }
        zzawz.zzep((String)"#004 The webview is destroyed. Ignoring action.");
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return !this.isDestroyed() && super.onTouchEvent(motionEvent);
    }

    @TargetApi(value=21)
    protected void onDraw(Canvas canvas) {
        if (this.isDestroyed()) {
            return;
        }
        super.onDraw(canvas);
    }

    public void onPause() {
        if (this.isDestroyed()) {
            return;
        }
        super.onPause();
    }

    public void onResume() {
        if (this.isDestroyed()) {
            return;
        }
        super.onResume();
    }

    public void stopLoading() {
        if (this.isDestroyed()) {
            return;
        }
        super.stopLoading();
    }

    public void setWebViewClient(WebViewClient webViewClient) {
    }

    final /* synthetic */ void zzacb() {
        super.destroy();
    }
}

