/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.os.PowerManager;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ListView;
import android.widget.ScrollView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzk;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzacj;
import com.google.android.gms.internal.ads.zzacu;
import com.google.android.gms.internal.ads.zzard;
import com.google.android.gms.internal.ads.zzawz;
import com.google.android.gms.internal.ads.zzaxi;
import com.google.android.gms.internal.ads.zzazj;
import com.google.android.gms.internal.ads.zzub;
import com.google.android.gms.internal.ads.zzuc;
import com.google.android.gms.internal.ads.zzud;
import com.google.android.gms.internal.ads.zzue;
import com.google.android.gms.internal.ads.zzuf;
import com.google.android.gms.internal.ads.zzyt;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

@zzard
@TargetApi(value=14)
public final class zzua
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final long zzbte;
    private final Context zzys;
    private Application zzww;
    private final WindowManager zzbtf;
    private final PowerManager zzyt;
    private final KeyguardManager zzyu;
    @Nullable
    @VisibleForTesting
    private BroadcastReceiver zzbtg;
    private WeakReference<ViewTreeObserver> zzyw;
    private WeakReference<View> zzbth;
    private zzuf zzbti;
    private zzazj zzbtj = new zzazj(zzbte);
    private boolean zzbtk = false;
    private int zzza = -1;
    private final HashSet<zzue> zzbtl = new HashSet();
    private final DisplayMetrics zzwb;
    private final Rect zzbtm;

    public zzua(Context context, View view) {
        this.zzys = context.getApplicationContext();
        this.zzbtf = (WindowManager)context.getSystemService("window");
        this.zzyt = (PowerManager)this.zzys.getSystemService("power");
        this.zzyu = (KeyguardManager)context.getSystemService("keyguard");
        if (this.zzys instanceof Application) {
            this.zzww = (Application)this.zzys;
            this.zzbti = new zzuf((Application)this.zzys, this);
        }
        this.zzwb = context.getResources().getDisplayMetrics();
        this.zzbtm = new Rect();
        this.zzbtm.right = this.zzbtf.getDefaultDisplay().getWidth();
        this.zzbtm.bottom = this.zzbtf.getDefaultDisplay().getHeight();
        View view2 = view;
        zzua zzua2 = this;
        View view3 = zzua2.zzbth != null ? (View)zzua2.zzbth.get() : null;
        if (view3 != null) {
            view3.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzua2);
            zzua2.zzf(view3);
        }
        zzua2.zzbth = new WeakReference<View>(view2);
        if (view2 != null) {
            if (zzk.zzli().isAttachedToWindow(view2)) {
                zzua2.zze(view2);
            }
            view2.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)zzua2);
        }
    }

    public final void zza(zzue zzue2) {
        this.zzbtl.add(zzue2);
        this.zzbu(3);
    }

    public final void zzb(zzue zzue2) {
        this.zzbtl.remove(zzue2);
    }

    private final void zzcu() {
        zzk.zzlg();
        zzaxi.zzdvv.post((Runnable)new zzub(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzza = -1;
        this.zze(view);
        this.zzbu(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzza = -1;
        this.zzbu(3);
        this.zzcu();
        this.zzf(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzbth == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = (View)this.zzbth.get();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzza = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzbu(3);
        this.zzcu();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzbu(3);
        this.zzcu();
    }

    public final void onGlobalLayout() {
        this.zzbu(2);
        this.zzcu();
    }

    public final void onScrollChanged() {
        this.zzbu(1);
    }

    private final void zzbu(int n) {
        boolean bl;
        if (this.zzbtl.size() == 0) {
            return;
        }
        if (this.zzbth == null) {
            return;
        }
        View view = (View)this.zzbth.get();
        boolean bl2 = n == 1;
        boolean bl3 = view == null;
        Rect rect = new Rect();
        Rect rect2 = new Rect();
        boolean bl4 = false;
        Rect rect3 = new Rect();
        boolean bl5 = false;
        Rect rect4 = new Rect();
        int[] nArray = new int[2];
        int[] nArray2 = new int[2];
        if (view != null) {
            bl4 = view.getGlobalVisibleRect(rect2);
            bl5 = view.getLocalVisibleRect(rect3);
            view.getHitRect(rect4);
            try {
                view.getLocationOnScreen(nArray);
                view.getLocationInWindow(nArray2);
            }
            catch (Exception exception) {
                zzawz.zzc((String)"Failure getting view location.", (Throwable)exception);
            }
            rect.left = nArray[0];
            rect.top = nArray[1];
            rect.right = rect.left + view.getWidth();
            rect.bottom = rect.top + view.getHeight();
        }
        zzacj zzacj2 = zzacu.zzcql;
        List<Rect> list = (Boolean)com.google.android.gms.internal.ads.zzyt.zzpe().zzd(zzacj2) != false && view != null ? this.zzh(view) : Collections.emptyList();
        int n2 = view != null ? view.getWindowVisibility() : 8;
        int n3 = this.zzza != -1 ? this.zzza : n2;
        boolean bl6 = bl = !bl3 && zzk.zzlg().zza(view, this.zzyt, this.zzyu) && bl4 && bl5 && n3 == 0;
        if (bl2 && !this.zzbtj.tryAcquire() && bl == this.zzbtk) {
            return;
        }
        if (!bl && !this.zzbtk && n == 1) {
            return;
        }
        zzud zzud2 = new zzud(zzk.zzln().elapsedRealtime(), this.zzyt.isScreenOn(), view != null && zzk.zzli().isAttachedToWindow(view), view != null ? view.getWindowVisibility() : 8, this.zza(this.zzbtm), this.zza(rect), this.zza(rect2), bl4, this.zza(rect3), bl5, this.zza(rect4), this.zzwb.density, bl, list);
        Iterator<zzue> iterator = this.zzbtl.iterator();
        while (iterator.hasNext()) {
            iterator.next().zza(zzud2);
        }
        this.zzbtk = bl;
    }

    private final Rect zza(Rect rect) {
        return new Rect(this.zzbv(rect.left), this.zzbv(rect.top), this.zzbv(rect.right), this.zzbv(rect.bottom));
    }

    private final int zzbv(int n) {
        float f = this.zzwb.density;
        return (int)((float)n / f);
    }

    private final List<Rect> zzh(View view) {
        try {
            ArrayList<Rect> arrayList = new ArrayList<Rect>();
            ViewParent viewParent = view.getParent();
            while (viewParent instanceof View) {
                View view2 = (View)viewParent;
                Rect rect = new Rect();
                View view3 = view2;
                if ((Build.VERSION.SDK_INT >= 16 ? view3.isScrollContainer() : view3 instanceof ScrollView || view3 instanceof ListView) && view2.getGlobalVisibleRect(rect)) {
                    arrayList.add(this.zza(rect));
                }
                viewParent = viewParent.getParent();
            }
            return arrayList;
        }
        catch (Exception exception) {
            zzk.zzlk().zza(exception, "PositionWatcher.getParentScrollViewRects");
            return Collections.emptyList();
        }
    }

    private final void zze(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzyw = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzua zzua2 = this;
        if (zzua2.zzbtg == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzua2.zzbtg = new zzuc(zzua2);
            zzk.zzmb().zza(zzua2.zzys, zzua2.zzbtg, intentFilter);
        }
        if (this.zzww != null) {
            try {
                this.zzww.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbti);
                return;
            }
            catch (Exception exception) {
                zzawz.zzc((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzyw != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzyw.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzyw = null;
            }
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            zzawz.zzc((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        zzua zzua2 = this;
        if (zzua2.zzbtg != null) {
            try {
                zzk.zzmb().zza(zzua2.zzys, zzua2.zzbtg);
            }
            catch (IllegalStateException illegalStateException) {
                zzawz.zzc((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzk.zzlk().zza(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            zzua2.zzbtg = null;
        }
        if (this.zzww != null) {
            try {
                this.zzww.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzbti);
                return;
            }
            catch (Exception exception) {
                zzawz.zzc((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            }
        }
    }

    public final void zzes(long l) {
        this.zzbtj.zzfe(l);
    }

    public final void zzmk() {
        this.zzbtj.zzfe(zzbte);
    }

    static /* synthetic */ void zza(zzua zzua2, int n) {
        zzua2.zzbu(3);
    }

    static {
        zzacj zzacj2 = zzacu.zzcqi;
        zzbte = (Long)com.google.android.gms.internal.ads.zzyt.zzpe().zzd(zzacj2);
    }
}

