/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.overlay;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.Window;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.overlay.AdOverlayInfoParcel;
import com.google.android.gms.ads.internal.overlay.zze;
import com.google.android.gms.ads.internal.overlay.zzf;
import com.google.android.gms.ads.internal.overlay.zzg;
import com.google.android.gms.ads.internal.overlay.zzi;
import com.google.android.gms.ads.internal.overlay.zzj;
import com.google.android.gms.ads.internal.overlay.zzl;
import com.google.android.gms.ads.internal.overlay.zzp;
import com.google.android.gms.ads.internal.overlay.zzq;
import com.google.android.gms.ads.internal.overlay.zzy;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzapb;
import com.google.android.gms.internal.ads.zzapf;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxf;
import com.google.android.gms.internal.ads.zzbek;
import com.google.android.gms.internal.ads.zzbes;
import com.google.android.gms.internal.ads.zzbfw;
import com.google.android.gms.internal.ads.zzst;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.util.Collections;

public class zzc
extends zzapf
implements zzy {
    @VisibleForTesting
    private static final int zzdjp = Color.argb((int)0, (int)0, (int)0, (int)0);
    protected final Activity zzaad;
    @VisibleForTesting
    AdOverlayInfoParcel zzdjq;
    @VisibleForTesting
    zzbek zzdce;
    @VisibleForTesting
    private zzi zzdjr;
    @VisibleForTesting
    private zzq zzdjs;
    @VisibleForTesting
    private boolean zzdjt = false;
    @VisibleForTesting
    private FrameLayout zzdju;
    @VisibleForTesting
    private WebChromeClient.CustomViewCallback zzdjv;
    @VisibleForTesting
    private boolean zzdjw = false;
    @VisibleForTesting
    private boolean zzblz = false;
    @VisibleForTesting
    private zzj zzdjx;
    @VisibleForTesting
    private boolean zzdjy = false;
    @VisibleForTesting
    int zzdjz = 0;
    private final Object zzdka = new Object();
    private Runnable zzdkb;
    private boolean zzdkc;
    private boolean zzdkd;
    private boolean zzdke = false;
    private boolean zzdkf = false;
    private boolean zzdkg = true;

    public zzc(Activity activity) {
        this.zzaad = activity;
    }

    public final void close() {
        this.zzdjz = 2;
        this.zzaad.finish();
    }

    public final void zzuf() {
        if (this.zzdjq != null && this.zzdjt) {
            this.setRequestedOrientation(this.zzdjq.orientation);
        }
        if (this.zzdju != null) {
            this.zzaad.setContentView((View)this.zzdjx);
            this.zzdkd = true;
            this.zzdju.removeAllViews();
            this.zzdju = null;
        }
        if (this.zzdjv != null) {
            this.zzdjv.onCustomViewHidden();
            this.zzdjv = null;
        }
        this.zzdjt = false;
    }

    @Override
    public final void zzug() {
        this.zzdjz = 1;
        this.zzaad.finish();
    }

    public final void onBackPressed() {
        this.zzdjz = 0;
    }

    public final boolean zzuh() {
        this.zzdjz = 0;
        if (this.zzdce == null) {
            return true;
        }
        boolean bl = this.zzdce.zzabq();
        if (!bl) {
            this.zzdce.zza("onbackblocked", Collections.emptyMap());
        }
        return bl;
    }

    public void onCreate(Bundle bundle) {
        this.zzaad.requestWindowFeature(1);
        this.zzdjw = bundle != null && bundle.getBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", false);
        try {
            this.zzdjq = AdOverlayInfoParcel.zzc(this.zzaad.getIntent());
            if (this.zzdjq == null) {
                throw new zzg("Could not get info for ad overlay.");
            }
            if (this.zzdjq.zzbmo.zzdzo > 7500000) {
                this.zzdjz = 3;
            }
            if (this.zzaad.getIntent() != null) {
                this.zzdkg = this.zzaad.getIntent().getBooleanExtra("shouldCallOnOverlayOpened", true);
            }
            this.zzblz = this.zzdjq.zzdla != null ? this.zzdjq.zzdla.zzblz : false;
            if (this.zzblz && this.zzdjq.zzdla.zzbme != -1) {
                new zzl(this, null).zzwn();
            }
            if (bundle == null) {
                if (this.zzdjq.zzdkt != null && this.zzdkg) {
                    this.zzdjq.zzdkt.zzua();
                }
                if (this.zzdjq.zzdky != 1 && this.zzdjq.zzceb != null) {
                    this.zzdjq.zzceb.onAdClicked();
                }
            }
            this.zzdjx = new zzj((Context)this.zzaad, this.zzdjq.zzdkz, this.zzdjq.zzbmo.zzbnd);
            this.zzdjx.setId(1000);
            com.google.android.gms.ads.internal.zzq.zzky().zzg(this.zzaad);
            switch (this.zzdjq.zzdky) {
                case 1: {
                    this.zzaj(false);
                    return;
                }
                case 2: {
                    this.zzdjr = new zzi(this.zzdjq.zzdce);
                    this.zzaj(false);
                    return;
                }
                case 3: {
                    this.zzaj(true);
                    return;
                }
            }
            throw new zzg("Could not determine ad overlay type.");
        }
        catch (zzg zzg2) {
            zzawr.zzfc((String)zzg2.getMessage());
            this.zzdjz = 3;
            this.zzaad.finish();
            return;
        }
    }

    public final void onRestart() {
    }

    public final void onStart() {
        zzzk zzzk2 = zzzz.zzcqn;
        if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            if (this.zzdce != null && !this.zzdce.isDestroyed()) {
                com.google.android.gms.ads.internal.zzq.zzky();
                zzaxf.zzb(this.zzdce);
                return;
            }
            zzawr.zzfc((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onResume() {
        if (this.zzdjq.zzdkt != null) {
            this.zzdjq.zzdkt.onResume();
        }
        this.zza(this.zzaad.getResources().getConfiguration());
        zzzk zzzk2 = zzzz.zzcqn;
        if (!((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue()) {
            if (this.zzdce != null && !this.zzdce.isDestroyed()) {
                com.google.android.gms.ads.internal.zzq.zzky();
                zzaxf.zzb(this.zzdce);
                return;
            }
            zzawr.zzfc((String)"The webview does not exist. Ignoring action.");
        }
    }

    public final void onPause() {
        this.zzuf();
        if (this.zzdjq.zzdkt != null) {
            this.zzdjq.zzdkt.onPause();
        }
        zzzk zzzk2 = zzzz.zzcqn;
        if (!(((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue() || this.zzdce == null || this.zzaad.isFinishing() && this.zzdjr != null)) {
            com.google.android.gms.ads.internal.zzq.zzky();
            zzaxf.zza(this.zzdce);
        }
        this.zzuj();
    }

    public final void onActivityResult(int n, int n2, Intent intent) {
    }

    public final void zzad(IObjectWrapper iObjectWrapper) {
        Configuration configuration = (Configuration)ObjectWrapper.unwrap((IObjectWrapper)iObjectWrapper);
        this.zza(configuration);
    }

    public final void onSaveInstanceState(Bundle bundle) {
        bundle.putBoolean("com.google.android.gms.ads.internal.overlay.hasResumed", this.zzdjw);
    }

    public final void onStop() {
        zzzk zzzk2 = zzzz.zzcqn;
        if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue() && this.zzdce != null && (!this.zzaad.isFinishing() || this.zzdjr == null)) {
            com.google.android.gms.ads.internal.zzq.zzky();
            zzaxf.zza(this.zzdce);
        }
        this.zzuj();
    }

    public final void onDestroy() {
        if (this.zzdce != null) {
            try {
                this.zzdjx.removeView(this.zzdce.getView());
            }
            catch (NullPointerException nullPointerException) {}
        }
        this.zzuj();
    }

    private final void zzai(boolean bl) {
        zzzk zzzk2 = zzzz.zzcqp;
        int n = (Integer)zzvj.zzpv().zzd(zzzk2);
        zzp zzp2 = new zzp();
        new zzp().size = 50;
        zzp2.paddingLeft = bl ? n : 0;
        zzp2.paddingRight = bl ? 0 : n;
        zzp2.paddingTop = 0;
        zzp2.paddingBottom = n;
        this.zzdjs = new zzq((Context)this.zzaad, zzp2, this);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(10);
        int n2 = bl ? 11 : 9;
        layoutParams.addRule(n2);
        this.zza(bl, this.zzdjq.zzdkv);
        this.zzdjx.addView((View)this.zzdjs, (ViewGroup.LayoutParams)layoutParams);
    }

    public final void zzdp() {
        this.zzdkd = true;
    }

    public final void zza(boolean bl, boolean bl2) {
        boolean bl3;
        zzzk zzzk2 = zzzz.zzclu;
        boolean bl4 = (Boolean)zzvj.zzpv().zzd(zzzk2) != false && this.zzdjq != null && this.zzdjq.zzdla != null && this.zzdjq.zzdla.zzbmg;
        zzzk2 = zzzz.zzclv;
        boolean bl5 = bl3 = (Boolean)zzvj.zzpv().zzd(zzzk2) != false && this.zzdjq != null && this.zzdjq.zzdla != null && this.zzdjq.zzdla.zzbmh;
        if (bl && bl2 && bl4 && !bl3) {
            new zzapb(this.zzdce, "useCustomClose").zzdv("Custom close has been disabled for interstitial ads in this ad slot.");
        }
        if (this.zzdjs != null) {
            this.zzdjs.zzal(bl3 || bl2 && !bl4);
        }
    }

    public final void zzui() {
        this.zzdjx.removeView((View)this.zzdjs);
        this.zzai(true);
    }

    public final void setRequestedOrientation(int n) {
        zzzk zzzk2 = zzzz.zzcsn;
        if (this.zzaad.getApplicationInfo().targetSdkVersion >= (Integer)zzvj.zzpv().zzd(zzzk2)) {
            zzzk2 = zzzz.zzcso;
            if (this.zzaad.getApplicationInfo().targetSdkVersion <= (Integer)zzvj.zzpv().zzd(zzzk2)) {
                zzzk2 = zzzz.zzcsp;
                if (Build.VERSION.SDK_INT >= (Integer)zzvj.zzpv().zzd(zzzk2)) {
                    zzzk2 = zzzz.zzcsq;
                    if (Build.VERSION.SDK_INT <= (Integer)zzvj.zzpv().zzd(zzzk2)) {
                        return;
                    }
                }
            }
        }
        try {
            this.zzaad.setRequestedOrientation(n);
            return;
        }
        catch (Throwable throwable) {
            com.google.android.gms.ads.internal.zzq.zzla().zzb(throwable, "AdOverlay.setRequestedOrientation");
            return;
        }
    }

    public final void zza(View view, WebChromeClient.CustomViewCallback customViewCallback) {
        this.zzdju = new FrameLayout((Context)this.zzaad);
        this.zzdju.setBackgroundColor(-16777216);
        this.zzdju.addView(view, -1, -1);
        this.zzaad.setContentView((View)this.zzdju);
        this.zzdkd = true;
        this.zzdjv = customViewCallback;
        this.zzdjt = true;
    }

    private final void zzaj(boolean bl) throws zzg {
        ViewParent viewParent;
        Window window;
        if (!this.zzdkd) {
            this.zzaad.requestWindowFeature(1);
        }
        if ((window = this.zzaad.getWindow()) == null) {
            throw new zzg("Invalid activity, no window available.");
        }
        zzbfw zzbfw2 = this.zzdjq.zzdce != null ? this.zzdjq.zzdce.zzabj() : null;
        boolean bl2 = zzbfw2 != null && zzbfw2.zzaap();
        this.zzdjy = false;
        if (bl2) {
            int n = this.zzdjq.orientation;
            com.google.android.gms.ads.internal.zzq.zzky();
            if (n == 6) {
                this.zzdjy = this.zzaad.getResources().getConfiguration().orientation == 1;
            } else {
                int n2 = this.zzdjq.orientation;
                com.google.android.gms.ads.internal.zzq.zzky();
                if (n2 == 7) {
                    this.zzdjy = this.zzaad.getResources().getConfiguration().orientation == 2;
                }
            }
        }
        boolean bl3 = this.zzdjy;
        zzawr.zzed((String)new StringBuilder(46).append("Delay onShow to next orientation change: ").append(bl3).toString());
        this.setRequestedOrientation(this.zzdjq.orientation);
        com.google.android.gms.ads.internal.zzq.zzky();
        window.setFlags(0x1000000, 0x1000000);
        zzawr.zzed((String)"Hardware acceleration on the AdActivity window enabled.");
        if (!this.zzblz) {
            this.zzdjx.setBackgroundColor(-16777216);
        } else {
            this.zzdjx.setBackgroundColor(zzdjp);
        }
        this.zzaad.setContentView((View)this.zzdjx);
        this.zzdkd = true;
        if (bl) {
            try {
                com.google.android.gms.ads.internal.zzq.zzkx();
                this.zzdce = zzbes.zza((Context)this.zzaad, this.zzdjq.zzdce != null ? this.zzdjq.zzdce.zzabh() : null, this.zzdjq.zzdce != null ? this.zzdjq.zzdce.zzabi() : null, true, bl2, null, this.zzdjq.zzbmo, null, null, this.zzdjq.zzdce != null ? this.zzdjq.zzdce.zzzi() : null, zzst.zzmz(), null, false);
            }
            catch (Exception exception) {
                zzawr.zzc((String)"Error obtaining webview.", (Throwable)exception);
                throw new zzg("Could not obtain webview for the overlay.");
            }
            this.zzdce.zzabj().zza(null, this.zzdjq.zzczu, null, this.zzdjq.zzczw, this.zzdjq.zzdkx, true, null, this.zzdjq.zzdce != null ? this.zzdjq.zzdce.zzabj().zzaao() : null, null, null);
            this.zzdce.zzabj().zza(new zzf(this));
            if (this.zzdjq.url != null) {
                this.zzdce.loadUrl(this.zzdjq.url);
            } else if (this.zzdjq.zzdkw != null) {
                this.zzdce.loadDataWithBaseURL(this.zzdjq.zzdku, this.zzdjq.zzdkw, "text/html", "UTF-8", null);
            } else {
                throw new zzg("No URL or HTML to display in ad overlay.");
            }
            if (this.zzdjq.zzdce != null) {
                this.zzdjq.zzdce.zzb(this);
            }
        } else {
            this.zzdce = this.zzdjq.zzdce;
            this.zzdce.zzbt((Context)this.zzaad);
        }
        this.zzdce.zza(this);
        if (this.zzdjq.zzdce != null) {
            zzc.zzc(this.zzdjq.zzdce.zzabn(), (View)this.zzdjx);
        }
        if ((viewParent = this.zzdce.getParent()) != null && viewParent instanceof ViewGroup) {
            ((ViewGroup)viewParent).removeView(this.zzdce.getView());
        }
        if (this.zzblz) {
            this.zzdce.zzabv();
        }
        this.zzdce.zza(null, this.zzaad, this.zzdjq.zzdku, this.zzdjq.zzdkw);
        this.zzdjx.addView(this.zzdce.getView(), -1, -1);
        if (!bl && !this.zzdjy) {
            this.zzum();
        }
        this.zzai(bl2);
        if (this.zzdce.zzabl()) {
            this.zza(bl2, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzuj() {
        if (!this.zzaad.isFinishing() || this.zzdke) {
            return;
        }
        this.zzdke = true;
        if (this.zzdce != null) {
            int n = this.zzdjz;
            this.zzdce.zzdn(n);
            Object object = this.zzdka;
            synchronized (object) {
                if (!this.zzdkc && this.zzdce.zzabr()) {
                    this.zzdkb = new zze(this);
                    zzzk zzzk2 = zzzz.zzclt;
                    zzaxa.zzdwf.postDelayed(this.zzdkb, ((Long)zzvj.zzpv().zzd(zzzk2)).longValue());
                    return;
                }
            }
        }
        this.zzuk();
    }

    @VisibleForTesting
    final void zzuk() {
        if (this.zzdkf) {
            return;
        }
        this.zzdkf = true;
        if (this.zzdce != null) {
            this.zzdjx.removeView(this.zzdce.getView());
            if (this.zzdjr != null) {
                this.zzdce.zzbt(this.zzdjr.zzvf);
                this.zzdce.zzba(false);
                this.zzdjr.parent.addView(this.zzdce.getView(), this.zzdjr.index, this.zzdjr.zzdkm);
                this.zzdjr = null;
            } else if (this.zzaad.getApplicationContext() != null) {
                this.zzdce.zzbt(this.zzaad.getApplicationContext());
            }
            this.zzdce = null;
        }
        if (this.zzdjq != null && this.zzdjq.zzdkt != null) {
            this.zzdjq.zzdkt.zztz();
        }
        if (this.zzdjq != null && this.zzdjq.zzdce != null) {
            zzc.zzc(this.zzdjq.zzdce.zzabn(), this.zzdjq.zzdce.getView());
        }
    }

    private static void zzc(@Nullable IObjectWrapper iObjectWrapper, @Nullable View view) {
        if (iObjectWrapper != null && view != null) {
            com.google.android.gms.ads.internal.zzq.zzll().zza(iObjectWrapper, view);
        }
    }

    public final void zzul() {
        if (this.zzdjy) {
            this.zzdjy = false;
            this.zzum();
        }
    }

    private final void zzum() {
        this.zzdce.zzum();
    }

    public final void zzun() {
        this.zzdjx.zzdko = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzuo() {
        Object object = this.zzdka;
        synchronized (object) {
            this.zzdkc = true;
            if (this.zzdkb != null) {
                zzaxa.zzdwf.removeCallbacks(this.zzdkb);
                zzaxa.zzdwf.post(this.zzdkb);
            }
            return;
        }
    }

    private final void zza(Configuration configuration) {
        boolean bl = this.zzdjq != null && this.zzdjq.zzdla != null && this.zzdjq.zzdla.zzbma;
        boolean bl2 = com.google.android.gms.ads.internal.zzq.zzky().zza(this.zzaad, configuration);
        boolean bl3 = false;
        boolean bl4 = false;
        if (!(this.zzblz && !bl || bl2)) {
            bl3 = true;
            if (Build.VERSION.SDK_INT >= 19 && this.zzdjq != null && this.zzdjq.zzdla != null && this.zzdjq.zzdla.zzbmf) {
                bl4 = true;
            }
        }
        Window window = this.zzaad.getWindow();
        zzzk zzzk2 = zzzz.zzclw;
        if (((Boolean)zzvj.zzpv().zzd(zzzk2)).booleanValue() && Build.VERSION.SDK_INT >= 19) {
            View view = window.getDecorView();
            int n = 256;
            if (bl3) {
                n = 5380;
                if (bl4) {
                    n = 5894;
                }
            }
            view.setSystemUiVisibility(n);
            return;
        }
        if (bl3) {
            window.addFlags(1024);
            window.clearFlags(2048);
            if (Build.VERSION.SDK_INT >= 19 && bl4) {
                window.getDecorView().setSystemUiVisibility(4098);
                return;
            }
        } else {
            window.addFlags(2048);
            window.clearFlags(1024);
        }
    }
}

