/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzf;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzakh;
import com.google.android.gms.internal.ads.zzakk;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzazz;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzbaf;
import com.google.android.gms.internal.ads.zzdqw;
import com.google.android.gms.internal.ads.zzdri;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.util.concurrent.Executor;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
public final class zzd {
    private Context zzvf;
    private long zzblx = 0L;

    public final void zza(Context context, zzazz zzazz2, String string2, @Nullable Runnable runnable) {
        this.zza(context, zzazz2, true, null, string2, null, runnable);
    }

    public final void zza(Context context, zzazz zzazz2, String string2, zzawe zzawe2) {
        String string3 = zzawe2 != null ? zzawe2.zzwi() : null;
        this.zza(context, zzazz2, false, zzawe2, string3, string2, null);
    }

    @VisibleForTesting
    private final void zza(Context context, zzazz zzazz2, boolean bl, @Nullable zzawe zzawe2, String string2, @Nullable String string3, @Nullable Runnable runnable) {
        boolean bl2;
        if (zzq.zzld().elapsedRealtime() - this.zzblx < 5000L) {
            zzawr.zzfc((String)"Not retrying to fetch app settings");
            return;
        }
        this.zzblx = zzq.zzld().elapsedRealtime();
        zzawe zzawe3 = zzawe2;
        if (zzawe3 == null) {
            bl2 = true;
        } else {
            long l = zzawe3.zzwf();
            zzzk zzzk2 = zzzz.zzcpn;
            bl2 = zzq.zzld().currentTimeMillis() - l > (Long)zzvj.zzpv().zzd(zzzk2) || !zzawe3.zzwg();
        }
        if (!bl2) {
            return;
        }
        if (context == null) {
            zzawr.zzfc((String)"Context not provided to fetch application settings");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string3)) {
            zzawr.zzfc((String)"App settings could not be fetched. Required parameters missing");
            return;
        }
        Context context2 = context.getApplicationContext();
        this.zzvf = context2 != null ? context2 : context;
        zzakh<JSONObject, JSONObject> zzakh2 = zzq.zzlj().zzb(this.zzvf, zzazz2).zza("google.afma.config.fetchAppSettings", zzakk.zzddu, zzakk.zzddu);
        try {
            JSONObject jSONObject = new JSONObject();
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                jSONObject.put("app_id", (Object)string2);
            } else if (!TextUtils.isEmpty((CharSequence)string3)) {
                jSONObject.put("ad_unit_id", (Object)string3);
            }
            jSONObject.put("is_init", bl);
            jSONObject.put("pn", (Object)context.getPackageName());
            zzdri<JSONObject> zzdri2 = zzakh2.zzi(jSONObject);
            zzdri zzdri3 = zzdqw.zzb(zzdri2, zzf.zzbly, (Executor)zzbab.zzdzw);
            if (runnable != null) {
                zzdri2.addListener(runnable, zzbab.zzdzw);
            }
            zzbaf.zza(zzdri3, "ConfigLoader.maybeFetchNewAppSettings");
            return;
        }
        catch (Exception exception) {
            zzawr.zzc((String)"Error requesting application settings", (Throwable)exception);
            return;
        }
    }
}

