/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.DeviceProperties;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.ads.zzaaw;
import com.google.android.gms.internal.ads.zzars;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzazm;
import com.google.android.gms.internal.ads.zzvj;
import java.util.Locale;

public final class zzarr {
    private int zzdpr;
    private boolean zzdps;
    private boolean zzdpt;
    private int zzdpu;
    private int zzdpv;
    private int zzdpw;
    private String zzdpx;
    private int zzdpy;
    private int zzdpz;
    private int zzdqa;
    private boolean zzdqb;
    private int zzdqc;
    private double zzdqd;
    private boolean zzdqe;
    private String zzdqf;
    private String zzdqg;
    private boolean zzdqh;
    private boolean zzdqi;
    private String zzdqj;
    private boolean zzdqk;
    private final boolean zzdql;
    private boolean zzdqm;
    private String zzdqn;
    private String zzdqo;
    private float zzbpk;
    private int zzdji;
    private int zzdjj;
    private String zzdqp;
    private boolean zzdqq;

    public zzarr(Context context) {
        PackageManager packageManager = context.getPackageManager();
        this.zzt(context);
        this.zzu(context);
        this.zzv(context);
        Locale locale = Locale.getDefault();
        this.zzdqh = zzarr.zza(packageManager, "geo:0,0?q=donuts") != null;
        this.zzdqi = zzarr.zza(packageManager, "http://www.google.com") != null;
        this.zzdqj = locale.getCountry();
        zzvj.zzpr();
        this.zzdqk = zzazm.zzyd();
        this.zzdql = DeviceProperties.isLatchsky((Context)context);
        this.zzdqm = DeviceProperties.isSidewinder((Context)context);
        this.zzdqn = locale.getLanguage();
        this.zzdqo = zzarr.zza(context, packageManager);
        this.zzdqp = zzarr.zzw(context);
        Resources resources = context.getResources();
        if (resources == null) {
            return;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        if (displayMetrics == null) {
            return;
        }
        this.zzbpk = displayMetrics.density;
        this.zzdji = displayMetrics.widthPixels;
        this.zzdjj = displayMetrics.heightPixels;
    }

    public zzarr(Context context, zzars zzars2) {
        this.zzt(context);
        this.zzu(context);
        this.zzv(context);
        Context context2 = context;
        zzarr zzarr2 = this;
        this.zzdqf = Build.FINGERPRINT;
        zzarr2.zzdqg = Build.DEVICE;
        zzarr2.zzdqq = PlatformVersion.isAtLeastIceCreamSandwichMR1() && zzaaw.zzj(context2);
        this.zzdqh = zzars2.zzdqh;
        this.zzdqi = zzars2.zzdqi;
        this.zzdqj = zzars2.zzdqj;
        this.zzdqk = zzars2.zzdqk;
        this.zzdql = zzars2.zzdql;
        this.zzdqm = zzars2.zzdqm;
        this.zzdqn = zzars2.zzdqn;
        this.zzdqo = zzars2.zzdqo;
        this.zzdqp = zzars2.zzdqp;
        this.zzbpk = zzars2.zzbpk;
        this.zzdji = zzars2.zzdji;
        this.zzdjj = zzars2.zzdjj;
    }

    private final void zzt(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        if (audioManager != null) {
            try {
                this.zzdpr = audioManager.getMode();
                this.zzdps = audioManager.isMusicActive();
                this.zzdpt = audioManager.isSpeakerphoneOn();
                this.zzdpu = audioManager.getStreamVolume(3);
                this.zzdpv = audioManager.getRingerMode();
                this.zzdpw = audioManager.getStreamVolume(2);
                return;
            }
            catch (Throwable throwable) {
                zzq.zzla().zza(throwable, "DeviceInfo.gatherAudioInfo");
            }
        }
        this.zzdpr = -2;
        this.zzdps = false;
        this.zzdpt = false;
        this.zzdpu = 0;
        this.zzdpv = 2;
        this.zzdpw = 0;
    }

    @TargetApi(value=16)
    private final void zzu(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        this.zzdpx = telephonyManager.getNetworkOperator();
        this.zzdpz = telephonyManager.getNetworkType();
        this.zzdqa = telephonyManager.getPhoneType();
        this.zzdpy = -2;
        this.zzdqb = false;
        this.zzdqc = -1;
        zzq.zzkw();
        if (zzaxa.zzq(context, "android.permission.ACCESS_NETWORK_STATE")) {
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                this.zzdpy = networkInfo.getType();
                this.zzdqc = networkInfo.getDetailedState().ordinal();
            } else {
                this.zzdpy = -1;
            }
            this.zzdqb = connectivityManager.isActiveNetworkMetered();
        }
    }

    private final void zzv(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = context.registerReceiver(null, intentFilter);
        if (intent != null) {
            int n = intent.getIntExtra("status", -1);
            int n2 = intent.getIntExtra("level", -1);
            int n3 = intent.getIntExtra("scale", -1);
            this.zzdqd = (float)n2 / (float)n3;
            this.zzdqe = n == 2 || n == 5;
            return;
        }
        this.zzdqd = -1.0;
        this.zzdqe = false;
    }

    private static String zzw(Context context) {
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo("com.android.vending", 128);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = packageInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String zza(Context context, PackageManager packageManager) {
        ResolveInfo resolveInfo = zzarr.zza(packageManager, "market://details?id=com.google.android.gms.ads");
        if (resolveInfo == null) {
            return null;
        }
        ActivityInfo activityInfo = resolveInfo.activityInfo;
        if (activityInfo == null) {
            return null;
        }
        try {
            PackageInfo packageInfo = Wrappers.packageManager((Context)context).getPackageInfo(activityInfo.packageName, 0);
            if (packageInfo != null) {
                int n = packageInfo.versionCode;
                String string2 = activityInfo.packageName;
                return new StringBuilder(12 + String.valueOf(string2).length()).append(n).append(".").append(string2).toString();
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return null;
        }
    }

    private static ResolveInfo zza(PackageManager packageManager, String string2) {
        try {
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
            return packageManager.resolveActivity(intent, 65536);
        }
        catch (Throwable throwable) {
            zzq.zzla().zza(throwable, "DeviceInfo.getResolveInfo");
            return null;
        }
    }

    public final zzars zzvb() {
        return new zzars(this.zzdpr, this.zzdqh, this.zzdqi, this.zzdpx, this.zzdqj, this.zzdqk, this.zzdql, this.zzdqm, this.zzdps, this.zzdpt, this.zzdqn, this.zzdqo, this.zzdqp, this.zzdpu, this.zzdpy, this.zzdpz, this.zzdqa, this.zzdpv, this.zzdpw, this.zzbpk, this.zzdji, this.zzdjj, this.zzdqd, this.zzdqe, this.zzdqb, this.zzdqc, this.zzdqf, this.zzdqq, this.zzdqg);
    }
}

