/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Looper;
import android.security.NetworkSecurityPolicy;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.ads.zzabh;
import com.google.android.gms.internal.ads.zzawe;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzawt;
import com.google.android.gms.internal.ads.zzawv;
import com.google.android.gms.internal.ads.zzawy;
import com.google.android.gms.internal.ads.zzbab;
import com.google.android.gms.internal.ads.zzdri;
import com.google.android.gms.internal.ads.zzqp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzaww
implements zzawt {
    private final Object lock = new Object();
    private boolean zzdvi;
    private final List<Runnable> zzdvj = new ArrayList<Runnable>();
    private zzdri<?> zzdvk;
    @GuardedBy(value="lock")
    @Nullable
    private zzqp zzdvl = null;
    @GuardedBy(value="lock")
    @Nullable
    private SharedPreferences zzcip;
    @GuardedBy(value="lock")
    @Nullable
    private SharedPreferences.Editor zzdvm;
    @GuardedBy(value="lock")
    private boolean zzdvn = false;
    @GuardedBy(value="lock")
    private boolean zzdme = true;
    @GuardedBy(value="lock")
    @Nullable
    private String zzdvo;
    @GuardedBy(value="lock")
    @Nullable
    private String zzdvp;
    @GuardedBy(value="lock")
    private boolean zzdmr = false;
    @GuardedBy(value="lock")
    private String zzdmu = "";
    @GuardedBy(value="lock")
    private long zzdvq = 0L;
    @GuardedBy(value="lock")
    private long zzdvr = 0L;
    @GuardedBy(value="lock")
    private long zzdvs = 0L;
    @GuardedBy(value="lock")
    private int zzdvt = -1;
    @GuardedBy(value="lock")
    private int zzdvu = 0;
    @GuardedBy(value="lock")
    private Set<String> zzdvv = Collections.emptySet();
    @GuardedBy(value="lock")
    private JSONObject zzdvw = new JSONObject();
    @GuardedBy(value="lock")
    private boolean zzdod = true;
    @GuardedBy(value="lock")
    private boolean zzdop = true;
    @GuardedBy(value="lock")
    private String zzdvx = null;
    @GuardedBy(value="lock")
    private int zzdvy = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Context context, String string2, boolean bl) {
        String string3;
        Object object = this.lock;
        synchronized (object) {
            if (this.zzcip != null) {
                return;
            }
        }
        if (string2 == null) {
            string3 = "admob";
        } else {
            String string4 = String.valueOf("admob__");
            String string5 = String.valueOf(string2);
            string3 = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        object = string3;
        this.zzdvk = zzbab.zzdzr.zzf(new zzawv(this, context, (String)object));
        this.zzdvi = bl;
    }

    private final void zzxd() {
        if (this.zzdvk == null) {
            return;
        }
        if (this.zzdvk.isDone()) {
            return;
        }
        try {
            this.zzdvk.get(1L, TimeUnit.SECONDS);
            return;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            zzawr.zzd((String)"Interrupted while waiting for preferences loaded.", (Throwable)interruptedException);
            return;
        }
        catch (CancellationException | ExecutionException | TimeoutException exception) {
            zzawr.zzc((String)"Fail to initialize AdSharedPreferenceManager.", (Throwable)exception);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bundle zzxe() {
        Bundle bundle = new Bundle();
        bundle.putBoolean("listener_registration_bundle", true);
        Object object = this.lock;
        synchronized (object) {
            bundle.putBoolean("use_https", this.zzdme);
            bundle.putBoolean("content_url_opted_out", this.zzdod);
            bundle.putBoolean("content_vertical_opted_out", this.zzdop);
            bundle.putBoolean("auto_collect_location", this.zzdmr);
            bundle.putInt("version_code", this.zzdvu);
            bundle.putStringArray("never_pool_slots", this.zzdvv.toArray(new String[0]));
            bundle.putString("app_settings_json", this.zzdmu);
            bundle.putLong("app_settings_last_update_ms", this.zzdvq);
            bundle.putLong("app_last_background_time_ms", this.zzdvr);
            bundle.putInt("request_in_session_count", this.zzdvt);
            bundle.putLong("first_ad_req_time_ms", this.zzdvs);
            bundle.putString("native_advanced_settings", this.zzdvw.toString());
            bundle.putString("display_cutout", this.zzdvx);
            bundle.putInt("app_measurement_npa", this.zzdvy);
            if (this.zzdvo != null) {
                bundle.putString("content_url_hashes", this.zzdvo);
            }
            if (this.zzdvp != null) {
                bundle.putString("content_vertical_hashes", this.zzdvp);
            }
        }
        return bundle;
    }

    private final void zzc(Bundle bundle) {
        zzbab.zzdzr.execute(new zzawy(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final zzqp zzwp() {
        if (!this.zzdvi) {
            return null;
        }
        if (this.zzwq() && this.zzws()) {
            return null;
        }
        if (!((Boolean)zzabh.zzcwc.get()).booleanValue()) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (Looper.getMainLooper() == null) {
                return null;
            }
            if (this.zzdvl == null) {
                this.zzdvl = new zzqp();
            }
            this.zzdvl.zzmh();
            zzawr.zzfb((String)"start fetching content...");
            return this.zzdvl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzao(boolean bl) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdod == bl) {
                return;
            }
            this.zzdod = bl;
            if (this.zzdvm != null) {
                this.zzdvm.putBoolean("content_url_opted_out", bl);
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzdod);
            bundle.putBoolean("content_vertical_opted_out", this.zzdop);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzwq() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzeh(@Nullable String string2) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzdvo)) {
                return;
            }
            this.zzdvo = string2;
            if (this.zzdvm != null) {
                this.zzdvm.putString("content_url_hashes", string2);
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_url_hashes", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final String zzwr() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzap(boolean bl) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdop == bl) {
                return;
            }
            this.zzdop = bl;
            if (this.zzdvm != null) {
                this.zzdvm.putBoolean("content_vertical_opted_out", bl);
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("content_url_opted_out", this.zzdod);
            bundle.putBoolean("content_vertical_opted_out", this.zzdop);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzws() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdop;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzei(@Nullable String string2) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            if (string2 == null || string2.equals(this.zzdvp)) {
                return;
            }
            this.zzdvp = string2;
            if (this.zzdvm != null) {
                this.zzdvm.putString("content_vertical_hashes", string2);
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("content_vertical_hashes", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final String zzwt() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzaq(boolean bl) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdmr == bl) {
                return;
            }
            this.zzdmr = bl;
            if (this.zzdvm != null) {
                this.zzdvm.putBoolean("auto_collect_location", bl);
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putBoolean("auto_collect_location", bl);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean zzwu() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdmr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcy(int n) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvu == n) {
                return;
            }
            this.zzdvu = n;
            if (this.zzdvm != null) {
                this.zzdvm.putInt("version_code", n);
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("version_code", n);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int zzwv() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvu;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzej(String string2) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            long l;
            this.zzdvq = l = zzq.zzld().currentTimeMillis();
            if (string2 == null || string2.equals(this.zzdmu)) {
                return;
            }
            this.zzdmu = string2;
            if (this.zzdvm != null) {
                this.zzdvm.putString("app_settings_json", string2);
                this.zzdvm.putLong("app_settings_last_update_ms", l);
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("app_settings_json", string2);
            bundle.putLong("app_settings_last_update_ms", l);
            this.zzc(bundle);
            Iterator<Runnable> iterator = this.zzdvj.iterator();
            while (iterator.hasNext()) {
                iterator.next().run();
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final zzawe zzww() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return new zzawe(this.zzdmu, this.zzdvq);
        }
    }

    @Override
    public final void zzb(Runnable runnable) {
        this.zzdvj.add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzez(long l) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvr == l) {
                return;
            }
            this.zzdvr = l;
            if (this.zzdvm != null) {
                this.zzdvm.putLong("app_last_background_time_ms", l);
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("app_last_background_time_ms", l);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long zzwx() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzcz(int n) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvt == n) {
                return;
            }
            this.zzdvt = n;
            if (this.zzdvm != null) {
                this.zzdvm.putInt("request_in_session_count", n);
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putInt("request_in_session_count", n);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int zzwy() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvt;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzfa(long l) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            if (this.zzdvs == l) {
                return;
            }
            this.zzdvs = l;
            if (this.zzdvm != null) {
                this.zzdvm.putLong("first_ad_req_time_ms", l);
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putLong("first_ad_req_time_ms", l);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long zzwz() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zza(String string2, String string3, boolean bl) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            JSONObject jSONObject;
            JSONArray jSONArray = this.zzdvw.optJSONArray(string2);
            if (jSONArray == null) {
                jSONArray = new JSONArray();
            }
            int n = jSONArray.length();
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.optJSONObject(i);
                if (jSONObject2 == null) {
                    return;
                }
                if (!string3.equals(jSONObject2.optString("template_id"))) continue;
                if (bl && jSONObject2.optBoolean("uses_media_view", false)) {
                    return;
                }
                n = i;
                break;
            }
            try {
                jSONObject = new JSONObject();
                jSONObject.put("template_id", (Object)string3);
                jSONObject.put("uses_media_view", bl);
                jSONObject.put("timestamp_ms", zzq.zzld().currentTimeMillis());
                jSONArray.put(n, (Object)jSONObject);
                this.zzdvw.put(string2, (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                zzawr.zzd((String)"Could not update native advanced settings", (Throwable)jSONException);
            }
            if (this.zzdvm != null) {
                this.zzdvm.putString("native_advanced_settings", this.zzdvw.toString());
                this.zzdvm.apply();
            }
            jSONObject = new Bundle();
            jSONObject.putString("native_advanced_settings", this.zzdvw.toString());
            this.zzc((Bundle)jSONObject);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final JSONObject zzxa() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvw;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzxb() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            this.zzdvw = new JSONObject();
            if (this.zzdvm != null) {
                this.zzdvm.remove("native_advanced_settings");
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("native_advanced_settings", "{}");
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String zzxc() {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            return this.zzdvx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzek(String string2) {
        this.zzxd();
        Object object = this.lock;
        synchronized (object) {
            if (TextUtils.equals((CharSequence)this.zzdvx, (CharSequence)string2)) {
                return;
            }
            this.zzdvx = string2;
            if (this.zzdvm != null) {
                this.zzdvm.putString("display_cutout", string2);
                this.zzdvm.apply();
            }
            Bundle bundle = new Bundle();
            bundle.putString("display_cutout", string2);
            this.zzc(bundle);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final /* synthetic */ void zzp(Context context, String string2) {
        String string3 = string2;
        Context context2 = context;
        zzaww zzaww2 = this;
        SharedPreferences sharedPreferences = context2.getSharedPreferences(string3, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        Object object = zzaww2.lock;
        synchronized (object) {
            zzaww2.zzcip = sharedPreferences;
            zzaww2.zzdvm = editor;
            zzaww2.zzdvn = PlatformVersion.isAtLeastM() && !NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
            zzaww2.zzdme = zzaww2.zzcip.getBoolean("use_https", zzaww2.zzdme);
            zzaww2.zzdod = zzaww2.zzcip.getBoolean("content_url_opted_out", zzaww2.zzdod);
            zzaww2.zzdvo = zzaww2.zzcip.getString("content_url_hashes", zzaww2.zzdvo);
            zzaww2.zzdmr = zzaww2.zzcip.getBoolean("auto_collect_location", zzaww2.zzdmr);
            zzaww2.zzdop = zzaww2.zzcip.getBoolean("content_vertical_opted_out", zzaww2.zzdop);
            zzaww2.zzdvp = zzaww2.zzcip.getString("content_vertical_hashes", zzaww2.zzdvp);
            zzaww2.zzdvu = zzaww2.zzcip.getInt("version_code", zzaww2.zzdvu);
            zzaww2.zzdmu = zzaww2.zzcip.getString("app_settings_json", zzaww2.zzdmu);
            zzaww2.zzdvq = zzaww2.zzcip.getLong("app_settings_last_update_ms", zzaww2.zzdvq);
            zzaww2.zzdvr = zzaww2.zzcip.getLong("app_last_background_time_ms", zzaww2.zzdvr);
            zzaww2.zzdvt = zzaww2.zzcip.getInt("request_in_session_count", zzaww2.zzdvt);
            zzaww2.zzdvs = zzaww2.zzcip.getLong("first_ad_req_time_ms", zzaww2.zzdvs);
            zzaww2.zzdvv = zzaww2.zzcip.getStringSet("never_pool_slots", zzaww2.zzdvv);
            zzaww2.zzdvx = zzaww2.zzcip.getString("display_cutout", zzaww2.zzdvx);
            zzaww2.zzdvy = zzaww2.zzcip.getInt("app_measurement_npa", zzaww2.zzdvy);
            try {
                zzaww2.zzdvw = new JSONObject(zzaww2.zzcip.getString("native_advanced_settings", "{}"));
            }
            catch (JSONException jSONException) {
                zzawr.zzd((String)"Could not convert native advanced settings to json object", (Throwable)jSONException);
            }
            zzaww2.zzc(zzaww2.zzxe());
            return;
        }
    }
}

