/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzaxa;
import com.google.android.gms.internal.ads.zzaxz;
import com.google.android.gms.internal.ads.zzaym;
import com.google.android.gms.internal.ads.zzdri;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzaya {
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private String zzdxa = "";
    @GuardedBy(value="lock")
    private String zzdxb = "";
    @GuardedBy(value="lock")
    private boolean zzdxc = false;
    @VisibleForTesting
    private String zzdxd = "";

    public final void zze(Context context, String string2, String string3) {
        if (!this.zzf(context, string2, string3)) {
            this.zza(context, "In-app preview failed to load because of a system error. Please try again later.", true, true);
            return;
        }
        if ("2".equals(this.zzdxd)) {
            zzawr.zzed((String)"Creative is not pushed for this device.");
            this.zza(context, "There was no creative pushed from DFP to the device.", false, false);
            return;
        }
        if ("1".equals(this.zzdxd)) {
            zzawr.zzed((String)"The app is not linked for creative preview.");
            this.zzi(context, string2, string3);
            return;
        }
        if ("0".equals(this.zzdxd)) {
            zzawr.zzed((String)"Device is linked for in app preview.");
            this.zza(context, "The device is successfully linked for creative preview.", false, true);
        }
    }

    public final void zza(Context context, String string2, String string3, @Nullable String string4) {
        boolean bl = this.zzxu();
        if (this.zzg(context, string2, string3)) {
            if (!bl && !TextUtils.isEmpty((CharSequence)string4)) {
                this.zzc(context, string3, string4, string2);
            }
            zzawr.zzed((String)"Device is linked for debug signals.");
            this.zza(context, "The device is successfully linked for troubleshooting.", false, true);
            return;
        }
        this.zzi(context, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zzf(Context context, String string2, String string3) {
        String string4;
        Object object = zzzz.zzcqh;
        String string5 = zzaya.zzh(context, this.zzd(context, (String)zzvj.zzpv().zzd(object), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzawr.zzed((String)"Not linked for in app preview.");
            return false;
        }
        string5 = string5.trim();
        try {
            JSONObject jSONObject = new JSONObject(string5);
            string4 = jSONObject.optString("gct");
            this.zzdxd = jSONObject.optString("status");
        }
        catch (JSONException jSONException) {
            zzawr.zzd((String)"Fail to get in app preview response json.", (Throwable)jSONException);
            return false;
        }
        String string6 = string4;
        object = this;
        Object object2 = object.lock;
        synchronized (object2) {
            object.zzdxb = string6;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    private final boolean zzg(Context context, String string2, String string3) {
        String string4;
        Object object = zzzz.zzcqi;
        String string5 = zzaya.zzh(context, this.zzd(context, (String)zzvj.zzpv().zzd(object), string2, string3).toString(), string3);
        if (TextUtils.isEmpty((CharSequence)string5)) {
            zzawr.zzed((String)"Not linked for debug signals.");
            return false;
        }
        string5 = string5.trim();
        try {
            string4 = new JSONObject(string5).optString("debug_mode");
        }
        catch (JSONException jSONException) {
            zzawr.zzd((String)"Fail to get debug mode response json.", (Throwable)jSONException);
            return false;
        }
        boolean bl = "1".equals(string4);
        object = this;
        Object object2 = object.lock;
        synchronized (object2) {
            object.zzdxc = bl;
        }
        return bl;
    }

    @VisibleForTesting
    private static String zzh(Context context, String string2, String string3) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("User-Agent", zzq.zzkw().zzr(context, string3));
        zzdri<String> zzdri2 = new zzaym(context).zzc(string2, hashMap);
        try {
            zzzk zzzk2 = zzzz.zzcqk;
            return (String)zzdri2.get(((Integer)zzvj.zzpv().zzd(zzzk2)).intValue(), TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException timeoutException) {
            String string4 = String.valueOf(string2);
            zzawr.zzc((String)(string4.length() != 0 ? "Timeout while retriving a response from: ".concat(string4) : new String("Timeout while retriving a response from: ")), (Throwable)timeoutException);
            zzdri2.cancel(true);
        }
        catch (InterruptedException interruptedException) {
            String string5 = String.valueOf(string2);
            zzawr.zzc((String)(string5.length() != 0 ? "Interrupted while retriving a response from: ".concat(string5) : new String("Interrupted while retriving a response from: ")), (Throwable)interruptedException);
            zzdri2.cancel(true);
        }
        catch (Exception exception) {
            String string6 = String.valueOf(string2);
            zzawr.zzc((String)(string6.length() != 0 ? "Error retriving a response from: ".concat(string6) : new String("Error retriving a response from: ")), (Throwable)exception);
        }
        return null;
    }

    private final void zzi(Context context, String string2, String string3) {
        zzq.zzkw();
        zzzk zzzk2 = zzzz.zzcqg;
        zzaxa.zza(context, this.zzd(context, (String)zzvj.zzpv().zzd(zzzk2), string2, string3));
    }

    public final boolean zzb(Context context, String string2, String string3, String string4) {
        if (TextUtils.isEmpty((CharSequence)string3) || !zzq.zzlg().zzxu()) {
            return false;
        }
        zzawr.zzed((String)"Sending troubleshooting signals to the server.");
        this.zzc(context, string2, string3, string4);
        return true;
    }

    private final void zzc(Context context, String string2, String string3, String string4) {
        zzzk zzzk2 = zzzz.zzcqj;
        Uri.Builder builder = this.zzd(context, (String)zzvj.zzpv().zzd(zzzk2), string4, string2).buildUpon();
        builder.appendQueryParameter("debugData", string3);
        zzq.zzkw();
        zzaxa.zzb(context, string2, builder.build().toString());
    }

    private final Uri zzd(Context context, String string2, String string3, String string4) {
        Uri.Builder builder = Uri.parse((String)string2).buildUpon();
        builder.appendQueryParameter("linkedDeviceId", this.zzbh(context));
        builder.appendQueryParameter("adSlotPath", string3);
        builder.appendQueryParameter("afmaVersion", string4);
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String zzbh(Context context) {
        Object object = this.lock;
        synchronized (object) {
            if (TextUtils.isEmpty((CharSequence)this.zzdxa)) {
                zzq.zzkw();
                this.zzdxa = zzaxa.zzs(context, "debug_signals_id.txt");
                if (TextUtils.isEmpty((CharSequence)this.zzdxa)) {
                    zzq.zzkw();
                    this.zzdxa = zzaxa.zzxg();
                    zzq.zzkw();
                    zzaxa.zzc(context, "debug_signals_id.txt", this.zzdxa);
                }
            }
            return this.zzdxa;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String zzxt() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzdxb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zzxu() {
        Object object = this.lock;
        synchronized (object) {
            return this.zzdxc;
        }
    }

    @VisibleForTesting
    private final void zza(Context context, String string2, boolean bl, boolean bl2) {
        if (!(context instanceof Activity)) {
            zzawr.zzfb((String)"Can not create dialog without Activity Context");
            return;
        }
        zzaxa.zzdwf.post((Runnable)new zzaxz(this, context, string2, bl, bl2));
    }
}

