/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Bundle;
import android.os.Parcelable;
import android.util.JsonReader;
import android.util.JsonToken;
import android.util.JsonWriter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzayt;
import com.google.android.gms.internal.ads.zzayv;
import com.google.android.gms.internal.ads.zzayw;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzayu {
    private static final zzayw<Map<String, ?>> zzdyc = new zzayt();

    @NonNull
    public static List<String> zza(@Nullable JSONArray jSONArray, @Nullable List<String> list) throws JSONException {
        list = new ArrayList<String>();
        if (jSONArray == null) {
            return list;
        }
        for (int i = 0; i < jSONArray.length(); ++i) {
            list.add(jSONArray.getString(i));
        }
        return list;
    }

    public static List<String> zza(JsonReader jsonReader) throws IllegalStateException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            arrayList.add(jsonReader.nextString());
        }
        jsonReader.endArray();
        return arrayList;
    }

    public static Map<String, String> zzb(JsonReader jsonReader) throws IllegalStateException, IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            hashMap.put(jsonReader.nextName(), jsonReader.nextString());
        }
        jsonReader.endObject();
        return hashMap;
    }

    public static JSONObject zzc(JsonReader jsonReader) throws IllegalStateException, IOException, JSONException {
        JSONObject jSONObject = new JSONObject();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String string2 = jsonReader.nextName();
            JsonToken jsonToken = jsonReader.peek();
            if (JsonToken.BEGIN_ARRAY.equals((Object)jsonToken)) {
                jSONObject.put(string2, (Object)zzayu.zzd(jsonReader));
                continue;
            }
            if (JsonToken.BEGIN_OBJECT.equals((Object)jsonToken)) {
                jSONObject.put(string2, (Object)zzayu.zzc(jsonReader));
                continue;
            }
            if (JsonToken.BOOLEAN.equals((Object)jsonToken)) {
                jSONObject.put(string2, jsonReader.nextBoolean());
                continue;
            }
            if (JsonToken.NUMBER.equals((Object)jsonToken)) {
                jSONObject.put(string2, jsonReader.nextDouble());
                continue;
            }
            if (JsonToken.STRING.equals((Object)jsonToken)) {
                jSONObject.put(string2, (Object)jsonReader.nextString());
                continue;
            }
            String string3 = String.valueOf(jsonToken);
            throw new IllegalStateException(new StringBuilder(23 + String.valueOf(string3).length()).append("unexpected json token: ").append(string3).toString());
        }
        jsonReader.endObject();
        return jSONObject;
    }

    public static JSONArray zzd(JsonReader jsonReader) throws IllegalStateException, IOException, JSONException {
        JSONArray jSONArray = new JSONArray();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            JsonToken jsonToken = jsonReader.peek();
            if (JsonToken.BEGIN_ARRAY.equals((Object)jsonToken)) {
                jSONArray.put((Object)zzayu.zzd(jsonReader));
                continue;
            }
            if (JsonToken.BEGIN_OBJECT.equals((Object)jsonToken)) {
                jSONArray.put((Object)zzayu.zzc(jsonReader));
                continue;
            }
            if (JsonToken.BOOLEAN.equals((Object)jsonToken)) {
                jSONArray.put(jsonReader.nextBoolean());
                continue;
            }
            if (JsonToken.NUMBER.equals((Object)jsonToken)) {
                jSONArray.put(jsonReader.nextDouble());
                continue;
            }
            if (JsonToken.STRING.equals((Object)jsonToken)) {
                jSONArray.put((Object)jsonReader.nextString());
                continue;
            }
            String string2 = String.valueOf(jsonToken);
            throw new IllegalStateException(new StringBuilder(23 + String.valueOf(string2).length()).append("unexpected json token: ").append(string2).toString());
        }
        jsonReader.endArray();
        return jSONArray;
    }

    public static String zza(zzayv zzayv2) {
        return zzayu.zzk(zzayv2);
    }

    private static String zzk(Object object) {
        if (object == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            zzayu.zza(jsonWriter, object);
            jsonWriter.close();
        }
        catch (IOException iOException) {
            zzawr.zzc((String)"Error when writing JSON.", (Throwable)iOException);
            return null;
        }
        return stringWriter.toString();
    }

    public static void zza(JsonWriter jsonWriter, JSONObject jSONObject) throws IOException {
        try {
            jsonWriter.beginObject();
            Iterator iterator = jSONObject.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                Object object = jSONObject.get(string2);
                if (object instanceof String) {
                    jsonWriter.name(string2).value((String)object);
                    continue;
                }
                if (object instanceof Number) {
                    jsonWriter.name(string2).value((Number)object);
                    continue;
                }
                if (object instanceof Boolean) {
                    jsonWriter.name(string2).value(((Boolean)object).booleanValue());
                    continue;
                }
                if (object instanceof JSONObject) {
                    zzayu.zza(jsonWriter.name(string2), (JSONObject)object);
                    continue;
                }
                if (object instanceof JSONArray) {
                    zzayu.zza(jsonWriter.name(string2), (JSONArray)object);
                    continue;
                }
                String string3 = String.valueOf(object);
                throw new JSONException(new StringBuilder(23 + String.valueOf(string3).length()).append("unable to write field: ").append(string3).toString());
            }
            jsonWriter.endObject();
            return;
        }
        catch (JSONException jSONException) {
            throw new IOException(jSONException);
        }
    }

    private static void zza(JsonWriter jsonWriter, JSONArray jSONArray) throws IOException {
        try {
            jsonWriter.beginArray();
            for (int i = 0; i < jSONArray.length(); ++i) {
                Object object = jSONArray.get(i);
                if (object instanceof String) {
                    jsonWriter.value((String)object);
                    continue;
                }
                if (object instanceof Number) {
                    jsonWriter.value((Number)object);
                    continue;
                }
                if (object instanceof Boolean) {
                    jsonWriter.value(((Boolean)object).booleanValue());
                    continue;
                }
                if (object instanceof JSONObject) {
                    zzayu.zza(jsonWriter, (JSONObject)object);
                    continue;
                }
                if (object instanceof JSONArray) {
                    zzayu.zza(jsonWriter, (JSONArray)object);
                    continue;
                }
                String string2 = String.valueOf(object);
                throw new JSONException(new StringBuilder(23 + String.valueOf(string2).length()).append("unable to write field: ").append(string2).toString());
            }
            jsonWriter.endArray();
            return;
        }
        catch (JSONException jSONException) {
            throw new IOException(jSONException);
        }
    }

    private static void zza(JsonWriter jsonWriter, Object object) throws IOException {
        if (object == null) {
            jsonWriter.nullValue();
            return;
        }
        if (object instanceof Number) {
            jsonWriter.value((Number)object);
            return;
        }
        if (object instanceof Boolean) {
            jsonWriter.value(((Boolean)object).booleanValue());
            return;
        }
        if (object instanceof String) {
            jsonWriter.value((String)object);
            return;
        }
        if (object instanceof zzayv) {
            ((zzayv)object).zza(jsonWriter);
            return;
        }
        if (object instanceof Map) {
            jsonWriter.beginObject();
            for (Map.Entry entry : ((Map)object).entrySet()) {
                Object k = entry.getKey();
                if (!(k instanceof String)) continue;
                Object v = entry.getValue();
                zzayu.zza(jsonWriter.name((String)k), v);
            }
            jsonWriter.endObject();
            return;
        }
        if (object instanceof List) {
            jsonWriter.beginArray();
            for (Object e : (List)object) {
                zzayu.zza(jsonWriter, e);
            }
            jsonWriter.endArray();
            return;
        }
        jsonWriter.nullValue();
    }

    public static JSONObject zzb(JSONObject jSONObject, String string2) throws JSONException {
        JSONObject jSONObject2;
        try {
            jSONObject2 = jSONObject.getJSONObject(string2);
        }
        catch (JSONException jSONException) {
            jSONObject2 = new JSONObject();
            jSONObject.put(string2, (Object)jSONObject2);
        }
        return jSONObject2;
    }

    public static JSONObject zza(String string2, Object object) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(string2, object);
        return jSONObject;
    }

    public static JSONObject zza(JSONObject jSONObject, String ... stringArray) {
        if ((jSONObject = zzayu.zzb(jSONObject, stringArray)) == null) {
            return null;
        }
        return jSONObject.optJSONObject(stringArray[stringArray.length - 1]);
    }

    public static boolean zza(boolean bl, JSONObject jSONObject, String ... stringArray) {
        if ((jSONObject = zzayu.zzb(jSONObject, stringArray)) == null) {
            return false;
        }
        return jSONObject.optBoolean(stringArray[stringArray.length - 1], false);
    }

    public static Bundle zzh(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        Iterator iterator = jSONObject.keys();
        Bundle bundle = new Bundle();
        while (iterator.hasNext()) {
            Object object;
            String string2 = (String)iterator.next();
            Object object2 = object = jSONObject.opt(string2);
            String string3 = string2;
            Bundle bundle2 = bundle;
            if (object2 == null) continue;
            if (object2 instanceof Boolean) {
                bundle2.putBoolean(string3, ((Boolean)object2).booleanValue());
                continue;
            }
            if (object2 instanceof Double) {
                bundle2.putDouble(string3, ((Double)object2).doubleValue());
                continue;
            }
            if (object2 instanceof Integer) {
                bundle2.putInt(string3, ((Integer)object2).intValue());
                continue;
            }
            if (object2 instanceof Long) {
                bundle2.putLong(string3, ((Long)object2).longValue());
                continue;
            }
            if (object2 instanceof String) {
                bundle2.putString(string3, (String)object2);
                continue;
            }
            if (object2 instanceof JSONArray) {
                int n;
                Object[] objectArray;
                JSONArray jSONArray = (JSONArray)object2;
                String string4 = string3;
                Bundle bundle3 = bundle2;
                if (jSONArray == null || jSONArray.length() == 0) continue;
                int n2 = jSONArray.length();
                Object object3 = null;
                for (int i = 0; object3 == null && i < n2; ++i) {
                    object3 = !jSONArray.isNull(i) ? jSONArray.opt(i) : null;
                }
                if (object3 == null) {
                    String string5 = String.valueOf(string4);
                    zzawr.zzfc((String)(string5.length() != 0 ? "Expected JSONArray with at least 1 non-null element for key:".concat(string5) : new String("Expected JSONArray with at least 1 non-null element for key:")));
                    continue;
                }
                if (object3 instanceof JSONObject) {
                    objectArray = new Bundle[n2];
                    for (n = 0; n < n2; ++n) {
                        objectArray[n] = !jSONArray.isNull(n) ? zzayu.zzh(jSONArray.optJSONObject(n)) : null;
                    }
                    bundle3.putParcelableArray(string4, (Parcelable[])objectArray);
                    continue;
                }
                if (object3 instanceof Number) {
                    objectArray = new double[jSONArray.length()];
                    for (n = 0; n < n2; ++n) {
                        objectArray[n] = (Bundle)jSONArray.optDouble(n);
                    }
                    bundle3.putDoubleArray(string4, (double[])objectArray);
                    continue;
                }
                if (object3 instanceof CharSequence) {
                    objectArray = new String[n2];
                    for (n = 0; n < n2; ++n) {
                        objectArray[n] = !jSONArray.isNull(n) ? jSONArray.optString(n) : null;
                    }
                    bundle3.putStringArray(string4, (String[])objectArray);
                    continue;
                }
                if (object3 instanceof Boolean) {
                    objectArray = new boolean[n2];
                    for (n = 0; n < n2; ++n) {
                        objectArray[n] = (Bundle)jSONArray.optBoolean(n);
                    }
                    bundle3.putBooleanArray(string4, (boolean[])objectArray);
                    continue;
                }
                zzawr.zzfc((String)String.format("JSONArray with unsupported type %s for key:%s", object3.getClass().getCanonicalName(), string4));
                continue;
            }
            if (object2 instanceof JSONObject) {
                bundle2.putBundle(string3, zzayu.zzh((JSONObject)object2));
                continue;
            }
            String string6 = String.valueOf(string3);
            zzawr.zzfc((String)(string6.length() != 0 ? "Unsupported type for key:".concat(string6) : new String("Unsupported type for key:")));
        }
        return bundle;
    }

    private static JSONObject zzb(JSONObject jSONObject, String[] stringArray) {
        JSONObject jSONObject2 = jSONObject;
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (jSONObject2 == null) {
                return null;
            }
            jSONObject2 = jSONObject2.optJSONObject(stringArray[i]);
        }
        return jSONObject2;
    }
}

