/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.view.Display;
import android.view.WindowManager;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzbbt;
import com.google.android.gms.internal.ads.zzbbw;
import com.google.android.gms.internal.ads.zzdns;
import javax.annotation.concurrent.GuardedBy;

final class zzbbu
implements SensorEventListener {
    private final SensorManager zzeck;
    private final Object zzecl;
    private final Display zzecm;
    private final float[] zzecn;
    private final float[] zzeco;
    @GuardedBy(value="sensorThreadLock")
    private float[] zzecp;
    private Handler zzecq;
    private zzbbw zzecr;

    zzbbu(Context context) {
        this.zzeck = (SensorManager)context.getSystemService("sensor");
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        this.zzecm = windowManager.getDefaultDisplay();
        this.zzecn = new float[9];
        this.zzeco = new float[9];
        this.zzecl = new Object();
    }

    final void start() {
        if (this.zzecq != null) {
            return;
        }
        Sensor sensor = this.zzeck.getDefaultSensor(11);
        if (sensor == null) {
            zzawr.zzfa((String)"No Sensor of TYPE_ROTATION_VECTOR");
            return;
        }
        HandlerThread handlerThread = new HandlerThread("OrientationMonitor");
        handlerThread.start();
        this.zzecq = new zzdns(handlerThread.getLooper());
        if (!this.zzeck.registerListener((SensorEventListener)this, sensor, 0, this.zzecq)) {
            zzawr.zzfa((String)"SensorManager.registerListener failed.");
            this.stop();
        }
    }

    final void stop() {
        if (this.zzecq == null) {
            return;
        }
        this.zzeck.unregisterListener((SensorEventListener)this);
        this.zzecq.post((Runnable)new zzbbt(this));
        this.zzecq = null;
    }

    final void zza(zzbbw zzbbw2) {
        this.zzecr = zzbbw2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onSensorChanged(SensorEvent sensorEvent) {
        float[] fArray = sensorEvent.values;
        zzbbu zzbbu2 = this;
        if (fArray[0] != 0.0f || fArray[1] != 0.0f || fArray[2] != 0.0f) {
            Object object = zzbbu2.zzecl;
            synchronized (object) {
                if (zzbbu2.zzecp == null) {
                    zzbbu2.zzecp = new float[9];
                }
            }
            SensorManager.getRotationMatrixFromVector((float[])zzbbu2.zzecn, (float[])fArray);
            switch (zzbbu2.zzecm.getRotation()) {
                case 1: {
                    SensorManager.remapCoordinateSystem((float[])zzbbu2.zzecn, (int)2, (int)129, (float[])zzbbu2.zzeco);
                    break;
                }
                case 2: {
                    SensorManager.remapCoordinateSystem((float[])zzbbu2.zzecn, (int)129, (int)130, (float[])zzbbu2.zzeco);
                    break;
                }
                case 3: {
                    SensorManager.remapCoordinateSystem((float[])zzbbu2.zzecn, (int)130, (int)1, (float[])zzbbu2.zzeco);
                    break;
                }
                default: {
                    System.arraycopy(zzbbu2.zzecn, 0, zzbbu2.zzeco, 0, 9);
                }
            }
            zzbbu2.zzl(1, 3);
            zzbbu2.zzl(2, 6);
            zzbbu2.zzl(5, 7);
            Object object2 = zzbbu2.zzecl;
            synchronized (object2) {
                System.arraycopy(zzbbu2.zzeco, 0, zzbbu2.zzecp, 0, 9);
            }
            if (zzbbu2.zzecr != null) {
                zzbbu2.zzecr.zzul();
            }
        }
    }

    public final void onAccuracyChanged(Sensor sensor, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean zza(float[] fArray) {
        Object object = this.zzecl;
        synchronized (object) {
            if (this.zzecp == null) {
                return false;
            }
            System.arraycopy(this.zzecp, 0, fArray, 0, this.zzecp.length);
            return true;
        }
    }

    private final void zzl(int n, int n2) {
        float f = this.zzeco[n];
        this.zzeco[n] = this.zzeco[n2];
        this.zzeco[n2] = f;
    }
}

