/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import android.util.Log;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzbbu;
import com.google.android.gms.internal.ads.zzbbw;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.concurrent.CountDownLatch;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

@TargetApi(value=14)
public final class zzbbv
extends Thread
implements SurfaceTexture.OnFrameAvailableListener,
zzbbw {
    private static final float[] zzecs = new float[]{-1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private final zzbbu zzect;
    private final float[] zzecp;
    private final float[] zzecu;
    private final float[] zzecv;
    private final float[] zzecw;
    private final float[] zzecx;
    private final float[] zzecy;
    private final float[] zzecz;
    private float zzeda;
    private float zzedb;
    private float zzedc;
    private int height;
    private int width;
    private SurfaceTexture zzedd;
    private SurfaceTexture zzede;
    private int zzedf;
    private int zzedg;
    private int zzedh;
    private FloatBuffer zzedi = ByteBuffer.allocateDirect(zzecs.length << 2).order(ByteOrder.nativeOrder()).asFloatBuffer();
    private final CountDownLatch zzedj;
    private final Object zzedk;
    private EGL10 zzedl;
    private EGLDisplay zzedm;
    private EGLContext zzedn;
    private EGLSurface zzedo;
    private volatile boolean zzedp;
    private volatile boolean zzedq;

    public zzbbv(Context context) {
        super("SphericalVideoProcessor");
        this.zzedi.put(zzecs).position(0);
        this.zzecp = new float[9];
        this.zzecu = new float[9];
        this.zzecv = new float[9];
        this.zzecw = new float[9];
        this.zzecx = new float[9];
        this.zzecy = new float[9];
        this.zzecz = new float[9];
        this.zzeda = Float.NaN;
        this.zzect = new zzbbu(context);
        this.zzect.zza(this);
        this.zzedj = new CountDownLatch(1);
        this.zzedk = new Object();
    }

    public final void zza(SurfaceTexture surfaceTexture, int n, int n2) {
        this.width = n;
        this.height = n2;
        this.zzede = surfaceTexture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzm(int n, int n2) {
        Object object = this.zzedk;
        synchronized (object) {
            this.width = n;
            this.height = n2;
            this.zzedp = true;
            this.zzedk.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzzb() {
        Object object = this.zzedk;
        synchronized (object) {
            this.zzedq = true;
            this.zzede = null;
            this.zzedk.notifyAll();
            return;
        }
    }

    public final SurfaceTexture zzzc() {
        if (this.zzede == null) {
            return null;
        }
        try {
            this.zzedj.await();
        }
        catch (InterruptedException interruptedException) {}
        return this.zzedd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onFrameAvailable(SurfaceTexture surfaceTexture) {
        ++this.zzedh;
        Object object = this.zzedk;
        synchronized (object) {
            this.zzedk.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void zzul() {
        Object object = this.zzedk;
        synchronized (object) {
            this.zzedk.notifyAll();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        boolean bl;
        int n;
        String string2;
        zzzk zzzk2;
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        if (this.zzede == null) {
            zzawr.zzfa((String)"SphericalVideoProcessor started with no output texture.");
            this.zzedj.countDown();
            return;
        }
        zzbbv zzbbv2 = this;
        this.zzedl = (EGL10)EGLContext.getEGL();
        zzbbv2.zzedm = zzbbv2.zzedl.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        if (zzbbv2.zzedm == EGL10.EGL_NO_DISPLAY) {
            bl2 = false;
        } else {
            int[] nArray = new int[2];
            if (!zzbbv2.zzedl.eglInitialize(zzbbv2.zzedm, nArray)) {
                bl2 = false;
            } else {
                object3 = zzbbv2;
                int[] nArray2 = new int[]{12352, 4, 12324, 8, 12323, 8, 12322, 8, 12325, 16, 12344};
                EGLConfig[] eGLConfigArray = new EGLConfig[1];
                object2 = new int[1];
                object = ((zzbbv)object3).zzedl.eglChooseConfig(((zzbbv)object3).zzedm, nArray2, eGLConfigArray, 1, (int[])object2) && object2[0] > 0 ? eGLConfigArray[0] : null;
                if ((EGLConfig)object == null) {
                    bl2 = false;
                } else {
                    int[] nArray3 = new int[]{12440, 2, 12344};
                    zzbbv2.zzedn = zzbbv2.zzedl.eglCreateContext(zzbbv2.zzedm, (EGLConfig)object, EGL10.EGL_NO_CONTEXT, nArray3);
                    if (zzbbv2.zzedn == null || zzbbv2.zzedn == EGL10.EGL_NO_CONTEXT) {
                        bl2 = false;
                    } else {
                        zzbbv2.zzedo = zzbbv2.zzedl.eglCreateWindowSurface(zzbbv2.zzedm, (EGLConfig)object, (Object)zzbbv2.zzede, null);
                        bl2 = zzbbv2.zzedo == null || zzbbv2.zzedo == EGL10.EGL_NO_SURFACE ? false : zzbbv2.zzedl.eglMakeCurrent(zzbbv2.zzedm, zzbbv2.zzedo, zzbbv2.zzedo, zzbbv2.zzedn);
                    }
                }
            }
        }
        boolean bl3 = bl2;
        zzbbv2 = this;
        object2 = zzbbv2;
        zzzk zzzk3 = zzzk2 = zzzz.zzcmr;
        if (!((String)zzvj.zzpv().zzd(zzzk3)).equals(zzzk2.zzqz())) {
            zzzk3 = zzzk2;
            string2 = (String)zzvj.zzpv().zzd(zzzk3);
        } else {
            string2 = "attribute highp vec3 aPosition;varying vec3 pos;void main() {  gl_Position = vec4(aPosition, 1.0);  pos = aPosition;}";
        }
        int n2 = zzbbv.zzd(35633, string2);
        if (n2 == 0) {
            n = 0;
        } else {
            String string3;
            zzzk3 = zzzk2 = zzzz.zzcms;
            if (!((String)zzvj.zzpv().zzd(zzzk3)).equals(zzzk2.zzqz())) {
                zzzk3 = zzzk2;
                string3 = (String)zzvj.zzpv().zzd(zzzk3);
            } else {
                string3 = "#extension GL_OES_EGL_image_external : require\n#define INV_PI 0.3183\nprecision highp float;varying vec3 pos;uniform samplerExternalOES uSplr;uniform mat3 uVMat;uniform float uFOVx;uniform float uFOVy;void main() {  vec3 ray = vec3(pos.x * tan(uFOVx), pos.y * tan(uFOVy), -1);  ray = (uVMat * ray).xyz;  ray = normalize(ray);  vec2 texCrd = vec2(    0.5 + atan(ray.x, - ray.z) * INV_PI * 0.5, acos(ray.y) * INV_PI);  gl_FragColor = vec4(texture2D(uSplr, texCrd).xyz, 1.0);}";
            }
            int n3 = zzbbv.zzd(35632, string3);
            if (n3 == 0) {
                n = 0;
            } else {
                int n4 = GLES20.glCreateProgram();
                zzbbv.zzfg("createProgram");
                if (n4 != 0) {
                    GLES20.glAttachShader((int)n4, (int)n2);
                    zzbbv.zzfg("attachShader");
                    GLES20.glAttachShader((int)n4, (int)n3);
                    zzbbv.zzfg("attachShader");
                    GLES20.glLinkProgram((int)n4);
                    zzbbv.zzfg("linkProgram");
                    int[] nArray = new int[1];
                    GLES20.glGetProgramiv((int)n4, (int)35714, (int[])nArray, (int)0);
                    zzbbv.zzfg("getProgramiv");
                    if (nArray[0] != 1) {
                        Log.e((String)"SphericalVideoRenderer", (String)"Could not link program: ");
                        Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetProgramInfoLog((int)n4));
                        GLES20.glDeleteProgram((int)n4);
                        zzbbv.zzfg("deleteProgram");
                        n4 = 0;
                    } else {
                        GLES20.glValidateProgram((int)n4);
                        zzbbv.zzfg("validateProgram");
                    }
                }
                n = n4;
            }
        }
        zzbbv2.zzedf = n;
        GLES20.glUseProgram((int)zzbbv2.zzedf);
        zzbbv.zzfg("useProgram");
        int n5 = GLES20.glGetAttribLocation((int)zzbbv2.zzedf, (String)"aPosition");
        GLES20.glVertexAttribPointer((int)n5, (int)3, (int)5126, (boolean)false, (int)12, (Buffer)zzbbv2.zzedi);
        zzbbv.zzfg("vertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)n5);
        zzbbv.zzfg("enableVertexAttribArray");
        object = new int[1];
        GLES20.glGenTextures((int)1, (int[])object, (int)0);
        zzbbv.zzfg("genTextures");
        int n6 = object[0];
        GLES20.glBindTexture((int)36197, (int)n6);
        zzbbv.zzfg("bindTextures");
        GLES20.glTexParameteri((int)36197, (int)10240, (int)9729);
        zzbbv.zzfg("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10241, (int)9729);
        zzbbv.zzfg("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        zzbbv.zzfg("texParameteri");
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        zzbbv.zzfg("texParameteri");
        zzbbv2.zzedg = GLES20.glGetUniformLocation((int)zzbbv2.zzedf, (String)"uVMat");
        object3 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
        GLES20.glUniformMatrix3fv((int)zzbbv2.zzedg, (int)1, (boolean)false, (float[])object3, (int)0);
        int n7 = n6;
        boolean bl4 = bl = this.zzedf != 0;
        if (!bl3 || !bl) {
            String string4 = GLUtils.getEGLErrorString((int)this.zzedl.eglGetError());
            String string5 = String.valueOf(string4);
            String string6 = string5.length() != 0 ? "EGL initialization failed: ".concat(string5) : new String("EGL initialization failed: ");
            zzawr.zzfa((String)string6);
            zzq.zzla().zza(new Throwable(string6), "SphericalVideoProcessor.run.1");
            this.zzzd();
            this.zzedj.countDown();
            return;
        }
        this.zzedd = new SurfaceTexture(n7);
        this.zzedd.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        this.zzedj.countDown();
        this.zzect.start();
        try {
            this.zzedp = true;
            while (!this.zzedq) {
                zzbbv2 = this;
                while (zzbbv2.zzedh > 0) {
                    zzbbv2.zzedd.updateTexImage();
                    --zzbbv2.zzedh;
                }
                if (zzbbv2.zzect.zza(zzbbv2.zzecp)) {
                    if (Float.isNaN(zzbbv2.zzeda)) {
                        float[] fArray = zzbbv2.zzecp;
                        object2 = new float[]{0.0f, 1.0f, 0.0f};
                        object3 = zzbbv2.zzecp;
                        float[] fArray2 = new float[]{(float)(object3[0] * object2[0] + object3[1] * object2[1] + object3[2] * object2[2]), (float)(object3[3] * object2[0] + object3[4] * object2[1] + object3[5] * object2[2]), (float)(object3[6] * object2[0] + object3[7] * object2[1] + object3[8] * object2[2])};
                        zzbbv2.zzeda = -((float)Math.atan2(fArray2[1], fArray2[0]) - 1.5707964f);
                    }
                    zzbbv.zzb(zzbbv2.zzecy, zzbbv2.zzeda + zzbbv2.zzedb);
                } else {
                    zzbbv.zza(zzbbv2.zzecp, -1.5707964f);
                    zzbbv.zzb(zzbbv2.zzecy, zzbbv2.zzedb);
                }
                zzbbv.zza(zzbbv2.zzecu, 1.5707964f);
                zzbbv.zza(zzbbv2.zzecv, zzbbv2.zzecy, zzbbv2.zzecu);
                zzbbv.zza(zzbbv2.zzecw, zzbbv2.zzecp, zzbbv2.zzecv);
                zzbbv.zza(zzbbv2.zzecx, zzbbv2.zzedc);
                zzbbv.zza(zzbbv2.zzecz, zzbbv2.zzecx, zzbbv2.zzecw);
                GLES20.glUniformMatrix3fv((int)zzbbv2.zzedg, (int)1, (boolean)false, (float[])zzbbv2.zzecz, (int)0);
                GLES20.glDrawArrays((int)5, (int)0, (int)4);
                zzbbv.zzfg("drawArrays");
                GLES20.glFinish();
                zzbbv2.zzedl.eglSwapBuffers(zzbbv2.zzedm, zzbbv2.zzedo);
                if (this.zzedp) {
                    zzbbv2 = this;
                    GLES20.glViewport((int)0, (int)0, (int)zzbbv2.width, (int)zzbbv2.height);
                    zzbbv.zzfg("viewport");
                    n5 = GLES20.glGetUniformLocation((int)zzbbv2.zzedf, (String)"uFOVx");
                    int n8 = GLES20.glGetUniformLocation((int)zzbbv2.zzedf, (String)"uFOVy");
                    if (zzbbv2.width > zzbbv2.height) {
                        GLES20.glUniform1f((int)n5, (float)0.87266463f);
                        GLES20.glUniform1f((int)n8, (float)(0.87266463f * (float)zzbbv2.height / (float)zzbbv2.width));
                    } else {
                        GLES20.glUniform1f((int)n5, (float)(0.87266463f * (float)zzbbv2.width / (float)zzbbv2.height));
                        GLES20.glUniform1f((int)n8, (float)0.87266463f);
                    }
                    this.zzedp = false;
                }
                try {
                    Object object4 = this.zzedk;
                    synchronized (object4) {
                        if (!this.zzedq && !this.zzedp && this.zzedh == 0) {
                            this.zzedk.wait();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
            return;
        }
        catch (IllegalStateException illegalStateException) {
            zzawr.zzfc((String)"SphericalVideoProcessor halted unexpectedly.");
            return;
        }
        catch (Throwable throwable) {
            zzawr.zzc((String)"SphericalVideoProcessor died.", (Throwable)throwable);
            zzq.zzla().zza(throwable, "SphericalVideoProcessor.run.2");
            return;
        }
        finally {
            this.zzect.stop();
            this.zzedd.setOnFrameAvailableListener(null);
            this.zzedd = null;
            this.zzzd();
        }
    }

    public final void zzb(float f, float f2) {
        float f3;
        float f4;
        if (this.width > this.height) {
            f4 = 1.7453293f * f / (float)this.width;
            f3 = 1.7453293f * f2 / (float)this.width;
        } else {
            f4 = 1.7453293f * f / (float)this.height;
            f3 = 1.7453293f * f2 / (float)this.height;
        }
        this.zzedb -= f4;
        this.zzedc -= f3;
        if (this.zzedc < -1.5707964f) {
            this.zzedc = -1.5707964f;
        }
        if (this.zzedc > 1.5707964f) {
            this.zzedc = 1.5707964f;
        }
    }

    private static void zza(float[] fArray, float[] fArray2, float[] fArray3) {
        fArray[0] = fArray2[0] * fArray3[0] + fArray2[1] * fArray3[3] + fArray2[2] * fArray3[6];
        fArray[1] = fArray2[0] * fArray3[1] + fArray2[1] * fArray3[4] + fArray2[2] * fArray3[7];
        fArray[2] = fArray2[0] * fArray3[2] + fArray2[1] * fArray3[5] + fArray2[2] * fArray3[8];
        fArray[3] = fArray2[3] * fArray3[0] + fArray2[4] * fArray3[3] + fArray2[5] * fArray3[6];
        fArray[4] = fArray2[3] * fArray3[1] + fArray2[4] * fArray3[4] + fArray2[5] * fArray3[7];
        fArray[5] = fArray2[3] * fArray3[2] + fArray2[4] * fArray3[5] + fArray2[5] * fArray3[8];
        fArray[6] = fArray2[6] * fArray3[0] + fArray2[7] * fArray3[3] + fArray2[8] * fArray3[6];
        fArray[7] = fArray2[6] * fArray3[1] + fArray2[7] * fArray3[4] + fArray2[8] * fArray3[7];
        fArray[8] = fArray2[6] * fArray3[2] + fArray2[7] * fArray3[5] + fArray2[8] * fArray3[8];
    }

    private static void zza(float[] fArray, float f) {
        fArray[0] = 1.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        fArray[4] = (float)Math.cos(f);
        fArray[5] = (float)(-Math.sin(f));
        fArray[6] = 0.0f;
        fArray[7] = (float)Math.sin(f);
        fArray[8] = (float)Math.cos(f);
    }

    private static void zzb(float[] fArray, float f) {
        fArray[0] = (float)Math.cos(f);
        fArray[1] = (float)(-Math.sin(f));
        fArray[2] = 0.0f;
        fArray[3] = (float)Math.sin(f);
        fArray[4] = (float)Math.cos(f);
        fArray[5] = 0.0f;
        fArray[6] = 0.0f;
        fArray[7] = 0.0f;
        fArray[8] = 1.0f;
    }

    private static int zzd(int n, String string2) {
        int n2 = GLES20.glCreateShader((int)n);
        zzbbv.zzfg("createShader");
        if (n2 != 0) {
            GLES20.glShaderSource((int)n2, (String)string2);
            zzbbv.zzfg("shaderSource");
            GLES20.glCompileShader((int)n2);
            zzbbv.zzfg("compileShader");
            int[] nArray = new int[1];
            GLES20.glGetShaderiv((int)n2, (int)35713, (int[])nArray, (int)0);
            zzbbv.zzfg("getShaderiv");
            if (nArray[0] == 0) {
                Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(37).append("Could not compile shader ").append(n).append(":").toString());
                Log.e((String)"SphericalVideoRenderer", (String)GLES20.glGetShaderInfoLog((int)n2));
                GLES20.glDeleteShader((int)n2);
                zzbbv.zzfg("deleteShader");
                n2 = 0;
            }
        }
        return n2;
    }

    @VisibleForTesting
    private final boolean zzzd() {
        boolean bl = false;
        if (this.zzedo != null && this.zzedo != EGL10.EGL_NO_SURFACE) {
            bl = false | this.zzedl.eglMakeCurrent(this.zzedm, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_SURFACE, EGL10.EGL_NO_CONTEXT) | this.zzedl.eglDestroySurface(this.zzedm, this.zzedo);
            this.zzedo = null;
        }
        if (this.zzedn != null) {
            bl |= this.zzedl.eglDestroyContext(this.zzedm, this.zzedn);
            this.zzedn = null;
        }
        if (this.zzedm != null) {
            bl |= this.zzedl.eglTerminate(this.zzedm);
            this.zzedm = null;
        }
        return bl;
    }

    private static void zzfg(String string2) {
        int n = GLES20.glGetError();
        if (n != 0) {
            Log.e((String)"SphericalVideoRenderer", (String)new StringBuilder(21 + String.valueOf(string2).length()).append(string2).append(": glError ").append(n).toString());
        }
    }
}

