/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdoj;
import com.google.android.gms.internal.ads.zzdok;
import com.google.android.gms.internal.ads.zzdom;
import com.google.android.gms.internal.ads.zzdqp;
import com.google.android.gms.internal.ads.zzdri;
import com.google.android.gms.internal.ads.zzdrz;
import com.google.android.gms.internal.ads.zzdsc;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;
import sun.misc.Unsafe;

public class zzdpw<V>
extends zzdrz
implements zzdri<V> {
    private static final boolean GENERATE_CANCELLATION_CAUSES;
    private static final Logger zzhgm;
    private static final zza zzhgn;
    private static final Object NULL;
    @NullableDecl
    private volatile Object value;
    @NullableDecl
    private volatile zzd listeners;
    @NullableDecl
    private volatile zzk waiters;

    /*
     * Unable to fully structure code
     */
    private final void zza(zzk var1_1) {
        var1_1.thread = null;
        block0: while (true) {
            var2_2 = null;
            var3_3 = this.waiters;
            if (var3_3 == zzk.zzhgz) {
                return;
            }
            while (var3_3 != null) {
                var4_4 = var3_3.next;
                if (var3_3.thread != null) {
                    var2_2 = var3_3;
                } else if (var2_2 != null) {
                    var2_2.next = var4_4;
                    if (var2_2.thread == null) {
                        continue block0;
                    }
                } else {
                    if (zzdpw.zzhgn.zza(this, var3_3, var4_4)) ** break;
                    continue block0;
                }
                var3_3 = var4_4;
            }
            break;
        }
    }

    protected zzdpw() {
    }

    @Override
    public V get(long l, TimeUnit timeUnit) throws InterruptedException, TimeoutException, ExecutionException {
        Object object;
        Object object2;
        long l2;
        Object object3;
        long l3;
        block15: {
            long l4;
            l3 = l4 = timeUnit.toNanos(l);
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            object3 = this.value;
            if (object3 != null & !(object3 instanceof zze)) {
                return zzdpw.zzaf(object3);
            }
            long l5 = l2 = l4 > 0L ? System.nanoTime() + l4 : 0L;
            if (l4 >= 1000L) {
                object2 = this.waiters;
                if (object2 != zzk.zzhgz) {
                    object = new zzk();
                    do {
                        ((zzk)object).zzb((zzk)object2);
                        if (!zzhgn.zza(this, (zzk)object2, (zzk)object)) continue;
                        do {
                            LockSupport.parkNanos(this, l3);
                            if (Thread.interrupted()) {
                                this.zza((zzk)object);
                                throw new InterruptedException();
                            }
                            object3 = this.value;
                            if (!(object3 != null & !(object3 instanceof zze))) continue;
                            return zzdpw.zzaf(object3);
                        } while ((l3 = l2 - System.nanoTime()) >= 1000L);
                        this.zza((zzk)object);
                        break block15;
                    } while ((object2 = this.waiters) != zzk.zzhgz);
                }
                return zzdpw.zzaf(this.value);
            }
        }
        while (l3 > 0L) {
            object3 = this.value;
            if (object3 != null & !(object3 instanceof zze)) {
                return zzdpw.zzaf(object3);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            l3 = l2 - System.nanoTime();
        }
        object2 = this.toString();
        object = timeUnit.toString().toLowerCase(Locale.ROOT);
        String string2 = timeUnit.toString().toLowerCase(Locale.ROOT);
        String string3 = new StringBuilder(28 + String.valueOf(string2).length()).append("Waited ").append(l).append(" ").append(string2).toString();
        if (l3 + 1000L < 0L) {
            String string4;
            boolean bl;
            string3 = String.valueOf(string3).concat(" (plus ");
            long l6 = -l3;
            long l7 = timeUnit.convert(l6, TimeUnit.NANOSECONDS);
            long l8 = l6 - timeUnit.toNanos(l7);
            boolean bl2 = bl = l7 == 0L || l8 > 1000L;
            if (l7 > 0L) {
                string4 = String.valueOf(string3);
                string3 = new StringBuilder(21 + String.valueOf(string4).length() + String.valueOf(object).length()).append(string4).append(l7).append(" ").append((String)object).toString();
                if (bl) {
                    string3 = String.valueOf(string3).concat(",");
                }
                string3 = String.valueOf(string3).concat(" ");
            }
            if (bl) {
                string4 = String.valueOf(string3);
                string3 = new StringBuilder(33 + String.valueOf(string4).length()).append(string4).append(l8).append(" nanoseconds ").toString();
            }
            string3 = String.valueOf(string3).concat("delay)");
        }
        if (this.isDone()) {
            throw new TimeoutException(String.valueOf(string3).concat(" but future completed as timeout expired"));
        }
        string2 = string3;
        throw new TimeoutException(new StringBuilder(5 + String.valueOf(string2).length() + String.valueOf(object2).length()).append(string2).append(" for ").append((String)object2).toString());
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Object object = this.value;
        if (object != null & !(object instanceof zze)) {
            return zzdpw.zzaf(object);
        }
        zzk zzk2 = this.waiters;
        if (zzk2 != zzk.zzhgz) {
            zzk zzk3 = new zzk();
            do {
                zzk3.zzb(zzk2);
                if (!zzhgn.zza(this, zzk2, zzk3)) continue;
                do {
                    LockSupport.park(this);
                    if (!Thread.interrupted()) continue;
                    this.zza(zzk3);
                    throw new InterruptedException();
                } while (!((object = this.value) != null & !(object instanceof zze)));
                return zzdpw.zzaf(object);
            } while ((zzk2 = this.waiters) != zzk.zzhgz);
        }
        return zzdpw.zzaf(this.value);
    }

    private static V zzaf(Object object) throws ExecutionException {
        if (object instanceof zzc) {
            Throwable throwable = ((zzc)object).cause;
            String string2 = "Task was cancelled.";
            CancellationException cancellationException = new CancellationException(string2);
            cancellationException.initCause(throwable);
            throw cancellationException;
        }
        if (object instanceof zzb) {
            throw new ExecutionException(((zzb)object).exception);
        }
        if (object == NULL) {
            return null;
        }
        return object;
    }

    @Override
    public boolean isDone() {
        Object object = this.value;
        return object != null & !(object instanceof zze);
    }

    @Override
    public boolean isCancelled() {
        return this.value instanceof zzc;
    }

    @Override
    public boolean cancel(boolean bl) {
        Object object = this.value;
        boolean bl2 = false;
        if (object == null | object instanceof zze) {
            zzc zzc2 = GENERATE_CANCELLATION_CAUSES ? new zzc(bl, new CancellationException("Future.cancel() was called.")) : (bl ? zzc.zzhgp : zzc.zzhgq);
            zzdpw zzdpw2 = this;
            while (true) {
                if (zzhgn.zza(zzdpw2, object, zzc2)) {
                    bl2 = true;
                    if (bl) {
                        zzdpw2.interruptTask();
                    }
                    zzdpw.zza(zzdpw2);
                    if (!(object instanceof zze)) break;
                    zzdri zzdri2 = ((zze)object).future;
                    if (zzdri2 instanceof zzg) {
                        zzdpw zzdpw3 = (zzdpw)zzdri2;
                        object = zzdpw3.value;
                        if (!(object == null | object instanceof zze)) break;
                        zzdpw2 = zzdpw3;
                        continue;
                    }
                    zzdri2.cancel(bl);
                    break;
                }
                object = zzdpw2.value;
                if (!(object instanceof zze)) break;
            }
        }
        return bl2;
    }

    protected void interruptTask() {
    }

    protected final boolean wasInterrupted() {
        Object object = this.value;
        return object instanceof zzc && ((zzc)object).wasInterrupted;
    }

    @Override
    public void addListener(Runnable runnable, Executor executor) {
        zzd zzd2;
        zzdoj.checkNotNull((Object)runnable, (Object)"Runnable was null.");
        zzdoj.checkNotNull((Object)executor, (Object)"Executor was null.");
        if (!this.isDone() && (zzd2 = this.listeners) != zzd.zzhgr) {
            zzd zzd3 = new zzd(runnable, executor);
            do {
                zzd3.next = zzd2;
                if (!zzhgn.zza(this, zzd2, zzd3)) continue;
                return;
            } while ((zzd2 = this.listeners) != zzd.zzhgr);
        }
        zzdpw.zza(runnable, executor);
    }

    protected boolean set(@NullableDecl V v) {
        Object object;
        Object object2 = object = v == null ? NULL : v;
        if (zzhgn.zza(this, null, object)) {
            zzdpw.zza(this);
            return true;
        }
        return false;
    }

    protected boolean setException(Throwable throwable) {
        zzb zzb2 = new zzb((Throwable)zzdoj.checkNotNull((Object)throwable));
        if (zzhgn.zza(this, null, zzb2)) {
            zzdpw.zza(this);
            return true;
        }
        return false;
    }

    protected final boolean setFuture(zzdri<? extends V> zzdri2) {
        zzdoj.checkNotNull(zzdri2);
        Object object = this.value;
        if (object == null) {
            if (zzdri2.isDone()) {
                Object object2 = zzdpw.getFutureValue(zzdri2);
                if (zzhgn.zza(this, null, object2)) {
                    zzdpw.zza(this);
                    return true;
                }
                return false;
            }
            zze<? extends V> zze2 = new zze<V>(this, zzdri2);
            if (zzhgn.zza(this, null, zze2)) {
                try {
                    zzdri2.addListener(zze2, zzdqp.zzhhu);
                }
                catch (Throwable throwable) {
                    zzb zzb2;
                    try {
                        zzb2 = new zzb(throwable);
                    }
                    catch (Throwable throwable2) {
                        zzb2 = zzb.zzhgo;
                    }
                    zzhgn.zza(this, zze2, zzb2);
                }
                return true;
            }
            object = this.value;
        }
        if (object instanceof zzc) {
            zzdri2.cancel(((zzc)object).wasInterrupted);
        }
        return false;
    }

    private static Object getFutureValue(zzdri<?> zzdri2) {
        boolean bl;
        Throwable throwable;
        if (zzdri2 instanceof zzg) {
            Object object = ((zzdpw)zzdri2).value;
            if (object instanceof zzc) {
                zzc zzc2 = (zzc)object;
                if (zzc2.wasInterrupted) {
                    object = zzc2.cause != null ? new zzc(false, zzc2.cause) : zzc.zzhgq;
                }
            }
            return object;
        }
        if (zzdri2 instanceof zzdrz && (throwable = zzdsc.zza((zzdrz)((Object)zzdri2))) != null) {
            return new zzb(throwable);
        }
        if (!GENERATE_CANCELLATION_CAUSES & (bl = zzdri2.isCancelled())) {
            return zzc.zzhgq;
        }
        try {
            Object obj = zzdpw.getUninterruptibly(zzdri2);
            if (bl) {
                String string2 = String.valueOf(zzdri2);
                return new zzc(false, new IllegalArgumentException(new StringBuilder(84 + String.valueOf(string2).length()).append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append(string2).toString()));
            }
            if (obj == null) {
                return NULL;
            }
            return obj;
        }
        catch (ExecutionException executionException) {
            if (bl) {
                String string3 = String.valueOf(zzdri2);
                return new zzc(false, new IllegalArgumentException(new StringBuilder(84 + String.valueOf(string3).length()).append("get() did not throw CancellationException, despite reporting isCancelled() == true: ").append(string3).toString(), executionException));
            }
            return new zzb(executionException.getCause());
        }
        catch (CancellationException cancellationException) {
            if (!bl) {
                String string4 = String.valueOf(zzdri2);
                return new zzb(new IllegalArgumentException(new StringBuilder(77 + String.valueOf(string4).length()).append("get() threw CancellationException, despite reporting isCancelled() == false: ").append(string4).toString(), cancellationException));
            }
            return new zzc(false, cancellationException);
        }
        catch (Throwable throwable2) {
            return new zzb(throwable2);
        }
    }

    private static <V> V getUninterruptibly(Future<V> future) throws ExecutionException {
        boolean bl = false;
        while (true) {
            V v;
            block5: {
                try {
                    v = future.get();
                    if (!bl) break block5;
                    Thread.currentThread().interrupt();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    continue;
                }
                catch (Throwable throwable) {
                    if (bl) {
                        Thread.currentThread().interrupt();
                    }
                    throw throwable;
                }
            }
            return v;
            break;
        }
    }

    private static void zza(zzdpw<?> zzdpw2) {
        Object object = null;
        block0: while (true) {
            Object object2;
            Object object3;
            zzk zzk2;
            zzdpw<?> zzdpw3 = zzdpw2;
            while (!zzhgn.zza(zzdpw3, zzk2 = zzdpw3.waiters, zzk.zzhgz)) {
            }
            Object object4 = zzk2;
            while (object4 != null) {
                object3 = object4;
                object2 = ((zzk)object3).thread;
                if (object2 != null) {
                    ((zzk)object3).thread = null;
                    LockSupport.unpark((Thread)object2);
                }
                object4 = ((zzk)object4).next;
            }
            zzdpw2.afterDone();
            zzk2 = object;
            zzdpw3 = zzdpw2;
            while (!zzhgn.zza(zzdpw3, (zzd)(object4 = zzdpw3.listeners), zzd.zzhgr)) {
            }
            object3 = zzk2;
            while (object4 != null) {
                object2 = object4;
                object4 = ((zzd)object4).next;
                ((zzd)object2).next = object3;
                object3 = object2;
            }
            object = object3;
            while (object != null) {
                zzk zzk3 = object;
                object = ((zzd)object).next;
                Runnable runnable = ((zzd)((Object)zzk3)).task;
                if (runnable instanceof zze) {
                    Object object5;
                    zze zze2 = (zze)runnable;
                    zzdpw2 = zze2.zzhgs;
                    if (zzdpw2.value == zze2 && zzhgn.zza(zzdpw2, zze2, object5 = zzdpw.getFutureValue(zze2.future))) continue block0;
                    continue;
                }
                zzdpw.zza(runnable, ((zzd)((Object)zzk3)).executor);
            }
            break;
        }
    }

    protected void afterDone() {
    }

    @Override
    @NullableDecl
    protected final Throwable zzawf() {
        Object object;
        if (this instanceof zzg && (object = this.value) instanceof zzb) {
            return ((zzb)object).exception;
        }
        return null;
    }

    final void maybePropagateCancellationTo(@NullableDecl Future<?> future) {
        if (future != null & this.isCancelled()) {
            future.cancel(this.wasInterrupted());
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(super.toString()).append("[status=");
        if (this.isCancelled()) {
            stringBuilder.append("CANCELLED");
        } else if (this.isDone()) {
            this.zza(stringBuilder);
        } else {
            StringBuilder stringBuilder2 = stringBuilder;
            zzdpw zzdpw2 = this;
            int n = stringBuilder2.length();
            stringBuilder2.append("PENDING");
            Object object = zzdpw2.value;
            if (object instanceof zze) {
                stringBuilder2.append(", setFuture=[");
                zzdpw2.zza(stringBuilder2, ((zze)object).future);
                stringBuilder2.append("]");
            } else {
                String string2;
                try {
                    string2 = zzdok.emptyToNull((String)zzdpw2.pendingToString());
                }
                catch (RuntimeException | StackOverflowError throwable) {
                    String string3 = String.valueOf(throwable.getClass());
                    string2 = new StringBuilder(38 + String.valueOf(string3).length()).append("Exception thrown from implementation: ").append(string3).toString();
                }
                if (string2 != null) {
                    stringBuilder2.append(", info=[").append(string2).append("]");
                }
            }
            if (zzdpw2.isDone()) {
                stringBuilder2.delete(n, stringBuilder2.length());
                zzdpw2.zza(stringBuilder2);
            }
        }
        return stringBuilder.append("]").toString();
    }

    @NullableDecl
    protected String pendingToString() {
        if (this instanceof ScheduledFuture) {
            long l = ((ScheduledFuture)((Object)this)).getDelay(TimeUnit.MILLISECONDS);
            return new StringBuilder(41).append("remaining delay=[").append(l).append(" ms]").toString();
        }
        return null;
    }

    private final void zza(StringBuilder stringBuilder) {
        try {
            V v = zzdpw.getUninterruptibly(this);
            stringBuilder.append("SUCCESS, result=[");
            this.zza(stringBuilder, v);
            stringBuilder.append("]");
            return;
        }
        catch (ExecutionException executionException) {
            stringBuilder.append("FAILURE, cause=[").append(executionException.getCause()).append("]");
            return;
        }
        catch (CancellationException cancellationException) {
            stringBuilder.append("CANCELLED");
            return;
        }
        catch (RuntimeException runtimeException) {
            stringBuilder.append("UNKNOWN, cause=[").append(runtimeException.getClass()).append(" thrown from get()]");
            return;
        }
    }

    private final void zza(StringBuilder stringBuilder, Object object) {
        try {
            if (object == this) {
                stringBuilder.append("this future");
                return;
            }
            stringBuilder.append(object);
            return;
        }
        catch (RuntimeException | StackOverflowError throwable) {
            stringBuilder.append("Exception thrown from implementation: ").append(throwable.getClass());
            return;
        }
    }

    private static void zza(Runnable runnable, Executor executor) {
        try {
            executor.execute(runnable);
            return;
        }
        catch (RuntimeException runtimeException) {
            String string2 = String.valueOf(runnable);
            String string3 = String.valueOf(executor);
            zzhgm.logp(Level.SEVERE, "com.google.common.util.concurrent.AbstractFuture", "executeListener", new StringBuilder(57 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("RuntimeException while executing runnable ").append(string2).append(" with executor ").append(string3).toString(), runtimeException);
            return;
        }
    }

    static {
        zza zza2;
        boolean bl;
        try {
            bl = Boolean.parseBoolean(System.getProperty("guava.concurrent.generate_cancellation_cause", "false"));
        }
        catch (SecurityException securityException) {
            bl = false;
        }
        GENERATE_CANCELLATION_CAUSES = bl;
        zzhgm = Logger.getLogger(zzdpw.class.getName());
        Throwable throwable = null;
        Throwable throwable2 = null;
        try {
            zza2 = new zzi();
        }
        catch (Throwable throwable3) {
            try {
                zza2 = new zzf(AtomicReferenceFieldUpdater.newUpdater(zzk.class, Thread.class, "thread"), AtomicReferenceFieldUpdater.newUpdater(zzk.class, zzk.class, "next"), AtomicReferenceFieldUpdater.newUpdater(zzdpw.class, zzk.class, "waiters"), AtomicReferenceFieldUpdater.newUpdater(zzdpw.class, zzd.class, "listeners"), AtomicReferenceFieldUpdater.newUpdater(zzdpw.class, Object.class, "value"));
            }
            catch (Throwable throwable4) {
                zza2 = new zzh();
            }
        }
        zzhgn = zza2;
        if (throwable2 != null) {
            zzhgm.logp(Level.SEVERE, "com.google.common.util.concurrent.AbstractFuture", "<clinit>", "UnsafeAtomicHelper is broken!", throwable);
            zzhgm.logp(Level.SEVERE, "com.google.common.util.concurrent.AbstractFuture", "<clinit>", "SafeAtomicHelper is broken!", throwable2);
        }
        NULL = new Object();
    }

    static final class zzh
    extends zza {
        private zzh() {
        }

        @Override
        final void zza(zzk zzk2, Thread thread) {
            zzk2.thread = thread;
        }

        @Override
        final void zza(zzk zzk2, zzk zzk3) {
            zzk2.next = zzk3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean zza(zzdpw<?> zzdpw2, zzk zzk2, zzk zzk3) {
            zzdpw<?> zzdpw3 = zzdpw2;
            synchronized (zzdpw3) {
                if (((zzdpw)zzdpw2).waiters == zzk2) {
                    ((zzdpw)zzdpw2).waiters = zzk3;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean zza(zzdpw<?> zzdpw2, zzd zzd2, zzd zzd3) {
            zzdpw<?> zzdpw3 = zzdpw2;
            synchronized (zzdpw3) {
                if (((zzdpw)zzdpw2).listeners == zzd2) {
                    ((zzdpw)zzdpw2).listeners = zzd3;
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final boolean zza(zzdpw<?> zzdpw2, Object object, Object object2) {
            zzdpw<?> zzdpw3 = zzdpw2;
            synchronized (zzdpw3) {
                if (((zzdpw)zzdpw2).value == object) {
                    ((zzdpw)zzdpw2).value = object2;
                    return true;
                }
                return false;
            }
        }
    }

    static final class zzf
    extends zza {
        final AtomicReferenceFieldUpdater<zzk, Thread> waiterThreadUpdater;
        final AtomicReferenceFieldUpdater<zzk, zzk> waiterNextUpdater;
        final AtomicReferenceFieldUpdater<zzdpw, zzk> waitersUpdater;
        final AtomicReferenceFieldUpdater<zzdpw, zzd> listenersUpdater;
        final AtomicReferenceFieldUpdater<zzdpw, Object> valueUpdater;

        zzf(AtomicReferenceFieldUpdater<zzk, Thread> atomicReferenceFieldUpdater, AtomicReferenceFieldUpdater<zzk, zzk> atomicReferenceFieldUpdater2, AtomicReferenceFieldUpdater<zzdpw, zzk> atomicReferenceFieldUpdater3, AtomicReferenceFieldUpdater<zzdpw, zzd> atomicReferenceFieldUpdater4, AtomicReferenceFieldUpdater<zzdpw, Object> atomicReferenceFieldUpdater5) {
            this.waiterThreadUpdater = atomicReferenceFieldUpdater;
            this.waiterNextUpdater = atomicReferenceFieldUpdater2;
            this.waitersUpdater = atomicReferenceFieldUpdater3;
            this.listenersUpdater = atomicReferenceFieldUpdater4;
            this.valueUpdater = atomicReferenceFieldUpdater5;
        }

        @Override
        final void zza(zzk zzk2, Thread thread) {
            this.waiterThreadUpdater.lazySet(zzk2, thread);
        }

        @Override
        final void zza(zzk zzk2, zzk zzk3) {
            this.waiterNextUpdater.lazySet(zzk2, zzk3);
        }

        @Override
        final boolean zza(zzdpw<?> zzdpw2, zzk zzk2, zzk zzk3) {
            return this.waitersUpdater.compareAndSet(zzdpw2, zzk2, zzk3);
        }

        @Override
        final boolean zza(zzdpw<?> zzdpw2, zzd zzd2, zzd zzd3) {
            return this.listenersUpdater.compareAndSet(zzdpw2, zzd2, zzd3);
        }

        @Override
        final boolean zza(zzdpw<?> zzdpw2, Object object, Object object2) {
            return this.valueUpdater.compareAndSet(zzdpw2, object, object2);
        }
    }

    static final class zzi
    extends zza {
        static final Unsafe zzhgt;
        static final long zzhgu;
        static final long zzhgv;
        static final long zzhgw;
        static final long zzhgx;
        static final long zzhgy;

        private zzi() {
        }

        @Override
        final void zza(zzk zzk2, Thread thread) {
            zzhgt.putObject(zzk2, zzhgx, thread);
        }

        @Override
        final void zza(zzk zzk2, zzk zzk3) {
            zzhgt.putObject(zzk2, zzhgy, zzk3);
        }

        @Override
        final boolean zza(zzdpw<?> zzdpw2, zzk zzk2, zzk zzk3) {
            return zzhgt.compareAndSwapObject(zzdpw2, zzhgv, zzk2, zzk3);
        }

        @Override
        final boolean zza(zzdpw<?> zzdpw2, zzd zzd2, zzd zzd3) {
            return zzhgt.compareAndSwapObject(zzdpw2, zzhgu, zzd2, zzd3);
        }

        @Override
        final boolean zza(zzdpw<?> zzdpw2, Object object, Object object2) {
            return zzhgt.compareAndSwapObject(zzdpw2, zzhgw, object, object2);
        }

        static {
            Unsafe unsafe;
            try {
                unsafe = Unsafe.getUnsafe();
            }
            catch (SecurityException securityException) {
                try {
                    unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                        @Override
                        public /* synthetic */ Object run() throws Exception {
                            Class<Unsafe> clazz = Unsafe.class;
                            for (Field field : Unsafe.class.getDeclaredFields()) {
                                field.setAccessible(true);
                                Object object = field.get(null);
                                if (!clazz.isInstance(object)) continue;
                                return (Unsafe)clazz.cast(object);
                            }
                            throw new NoSuchFieldError("the Unsafe");
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw new RuntimeException("Could not initialize intrinsics", privilegedActionException.getCause());
                }
            }
            try {
                Class<zzdpw> clazz = zzdpw.class;
                zzhgv = unsafe.objectFieldOffset(clazz.getDeclaredField("waiters"));
                zzhgu = unsafe.objectFieldOffset(clazz.getDeclaredField("listeners"));
                zzhgw = unsafe.objectFieldOffset(clazz.getDeclaredField("value"));
                zzhgx = unsafe.objectFieldOffset(zzk.class.getDeclaredField("thread"));
                zzhgy = unsafe.objectFieldOffset(zzk.class.getDeclaredField("next"));
                zzhgt = unsafe;
                return;
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                zzdom.zzg((Throwable)exception);
                throw new RuntimeException(exception2);
            }
        }
    }

    static abstract class zza {
        private zza() {
        }

        abstract void zza(zzk var1, Thread var2);

        abstract void zza(zzk var1, zzk var2);

        abstract boolean zza(zzdpw<?> var1, zzk var2, zzk var3);

        abstract boolean zza(zzdpw<?> var1, zzd var2, zzd var3);

        abstract boolean zza(zzdpw<?> var1, Object var2, Object var3);
    }

    static final class zze<V>
    implements Runnable {
        final zzdpw<V> zzhgs;
        final zzdri<? extends V> future;

        zze(zzdpw<V> zzdpw2, zzdri<? extends V> zzdri2) {
            this.zzhgs = zzdpw2;
            this.future = zzdri2;
        }

        @Override
        public final void run() {
            if (((zzdpw)this.zzhgs).value != this) {
                return;
            }
            Object object = zzdpw.getFutureValue(this.future);
            if (zzhgn.zza(this.zzhgs, this, object)) {
                zzdpw.zza((zzdpw)this.zzhgs);
            }
        }
    }

    static final class zzc {
        static final zzc zzhgp;
        static final zzc zzhgq;
        final boolean wasInterrupted;
        @NullableDecl
        final Throwable cause;

        zzc(boolean bl, @NullableDecl Throwable throwable) {
            this.wasInterrupted = bl;
            this.cause = throwable;
        }

        static {
            if (GENERATE_CANCELLATION_CAUSES) {
                zzhgq = null;
                zzhgp = null;
            } else {
                zzhgq = new zzc(false, null);
                zzhgp = new zzc(true, null);
            }
        }
    }

    static final class zzb {
        static final zzb zzhgo = new zzb(new Throwable("Failure occurred while trying to finish a future."){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        });
        final Throwable exception;

        zzb(Throwable throwable) {
            this.exception = (Throwable)zzdoj.checkNotNull((Object)throwable);
        }
    }

    static final class zzd {
        static final zzd zzhgr = new zzd(null, null);
        final Runnable task;
        final Executor executor;
        @NullableDecl
        zzd next;

        zzd(Runnable runnable, Executor executor) {
            this.task = runnable;
            this.executor = executor;
        }
    }

    static final class zzk {
        static final zzk zzhgz = new zzk(false);
        @NullableDecl
        volatile Thread thread;
        @NullableDecl
        volatile zzk next;

        private zzk(boolean bl) {
        }

        zzk() {
            zzhgn.zza(this, Thread.currentThread());
        }

        final void zzb(zzk zzk2) {
            zzhgn.zza(this, zzk2);
        }
    }

    static abstract class zzj<V>
    extends zzdpw<V>
    implements zzg<V> {
        zzj() {
        }

        @Override
        public final V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            return super.get(l, timeUnit);
        }
    }

    static interface zzg<V>
    extends zzdri<V> {
    }
}

