/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdse;
import com.google.android.gms.internal.ads.zzdsh;
import com.google.android.gms.internal.ads.zzdsm;
import com.google.android.gms.internal.ads.zzdsn;
import com.google.android.gms.internal.ads.zzdst;
import com.google.android.gms.internal.ads.zzdsu;
import com.google.android.gms.internal.ads.zzdsw;
import com.google.android.gms.internal.ads.zzdsy;
import com.google.android.gms.internal.ads.zzdsz;
import com.google.android.gms.internal.ads.zzdta;
import com.google.android.gms.internal.ads.zzdtb;
import com.google.android.gms.internal.ads.zzdtc;
import com.google.android.gms.internal.ads.zzdte;
import com.google.android.gms.internal.ads.zzdxf;
import com.google.android.gms.internal.ads.zzdxj;
import com.google.android.gms.internal.ads.zzdxl;
import com.google.android.gms.internal.ads.zzdxp;
import com.google.android.gms.internal.ads.zzeaq;
import com.google.android.gms.internal.ads.zzedo;
import java.security.GeneralSecurityException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class zzdsx {
    private static final Logger logger = Logger.getLogger(zzdsx.class.getName());
    private static final ConcurrentMap<String, zza> zzhjm = new ConcurrentHashMap<String, zza>();
    private static final ConcurrentMap<String, zzb> zzhjn = new ConcurrentHashMap<String, zzb>();
    private static final ConcurrentMap<String, Boolean> zzhjo = new ConcurrentHashMap<String, Boolean>();
    private static final ConcurrentMap<String, zzdse<?>> zzhjp = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, zzdsw<?>> zzhjq = new ConcurrentHashMap();

    private static <KeyProtoT extends zzedo> zza zza(zzdsm<KeyProtoT> zzdsm2) {
        zzdsm<KeyProtoT> zzdsm3 = zzdsm2;
        return new zzdsz(zzdsm3);
    }

    private static <KeyProtoT extends zzedo> zzb zzb(zzdsm<KeyProtoT> zzdsm2) {
        return new zzdtb(zzdsm2);
    }

    private static synchronized zza zzhi(String string2) throws GeneralSecurityException {
        if (!zzhjm.containsKey(string2)) {
            String string3 = String.valueOf(string2);
            throw new GeneralSecurityException(string3.length() != 0 ? "No key manager found for key type ".concat(string3) : new String("No key manager found for key type "));
        }
        return (zza)zzhjm.get(string2);
    }

    @Deprecated
    public static zzdse<?> zzhj(String string2) throws GeneralSecurityException {
        if (string2 == null) {
            throw new IllegalArgumentException("catalogueName must be non-null.");
        }
        zzdse zzdse2 = (zzdse)zzhjp.get(string2.toLowerCase());
        if (zzdse2 == null) {
            String string3 = String.format("no catalogue found for %s. ", string2);
            if (string2.toLowerCase().startsWith("tinkaead")) {
                string3 = String.valueOf(string3).concat("Maybe call AeadConfig.register().");
            }
            if (string2.toLowerCase().startsWith("tinkdeterministicaead")) {
                string3 = String.valueOf(string3).concat("Maybe call DeterministicAeadConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkstreamingaead")) {
                string3 = String.valueOf(string3).concat("Maybe call StreamingAeadConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkhybriddecrypt") || string2.toLowerCase().startsWith("tinkhybridencrypt")) {
                string3 = String.valueOf(string3).concat("Maybe call HybridConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkmac")) {
                string3 = String.valueOf(string3).concat("Maybe call MacConfig.register().");
            } else if (string2.toLowerCase().startsWith("tinkpublickeysign") || string2.toLowerCase().startsWith("tinkpublickeyverify")) {
                string3 = String.valueOf(string3).concat("Maybe call SignatureConfig.register().");
            } else if (string2.toLowerCase().startsWith("tink")) {
                string3 = String.valueOf(string3).concat("Maybe call TinkConfig.register().");
            }
            throw new GeneralSecurityException(string3);
        }
        return zzdse2;
    }

    private static <T> T checkNotNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    private static synchronized <P> void zza(String string2, Class<?> clazz, boolean bl) throws GeneralSecurityException {
        if (!zzhjm.containsKey(string2)) {
            return;
        }
        zza zza2 = (zza)zzhjm.get(string2);
        if (!zza2.zzaxj().equals(clazz)) {
            String string3 = String.valueOf(string2);
            logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "ensureKeyManagerInsertable", string3.length() != 0 ? "Attempted overwrite of a registered key manager for key type ".concat(string3) : new String("Attempted overwrite of a registered key manager for key type "));
            throw new GeneralSecurityException(String.format("typeUrl (%s) is already registered with %s, cannot be re-registered with %s", string2, zza2.zzaxj().getName(), clazz.getName()));
        }
        if (bl && !((Boolean)zzhjo.get(string2)).booleanValue()) {
            String string4 = String.valueOf(string2);
            throw new GeneralSecurityException(string4.length() != 0 ? "New keys are already disallowed for key type ".concat(string4) : new String("New keys are already disallowed for key type "));
        }
    }

    public static synchronized <P> void zza(zzdsh<P> zzdsh2, boolean bl) throws GeneralSecurityException {
        if (zzdsh2 == null) {
            throw new IllegalArgumentException("key manager must be non-null.");
        }
        String string2 = zzdsh2.getKeyType();
        zzdsx.zza(string2, zzdsh2.getClass(), bl);
        if (!zzhjm.containsKey(string2)) {
            zzdsh<P> zzdsh3 = zzdsh2;
            zzhjm.put(string2, new zzdta(zzdsh3));
        }
        zzhjo.put(string2, bl);
    }

    public static synchronized <KeyProtoT extends zzedo> void zza(zzdsm<KeyProtoT> zzdsm2, boolean bl) throws GeneralSecurityException {
        String string2 = zzdsm2.getKeyType();
        zzdsx.zza(string2, zzdsm2.getClass(), true);
        if (!zzhjm.containsKey(string2)) {
            zzhjm.put(string2, zzdsx.zza(zzdsm2));
            zzhjn.put(string2, zzdsx.zzb(zzdsm2));
        }
        zzhjo.put(string2, true);
    }

    public static synchronized <KeyProtoT extends zzedo, PublicKeyProtoT extends zzedo> void zza(zzdsy<KeyProtoT, PublicKeyProtoT> zzdsy2, zzdsm<PublicKeyProtoT> zzdsm2, boolean bl) throws GeneralSecurityException {
        Class<?> clazz;
        String string2 = zzdsy2.getKeyType();
        String string3 = zzdsm2.getKeyType();
        zzdsx.zza(string2, zzdsy2.getClass(), true);
        zzdsx.zza(string3, zzdsm2.getClass(), false);
        if (string2.equals(string3)) {
            throw new GeneralSecurityException("Private and public key type must be different.");
        }
        if (zzhjm.containsKey(string2) && (clazz = ((zza)zzhjm.get(string2)).zzaxk()) != null && !clazz.equals(zzdsm2.getClass())) {
            logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerAsymmetricKeyManagers", new StringBuilder(96 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Attempted overwrite of a registered key manager for key type ").append(string2).append(" with inconsistent public key type ").append(string3).toString());
            throw new GeneralSecurityException(String.format("public key manager corresponding to %s is already registered with %s, cannot be re-registered with %s", zzdsy2.getClass().getName(), clazz.getName(), zzdsm2.getClass().getName()));
        }
        if (!zzhjm.containsKey(string2) || ((zza)zzhjm.get(string2)).zzaxk() == null) {
            zzdsm<PublicKeyProtoT> zzdsm3 = zzdsm2;
            zzdsy<KeyProtoT, PublicKeyProtoT> zzdsy3 = zzdsy2;
            zzdsm<PublicKeyProtoT> zzdsm4 = zzdsm3;
            zzhjm.put(string2, new zzdtc(zzdsy3, zzdsm4));
            zzhjn.put(string2, zzdsx.zzb(zzdsy2));
        }
        zzhjo.put(string2, true);
        if (!zzhjm.containsKey(string3)) {
            zzhjm.put(string3, zzdsx.zza(zzdsm2));
        }
        zzhjo.put(string3, false);
    }

    public static synchronized <P> void zza(zzdsw<P> zzdsw2) throws GeneralSecurityException {
        if (zzdsw2 == null) {
            throw new IllegalArgumentException("wrapper must be non-null");
        }
        Class<P> clazz = zzdsw2.zzawu();
        if (zzhjq.containsKey(clazz)) {
            zzdsw zzdsw3 = (zzdsw)zzhjq.get(clazz);
            if (!zzdsw2.getClass().equals(zzdsw3.getClass())) {
                String string2 = String.valueOf(clazz.toString());
                logger.logp(Level.WARNING, "com.google.crypto.tink.Registry", "registerPrimitiveWrapper", string2.length() != 0 ? "Attempted overwrite of a registered SetWrapper for type ".concat(string2) : new String("Attempted overwrite of a registered SetWrapper for type "));
                throw new GeneralSecurityException(String.format("SetWrapper for primitive (%s) is already registered to be %s, cannot be re-registered with %s", clazz.getName(), zzdsw3.getClass().getName(), zzdsw2.getClass().getName()));
            }
        }
        zzhjq.put(clazz, zzdsw2);
    }

    private static zzdsh<?> zzhk(String string2) throws GeneralSecurityException {
        return zzdsx.zzhi(string2).zzaxi();
    }

    private static <P> zzdsh<P> zza(String string2, Class<P> clazz) throws GeneralSecurityException {
        zza zza2 = zzdsx.zzhi(string2);
        if (clazz == null) {
            return zza2.zzaxi();
        }
        if (zza2.zzawz().contains(clazz)) {
            return zza2.zzb(clazz);
        }
        String string3 = clazz.getName();
        String string4 = String.valueOf(zza2.zzaxj());
        Set<Class<?>> set = zza2.zzawz();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Class<?> clazz2 : set) {
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(clazz2.getCanonicalName());
            bl = false;
        }
        String string5 = stringBuilder.toString();
        throw new GeneralSecurityException(new StringBuilder(77 + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append("Primitive type ").append(string3).append(" not supported by key manager of type ").append(string4).append(", supported primitives: ").append(string5).toString());
    }

    public static synchronized zzdxf zza(zzdxl zzdxl2) throws GeneralSecurityException {
        zzdsh<?> zzdsh2 = zzdsx.zzhk(zzdxl2.zzbad());
        if (((Boolean)zzhjo.get(zzdxl2.zzbad())).booleanValue()) {
            return zzdsh2.zzo(zzdxl2.zzbae());
        }
        String string2 = String.valueOf(zzdxl2.zzbad());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static synchronized zzedo zzb(zzdxl zzdxl2) throws GeneralSecurityException {
        zzdsh<?> zzdsh2 = zzdsx.zzhk(zzdxl2.zzbad());
        if (((Boolean)zzhjo.get(zzdxl2.zzbad())).booleanValue()) {
            return zzdsh2.zzn(zzdxl2.zzbae());
        }
        String string2 = String.valueOf(zzdxl2.zzbad());
        throw new GeneralSecurityException(string2.length() != 0 ? "newKey-operation not permitted for key type ".concat(string2) : new String("newKey-operation not permitted for key type "));
    }

    public static <P> P zza(String string2, zzedo zzedo2, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = zzdsx.checkNotNull(clazz);
        zzedo zzedo3 = zzedo2;
        return zzdsx.zza(string2, clazz2).zza(zzedo3);
    }

    private static <P> P zza(String string2, zzeaq zzeaq2, Class<P> clazz) throws GeneralSecurityException {
        return zzdsx.zza(string2, clazz).zzm(zzeaq2);
    }

    public static <P> P zza(String string2, byte[] byArray, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = clazz;
        zzeaq zzeaq2 = zzeaq.zzu((byte[])byArray);
        return zzdsx.zza(string2, zzeaq2, zzdsx.checkNotNull(clazz2));
    }

    public static <P> zzdsu<P> zza(zzdsn zzdsn2, zzdsh<P> zzdsh2, Class<P> clazz) throws GeneralSecurityException {
        Class<P> clazz2 = zzdsx.checkNotNull(clazz);
        zzdsn zzdsn3 = zzdsn2;
        zzdte.zzc(zzdsn3.zzaxc());
        zzdsu<P> zzdsu2 = zzdsu.zza(clazz2);
        for (zzdxp.zza zza2 : zzdsn3.zzaxc().zzbar()) {
            if (zza2.zzaxe() != zzdxj.zzhol) continue;
            P p = zzdsx.zza(zza2.zzbav().zzbad(), zza2.zzbav().zzbae(), clazz2);
            zzdst<P> zzdst2 = zzdsu2.zza(p, zza2);
            if (zza2.zzbaw() != zzdsn3.zzaxc().zzbaq()) continue;
            zzdsu2.zza(zzdst2);
        }
        return zzdsu2;
    }

    public static <P> P zza(zzdsu<P> zzdsu2) throws GeneralSecurityException {
        zzdsw zzdsw2 = (zzdsw)zzhjq.get(zzdsu2.zzawu());
        if (zzdsw2 == null) {
            String string2 = String.valueOf(zzdsu2.zzawu().getName());
            throw new GeneralSecurityException(string2.length() != 0 ? "No wrapper found for ".concat(string2) : new String("No wrapper found for "));
        }
        return zzdsw2.zza(zzdsu2);
    }

    static interface zzb {
    }

    static interface zza {
        public <P> zzdsh<P> zzb(Class<P> var1) throws GeneralSecurityException;

        public zzdsh<?> zzaxi();

        public Class<?> zzaxj();

        public Set<Class<?>> zzawz();

        public Class<?> zzaxk();
    }
}

