/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzdss;
import com.google.android.gms.internal.ads.zzdzi;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;

public final class zzdzr
implements zzdss {
    private final Mac zzhsc;
    private final int zzhsd;
    private final String zzhse;
    private final Key zzhsf;

    public zzdzr(String string2, Key key, int n) throws GeneralSecurityException {
        if (n < 10) {
            throw new InvalidAlgorithmParameterException("tag size too small, need at least 10 bytes");
        }
        if (key.getEncoded().length < 16) {
            throw new InvalidAlgorithmParameterException("key size too small, need at least 16 bytes");
        }
        switch (string2) {
            case "HMACSHA1": {
                if (n <= 20) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA256": {
                if (n <= 32) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            case "HMACSHA512": {
                if (n <= 64) break;
                throw new InvalidAlgorithmParameterException("tag size too big");
            }
            default: {
                String string3 = String.valueOf(string2);
                throw new NoSuchAlgorithmException(string3.length() != 0 ? "unknown Hmac algorithm: ".concat(string3) : new String("unknown Hmac algorithm: "));
            }
        }
        this.zzhse = string2;
        this.zzhsd = n;
        this.zzhsf = key;
        this.zzhsc = zzdzi.zzhrt.zzho(string2);
        this.zzhsc.init(key);
    }

    @Override
    public final byte[] zzm(byte[] byArray) throws GeneralSecurityException {
        Mac mac;
        try {
            mac = (Mac)this.zzhsc.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            mac = zzdzi.zzhrt.zzho(this.zzhse);
            mac.init(this.zzhsf);
        }
        mac.update(byArray);
        byte[] byArray2 = new byte[this.zzhsd];
        System.arraycopy(mac.doFinal(), 0, byArray2, 0, this.zzhsd);
        return byArray2;
    }
}

