/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.GooglePlayServicesNotAvailableException;
import com.google.android.gms.common.GooglePlayServicesRepairableException;
import com.google.android.gms.internal.ads.zzbv;
import com.google.android.gms.internal.ads.zzcn;
import com.google.android.gms.internal.ads.zzdh;
import com.google.android.gms.internal.ads.zzdlu;
import com.google.android.gms.internal.ads.zzdv;
import com.google.android.gms.internal.ads.zzdy;
import com.google.android.gms.internal.ads.zzeaq;
import com.google.android.gms.internal.ads.zzebq;
import com.google.android.gms.internal.ads.zzecd;
import com.google.android.gms.internal.ads.zzeh;
import com.google.android.gms.internal.ads.zzem;
import com.google.android.gms.internal.ads.zzen;
import com.google.android.gms.internal.ads.zzep;
import com.google.android.gms.internal.ads.zzeq;
import com.google.android.gms.internal.ads.zzes;
import com.google.android.gms.internal.ads.zzet;
import com.google.android.gms.internal.ads.zzfx;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import dalvik.system.DexClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class zzeo {
    private static final String TAG = zzeo.class.getSimpleName();
    protected Context zzvf;
    private ExecutorService zzyj;
    private DexClassLoader zzyk;
    private zzdv zzyl;
    private byte[] zzym;
    private volatile AdvertisingIdClient zzyn = null;
    private volatile boolean zzwb = false;
    private Future zzyo = null;
    private boolean zzyp;
    private volatile zzbv.zza zzyq = null;
    private Future zzyr = null;
    private zzdh zzys;
    private boolean zzyt = false;
    private boolean zzyu = false;
    private Map<Pair<String, String>, zzfx> zzyv;
    private boolean zzyw = false;
    private zzem zzya;

    public static zzeo zza(Context context, String string2, String string3, boolean bl) {
        zzeo zzeo2 = new zzeo(context);
        try {
            Object object;
            boolean bl2 = bl;
            String string4 = string3;
            String string5 = string2;
            zzeo zzeo3 = zzeo2;
            zzeo2.zzyj = Executors.newCachedThreadPool(new zzen());
            boolean bl3 = bl2;
            zzeo zzeo4 = zzeo3;
            zzeo3.zzwb = bl3;
            if (bl3) {
                zzeo4.zzyo = zzeo4.zzyj.submit(new zzeq(zzeo4));
            }
            zzeo zzeo5 = zzeo3;
            zzeo5.zzyj.execute(new zzes(zzeo5));
            try {
                object = GoogleApiAvailabilityLight.getInstance();
                zzeo5.zzyt = object.getApkVersion(zzeo5.zzvf) > 0;
                zzeo5.zzyu = object.isGooglePlayServicesAvailable(zzeo5.zzvf) == 0;
            }
            catch (Throwable throwable) {}
            zzeo3.zza(0, true);
            if (zzet.isMainThread()) {
                zzeo4 = zzzz.zzcob;
                if (((Boolean)zzvj.zzpv().zzd((zzzk)zzeo4)).booleanValue()) {
                    throw new IllegalStateException("Task Context initialization must not be called from the UI thread.");
                }
            }
            object = string5;
            zzeo5 = zzeo3;
            zzeo3.zzyl = new zzdv(null);
            try {
                zzeo5.zzym = zzeo5.zzyl.zzan((String)object);
            }
            catch (zzdy zzdy2) {
                throw new zzeh(zzdy2);
            }
            object = string4;
            zzeo5 = zzeo3;
            try {
                String string6;
                File file = zzeo5.zzvf.getCacheDir();
                if (file == null && (file = zzeo5.zzvf.getDir("dex", 0)) == null) {
                    throw new zzeh();
                }
                String string7 = string6 = "1582435991586";
                File file2 = file;
                Object object2 = object;
                zzeo zzeo6 = zzeo5;
                File file3 = new File(String.format("%s/%s.jar", file2, string7));
                if (!file3.exists()) {
                    byte[] byArray = zzeo6.zzyl.zza(zzeo6.zzym, (String)object2);
                    file3.createNewFile();
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    fileOutputStream.write(byArray, 0, byArray.length);
                    fileOutputStream.close();
                }
                File file4 = file3;
                zzeo5.zzb(file, string6);
                try {
                    zzeo5.zzyk = new DexClassLoader(file4.getAbsolutePath(), file.getAbsolutePath(), null, zzeo5.zzvf.getClassLoader());
                }
                catch (Throwable throwable) {
                    zzeo.zzb(file4);
                    zzeo5.zza(file, string6);
                    zzeo.zzao(String.format("%s/%s.dex", file, string6));
                    throw throwable;
                }
                zzeo.zzb(file4);
                zzeo5.zza(file, string6);
                zzeo.zzao(String.format("%s/%s.dex", file, string6));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new zzeh(fileNotFoundException);
            }
            catch (IOException iOException) {
                throw new zzeh(iOException);
            }
            catch (zzdy zzdy3) {
                throw new zzeh(zzdy3);
            }
            catch (NullPointerException nullPointerException) {
                throw new zzeh(nullPointerException);
            }
            zzeo3.zzys = new zzdh(zzeo3);
            zzeo3.zzyw = true;
        }
        catch (zzeh zzeh2) {}
        return zzeo2;
    }

    public final Context getContext() {
        return this.zzvf;
    }

    public final boolean isInitialized() {
        return this.zzyw;
    }

    public final ExecutorService zzch() {
        return this.zzyj;
    }

    public final DexClassLoader zzci() {
        return this.zzyk;
    }

    public final zzdv zzcj() {
        return this.zzyl;
    }

    public final byte[] zzck() {
        return this.zzym;
    }

    public final boolean zzcl() {
        return this.zzyt;
    }

    public final zzdh zzcm() {
        return this.zzys;
    }

    public final boolean zzcn() {
        return this.zzyu;
    }

    public final boolean zzcg() {
        return this.zzya.zzcg();
    }

    final zzem zzco() {
        return this.zzya;
    }

    public final zzbv.zza zzcp() {
        return this.zzyq;
    }

    public final Future zzcq() {
        return this.zzyr;
    }

    private zzeo(Context context) {
        Context context2 = context.getApplicationContext();
        this.zzyp = context2 != null;
        this.zzvf = this.zzyp ? context2 : context;
        this.zzyv = new HashMap<Pair<String, String>, zzfx>();
        zzeo zzeo2 = this;
        if (zzeo2.zzya == null) {
            zzeo2.zzya = new zzem(zzeo2.zzvf);
        }
    }

    /*
     * Loose catch block
     */
    private final void zza(File file, String string2) {
        byte[] byArray;
        FileOutputStream fileOutputStream;
        FileInputStream fileInputStream;
        File file2;
        File file3;
        block25: {
            file3 = new File(String.format("%s/%s.tmp", file, string2));
            if (file3.exists()) {
                return;
            }
            file2 = new File(String.format("%s/%s.dex", file, string2));
            if (!file2.exists()) {
                return;
            }
            fileInputStream = null;
            fileOutputStream = null;
            long l = file2.length();
            if (l <= 0L) {
                return;
            }
            byArray = new byte[(int)l];
            fileInputStream = new FileInputStream(file2);
            if (fileInputStream.read(byArray) > 0) break block25;
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            zzeo.zzb(file2);
            return;
        }
        System.out.print("test");
        System.out.print("test");
        System.out.print("test");
        zzbv.zzc.zza zza2 = zzbv.zzc.zzbf().zzd(zzeaq.zzu((byte[])Build.VERSION.SDK.getBytes())).zzc(zzeaq.zzu((byte[])string2.getBytes()));
        byte[] byArray2 = this.zzyl.zzb(this.zzym, byArray).getBytes();
        zza2.zza(zzeaq.zzu((byte[])byArray2)).zzb(zzeaq.zzu((byte[])zzcn.zzb(byArray2)));
        file3.createNewFile();
        fileOutputStream = new FileOutputStream(file3);
        byte[] byArray3 = ((zzbv.zzc)((zzecd)zza2.zzbet())).toByteArray();
        fileOutputStream.write(byArray3, 0, byArray3.length);
        fileOutputStream.close();
        try {
            fileInputStream.close();
        }
        catch (IOException iOException) {}
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {}
        zzeo.zzb(file2);
        return;
        catch (zzdy | IOException | NoSuchAlgorithmException exception) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzeo.zzb(file2);
            return;
        }
        catch (Throwable throwable) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
            catch (IOException iOException) {}
            zzeo.zzb(file2);
            throw throwable;
        }
    }

    private static void zzao(String string2) {
        zzeo.zzb(new File(string2));
    }

    private static void zzb(File file) {
        if (!file.exists()) {
            Log.d((String)TAG, (String)String.format("File %s not found. No need for deletion", file.getAbsolutePath()));
            return;
        }
        file.delete();
    }

    /*
     * Loose catch block
     */
    private final boolean zzb(File file, String string2) {
        block31: {
            zzbv.zzc zzc2;
            FileOutputStream fileOutputStream;
            FileInputStream fileInputStream;
            File file2;
            block30: {
                byte[] byArray;
                File file3;
                block29: {
                    long l;
                    block28: {
                        file3 = new File(String.format("%s/%s.tmp", file, string2));
                        if (!file3.exists()) {
                            return false;
                        }
                        file2 = new File(String.format("%s/%s.dex", file, string2));
                        if (file2.exists()) {
                            return false;
                        }
                        fileInputStream = null;
                        fileOutputStream = null;
                        l = file3.length();
                        if (l > 0L) break block28;
                        zzeo.zzb(file3);
                        return false;
                    }
                    byArray = new byte[(int)l];
                    fileInputStream = new FileInputStream(file3);
                    if (fileInputStream.read(byArray) > 0) break block29;
                    Log.d((String)TAG, (String)"Cannot read the cache data.");
                    zzeo.zzb(file3);
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    return false;
                }
                zzc2 = zzbv.zzc.zzb((byte[])byArray, (zzebq)zzebq.zzbed());
                if (string2.equals(new String(zzc2.zzbd().toByteArray())) && Arrays.equals(zzc2.zzbc().toByteArray(), zzcn.zzb(zzc2.zzbb().toByteArray())) && Arrays.equals(zzc2.zzbe().toByteArray(), Build.VERSION.SDK.getBytes())) break block30;
                zzeo.zzb(file3);
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
                return false;
            }
            byte[] byArray = this.zzyl.zza(this.zzym, new String(zzc2.zzbb().toByteArray()));
            file2.createNewFile();
            fileOutputStream = new FileOutputStream(file2);
            fileOutputStream.write(byArray, 0, byArray.length);
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            try {
                fileOutputStream.close();
            }
            catch (IOException iOException) {}
            break block31;
            catch (zzdy | IOException | NoSuchAlgorithmException exception) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                return false;
            }
            catch (Throwable throwable) {
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException) {}
                try {
                    if (fileOutputStream != null) {
                        fileOutputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        return true;
    }

    public final boolean zza(String string2, String string3, Class<?> ... classArray) {
        if (!this.zzyv.containsKey(new Pair((Object)string2, (Object)string3))) {
            this.zzyv.put((Pair<String, String>)new Pair((Object)string2, (Object)string3), new zzfx(this, string2, string3, classArray));
            return true;
        }
        return false;
    }

    public final Method zza(String string2, String string3) {
        zzfx zzfx2 = this.zzyv.get(new Pair((Object)string2, (Object)string3));
        if (zzfx2 == null) {
            return null;
        }
        return zzfx2.zzdc();
    }

    private final void zzcr() {
        try {
            if (this.zzyn == null && this.zzyp) {
                AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient(this.zzvf);
                advertisingIdClient.start();
                this.zzyn = advertisingIdClient;
            }
            return;
        }
        catch (GooglePlayServicesNotAvailableException | GooglePlayServicesRepairableException | IOException throwable) {
            this.zzyn = null;
            return;
        }
    }

    @VisibleForTesting
    final void zza(int n, boolean bl) {
        if (!this.zzyu) {
            return;
        }
        Future<?> future = this.zzyj.submit(new zzep(this, n, bl));
        if (n == 0) {
            this.zzyr = future;
        }
    }

    @VisibleForTesting
    final zzbv.zza zzb(int n, boolean bl) {
        if (n > 0 && bl) {
            try {
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.zzcs();
    }

    private static boolean zza(int n, zzbv.zza zza2) {
        if (n < 4) {
            if (zza2 == null) {
                return true;
            }
            if (!zza2.zzak() || zza2.zzag().equals("0000000000000000000000000000000000000000000000000000000000000000")) {
                return true;
            }
            if (!zza2.zzap() || !zza2.zzaq().zzbh() || zza2.zzaq().zzbi() == -2L) {
                return true;
            }
        }
        return false;
    }

    @VisibleForTesting
    private final zzbv.zza zzcs() {
        zzbv.zza zza2 = null;
        try {
            PackageInfo packageInfo = this.zzvf.getPackageManager().getPackageInfo(this.zzvf.getPackageName(), 0);
            zza2 = zzdlu.zzj((Context)this.zzvf, (String)this.zzvf.getPackageName(), (String)Integer.toString(packageInfo.versionCode));
        }
        catch (Throwable throwable) {}
        return zza2;
    }

    public final AdvertisingIdClient zzct() {
        if (!this.zzwb) {
            return null;
        }
        if (this.zzyn != null) {
            return this.zzyn;
        }
        if (this.zzyo != null) {
            try {
                this.zzyo.get(2000L, TimeUnit.MILLISECONDS);
                this.zzyo = null;
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
            }
            catch (TimeoutException timeoutException) {
                this.zzyo.cancel(true);
            }
        }
        return this.zzyn;
    }

    public final int zzbv() {
        int n = Integer.MIN_VALUE;
        if (this.zzys != null) {
            n = zzdh.zzbv();
        }
        return n;
    }

    static /* synthetic */ void zza(zzeo zzeo2) {
        zzeo2.zzcr();
    }

    static /* synthetic */ zzbv.zza zza(zzeo zzeo2, zzbv.zza zza2) {
        zzeo2.zzyq = zza2;
        return zzeo2.zzyq;
    }

    static /* synthetic */ boolean zzb(int n, zzbv.zza zza2) {
        return zzeo.zza(n, zza2);
    }
}

