/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzea;
import com.google.android.gms.internal.ads.zzem;
import com.google.android.gms.internal.ads.zzet;
import com.google.android.gms.internal.ads.zzex;
import com.google.android.gms.internal.ads.zzey;
import java.lang.ref.WeakReference;

public final class zzev
implements Application.ActivityLifecycleCallbacks,
View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener {
    private static final Handler zzzn = new Handler(Looper.getMainLooper());
    private final Context zzzo;
    private Application zzxv;
    @Nullable
    private final PowerManager zzzp;
    @Nullable
    private final KeyguardManager zzzq;
    private BroadcastReceiver zzzr;
    private final zzem zzya;
    private WeakReference<ViewTreeObserver> zzzs;
    @Nullable
    private WeakReference<View> zzzt;
    private zzea zzzu;
    private byte zzzv = (byte)-1;
    private int zzzw = -1;
    private long zzzx = -3L;

    public zzev(Context context, zzem zzem2) {
        this.zzzo = context.getApplicationContext();
        this.zzya = zzem2;
        this.zzzp = (PowerManager)this.zzzo.getSystemService("power");
        this.zzzq = (KeyguardManager)this.zzzo.getSystemService("keyguard");
        if (this.zzzo instanceof Application) {
            this.zzxv = (Application)this.zzzo;
            this.zzzu = new zzea((Application)this.zzzo, this);
        }
        this.zze(null);
    }

    final void zze(View view) {
        View view2 = this.getCurrentView();
        if (view2 != null) {
            view2.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzg(view2);
        }
        this.zzzt = new WeakReference<View>(view);
        if (view != null) {
            View view3 = view;
            if (view3.getWindowToken() != null || view3.getWindowVisibility() != 8) {
                this.zzf(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzzx = -2L;
            return;
        }
        this.zzzx = -3L;
    }

    @Nullable
    private final View getCurrentView() {
        if (this.zzzt != null) {
            return (View)this.zzzt.get();
        }
        return null;
    }

    private final void zzcu() {
        zzzn.post((Runnable)new zzey(this));
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzzw = -1;
        this.zzf(view);
        this.zzcw();
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzzw = -1;
        this.zzcw();
        this.zzcu();
        this.zzg(view);
    }

    private final void zza(Activity activity, int n) {
        if (this.zzzt == null) {
            return;
        }
        Window window = activity.getWindow();
        if (window == null) {
            return;
        }
        View view = window.peekDecorView();
        View view2 = this.getCurrentView();
        if (view2 != null && view != null && view2.getRootView() == view.getRootView()) {
            this.zzzw = n;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zza(activity, 0);
        this.zzcw();
    }

    public final void onActivityStarted(Activity activity) {
        this.zza(activity, 0);
        this.zzcw();
    }

    public final void onActivityResumed(Activity activity) {
        this.zza(activity, 0);
        this.zzcw();
        this.zzcu();
    }

    public final void onActivityPaused(Activity activity) {
        this.zza(activity, 4);
        this.zzcw();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzcw();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzcw();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzcw();
    }

    public final void onGlobalLayout() {
        this.zzcw();
    }

    public final void onScrollChanged() {
        this.zzcw();
    }

    public final long zzcv() {
        if (this.zzzx <= -2L && this.getCurrentView() == null) {
            this.zzzx = -3L;
        }
        return this.zzzx;
    }

    private final void zzcw() {
        Window window;
        WindowManager.LayoutParams layoutParams;
        View view;
        Activity activity;
        byte by = 0;
        if (this.zzzt == null) {
            return;
        }
        View view2 = this.getCurrentView();
        if (view2 == null) {
            this.zzzx = -3L;
            this.zzzv = (byte)-1;
            return;
        }
        if (view2.getVisibility() != 0) {
            by = 1;
        }
        if (!view2.isShown()) {
            by = (byte)(by | 2);
        }
        if (this.zzzp != null && !this.zzzp.isScreenOn()) {
            by = (byte)(by | 4);
        }
        if (!(this.zzya.zzcg() || this.zzzq != null && this.zzzq.inKeyguardRestrictedInputMode() && (activity = zzet.zzd(view = view2)) != null && (layoutParams = (window = activity.getWindow()) == null ? null : window.getAttributes()) != null && (layoutParams.flags & 0x80000) != 0)) {
            by = (byte)(by | 8);
        }
        if (!view2.getGlobalVisibleRect(new Rect())) {
            by = (byte)(by | 0x10);
        }
        if (!view2.getLocalVisibleRect(new Rect())) {
            by = (byte)(by | 0x20);
        }
        int n = view2.getWindowVisibility();
        if ((this.zzzw != -1 ? this.zzzw : n) != 0) {
            by = (byte)(by | 0x40);
        }
        if (this.zzzv != by) {
            long l;
            this.zzzv = by;
            if (this.zzzv == 0) {
                l = SystemClock.elapsedRealtime();
            } else {
                zzev zzev2 = this;
                l = -3L - (long)zzev2.zzzv;
            }
            this.zzzx = l;
        }
    }

    private final void zzf(View view) {
        ViewTreeObserver viewTreeObserver = view.getViewTreeObserver();
        if (viewTreeObserver.isAlive()) {
            this.zzzs = new WeakReference<ViewTreeObserver>(viewTreeObserver);
            viewTreeObserver.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            viewTreeObserver.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        zzev zzev2 = this;
        if (zzev2.zzzr == null) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.intent.action.SCREEN_ON");
            intentFilter.addAction("android.intent.action.SCREEN_OFF");
            intentFilter.addAction("android.intent.action.USER_PRESENT");
            zzev2.zzzr = new zzex(zzev2);
            zzev2.zzzo.registerReceiver(zzev2.zzzr, intentFilter);
        }
        if (this.zzxv != null) {
            try {
                this.zzxv.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzzu);
                return;
            }
            catch (Exception exception) {}
        }
    }

    private final void zzg(View view) {
        ViewTreeObserver viewTreeObserver;
        try {
            if (this.zzzs != null) {
                viewTreeObserver = (ViewTreeObserver)this.zzzs.get();
                if (viewTreeObserver != null && viewTreeObserver.isAlive()) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzzs = null;
            }
        }
        catch (Exception exception) {}
        try {
            viewTreeObserver = view.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {}
        zzev zzev2 = this;
        if (zzev2.zzzr != null) {
            try {
                zzev2.zzzo.unregisterReceiver(zzev2.zzzr);
            }
            catch (Exception exception) {}
            zzev2.zzzr = null;
        }
        if (this.zzxv != null) {
            try {
                this.zzxv.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzzu);
                return;
            }
            catch (Exception exception) {}
        }
    }

    static /* synthetic */ void zza(zzev zzev2) {
        zzev2.zzcw();
    }
}

