/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.internal.ads.zzgr;
import com.google.android.gms.internal.ads.zzjc;
import com.google.android.gms.internal.ads.zzje;
import com.google.android.gms.internal.ads.zzoh;
import com.google.android.gms.internal.ads.zzov;
import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;

public final class zzja
implements Parcelable,
Comparator<zza> {
    private final zza[] zzanm;
    private int zzahb;
    public final int zzann;
    public static final Parcelable.Creator<zzja> CREATOR = new zzjc();

    public zzja(zza ... zzaArray) {
        this(true, zzaArray);
    }

    private zzja(boolean bl, zza ... zzaArray) {
        zzaArray = (zza[])zzaArray.clone();
        Arrays.sort(zzaArray, this);
        for (int i = 1; i < zzaArray.length; ++i) {
            if (!zzaArray[i - 1].uuid.equals(zzaArray[i].uuid)) continue;
            String string2 = String.valueOf(zzaArray[i].uuid);
            throw new IllegalArgumentException(new StringBuilder(25 + String.valueOf(string2).length()).append("Duplicate data for uuid: ").append(string2).toString());
        }
        this.zzanm = zzaArray;
        this.zzann = zzaArray.length;
    }

    zzja(Parcel parcel) {
        this.zzanm = (zza[])parcel.createTypedArray(zza.CREATOR);
        this.zzann = this.zzanm.length;
    }

    public final zza zzaa(int n) {
        return this.zzanm[n];
    }

    public final int hashCode() {
        if (this.zzahb == 0) {
            this.zzahb = Arrays.hashCode(this.zzanm);
        }
        return this.zzahb;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return Arrays.equals(this.zzanm, ((zzja)object).zzanm);
    }

    public final int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        parcel.writeTypedArray((Parcelable[])this.zzanm, 0);
    }

    @Override
    public final /* synthetic */ int compare(Object object, Object object2) {
        zza zza2 = (zza)object2;
        zza zza3 = (zza)object;
        if (zzgr.zzadl.equals(zza3.uuid)) {
            if (zzgr.zzadl.equals(zza2.uuid)) {
                return 0;
            }
            return 1;
        }
        return zza3.uuid.compareTo(zza2.uuid);
    }

    public static final class zza
    implements Parcelable {
        private int zzahb;
        private final UUID uuid;
        private final String mimeType;
        private final byte[] data;
        public final boolean zzanq;
        public static final Parcelable.Creator<zza> CREATOR = new zzje();

        public zza(UUID uUID, String string2, byte[] byArray) {
            this(uUID, string2, byArray, false);
        }

        private zza(UUID uUID, String string2, byte[] byArray, boolean bl) {
            this.uuid = zzoh.checkNotNull(uUID);
            this.mimeType = zzoh.checkNotNull(string2);
            this.data = zzoh.checkNotNull(byArray);
            this.zzanq = false;
        }

        zza(Parcel parcel) {
            this.uuid = new UUID(parcel.readLong(), parcel.readLong());
            this.mimeType = parcel.readString();
            this.data = parcel.createByteArray();
            this.zzanq = parcel.readByte() != 0;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof zza)) {
                return false;
            }
            if (object == this) {
                return true;
            }
            zza zza2 = (zza)object;
            return this.mimeType.equals(zza2.mimeType) && zzov.zza(this.uuid, zza2.uuid) && Arrays.equals(this.data, zza2.data);
        }

        public final int hashCode() {
            if (this.zzahb == 0) {
                int n = this.uuid.hashCode();
                n = n * 31 + this.mimeType.hashCode();
                this.zzahb = n = n * 31 + Arrays.hashCode(this.data);
            }
            return this.zzahb;
        }

        public final int describeContents() {
            return 0;
        }

        public final void writeToParcel(Parcel parcel, int n) {
            parcel.writeLong(this.uuid.getMostSignificantBits());
            parcel.writeLong(this.uuid.getLeastSignificantBits());
            parcel.writeString(this.mimeType);
            parcel.writeByteArray(this.data);
            parcel.writeByte((byte)(this.zzanq ? 1 : 0));
        }
    }
}

