/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.util.Log;
import com.google.android.gms.internal.ads.zzhf;
import com.google.android.gms.internal.ads.zzhi;
import com.google.android.gms.internal.ads.zzja;
import com.google.android.gms.internal.ads.zzjo;
import com.google.android.gms.internal.ads.zzjt;
import com.google.android.gms.internal.ads.zzjw;
import com.google.android.gms.internal.ads.zzkb;
import com.google.android.gms.internal.ads.zzkc;
import com.google.android.gms.internal.ads.zzoo;
import com.google.android.gms.internal.ads.zzos;
import com.google.android.gms.internal.ads.zzov;
import com.google.android.gms.internal.ads.zzox;
import com.google.android.gms.internal.ads.zzpa;
import com.google.android.gms.internal.ads.zzpd;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

final class zzkd {
    public String zzaqo;
    public int number;
    public int type;
    public int zzaqp;
    public boolean zzaqq;
    public byte[] zzaqr;
    public zzjw zzaqs;
    public byte[] zzaqt;
    public zzja zzagl;
    public int width = -1;
    public int height = -1;
    public int zzaqu = -1;
    public int zzaqv = -1;
    public int zzaqw = 0;
    public byte[] zzagq = null;
    public int zzagp = -1;
    public boolean zzaqx = false;
    public int zzaqy = -1;
    public int zzaqz = -1;
    public int zzara = -1;
    public int zzarb = 1000;
    public int zzarc = 200;
    public float zzard = -1.0f;
    public float zzare = -1.0f;
    public float zzarf = -1.0f;
    public float zzarg = -1.0f;
    public float zzarh = -1.0f;
    public float zzari = -1.0f;
    public float zzarj = -1.0f;
    public float zzark = -1.0f;
    public float zzarl = -1.0f;
    public float zzarm = -1.0f;
    public int zzags = 1;
    public int zzarn = -1;
    public int zzagt = 8000;
    public long zzaro = 0L;
    public long zzarp = 0L;
    public boolean zzarq;
    public boolean zzarr = true;
    private String zzagz = "eng";
    public zzjt zzars;
    public int zzart;

    private zzkd() {
    }

    public final void zza(zzjo zzjo2, int n) throws zzhi {
        zzhf zzhf2;
        int n2;
        String string2;
        String string3;
        int n3 = -1;
        int n4 = -1;
        List<byte[]> list = null;
        switch (this.zzaqo) {
            case "V_VP8": {
                string3 = "video/x-vnd.on2.vp8";
                break;
            }
            case "V_VP9": {
                string3 = "video/x-vnd.on2.vp9";
                break;
            }
            case "V_MPEG2": {
                string3 = "video/mpeg2";
                break;
            }
            case "V_MPEG4/ISO/SP": 
            case "V_MPEG4/ISO/ASP": 
            case "V_MPEG4/ISO/AP": {
                string3 = "video/mp4v-es";
                list = this.zzaqt == null ? null : Collections.singletonList(this.zzaqt);
                break;
            }
            case "V_MPEG4/ISO/AVC": {
                string3 = "video/avc";
                zzox zzox2 = zzox.zzf(new zzos(this.zzaqt));
                list = zzox2.zzagk;
                this.zzart = zzox2.zzart;
                break;
            }
            case "V_MPEGH/ISO/HEVC": {
                string3 = "video/hevc";
                zzpd zzpd2 = zzpd.zzh(new zzos(this.zzaqt));
                list = zzpd2.zzagk;
                this.zzart = zzpd2.zzart;
                break;
            }
            case "V_MS/VFW/FOURCC": {
                list = zzkd.zza(new zzos(this.zzaqt));
                if (list != null) {
                    string3 = "video/wvc1";
                    break;
                }
                Log.w((String)"MatroskaExtractor", (String)"Unsupported FourCC. Setting mimeType to video/x-unknown");
                string3 = "video/x-unknown";
                break;
            }
            case "V_THEORA": {
                string3 = "video/x-unknown";
                break;
            }
            case "A_VORBIS": {
                string3 = "audio/vorbis";
                n3 = 8192;
                list = zzkd.zzd(this.zzaqt);
                break;
            }
            case "A_OPUS": {
                string3 = "audio/opus";
                n3 = 5760;
                list = new ArrayList<byte[]>(3);
                list.add(this.zzaqt);
                list.add(ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(this.zzaro).array());
                list.add(ByteBuffer.allocate(8).order(ByteOrder.nativeOrder()).putLong(this.zzarp).array());
                break;
            }
            case "A_AAC": {
                string3 = "audio/mp4a-latm";
                list = Collections.singletonList(this.zzaqt);
                break;
            }
            case "A_MPEG/L2": {
                string3 = "audio/mpeg-L2";
                n3 = 4096;
                break;
            }
            case "A_MPEG/L3": {
                string3 = "audio/mpeg";
                n3 = 4096;
                break;
            }
            case "A_AC3": {
                string3 = "audio/ac3";
                break;
            }
            case "A_EAC3": {
                string3 = "audio/eac3";
                break;
            }
            case "A_TRUEHD": {
                string3 = "audio/true-hd";
                break;
            }
            case "A_DTS": 
            case "A_DTS/EXPRESS": {
                string3 = "audio/vnd.dts";
                break;
            }
            case "A_DTS/LOSSLESS": {
                string3 = "audio/vnd.dts.hd";
                break;
            }
            case "A_FLAC": {
                string3 = "audio/x-flac";
                list = Collections.singletonList(this.zzaqt);
                break;
            }
            case "A_MS/ACM": {
                int n5;
                string3 = "audio/raw";
                if (zzkd.zzb(new zzos(this.zzaqt))) {
                    n4 = zzov.zzbl(this.zzarn);
                    if (n4 != 0) break;
                    n4 = -1;
                    string3 = "audio/x-unknown";
                    n5 = this.zzarn;
                    string2 = string3;
                    Log.w((String)"MatroskaExtractor", (String)new StringBuilder(60 + String.valueOf(string2).length()).append("Unsupported PCM bit depth: ").append(n5).append(". Setting mimeType to ").append(string2).toString());
                    break;
                }
                string3 = "audio/x-unknown";
                String string4 = String.valueOf(string3);
                Log.w((String)"MatroskaExtractor", (String)(string4.length() != 0 ? "Non-PCM MS/ACM is unsupported. Setting mimeType to ".concat(string4) : new String("Non-PCM MS/ACM is unsupported. Setting mimeType to ")));
                break;
            }
            case "A_PCM/INT/LIT": {
                string3 = "audio/raw";
                n4 = zzov.zzbl(this.zzarn);
                if (n4 != 0) break;
                n4 = -1;
                string3 = "audio/x-unknown";
                int n5 = this.zzarn;
                string2 = string3;
                Log.w((String)"MatroskaExtractor", (String)new StringBuilder(60 + String.valueOf(string2).length()).append("Unsupported PCM bit depth: ").append(n5).append(". Setting mimeType to ").append(string2).toString());
                break;
            }
            case "S_TEXT/UTF8": {
                string3 = "application/x-subrip";
                break;
            }
            case "S_VOBSUB": {
                string3 = "application/vobsub";
                list = Collections.singletonList(this.zzaqt);
                break;
            }
            case "S_HDMV/PGS": {
                string3 = "application/pgs";
                break;
            }
            case "S_DVBSUB": {
                string3 = "application/dvbsubs";
                list = Collections.singletonList(new byte[]{this.zzaqt[0], this.zzaqt[1], this.zzaqt[2], this.zzaqt[3]});
                break;
            }
            default: {
                throw new zzhi("Unrecognized codec identifier.");
            }
        }
        int n6 = 0 | (this.zzarr ? 1 : 0) | (this.zzarq ? 2 : 0);
        if (zzoo.zzbd(string3)) {
            n2 = 1;
            zzhf2 = zzhf.zza(Integer.toString(n), string3, null, -1, n3, this.zzags, this.zzagt, n4, list, this.zzagl, n6, this.zzagz);
        } else if (zzoo.zzbe(string3)) {
            n2 = 2;
            if (this.zzaqw == 0) {
                this.zzaqu = this.zzaqu == -1 ? this.width : this.zzaqu;
                this.zzaqv = this.zzaqv == -1 ? this.height : this.zzaqv;
            }
            float f = -1.0f;
            if (this.zzaqu != -1 && this.zzaqv != -1) {
                f = (float)(this.height * this.zzaqu) / (float)(this.width * this.zzaqv);
            }
            zzpa zzpa2 = null;
            if (this.zzaqx) {
                byte[] byArray;
                zzkd zzkd2 = this;
                if (zzkd2.zzard == -1.0f || zzkd2.zzare == -1.0f || zzkd2.zzarf == -1.0f || zzkd2.zzarg == -1.0f || zzkd2.zzarh == -1.0f || zzkd2.zzari == -1.0f || zzkd2.zzarj == -1.0f || zzkd2.zzark == -1.0f || zzkd2.zzarl == -1.0f || zzkd2.zzarm == -1.0f) {
                    byArray = null;
                } else {
                    byte[] byArray2 = new byte[25];
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
                    byteBuffer.put((byte)0);
                    byteBuffer.putShort((short)(zzkd2.zzard * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzkd2.zzare * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzkd2.zzarf * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzkd2.zzarg * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzkd2.zzarh * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzkd2.zzari * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzkd2.zzarj * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzkd2.zzark * 50000.0f + 0.5f));
                    byteBuffer.putShort((short)(zzkd2.zzarl + 0.5f));
                    byteBuffer.putShort((short)(zzkd2.zzarm + 0.5f));
                    byteBuffer.putShort((short)zzkd2.zzarb);
                    byteBuffer.putShort((short)zzkd2.zzarc);
                    byArray = byArray2;
                }
                string2 = byArray;
                zzpa2 = new zzpa(this.zzaqy, this.zzara, this.zzaqz, (byte[])string2);
            }
            zzhf2 = zzhf.zza(Integer.toString(n), string3, null, -1, n3, this.width, this.height, -1.0f, list, -1, f, this.zzagq, this.zzagp, zzpa2, this.zzagl);
        } else if ("application/x-subrip".equals(string3)) {
            n2 = 3;
            zzhf2 = zzhf.zza(Integer.toString(n), string3, null, -1, n6, this.zzagz, this.zzagl);
        } else if ("application/vobsub".equals(string3) || "application/pgs".equals(string3) || "application/dvbsubs".equals(string3)) {
            n2 = 3;
            zzhf2 = zzhf.zza(Integer.toString(n), string3, null, -1, list, this.zzagz, this.zzagl);
        } else {
            throw new zzhi("Unexpected MIME type.");
        }
        this.zzars = zzjo2.zzc(this.number, n2);
        this.zzars.zze(zzhf2);
    }

    private static List<byte[]> zza(zzos zzos2) throws zzhi {
        try {
            zzos2.zzbj(16);
            if (zzos2.zzjc() != 826496599L) {
                return null;
            }
            int n = zzos2.getPosition() + 20;
            byte[] byArray = zzos2.data;
            for (int i = n; i < byArray.length - 4; ++i) {
                if (byArray[i] != 0 || byArray[i + 1] != 0 || byArray[i + 2] != 1 || byArray[i + 3] != 15) continue;
                return Collections.singletonList(Arrays.copyOfRange(byArray, i, byArray.length));
            }
            throw new zzhi("Failed to find FourCC VC1 initialization data");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new zzhi("Error parsing FourCC VC1 codec private");
        }
    }

    private static List<byte[]> zzd(byte[] byArray) throws zzhi {
        try {
            if (byArray[0] != 2) {
                throw new zzhi("Error parsing vorbis codec private");
            }
            int n = 1;
            int n2 = 0;
            while (byArray[n] == -1) {
                n2 += 255;
                ++n;
            }
            n2 += byArray[n++];
            int n3 = 0;
            while (byArray[n] == -1) {
                n3 += 255;
                ++n;
            }
            n3 += byArray[n++];
            if (byArray[n] != 1) {
                throw new zzhi("Error parsing vorbis codec private");
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            if (byArray[n += n2] != 3) {
                throw new zzhi("Error parsing vorbis codec private");
            }
            if (byArray[n += n3] != 5) {
                throw new zzhi("Error parsing vorbis codec private");
            }
            byte[] byArray3 = new byte[byArray.length - n];
            System.arraycopy(byArray, n, byArray3, 0, byArray.length - n);
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>(2);
            arrayList.add(byArray2);
            arrayList.add(byArray3);
            return arrayList;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new zzhi("Error parsing vorbis codec private");
        }
    }

    private static boolean zzb(zzos zzos2) throws zzhi {
        try {
            int n = zzos2.zzja();
            if (n == 1) {
                return true;
            }
            if (n == 65534) {
                zzos2.zzbi(24);
                return zzos2.readLong() == zzkc.zzgu().getMostSignificantBits() && zzos2.readLong() == zzkc.zzgu().getLeastSignificantBits();
            }
            return false;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new zzhi("Error parsing MS/ACM codec private");
        }
    }

    /* synthetic */ zzkd(zzkb zzkb2) {
        this();
    }

    static /* synthetic */ String zza(zzkd zzkd2, String string2) {
        zzkd2.zzagz = string2;
        return zzkd2.zzagz;
    }
}

