/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.util.SparseIntArray;
import com.google.android.gms.internal.ads.zzlc;
import com.google.android.gms.internal.ads.zzli;
import com.google.android.gms.internal.ads.zzlj;
import com.google.android.gms.internal.ads.zzlk;
import com.google.android.gms.internal.ads.zzll;
import com.google.android.gms.internal.ads.zzov;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TargetApi(value=16)
@SuppressLint(value={"InlinedApi"})
public final class zzlf {
    private static final zzlc zzbah = zzlc.zzaz("OMX.google.raw.decoder");
    private static final Pattern zzbai = Pattern.compile("^\\D?(\\d+)$");
    private static final HashMap<zza, List<zzlc>> zzbaj = new HashMap();
    private static final SparseIntArray zzbak;
    private static final SparseIntArray zzbal;
    private static final Map<String, Integer> zzbam;
    private static int zzban;

    public static zzlc zzhi() {
        return zzbah;
    }

    public static zzlc zzb(String string2, boolean bl) throws zzlj {
        List<zzlc> list = zzlf.zzc(string2, bl);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    private static synchronized List<zzlc> zzc(String string2, boolean bl) throws zzlj {
        zza zza2 = new zza(string2, bl);
        List<zzlc> list = zzbaj.get(zza2);
        if (list != null) {
            return list;
        }
        zzli zzli2 = zzov.SDK_INT >= 21 ? new zzlk(bl) : new zzll(null);
        list = zzlf.zza(zza2, zzli2);
        if (bl && list.isEmpty() && 21 <= zzov.SDK_INT && zzov.SDK_INT <= 23 && !(list = zzlf.zza(zza2, zzli2 = new zzll(null))).isEmpty()) {
            String string3 = list.get((int)0).name;
            Log.w((String)"MediaCodecUtil", (String)new StringBuilder(63 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("MediaCodecList API didn't list secure decoder for: ").append(string2).append(". Assuming: ").append(string3).toString());
        }
        list = Collections.unmodifiableList(list);
        zzbaj.put(zza2, list);
        return list;
    }

    public static int zzhj() throws zzlj {
        if (zzban == -1) {
            int n = 0;
            zzlc zzlc2 = zzlf.zzb("video/avc", false);
            if (zzlc2 != null) {
                MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = zzlc2.zzhh();
                int n2 = codecProfileLevelArray.length;
                for (int i = 0; i < n2; ++i) {
                    int n3;
                    switch (codecProfileLevelArray[i].level) {
                        case 1: {
                            n3 = 25344;
                            break;
                        }
                        case 2: {
                            n3 = 25344;
                            break;
                        }
                        case 8: {
                            n3 = 101376;
                            break;
                        }
                        case 16: {
                            n3 = 101376;
                            break;
                        }
                        case 32: {
                            n3 = 101376;
                            break;
                        }
                        case 64: {
                            n3 = 202752;
                            break;
                        }
                        case 128: {
                            n3 = 414720;
                            break;
                        }
                        case 256: {
                            n3 = 414720;
                            break;
                        }
                        case 512: {
                            n3 = 921600;
                            break;
                        }
                        case 1024: {
                            n3 = 0x140000;
                            break;
                        }
                        case 2048: {
                            n3 = 0x200000;
                            break;
                        }
                        case 4096: {
                            n3 = 0x200000;
                            break;
                        }
                        case 8192: {
                            n3 = 0x220000;
                            break;
                        }
                        case 16384: {
                            n3 = 5652480;
                            break;
                        }
                        case 32768: {
                            n3 = 0x900000;
                            break;
                        }
                        case 65536: {
                            n3 = 0x900000;
                            break;
                        }
                        default: {
                            n3 = -1;
                        }
                    }
                    n = Math.max(n3, n);
                }
                n = Math.max(n, zzov.SDK_INT >= 21 ? 345600 : 172800);
            }
            zzban = n;
        }
        return zzban;
    }

    public static Pair<Integer, Integer> zzbc(String string2) {
        if (string2 == null) {
            return null;
        }
        String[] stringArray = string2.split("\\.");
        switch (stringArray[0]) {
            case "hev1": 
            case "hvc1": {
                int n;
                String[] stringArray2 = stringArray;
                String string3 = string2;
                if (stringArray2.length < 4) {
                    String string4 = String.valueOf(string3);
                    Log.w((String)"MediaCodecUtil", (String)(string4.length() != 0 ? "Ignoring malformed HEVC codec string: ".concat(string4) : new String("Ignoring malformed HEVC codec string: ")));
                    return null;
                }
                Matcher matcher = zzbai.matcher(stringArray2[1]);
                if (!matcher.matches()) {
                    String string5 = String.valueOf(string3);
                    Log.w((String)"MediaCodecUtil", (String)(string5.length() != 0 ? "Ignoring malformed HEVC codec string: ".concat(string5) : new String("Ignoring malformed HEVC codec string: ")));
                    return null;
                }
                String string6 = matcher.group(1);
                if ("1".equals(string6)) {
                    n = 1;
                } else if ("2".equals(string6)) {
                    n = 2;
                } else {
                    String string7 = String.valueOf(string6);
                    Log.w((String)"MediaCodecUtil", (String)(string7.length() != 0 ? "Unknown HEVC profile string: ".concat(string7) : new String("Unknown HEVC profile string: ")));
                    return null;
                }
                Integer n2 = zzbam.get(stringArray2[3]);
                if (n2 == null) {
                    String string8 = String.valueOf(matcher.group(1));
                    Log.w((String)"MediaCodecUtil", (String)(string8.length() != 0 ? "Unknown HEVC level string: ".concat(string8) : new String("Unknown HEVC level string: ")));
                    return null;
                }
                return new Pair((Object)n, (Object)n2);
            }
            case "avc1": 
            case "avc2": {
                return zzlf.zza(string2, stringArray);
            }
        }
        return null;
    }

    private static List<zzlc> zza(zza zza2, zzli zzli2) throws zzlj {
        try {
            ArrayList<zzlc> arrayList = new ArrayList<zzlc>();
            String string2 = zza2.mimeType;
            int n = zzli2.getCodecCount();
            boolean bl = zzli2.zzhk();
            for (int i = 0; i < n; ++i) {
                MediaCodecInfo mediaCodecInfo = zzli2.getCodecInfoAt(i);
                String string3 = mediaCodecInfo.getName();
                boolean bl2 = bl;
                String string4 = string3;
                if (!(mediaCodecInfo.isEncoder() || !bl2 && string4.endsWith(".secure") ? false : (zzov.SDK_INT < 21 && ("CIPAACDecoder".equals(string4) || "CIPMP3Decoder".equals(string4) || "CIPVorbisDecoder".equals(string4) || "CIPAMRNBDecoder".equals(string4) || "AACDecoder".equals(string4) || "MP3Decoder".equals(string4)) ? false : (zzov.SDK_INT < 18 && "OMX.SEC.MP3.Decoder".equals(string4) ? false : (zzov.SDK_INT < 18 && "OMX.MTK.AUDIO.DECODER.AAC".equals(string4) && "a70".equals(zzov.DEVICE) ? false : (zzov.SDK_INT == 16 && "OMX.qcom.audio.decoder.mp3".equals(string4) && ("dlxu".equals(zzov.DEVICE) || "protou".equals(zzov.DEVICE) || "ville".equals(zzov.DEVICE) || "villeplus".equals(zzov.DEVICE) || "villec2".equals(zzov.DEVICE) || zzov.DEVICE.startsWith("gee") || "C6602".equals(zzov.DEVICE) || "C6603".equals(zzov.DEVICE) || "C6606".equals(zzov.DEVICE) || "C6616".equals(zzov.DEVICE) || "L36h".equals(zzov.DEVICE) || "SO-02E".equals(zzov.DEVICE)) ? false : (zzov.SDK_INT == 16 && "OMX.qcom.audio.decoder.aac".equals(string4) && ("C1504".equals(zzov.DEVICE) || "C1505".equals(zzov.DEVICE) || "C1604".equals(zzov.DEVICE) || "C1605".equals(zzov.DEVICE)) ? false : (zzov.SDK_INT <= 19 && "OMX.SEC.vp8.dec".equals(string4) && "samsung".equals(zzov.MANUFACTURER) && (zzov.DEVICE.startsWith("d2") || zzov.DEVICE.startsWith("serrano") || zzov.DEVICE.startsWith("jflte") || zzov.DEVICE.startsWith("santos") || zzov.DEVICE.startsWith("t0")) ? false : zzov.SDK_INT > 19 || !zzov.DEVICE.startsWith("jflte") || !"OMX.qcom.video.decoder.vp8".equals(string4))))))))) continue;
                for (String string5 : mediaCodecInfo.getSupportedTypes()) {
                    if (!string5.equalsIgnoreCase(string2)) continue;
                    try {
                        boolean bl3;
                        MediaCodecInfo.CodecCapabilities codecCapabilities = mediaCodecInfo.getCapabilitiesForType(string5);
                        boolean bl4 = zzli2.zza(string2, codecCapabilities);
                        String string6 = string3;
                        boolean bl5 = bl3 = !(zzov.SDK_INT > 22 || !zzov.MODEL.equals("ODROID-XU3") && !zzov.MODEL.equals("Nexus 10") || !"OMX.Exynos.AVC.Decoder".equals(string6) && !"OMX.Exynos.AVC.Decoder.secure".equals(string6));
                        if (bl && zza2.zzbab == bl4 || !bl && !zza2.zzbab) {
                            arrayList.add(zzlc.zza(string3, string2, codecCapabilities, bl3, false));
                            continue;
                        }
                        if (bl || !bl4) continue;
                        arrayList.add(zzlc.zza(String.valueOf(string3).concat(".secure"), string2, codecCapabilities, bl3, true));
                        return arrayList;
                    }
                    catch (Exception exception) {
                        if (zzov.SDK_INT <= 23 && !arrayList.isEmpty()) {
                            Log.e((String)"MediaCodecUtil", (String)new StringBuilder(46 + String.valueOf(string3).length()).append("Skipping codec ").append(string3).append(" (failed to query capabilities)").toString());
                            continue;
                        }
                        Log.e((String)"MediaCodecUtil", (String)new StringBuilder(25 + String.valueOf(string3).length() + String.valueOf(string5).length()).append("Failed to query codec ").append(string3).append(" (").append(string5).append(")").toString());
                        throw exception;
                    }
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            throw new zzlj(exception, null);
        }
    }

    private static Pair<Integer, Integer> zza(String string2, String[] stringArray) {
        Integer n;
        Integer n2;
        block7: {
            if (stringArray.length < 2) {
                String string3 = String.valueOf(string2);
                Log.w((String)"MediaCodecUtil", (String)(string3.length() != 0 ? "Ignoring malformed AVC codec string: ".concat(string3) : new String("Ignoring malformed AVC codec string: ")));
                return null;
            }
            try {
                if (stringArray[1].length() == 6) {
                    n2 = Integer.parseInt(stringArray[1].substring(0, 2), 16);
                    n = Integer.parseInt(stringArray[1].substring(4), 16);
                    break block7;
                }
                if (stringArray.length >= 3) {
                    n2 = Integer.parseInt(stringArray[1]);
                    n = Integer.parseInt(stringArray[2]);
                    break block7;
                }
                String string4 = String.valueOf(string2);
                Log.w((String)"MediaCodecUtil", (String)(string4.length() != 0 ? "Ignoring malformed AVC codec string: ".concat(string4) : new String("Ignoring malformed AVC codec string: ")));
                return null;
            }
            catch (NumberFormatException numberFormatException) {
                String string5 = String.valueOf(string2);
                Log.w((String)"MediaCodecUtil", (String)(string5.length() != 0 ? "Ignoring malformed AVC codec string: ".concat(string5) : new String("Ignoring malformed AVC codec string: ")));
                return null;
            }
        }
        Integer n3 = zzbak.get(n2.intValue());
        if (n3 == null) {
            String string6 = String.valueOf(n2);
            Log.w((String)"MediaCodecUtil", (String)new StringBuilder(21 + String.valueOf(string6).length()).append("Unknown AVC profile: ").append(string6).toString());
            return null;
        }
        Integer n4 = zzbal.get(n.intValue());
        if (n4 == null) {
            String string7 = String.valueOf(n);
            Log.w((String)"MediaCodecUtil", (String)new StringBuilder(19 + String.valueOf(string7).length()).append("Unknown AVC level: ").append(string7).toString());
            return null;
        }
        return new Pair((Object)n3, (Object)n4);
    }

    static {
        zzban = -1;
        zzbak = new SparseIntArray();
        zzbak.put(66, 1);
        zzbak.put(77, 2);
        zzbak.put(88, 4);
        zzbak.put(100, 8);
        zzbal = new SparseIntArray();
        zzbal.put(10, 1);
        zzbal.put(11, 4);
        zzbal.put(12, 8);
        zzbal.put(13, 16);
        zzbal.put(20, 32);
        zzbal.put(21, 64);
        zzbal.put(22, 128);
        zzbal.put(30, 256);
        zzbal.put(31, 512);
        zzbal.put(32, 1024);
        zzbal.put(40, 2048);
        zzbal.put(41, 4096);
        zzbal.put(42, 8192);
        zzbal.put(50, 16384);
        zzbal.put(51, 32768);
        zzbal.put(52, 65536);
        zzbam = new HashMap<String, Integer>();
        zzbam.put("L30", 1);
        zzbam.put("L60", 4);
        zzbam.put("L63", 16);
        zzbam.put("L90", 64);
        zzbam.put("L93", 256);
        zzbam.put("L120", 1024);
        zzbam.put("L123", 4096);
        zzbam.put("L150", 16384);
        zzbam.put("L153", 65536);
        zzbam.put("L156", 262144);
        zzbam.put("L180", 0x100000);
        zzbam.put("L183", 0x400000);
        zzbam.put("L186", 0x1000000);
        zzbam.put("H30", 2);
        zzbam.put("H60", 8);
        zzbam.put("H63", 32);
        zzbam.put("H90", 128);
        zzbam.put("H93", 512);
        zzbam.put("H120", 2048);
        zzbam.put("H123", 8192);
        zzbam.put("H150", 32768);
        zzbam.put("H153", 131072);
        zzbam.put("H156", 524288);
        zzbam.put("H180", 0x200000);
        zzbam.put("H183", 0x800000);
        zzbam.put("H186", 0x2000000);
    }

    static final class zza {
        public final String mimeType;
        public final boolean zzbab;

        public zza(String string2, boolean bl) {
            this.mimeType = string2;
            this.zzbab = bl;
        }

        public final int hashCode() {
            int n = 31 + (this.mimeType == null ? 0 : this.mimeType.hashCode());
            return n * 31 + (this.zzbab ? 1231 : 1237);
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != zza.class) {
                return false;
            }
            zza zza2 = (zza)object;
            return TextUtils.equals((CharSequence)this.mimeType, (CharSequence)zza2.mimeType) && this.zzbab == zza2.zzbab;
        }
    }
}

