/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.internal.ads.zznu;
import com.google.android.gms.internal.ads.zznv;
import com.google.android.gms.internal.ads.zznw;
import com.google.android.gms.internal.ads.zznz;
import com.google.android.gms.internal.ads.zzoa;
import com.google.android.gms.internal.ads.zzoc;
import com.google.android.gms.internal.ads.zzoh;
import com.google.android.gms.internal.ads.zzoi;
import com.google.android.gms.internal.ads.zzou;
import com.google.android.gms.internal.ads.zzov;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.NoRouteToHostException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class zznx
implements zznu {
    private static final Pattern zzbfo = Pattern.compile("^bytes (\\d+)-(\\d+)/(\\d+)$");
    private static final AtomicReference<byte[]> zzbfp = new AtomicReference();
    private final boolean zzbfq;
    private final int zzbfr;
    private final int zzbfs;
    private final String zzbft;
    private final zzou<String> zzbfu;
    private final zzoc zzbfv;
    private final zzoc zzbfw;
    private final zzoi<? super zznx> zzbfx;
    private zznv zzbfy;
    private HttpURLConnection zzbfz;
    private InputStream zzbga;
    private boolean zzbgb;
    private long zzbgc;
    private long zzbgd;
    private long zzbge;
    private long zzcf;

    public zznx(String string2, zzou<String> zzou2, zzoi<? super zznx> zzoi2, int n, int n2, boolean bl, zzoc zzoc2) {
        this.zzbft = zzoh.checkNotEmpty(string2);
        this.zzbfu = null;
        this.zzbfx = zzoi2;
        this.zzbfw = new zzoc();
        this.zzbfr = n;
        this.zzbfs = n2;
        this.zzbfq = true;
        this.zzbfv = null;
    }

    @Override
    public final Uri getUri() {
        if (this.zzbfz == null) {
            return null;
        }
        return Uri.parse((String)this.zzbfz.getURL().toString());
    }

    public final Map<String, List<String>> getResponseHeaders() {
        if (this.zzbfz == null) {
            return null;
        }
        return this.zzbfz.getHeaderFields();
    }

    @Override
    public final long zza(zznv zznv2) throws zzoa {
        long l;
        int n;
        this.zzbfy = zznv2;
        this.zzcf = 0L;
        this.zzbge = 0L;
        try {
            HttpURLConnection httpURLConnection;
            block15: {
                zznv zznv3 = zznv2;
                zznx zznx2 = this;
                URL uRL = new URL(zznv3.uri.toString());
                byte[] byArray = zznv3.zzbfm;
                long l2 = zznv3.position;
                long l3 = zznv3.zzce;
                boolean bl = zznv3.isFlagSet(1);
                if (!zznx2.zzbfq) {
                    httpURLConnection = zznx2.zza(uRL, byArray, l2, l3, bl, true);
                } else {
                    int n2 = 0;
                    while (n2++ <= 20) {
                        HttpURLConnection httpURLConnection2 = zznx2.zza(uRL, byArray, l2, l3, bl, false);
                        int n3 = httpURLConnection2.getResponseCode();
                        if (n3 == 300 || n3 == 301 || n3 == 302 || n3 == 303 || byArray == null && (n3 == 307 || n3 == 308)) {
                            byArray = null;
                            String string2 = httpURLConnection2.getHeaderField("Location");
                            httpURLConnection2.disconnect();
                            String string3 = string2;
                            URL uRL2 = uRL;
                            if (string3 == null) {
                                throw new ProtocolException("Null location redirect");
                            }
                            URL uRL3 = new URL(uRL2, string3);
                            String string4 = uRL3.getProtocol();
                            if (!"https".equals(string4) && !"http".equals(string4)) {
                                String string5 = String.valueOf(string4);
                                throw new ProtocolException(string5.length() != 0 ? "Unsupported protocol redirect: ".concat(string5) : new String("Unsupported protocol redirect: "));
                            }
                            uRL = uRL3;
                            continue;
                        }
                        httpURLConnection = httpURLConnection2;
                        break block15;
                    }
                    int n4 = n2;
                    throw new NoRouteToHostException(new StringBuilder(31).append("Too many redirects: ").append(n4).toString());
                }
            }
            this.zzbfz = httpURLConnection;
        }
        catch (IOException iOException) {
            String string6 = String.valueOf(zznv2.uri.toString());
            throw new zzoa(string6.length() != 0 ? "Unable to connect to ".concat(string6) : new String("Unable to connect to "), iOException, zznv2, 1);
        }
        try {
            n = this.zzbfz.getResponseCode();
        }
        catch (IOException iOException) {
            this.zzip();
            String string7 = String.valueOf(zznv2.uri.toString());
            throw new zzoa(string7.length() != 0 ? "Unable to connect to ".concat(string7) : new String("Unable to connect to "), iOException, zznv2, 1);
        }
        if (n < 200 || n > 299) {
            Map<String, List<String>> map = this.zzbfz.getHeaderFields();
            this.zzip();
            zznz zznz2 = new zznz(n, map, zznv2);
            if (n == 416) {
                zznz2.initCause(new zznw(0));
            }
            throw zznz2;
        }
        this.zzbfz.getContentType();
        long l4 = this.zzbgc = n == 200 && zznv2.position != 0L ? zznv2.position : 0L;
        this.zzbgd = !zznv2.isFlagSet(1) ? (zznv2.zzce != -1L ? zznv2.zzce : ((l = zznx.zzc(this.zzbfz)) != -1L ? l - this.zzbgc : -1L)) : zznv2.zzce;
        try {
            this.zzbga = this.zzbfz.getInputStream();
        }
        catch (IOException iOException) {
            this.zzip();
            throw new zzoa(iOException, zznv2, 1);
        }
        this.zzbgb = true;
        if (this.zzbfx != null) {
            this.zzbfx.zza(this, zznv2);
        }
        return this.zzbgd;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws zzoa {
        try {
            int n3;
            int n4;
            int n5;
            byte[] byArray2;
            zznx zznx2 = this;
            if (zznx2.zzbge != zznx2.zzbgc) {
                byArray2 = zzbfp.getAndSet(null);
                if (byArray2 == null) {
                    byArray2 = new byte[4096];
                }
                while (zznx2.zzbge != zznx2.zzbgc) {
                    n5 = (int)Math.min(zznx2.zzbgc - zznx2.zzbge, (long)byArray2.length);
                    n4 = zznx2.zzbga.read(byArray2, 0, n5);
                    if (Thread.interrupted()) {
                        throw new InterruptedIOException();
                    }
                    if (n4 == -1) {
                        throw new EOFException();
                    }
                    zznx2.zzbge += (long)n4;
                    if (zznx2.zzbfx == null) continue;
                    zznx2.zzbfx.zzc(zznx2, n4);
                }
                zzbfp.set(byArray2);
            }
            n4 = n2;
            n5 = n;
            byArray2 = byArray;
            zznx2 = this;
            if (n4 == 0) {
                return 0;
            }
            if (zznx2.zzbgd != -1L) {
                long l = zznx2.zzbgd - zznx2.zzcf;
                if (l == 0L) {
                    return -1;
                }
                n4 = (int)Math.min((long)n4, l);
            }
            if ((n3 = zznx2.zzbga.read(byArray2, n5, n4)) == -1) {
                if (zznx2.zzbgd != -1L) {
                    throw new EOFException();
                }
                return -1;
            }
            zznx2.zzcf += (long)n3;
            if (zznx2.zzbfx != null) {
                zznx2.zzbfx.zzc(zznx2, n3);
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new zzoa(iOException, this.zzbfy, 2);
        }
    }

    @Override
    public final void close() throws zzoa {
        try {
            if (this.zzbga != null) {
                block14: {
                    Object object = this;
                    long l = ((zznx)object).zzbgd == -1L ? ((zznx)object).zzbgd : ((zznx)object).zzbgd - ((zznx)object).zzcf;
                    object = this.zzbfz;
                    if (zzov.SDK_INT == 19 || zzov.SDK_INT == 20) {
                        InputStream inputStream;
                        try {
                            inputStream = ((URLConnection)object).getInputStream();
                            if (l != -1L ? l <= 2048L : inputStream.read() == -1) break block14;
                        }
                        catch (Exception exception) {}
                        String string2 = inputStream.getClass().getName();
                        if (string2.equals("com.android.okhttp.internal.http.HttpTransport$ChunkedInputStream") || string2.equals("com.android.okhttp.internal.http.HttpTransport$FixedLengthInputStream")) {
                            Method method = inputStream.getClass().getSuperclass().getDeclaredMethod("unexpectedEndOfInput", new Class[0]);
                            method.setAccessible(true);
                            method.invoke((Object)inputStream, new Object[0]);
                        }
                    }
                }
                try {
                    this.zzbga.close();
                }
                catch (IOException iOException) {
                    throw new zzoa(iOException, this.zzbfy, 3);
                }
            }
            this.zzbga = null;
            this.zzip();
            if (this.zzbgb) {
                this.zzbgb = false;
                if (this.zzbfx != null) {
                    this.zzbfx.zze(this);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            this.zzbga = null;
            this.zzip();
            if (this.zzbgb) {
                this.zzbgb = false;
                if (this.zzbfx != null) {
                    this.zzbfx.zze(this);
                }
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final HttpURLConnection zza(URL uRL, byte[] byArray, long l, long l2, boolean bl, boolean bl2) throws IOException {
        Object object;
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setConnectTimeout(this.zzbfr);
        httpURLConnection.setReadTimeout(this.zzbfs);
        for (Map.Entry<String, String> entry : this.zzbfw.zzis().entrySet()) {
            httpURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (l != 0L || l2 != -1L) {
            object = new StringBuilder(27).append("bytes=").append(l).append("-").toString();
            if (l2 != -1L) {
                String string2 = String.valueOf(object);
                long l3 = l + l2 - 1L;
                object = new StringBuilder(20 + String.valueOf(string2).length()).append(string2).append(l3).toString();
            }
            httpURLConnection.setRequestProperty("Range", (String)object);
        }
        httpURLConnection.setRequestProperty("User-Agent", this.zzbft);
        if (!bl) {
            httpURLConnection.setRequestProperty("Accept-Encoding", "identity");
        }
        httpURLConnection.setInstanceFollowRedirects(bl2);
        httpURLConnection.setDoOutput(byArray != null);
        if (byArray != null) {
            httpURLConnection.setRequestMethod("POST");
            if (byArray.length != 0) {
                httpURLConnection.setFixedLengthStreamingMode(byArray.length);
                httpURLConnection.connect();
                object = httpURLConnection.getOutputStream();
                ((OutputStream)object).write(byArray);
                ((OutputStream)object).close();
                return httpURLConnection;
            }
        }
        httpURLConnection.connect();
        return httpURLConnection;
    }

    private static long zzc(HttpURLConnection httpURLConnection) {
        Matcher matcher;
        String string2;
        long l = -1L;
        String string3 = httpURLConnection.getHeaderField("Content-Length");
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            try {
                l = Long.parseLong(string3);
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)"DefaultHttpDataSource", (String)new StringBuilder(28 + String.valueOf(string3).length()).append("Unexpected Content-Length [").append(string3).append("]").toString());
            }
        }
        if (!TextUtils.isEmpty((CharSequence)(string2 = httpURLConnection.getHeaderField("Content-Range"))) && (matcher = zzbfo.matcher(string2)).find()) {
            try {
                long l2 = Long.parseLong(matcher.group(2)) - Long.parseLong(matcher.group(1)) + 1L;
                if (l < 0L) {
                    l = l2;
                } else if (l != l2) {
                    Log.w((String)"DefaultHttpDataSource", (String)new StringBuilder(26 + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Inconsistent headers [").append(string3).append("] [").append(string2).append("]").toString());
                    l = Math.max(l, l2);
                }
            }
            catch (NumberFormatException numberFormatException) {
                Log.e((String)"DefaultHttpDataSource", (String)new StringBuilder(27 + String.valueOf(string2).length()).append("Unexpected Content-Range [").append(string2).append("]").toString());
            }
        }
        return l;
    }

    private final void zzip() {
        if (this.zzbfz != null) {
            try {
                this.zzbfz.disconnect();
            }
            catch (Exception exception) {
                Log.e((String)"DefaultHttpDataSource", (String)"Unexpected error while disconnecting", (Throwable)exception);
            }
            this.zzbfz = null;
        }
    }
}

