/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.graphics.Rect;
import android.os.PowerManager;
import android.os.Process;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.zzq;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzabh;
import com.google.android.gms.internal.ads.zzawr;
import com.google.android.gms.internal.ads.zzbek;
import com.google.android.gms.internal.ads.zzqj;
import com.google.android.gms.internal.ads.zzqm;
import com.google.android.gms.internal.ads.zzqr;
import com.google.android.gms.internal.ads.zzqs;
import com.google.android.gms.internal.ads.zzqt;
import com.google.android.gms.internal.ads.zzvj;
import com.google.android.gms.internal.ads.zzzk;
import com.google.android.gms.internal.ads.zzzz;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import org.json.JSONException;
import org.json.JSONObject;

@ParametersAreNonnullByDefault
@TargetApi(value=14)
public final class zzqp
extends Thread {
    private boolean started = false;
    private boolean zzbqm = false;
    private boolean zzbqn = false;
    private final Object lock;
    private final zzqm zzbqo;
    private final int zzbqp;
    private final int zzbpm;
    private final int zzbqq;
    private final int zzbpo;
    private final int zzbqr;
    private final int zzbqs;
    private final int zzbqt;
    private final int zzbqu;
    private final String zzbqv;
    private final boolean zzbqw;
    private final boolean zzbpp;
    private final boolean zzbqx;

    public zzqp() {
        this(new zzqm());
    }

    @VisibleForTesting
    private zzqp(zzqm zzqm2) {
        this.zzbqo = zzqm2;
        this.lock = new Object();
        this.zzbpm = ((Long)zzabh.zzcwe.get()).intValue();
        this.zzbqq = ((Long)zzabh.zzcwb.get()).intValue();
        this.zzbpo = ((Long)zzabh.zzcwf.get()).intValue();
        this.zzbqr = ((Long)zzabh.zzcwd.get()).intValue();
        zzzk zzzk2 = zzzz.zzcke;
        this.zzbqs = (Integer)zzvj.zzpv().zzd(zzzk2);
        zzzk2 = zzzz.zzckf;
        this.zzbqt = (Integer)zzvj.zzpv().zzd(zzzk2);
        zzzk2 = zzzz.zzckg;
        this.zzbqu = (Integer)zzvj.zzpv().zzd(zzzk2);
        this.zzbqp = ((Long)zzabh.zzcwg.get()).intValue();
        zzzk2 = zzzz.zzcki;
        this.zzbqv = (String)zzvj.zzpv().zzd(zzzk2);
        zzzk2 = zzzz.zzckj;
        this.zzbqw = (Boolean)zzvj.zzpv().zzd(zzzk2);
        zzzk2 = zzzz.zzckk;
        this.zzbpp = (Boolean)zzvj.zzpv().zzd(zzzk2);
        zzzk2 = zzzz.zzckl;
        this.zzbqx = (Boolean)zzvj.zzpv().zzd(zzzk2);
        this.setName("ContentFetchTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzmh() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                zzawr.zzed((String)"Content hash thread already started, quiting...");
                return;
            }
            this.started = true;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        while (true) {
            Object object;
            try {
                if (zzqp.zzmi()) {
                    object = zzq.zzkz().getActivity();
                    if (object == null) {
                        zzawr.zzed((String)"ContentFetchThread: no activity. Sleeping.");
                        this.zzmk();
                    } else {
                        Activity activity = object;
                        zzqp zzqp2 = this;
                        if (activity != null) {
                            View view = null;
                            try {
                                if (activity.getWindow() != null && activity.getWindow().getDecorView() != null) {
                                    view = activity.getWindow().getDecorView().findViewById(0x1020002);
                                }
                            }
                            catch (Exception exception) {
                                zzq.zzla().zza(exception, "ContentFetchTask.extractContent");
                                zzawr.zzed((String)"Failed getting root view of activity. Content not extracted.");
                            }
                            if (view != null) {
                                boolean bl;
                                View view2 = view;
                                zzqp zzqp3 = zzqp2;
                                if (view2 == null) {
                                    bl = false;
                                } else {
                                    view2.post((Runnable)new zzqs(zzqp3, view2));
                                    bl = true;
                                }
                            }
                        }
                    }
                } else {
                    zzawr.zzed((String)"ContentFetchTask: sleeping");
                    this.zzmk();
                }
                Thread.sleep(this.zzbqp * 1000);
            }
            catch (InterruptedException interruptedException) {
                zzawr.zzc((String)"Error in ContentFetchTask", (Throwable)interruptedException);
            }
            catch (Exception exception) {
                zzawr.zzc((String)"Error in ContentFetchTask", (Throwable)exception);
                zzq.zzla().zza(exception, "ContentFetchTask.run");
            }
            object = this.lock;
            synchronized (object) {
                while (this.zzbqm) {
                    try {
                        zzawr.zzed((String)"ContentFetchTask: waiting");
                        this.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    @VisibleForTesting
    final void zzj(View view) {
        try {
            zzqj zzqj2 = new zzqj(this.zzbpm, this.zzbqq, this.zzbpo, this.zzbqr, this.zzbqs, this.zzbqt, this.zzbqu, this.zzbpp);
            Context context = zzq.zzkz().getContext();
            if (context != null && !TextUtils.isEmpty((CharSequence)this.zzbqv)) {
                zzzk zzzk2 = zzzz.zzckh;
                int n = context.getResources().getIdentifier((String)zzvj.zzpv().zzd(zzzk2), "id", context.getPackageName());
                String string2 = (String)view.getTag(n);
                if (string2 != null && string2.equals(this.zzbqv)) {
                    return;
                }
            }
            zzqt zzqt2 = this.zza(view, zzqj2);
            zzqj2.zzmf();
            if (zzqt2.zzbre == 0 && zzqt2.zzbrf == 0) {
                return;
            }
            if (zzqt2.zzbrf == 0 && zzqj2.zzmg() == 0) {
                return;
            }
            if (zzqt2.zzbrf == 0 && this.zzbqo.zza(zzqj2)) {
                return;
            }
            this.zzbqo.zzc(zzqj2);
            return;
        }
        catch (Exception exception) {
            zzawr.zzc((String)"Exception in fetchContentOnUIThread", (Throwable)exception);
            zzq.zzla().zza(exception, "ContentFetchTask.fetchContent");
            return;
        }
    }

    @VisibleForTesting
    private static boolean zzmi() {
        try {
            Context context = zzq.zzkz().getContext();
            if (context == null) {
                return false;
            }
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
            if (activityManager == null || keyguardManager == null) {
                return false;
            }
            List list = activityManager.getRunningAppProcesses();
            if (list == null) {
                return false;
            }
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                PowerManager powerManager;
                if (Process.myPid() != runningAppProcessInfo.pid) continue;
                if (runningAppProcessInfo.importance != 100 || keyguardManager.inKeyguardRestrictedInputMode() || !((powerManager = (PowerManager)context.getSystemService("power")) == null ? false : powerManager.isScreenOn())) break;
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            zzq.zzla().zza(throwable, "ContentFetchTask.isInForeground");
            return false;
        }
    }

    @VisibleForTesting
    private final zzqt zza(@Nullable View view, zzqj zzqj2) {
        if (view == null) {
            return new zzqt(this, 0, 0);
        }
        Rect rect = new Rect();
        boolean bl = view.getGlobalVisibleRect(rect);
        if (view instanceof TextView && !(view instanceof EditText)) {
            CharSequence charSequence = ((TextView)view).getText();
            if (!TextUtils.isEmpty((CharSequence)charSequence)) {
                String string2 = charSequence.toString();
                zzqj2.zzb(string2, bl, view.getX(), view.getY(), view.getWidth(), view.getHeight());
                return new zzqt(this, 1, 0);
            }
            return new zzqt(this, 0, 0);
        }
        if (view instanceof WebView && !(view instanceof zzbek)) {
            boolean bl2;
            zzqj zzqj3 = zzqj2;
            WebView webView = (WebView)view;
            zzqp zzqp2 = this;
            if (!PlatformVersion.isAtLeastKitKat()) {
                bl2 = false;
            } else {
                zzqj3.zzmd();
                webView.post((Runnable)new zzqr(zzqp2, zzqj3, webView, bl));
                bl2 = true;
            }
            if (bl2) {
                return new zzqt(this, 0, 1);
            }
            return new zzqt(this, 0, 0);
        }
        if (view instanceof ViewGroup) {
            ViewGroup viewGroup = (ViewGroup)view;
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                zzqt zzqt2 = this.zza(viewGroup.getChildAt(i), zzqj2);
                n += zzqt2.zzbre;
                n2 += zzqt2.zzbrf;
            }
            return new zzqt(this, n, n2);
        }
        return new zzqt(this, 0, 0);
    }

    @VisibleForTesting
    final void zza(zzqj zzqj2, WebView webView, String string2, boolean bl) {
        zzqj2.zzmc();
        try {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                String string3 = new JSONObject(string2).optString("text");
                if (!this.zzbqw && !TextUtils.isEmpty((CharSequence)webView.getTitle())) {
                    String string4 = webView.getTitle();
                    zzqj2.zza(new StringBuilder(1 + String.valueOf(string4).length() + String.valueOf(string3).length()).append(string4).append("\n").append(string3).toString(), bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                } else {
                    zzqj2.zza(string3, bl, webView.getX(), webView.getY(), webView.getWidth(), webView.getHeight());
                }
            }
            if (zzqj2.zzlx()) {
                this.zzbqo.zzb(zzqj2);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzawr.zzed((String)"Json string may be malformed.");
            return;
        }
        catch (Throwable throwable) {
            zzawr.zzb((String)"Failed to get webview content.", (Throwable)throwable);
            zzq.zzla().zza(throwable, "ContentFetchTask.processWebViewContent");
            return;
        }
    }

    public final zzqj zzmj() {
        return this.zzbqo.zzo(this.zzbqx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void wakeup() {
        Object object = this.lock;
        synchronized (object) {
            this.zzbqm = false;
            this.lock.notifyAll();
            zzawr.zzed((String)"ContentFetchThread: wakeup");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void zzmk() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = this.zzbqm = true;
            zzawr.zzed((String)new StringBuilder(42).append("ContentFetchThread: paused, mPause = ").append(bl).toString());
            return;
        }
    }

    public final boolean zzml() {
        return this.zzbqm;
    }
}

