/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util;

import android.os.Bundle;
import android.os.Parcelable;
import android.util.JsonReader;
import android.util.JsonToken;
import android.util.JsonWriter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.util.zzbi;
import com.google.android.gms.ads.internal.util.zzbj;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.internal.ads.zzdqh;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzbk {
    public static final zzbj<Map<String, ?>> zza;

    @NonNull
    public static List<String> zza(@Nullable JSONArray jSONArray, @Nullable List<String> arrayList) throws JSONException {
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        if (jSONArray != null) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                arrayList.add(jSONArray.getString(i));
            }
            return arrayList;
        }
        return arrayList;
    }

    public static List<String> zzb(JsonReader jsonReader) throws IllegalStateException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        jsonReader.beginArray();
        while (jsonReader.hasNext()) {
            arrayList.add(jsonReader.nextString());
        }
        jsonReader.endArray();
        return arrayList;
    }

    public static JSONObject zzc(JsonReader object) throws IllegalStateException, IOException, JSONException {
        Object object2 = new JSONObject();
        object.beginObject();
        while (object.hasNext()) {
            String string2 = object.nextName();
            Object object3 = object.peek();
            if (JsonToken.BEGIN_ARRAY.equals(object3)) {
                object2.put(string2, (Object)zzbk.zzd(object));
                continue;
            }
            if (JsonToken.BEGIN_OBJECT.equals(object3)) {
                object2.put(string2, (Object)zzbk.zzc(object));
                continue;
            }
            if (JsonToken.BOOLEAN.equals(object3)) {
                object2.put(string2, object.nextBoolean());
                continue;
            }
            if (JsonToken.NUMBER.equals(object3)) {
                object2.put(string2, object.nextDouble());
                continue;
            }
            if (JsonToken.STRING.equals(object3)) {
                object2.put(string2, (Object)object.nextString());
                continue;
            }
            object2 = String.valueOf(object3);
            string2 = String.valueOf(object2);
            int n = string2.length();
            object3 = new StringBuilder(n + 23);
            ((StringBuilder)object3).append("unexpected json token: ");
            ((StringBuilder)object3).append((String)object2);
            object = new IllegalStateException(((StringBuilder)object3).toString());
            throw object;
        }
        object.endObject();
        return object2;
    }

    public static JSONArray zzd(JsonReader object) throws IllegalStateException, IOException, JSONException {
        Object object2 = new JSONArray();
        object.beginArray();
        while (object.hasNext()) {
            Object object3 = object.peek();
            if (JsonToken.BEGIN_ARRAY.equals(object3)) {
                object2.put((Object)zzbk.zzd(object));
                continue;
            }
            if (JsonToken.BEGIN_OBJECT.equals(object3)) {
                object2.put((Object)zzbk.zzc(object));
                continue;
            }
            if (JsonToken.BOOLEAN.equals(object3)) {
                object2.put(object.nextBoolean());
                continue;
            }
            if (JsonToken.NUMBER.equals(object3)) {
                object2.put(object.nextDouble());
                continue;
            }
            if (JsonToken.STRING.equals(object3)) {
                object2.put((Object)object.nextString());
                continue;
            }
            object2 = String.valueOf(object3);
            object3 = String.valueOf(object2);
            int n = ((String)object3).length();
            StringBuilder stringBuilder = new StringBuilder(n + 23);
            stringBuilder.append("unexpected json token: ");
            stringBuilder.append((String)object2);
            object = new IllegalStateException(stringBuilder.toString());
            throw object;
        }
        object.endArray();
        return object2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zze(JsonWriter object, JSONObject object2) throws IOException {
        Object object3;
        CharSequence charSequence;
        try {
            object.beginObject();
            Iterator iterator = object2.keys();
            while (true) {
                boolean bl;
                if (!(bl = iterator.hasNext())) {
                    object.endObject();
                    return;
                }
                charSequence = (String)iterator.next();
                object3 = object2.get((String)charSequence);
                boolean bl2 = object3 instanceof String;
                if (bl2) {
                    object.name((String)charSequence).value((String)object3);
                    continue;
                }
                bl2 = object3 instanceof Number;
                if (bl2) {
                    object.name((String)charSequence).value((Number)object3);
                    continue;
                }
                bl2 = object3 instanceof Boolean;
                if (bl2) {
                    object.name((String)charSequence).value(((Boolean)object3).booleanValue());
                    continue;
                }
                bl2 = object3 instanceof JSONObject;
                if (bl2) {
                    zzbk.zze(object.name((String)charSequence), (JSONObject)object3);
                    continue;
                }
                bl2 = object3 instanceof JSONArray;
                if (!bl2) break;
                zzbk.zzf(object.name((String)charSequence), (JSONArray)object3);
            }
        }
        catch (JSONException jSONException) {
            object2 = new IOException(jSONException);
            throw object2;
        }
        {
            object2 = String.valueOf(object3);
            int n = String.valueOf(object2).length();
            charSequence = new StringBuilder(n += 23);
            ((StringBuilder)charSequence).append("unable to write field: ");
            ((StringBuilder)charSequence).append((String)object2);
            object = new JSONException(((StringBuilder)charSequence).toString());
            throw object;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zzf(JsonWriter object, JSONArray object2) throws IOException {
        try {
            Object object3;
            int n;
            block10: {
                int n2;
                object.beginArray();
                for (n = 0; n < (n2 = object2.length()); ++n) {
                    object3 = object2.get(n);
                    boolean bl = object3 instanceof String;
                    if (bl) {
                        object.value((String)object3);
                        continue;
                    }
                    bl = object3 instanceof Number;
                    if (bl) {
                        object.value((Number)object3);
                        continue;
                    }
                    bl = object3 instanceof Boolean;
                    if (bl) {
                        object.value(((Boolean)object3).booleanValue());
                        continue;
                    }
                    bl = object3 instanceof JSONObject;
                    if (bl) {
                        zzbk.zze(object, (JSONObject)object3);
                        continue;
                    }
                    bl = object3 instanceof JSONArray;
                    if (bl) {
                        zzbk.zzf(object, (JSONArray)object3);
                        continue;
                    }
                    break block10;
                }
                object.endArray();
                return;
            }
            object2 = String.valueOf(object3);
            n = String.valueOf(object2).length();
            object3 = new StringBuilder(n += 23);
            ((StringBuilder)object3).append("unable to write field: ");
            ((StringBuilder)object3).append((String)object2);
            object = new JSONException(((StringBuilder)object3).toString());
            throw object;
        }
        catch (JSONException jSONException) {
            object2 = new IOException(jSONException);
            throw object2;
        }
    }

    private static void zzl(JsonWriter jsonWriter, Object iterator) throws IOException {
        if (iterator == null) {
            jsonWriter.nullValue();
            return;
        }
        if (iterator instanceof Number) {
            jsonWriter.value((Number)((Object)iterator));
            return;
        }
        if (iterator instanceof Boolean) {
            jsonWriter.value(((Boolean)((Object)iterator)).booleanValue());
            return;
        }
        if (iterator instanceof String) {
            jsonWriter.value((String)((Object)iterator));
            return;
        }
        if (iterator instanceof zzdqh) {
            zzbk.zze(jsonWriter, ((zzdqh)((Object)iterator)).zzd);
            return;
        }
        if (iterator instanceof Map) {
            jsonWriter.beginObject();
            for (Map.Entry entry : ((Map)((Object)iterator)).entrySet()) {
                Object k = entry.getKey();
                if (!(k instanceof String)) continue;
                entry = entry.getValue();
                zzbk.zzl(jsonWriter.name((String)k), entry);
            }
            jsonWriter.endObject();
            return;
        }
        if (iterator instanceof List) {
            jsonWriter.beginArray();
            iterator = ((List)((Object)iterator)).iterator();
            while (iterator.hasNext()) {
                zzbk.zzl(jsonWriter, iterator.next());
            }
            jsonWriter.endArray();
            return;
        }
        jsonWriter.nullValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JSONObject zzg(JSONObject jSONObject, String string2) throws JSONException {
        try {
            JSONObject jSONObject2 = jSONObject.getJSONObject(string2);
            return jSONObject2;
        }
        catch (JSONException jSONException) {
            JSONObject jSONObject3 = new JSONObject();
            jSONObject.put(string2, (Object)jSONObject3);
            return jSONObject3;
        }
    }

    public static JSONObject zzh(JSONObject jSONObject, String ... stringArray) {
        if ((jSONObject = zzbk.zzm(jSONObject, stringArray)) == null) {
            return null;
        }
        return jSONObject.optJSONObject(stringArray[stringArray.length + -1]);
    }

    public static boolean zzi(boolean bl, JSONObject jSONObject, String ... stringArray) {
        JSONObject jSONObject2 = zzbk.zzm(jSONObject, stringArray);
        if (jSONObject2 == null) {
            return false;
        }
        return jSONObject2.optBoolean(stringArray[stringArray.length + -1], false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static Bundle zzj(JSONObject jSONObject) {
        if (jSONObject == null) {
            return null;
        }
        Iterator iterator = jSONObject.keys();
        Bundle bundle = new Bundle();
        while (true) {
            String[] stringArray;
            int n;
            JSONArray jSONArray;
            String string2;
            block23: {
                Bundle[] bundleArray;
                if (!iterator.hasNext()) {
                    return bundle;
                }
                string2 = (String)iterator.next();
                Object object = jSONObject.opt(string2);
                if (object == null) continue;
                if (object instanceof Boolean) {
                    bundle.putBoolean(string2, ((Boolean)object).booleanValue());
                    continue;
                }
                if (object instanceof Double) {
                    bundle.putDouble(string2, ((Double)object).doubleValue());
                    continue;
                }
                if (object instanceof Integer) {
                    bundle.putInt(string2, ((Integer)object).intValue());
                    continue;
                }
                if (object instanceof Long) {
                    bundle.putLong(string2, ((Long)object).longValue());
                    continue;
                }
                if (object instanceof String) {
                    bundle.putString(string2, (String)object);
                    continue;
                }
                if (object instanceof JSONArray) {
                    jSONArray = (JSONArray)object;
                    if (jSONArray.length() == 0) continue;
                    n = jSONArray.length();
                    object = null;
                } else {
                    if (object instanceof JSONObject) {
                        bundle.putBundle(string2, zzbk.zzj((JSONObject)object));
                        continue;
                    }
                    object = String.valueOf(string2);
                    String string3 = "Unsupported type for key:";
                    object = ((String)object).length() != 0 ? string3.concat((String)object) : new String(string3);
                    zze.zzi((String)object);
                    continue;
                }
                for (int i = 0; object == null && i < n; ++i) {
                    object = !jSONArray.isNull(i) ? jSONArray.opt(i) : null;
                }
                if (object == null) {
                    object = String.valueOf(string2);
                    String string4 = "Expected JSONArray with at least 1 non-null element for key:";
                    object = ((String)object).length() != 0 ? string4.concat((String)object) : new String(string4);
                    zze.zzi((String)object);
                    continue;
                }
                if (object instanceof JSONObject) {
                    bundleArray = new Bundle[n];
                } else {
                    if (object instanceof Number) {
                        double[] dArray = new double[jSONArray.length()];
                        for (int i = 0; i < n; ++i) {
                            dArray[i] = jSONArray.optDouble(i);
                        }
                        bundle.putDoubleArray(string2, dArray);
                        continue;
                    }
                    if (object instanceof CharSequence) {
                        stringArray = new String[n];
                        break block23;
                    } else {
                        if (object instanceof Boolean) {
                            boolean[] blArray = new boolean[n];
                            for (int i = 0; i < n; ++i) {
                                blArray[i] = jSONArray.optBoolean(i);
                            }
                            bundle.putBooleanArray(string2, blArray);
                            continue;
                        }
                        Object[] objectArray = new Object[]{object.getClass().getCanonicalName(), string2};
                        zze.zzi((String)String.format("JSONArray with unsupported type %s for key:%s", objectArray));
                        continue;
                    }
                }
                for (int i = 0; i < n; ++i) {
                    Bundle bundle2 = !jSONArray.isNull(i) ? zzbk.zzj(jSONArray.optJSONObject(i)) : null;
                    bundleArray[i] = bundle2;
                }
                bundle.putParcelableArray(string2, (Parcelable[])bundleArray);
                continue;
            }
            for (int i = 0; i < n; ++i) {
                String string5 = !jSONArray.isNull(i) ? jSONArray.optString(i) : null;
                stringArray[i] = string5;
            }
            bundle.putStringArray(string2, stringArray);
        }
    }

    private static JSONObject zzm(JSONObject jSONObject, String[] stringArray) {
        for (int i = 0; i < stringArray.length + -1; ++i) {
            if (jSONObject == null) {
                return null;
            }
            jSONObject = jSONObject.optJSONObject(stringArray[i]);
        }
        return jSONObject;
    }

    static {
        zzbi zzbi2;
        zza = zzbi2 = new zzbi();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String zzk(zzdqh object) {
        if (object == null) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        try {
            JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);
            zzbk.zzl(jsonWriter, object);
            jsonWriter.close();
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            zze.zzg((String)"Error when writing JSON.", (Throwable)iOException);
            return null;
        }
    }
}

