/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.PowerManager;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.util.zzbp;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzaeh;
import com.google.android.gms.internal.ads.zzaep;
import com.google.android.gms.internal.ads.zzeax;
import com.google.android.gms.internal.ads.zzre;
import com.google.android.gms.internal.ads.zzrf;
import com.google.android.gms.internal.ads.zzrg;
import com.google.android.gms.internal.ads.zzrh;
import com.google.android.gms.internal.ads.zzru;
import com.google.android.gms.internal.ads.zzzy;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

@TargetApi(value=14)
public final class zzri
implements View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
Application.ActivityLifecycleCallbacks {
    private static final long zzc;
    private final Context zzd;
    private Application zze;
    private final WindowManager zzf;
    private final PowerManager zzg;
    private final KeyguardManager zzh;
    @Nullable
    @VisibleForTesting
    BroadcastReceiver zza;
    private WeakReference<ViewTreeObserver> zzi;
    final WeakReference<View> zzb;
    private zzru zzj;
    private final zzbp zzk;
    private boolean zzl;
    private int zzm;
    private final HashSet<zzrh> zzn;
    private final DisplayMetrics zzo;
    private final Rect zzp;

    /*
     * Enabled aggressive block sorting
     */
    public zzri(Context object, View view) {
        Context context = new zzbp(zzc);
        this.zzk = context;
        this.zzl = false;
        this.zzm = -1;
        context = new HashSet();
        this.zzn = context;
        this.zzd = object.getApplicationContext();
        this.zzf = (WindowManager)object.getSystemService("window");
        this.zzg = (PowerManager)this.zzd.getSystemService("power");
        this.zzh = (KeyguardManager)object.getSystemService("keyguard");
        context = this.zzd;
        if (context instanceof Application) {
            zzru zzru2;
            context = (Application)context;
            this.zze = context;
            this.zzj = zzru2 = new zzru((Application)context, this);
        }
        this.zzo = object.getResources().getDisplayMetrics();
        object = new Rect();
        this.zzp = object;
        this.zzp.right = this.zzf.getDefaultDisplay().getWidth();
        this.zzp.bottom = this.zzf.getDefaultDisplay().getHeight();
        object = this.zzb;
        object = object != null ? (View)((Reference)object).get() : null;
        if (object != null) {
            object.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzm((View)object);
        }
        this.zzb = object = new WeakReference(view);
        if (view == null) {
            return;
        }
        if (zzs.zze().zzg(view)) {
            this.zzl(view);
        }
        view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
    }

    public final void zza(zzrh zzrh2) {
        this.zzn.add(zzrh2);
        this.zzj(3);
    }

    public final void zzb(zzrh zzrh2) {
        this.zzn.remove(zzrh2);
    }

    private final void zzh() {
        zzeax zzeax2 = zzr.zza;
        zzre zzre2 = new zzre(this);
        zzeax2.post((Runnable)zzre2);
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzm = -1;
        this.zzl(view);
        this.zzj(3);
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzm = -1;
        this.zzj(3);
        this.zzh();
        this.zzm(view);
    }

    private final void zzi(Activity activity, int n) {
        if (this.zzb == null) {
            return;
        }
        if ((activity = activity.getWindow()) == null) {
            return;
        }
        activity = activity.peekDecorView();
        View view = (View)this.zzb.get();
        if (view != null && activity != null && view.getRootView() == activity.getRootView()) {
            this.zzm = n;
            return;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zzi(activity, 0);
        this.zzj(3);
        this.zzh();
    }

    public final void onActivityStarted(Activity activity) {
        this.zzi(activity, 0);
        this.zzj(3);
        this.zzh();
    }

    public final void onActivityResumed(Activity activity) {
        this.zzi(activity, 0);
        this.zzj(3);
        this.zzh();
    }

    public final void onActivityPaused(Activity activity) {
        this.zzi(activity, 4);
        this.zzj(3);
        this.zzh();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzj(3);
        this.zzh();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzj(3);
        this.zzh();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzj(3);
        this.zzh();
    }

    public final void onGlobalLayout() {
        this.zzj(2);
        this.zzh();
    }

    public final void onScrollChanged() {
        this.zzj(1);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void zzj(int var1_1) {
        block21: {
            if (this.zzn.size() == 0) {
                return;
            }
            var2_3 = this.zzb;
            if (var2_3 == null) {
                return;
            }
            var7_5 /* !! */  = (View)var2_3.get();
            var8_6 = new Rect();
            var9_7 = new Rect();
            var10_8 = new Rect();
            var11_9 = new Rect();
            var2_3 = (WeakReference<View>)new int[2];
            var3_10 = new int[2];
            if (var7_5 /* !! */  == null) break block21;
            var4_13 = var7_5 /* !! */ .getGlobalVisibleRect(var9_7);
            var5_14 = var7_5 /* !! */ .getLocalVisibleRect(var10_8);
            var7_5 /* !! */ .getHitRect(var11_9);
            try {
                var7_5 /* !! */ .getLocationOnScreen((int[])var2_3);
                var7_5 /* !! */ .getLocationInWindow(var3_10);
            }
            catch (Exception var3_12) {
                com.google.android.gms.ads.internal.util.zze.zzg((String)"Failure getting view location.", (Throwable)var3_12);
                ** continue;
            }
lbl20:
            // 2 sources

            while (true) {
                var8_6.left = (int)var2_3[0];
                var8_6.top = (int)var2_3[1];
                var8_6.right = var8_6.left + var7_5 /* !! */ .getWidth();
                var8_6.bottom = var8_6.top + var7_5 /* !! */ .getHeight();
                var2_3 = var7_5 /* !! */ ;
                var3_11 = var4_13;
                var4_13 = var5_14;
lbl28:
                // 2 sources

                while (true) {
                    block22: {
                        var5_15 /* !! */  = zzaep.zzaT;
                        if (!((Boolean)zzzy.zze().zzb(var5_15 /* !! */ )).booleanValue() || var2_3 == null) break block22;
                        var6_17 = new ArrayList<Rect>();
                        var5_15 /* !! */  = var2_3.getParent();
                        ** while (var12_19 = var5_15 /* !! */  instanceof View)
lbl-1000:
                        // 1 sources

                        {
                            var12_20 = (View)var5_15 /* !! */ ;
                            var13_22 = new Rect();
                            var14_23 = var12_20.isScrollContainer();
                            if (!var14_23) ** GOTO lbl46
                            var12_21 = var12_20.getGlobalVisibleRect(var13_22);
                            if (!var12_21) ** GOTO lbl46
                            var6_17.add(this.zzc(var13_22));
lbl46:
                            // 3 sources

                            var5_15 /* !! */  = var5_15 /* !! */ .getParent();
                            continue;
                        }
lbl48:
                        // 1 sources

                        var5_15 /* !! */  = var6_17;
lbl49:
                        // 3 sources

                        while (true) {
                            block23: {
                                if (var2_3 == null) break block23;
                                var6_18 = var2_3.getWindowVisibility();
lbl52:
                                // 2 sources

                                while (true) {
                                    block24: {
                                        block25: {
                                            block26: {
                                                block27: {
                                                    block28: {
                                                        var12_19 = this.zzm;
                                                        if (var12_19 != -1 != 0) {
                                                            var6_18 = var12_19;
                                                        }
                                                        if (var7_5 /* !! */  == null) break block24;
                                                        zzs.zzc();
                                                        if (!zzr.zzU((View)var2_3, this.zzg, this.zzh)) break block25;
                                                        if (!var3_11) break block26;
                                                        if (!var4_13) break block27;
                                                        if (var6_18) break block28;
                                                        var6_18 = true;
lbl64:
                                                        // 6 sources

                                                        while (true) {
                                                            block29: {
                                                                block30: {
                                                                    block31: {
                                                                        if (var1_1 == 1 && !this.zzk.zza() && var6_18 == this.zzl) break block29;
                                                                        if (!var6_18 && !this.zzl && var1_1 == 1) break block30;
                                                                        var15_24 = zzs.zzj().elapsedRealtime();
                                                                        var12_19 = this.zzg.isScreenOn();
                                                                        if (var2_3 == null) break block31;
                                                                        if (zzs.zze().zzg((View)var2_3)) {
                                                                            var1_1 = 1;
lbl72:
                                                                            // 3 sources

                                                                            while (true) {
                                                                                if (var2_3 != null) {
                                                                                    var2_4 = var2_3.getWindowVisibility();
lbl75:
                                                                                    // 2 sources

                                                                                    while (true) {
                                                                                        var7_5 /* !! */  = new zzrg(var15_24, var12_19, (boolean)var1_1, var2_4, this.zzc(this.zzp), this.zzc(var8_6), this.zzc(var9_7), var3_11, this.zzc(var10_8), var4_13, this.zzc(var11_9), this.zzo.density, var6_18, (List<Rect>)var5_15 /* !! */ );
                                                                                        var1_2 = this.zzn.iterator();
                                                                                        while (var1_2.hasNext()) {
                                                                                            var1_2.next().zzc((zzrg)var7_5 /* !! */ );
                                                                                        }
                                                                                        this.zzl = var6_18;
                                                                                        return;
                                                                                    }
                                                                                }
                                                                                var2_4 = 8;
                                                                                ** continue;
                                                                                break;
                                                                            }
                                                                        }
                                                                        var1_1 = 0;
                                                                        ** GOTO lbl72
                                                                    }
                                                                    var1_1 = 0;
                                                                    ** continue;
                                                                }
                                                                return;
                                                            }
                                                            return;
                                                        }
                                                    }
                                                    var6_18 = false;
                                                    ** GOTO lbl64
                                                }
                                                var6_18 = false;
                                                ** GOTO lbl64
                                            }
                                            var6_18 = false;
                                            ** GOTO lbl64
                                        }
                                        var6_18 = false;
                                        ** GOTO lbl64
                                    }
                                    var6_18 = false;
                                    ** continue;
                                    break;
                                }
                            }
                            var6_18 = 8 != 0;
                            ** continue;
                            break;
                        }
                    }
                    var5_15 /* !! */  = Collections.emptyList();
                    ** GOTO lbl49
                    break;
                }
                break;
            }
        }
        var2_3 = null;
        var3_11 = false;
        var4_13 = false;
        ** while (true)
        catch (Exception var5_16) {
            zzs.zzg().zzg(var5_16, "PositionWatcher.getParentScrollViewRects");
            var5_15 /* !! */  = Collections.emptyList();
            ** continue;
        }
    }

    final Rect zzc(Rect rect) {
        Rect rect2 = new Rect(this.zzk(rect.left), this.zzk(rect.top), this.zzk(rect.right), this.zzk(rect.bottom));
        return rect2;
    }

    private final int zzk(int n) {
        return (int)((float)n / this.zzo.density);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void zzl(View view) {
        if ((view = view.getViewTreeObserver()).isAlive()) {
            WeakReference<View> weakReference = new WeakReference<View>(view);
            this.zzi = weakReference;
            view.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            view.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        if (this.zza == null) {
            view = new IntentFilter();
            view.addAction("android.intent.action.SCREEN_ON");
            view.addAction("android.intent.action.SCREEN_OFF");
            view.addAction("android.intent.action.USER_PRESENT");
            zzrf zzrf2 = new zzrf(this);
            this.zza = zzrf2;
            zzs.zzx().zzb(this.zzd, this.zza, (IntentFilter)view);
        }
        if ((view = this.zze) == null) return;
        try {
            view.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private final void zzm(View view) {
        try {
            ViewTreeObserver viewTreeObserver = this.zzi;
            if (viewTreeObserver != null) {
                boolean bl;
                if ((viewTreeObserver = (ViewTreeObserver)viewTreeObserver.get()) != null && (bl = viewTreeObserver.isAlive())) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzi = null;
            }
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Error while unregistering listeners from the last ViewTreeObserver.", (Throwable)exception);
        }
        try {
            view = view.getViewTreeObserver();
            boolean bl = view.isAlive();
            if (bl) {
                view.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                view.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Error while unregistering listeners from the ViewTreeObserver.", (Throwable)exception);
        }
        if (this.zza != null) {
            try {
                zzs.zzx().zzc(this.zzd, this.zza);
            }
            catch (IllegalStateException illegalStateException) {
                com.google.android.gms.ads.internal.util.zze.zzg((String)"Failed trying to unregister the receiver", (Throwable)illegalStateException);
            }
            catch (Exception exception) {
                zzs.zzg().zzg(exception, "ActiveViewUnit.stopScreenStatusMonitoring");
            }
            this.zza = null;
        }
        if ((view = this.zze) == null) return;
        try {
            view.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
            return;
        }
        catch (Exception exception) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Error registering activity lifecycle callbacks.", (Throwable)exception);
            return;
        }
    }

    public final void zzd(long l) {
        this.zzk.zzb(l);
    }

    public final void zze() {
        this.zzk.zzb(zzc);
    }

    final /* synthetic */ void zzf() {
        this.zzj(3);
    }

    static /* synthetic */ void zzg(zzri zzri2, int n) {
        zzri2.zzj(3);
    }

    static {
        zzaeh zzaeh2 = zzaep.zzaQ;
        zzc = (Long)zzzy.zze().zzb(zzaeh2);
    }
}

