/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.internal.util;

import android.annotation.TargetApi;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.provider.Settings;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.text.TextUtils;
import android.webkit.WebSettings;
import com.google.android.gms.ads.internal.util.zzac;
import com.google.android.gms.ads.internal.util.zzcc;
import com.google.android.gms.ads.internal.util.zzcd;
import com.google.android.gms.ads.internal.util.zzce;
import com.google.android.gms.ads.internal.util.zzcf;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.common.GooglePlayServicesUtilLight;
import com.google.android.gms.common.util.ClientLibraryUtils;
import com.google.android.gms.common.util.SharedPreferencesUtils;
import java.util.concurrent.Callable;

@TargetApi(value=17)
public class zzu
extends zzac {
    public zzu() {
        super(null);
    }

    @Override
    public final boolean zza(Context context, WebSettings webSettings) {
        super.zza(context, webSettings);
        webSettings.setMediaPlaybackRequiresUserGesture(false);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final String zzb(Context context) {
        Object object;
        zzcf zzcf2 = zzcf.zza();
        if (!TextUtils.isEmpty((CharSequence)zzcf2.zza)) {
            return zzcf2.zza;
        }
        if (ClientLibraryUtils.isPackageSide()) {
            object = new zzcd(zzcf2, context);
            object = (String)zzcc.zza((Context)context, (Callable)object);
        } else {
            object = GooglePlayServicesUtilLight.getRemoteContext((Context)context);
            zzce zzce2 = new zzce(zzcf2, (Context)object, context);
            object = (String)zzcc.zza((Context)context, (Callable)zzce2);
        }
        zzcf2.zza = object;
        return zzcf2.zza;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final void zzc(Context context) {
        block5: {
            String string2;
            block7: {
                block6: {
                    zzcf zzcf2 = zzcf.zza();
                    zze.zza("Updating user agent.");
                    string2 = WebSettings.getDefaultUserAgent((Context)context);
                    if (string2.equals(zzcf2.zza)) break block5;
                    zzu zzu2 = GooglePlayServicesUtilLight.getRemoteContext((Context)context);
                    if (ClientLibraryUtils.isPackageSide()) break block6;
                    if (zzu2 != null) break block7;
                    zzu2 = null;
                }
                String string3 = WebSettings.getDefaultUserAgent((Context)context);
                string3 = context.getSharedPreferences("admob_user_agent", 0).edit().putString("user_agent", string3);
                if (zzu2 == null) {
                    string3.apply();
                } else {
                    SharedPreferencesUtils.publishWorldReadableSharedPreferences((Context)context, (SharedPreferences.Editor)string3, (String)"admob_user_agent");
                }
            }
            zzcf2.zza = string2;
        }
        zze.zza("User agent is updated.");
    }

    @Override
    public final Drawable zzd(Context context, Bitmap bitmap, boolean bl, float f) {
        zzu zzu2;
        if (!bl || f <= 0.0f || f > 25.0f) {
            zzu2 = new BitmapDrawable(context.getResources(), bitmap);
            return zzu2;
        }
        try {
            zzu2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (boolean)false);
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)zzu2);
            RenderScript renderScript = RenderScript.create((Context)context);
            ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
            zzu2 = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)zzu2);
            renderScript = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)bitmap2);
            scriptIntrinsicBlur.setRadius(f);
            scriptIntrinsicBlur.setInput((Allocation)zzu2);
            scriptIntrinsicBlur.forEach((Allocation)renderScript);
            renderScript.copyTo(bitmap2);
            zzu2 = new BitmapDrawable(context.getResources(), bitmap2);
            return zzu2;
        }
        catch (RuntimeException runtimeException) {
            zzu2 = new BitmapDrawable(context.getResources(), bitmap);
            return zzu2;
        }
    }

    @Override
    public final int zze(ContentResolver contentResolver) {
        return Settings.Global.getInt((ContentResolver)contentResolver, (String)"wifi_on", (int)0);
    }

    @Override
    public final int zzf(ContentResolver contentResolver) {
        return Settings.Global.getInt((ContentResolver)contentResolver, (String)"airplane_mode_on", (int)0);
    }
}

