/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.annotation.TargetApi;
import android.media.MediaCodecInfo;
import android.util.Log;
import android.util.Pair;
import com.google.android.gms.internal.ads.zzarj;
import com.google.android.gms.internal.ads.zzauw;

@TargetApi(value=16)
public final class zzaqy {
    public final String zza;
    public final boolean zzb;
    public final boolean zzc;
    public final boolean zzd;
    private final String zze;
    private final MediaCodecInfo.CodecCapabilities zzf;

    public static zzaqy zza(String object) {
        object = new zzaqy("OMX.google.raw.decoder", null, null, false, false);
        return object;
    }

    public static zzaqy zzb(String string2, String string3, MediaCodecInfo.CodecCapabilities codecCapabilities, boolean bl, boolean bl2) {
        zzaqy zzaqy2 = new zzaqy(string2, string3, codecCapabilities, bl, bl2);
        return zzaqy2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private zzaqy(String string2, String string3, MediaCodecInfo.CodecCapabilities codecCapabilities, boolean bl, boolean bl2) {
        if (string2 == null) {
            throw null;
        }
        this.zza = string2;
        this.zze = string3;
        this.zzf = codecCapabilities;
        boolean bl3 = !bl ? (codecCapabilities != null ? (zzauw.zza >= 19 ? codecCapabilities.isFeatureSupported("adaptive-playback") : false) : false) : false;
        this.zzb = bl3;
        bl3 = codecCapabilities != null ? (zzauw.zza >= 21 ? codecCapabilities.isFeatureSupported("tunneled-playback") : false) : false;
        this.zzc = bl3;
        bl3 = !bl2 ? (codecCapabilities != null ? (zzauw.zza >= 21 ? codecCapabilities.isFeatureSupported("secure-playback") : false) : false) : true;
        this.zzd = bl3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final MediaCodecInfo.CodecProfileLevel[] zzc() {
        MediaCodecInfo.CodecCapabilities codecCapabilities = this.zzf;
        if (codecCapabilities == null) return new MediaCodecInfo.CodecProfileLevel[0];
        if (codecCapabilities.profileLevels != null) return this.zzf.profileLevels;
        return new MediaCodecInfo.CodecProfileLevel[0];
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean zzd(String string2) {
        if (string2 == null) return true;
        if (this.zze == null) {
            return true;
        }
        String string3 = string2.trim();
        if (string3.startsWith("avc1") || string3.startsWith("avc3")) {
            string3 = "video/avc";
        } else if (string3.startsWith("hev1") || string3.startsWith("hvc1")) {
            string3 = "video/hevc";
        } else if (string3.startsWith("vp9")) {
            string3 = "video/x-vnd.on2.vp9";
        } else if (string3.startsWith("vp8")) {
            string3 = "video/x-vnd.on2.vp8";
        } else if (string3.startsWith("mp4a")) {
            string3 = "audio/mp4a-latm";
        } else if (string3.startsWith("ac-3") || string3.startsWith("dac3")) {
            string3 = "audio/ac3";
        } else if (string3.startsWith("ec-3") || string3.startsWith("dec3")) {
            string3 = "audio/eac3";
        } else if (string3.startsWith("dtsc") || string3.startsWith("dtse")) {
            string3 = "audio/vnd.dts";
        } else if (string3.startsWith("dtsh") || string3.startsWith("dtsl")) {
            string3 = "audio/vnd.dts.hd";
        } else if (string3.startsWith("opus")) {
            string3 = "audio/opus";
        } else {
            if (!string3.startsWith("vorbis")) return true;
            string3 = "audio/vorbis";
        }
        if (string3 == null) {
            return true;
        }
        if (!this.zze.equals(string3)) {
            int n = string2.length();
            int n2 = string3.length();
            StringBuilder stringBuilder = new StringBuilder(n + 13 + n2);
            stringBuilder.append("codec.mime ");
            stringBuilder.append(string2);
            stringBuilder.append(", ");
            stringBuilder.append(string3);
            this.zzh(stringBuilder.toString());
            return false;
        }
        Pair<Integer, Integer> pair = zzarj.zzd(string2);
        if (pair == null) {
            return true;
        }
        Object object = this.zzc();
        int n = ((MediaCodecInfo.CodecProfileLevel[])object).length;
        int n3 = 0;
        while (true) {
            if (n3 >= n) {
                n3 = string2.length();
                int n4 = string3.length();
                object = new StringBuilder(n3 + 22 + n4);
                ((StringBuilder)object).append("codec.profileLevel, ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(", ");
                ((StringBuilder)object).append(string3);
                this.zzh(((StringBuilder)object).toString());
                return false;
            }
            MediaCodecInfo.CodecProfileLevel codecProfileLevel = object[n3];
            if (codecProfileLevel.profile == (Integer)pair.first && codecProfileLevel.level >= (Integer)pair.second) {
                return true;
            }
            ++n3;
        }
    }

    @TargetApi(value=21)
    public final boolean zze(int n, int n2, double d) {
        Object object = ((zzaqy)((Object)string4)).zzf;
        if (object == null) {
            ((zzaqy)((Object)string4)).zzh("sizeAndRate.caps");
            return false;
        }
        if ((object = object.getVideoCapabilities()) == null) {
            ((zzaqy)((Object)string4)).zzh("sizeAndRate.vCaps");
            return false;
        }
        if (!zzaqy.zzi((MediaCodecInfo.VideoCapabilities)object, n, n2, d)) {
            if (n >= n2 || !zzaqy.zzi((MediaCodecInfo.VideoCapabilities)object, n2, n, d)) {
                object = new StringBuilder(69);
                ((StringBuilder)object).append("sizeAndRate.support, ");
                ((StringBuilder)object).append(n);
                ((StringBuilder)object).append("x");
                ((StringBuilder)object).append(n2);
                ((StringBuilder)object).append("x");
                ((StringBuilder)object).append(d);
                ((zzaqy)((Object)string4)).zzh(((StringBuilder)object).toString());
                return false;
            }
            object = new StringBuilder(69);
            ((StringBuilder)object).append("sizeAndRate.rotated, ");
            ((StringBuilder)object).append(n);
            ((StringBuilder)object).append("x");
            ((StringBuilder)object).append(n2);
            ((StringBuilder)object).append("x");
            ((StringBuilder)object).append(d);
            String string2 = ((StringBuilder)object).toString();
            String string3 = ((zzaqy)((Object)string4)).zza;
            String string4 = ((zzaqy)((Object)string4)).zze;
            object = zzauw.zze;
            String string5 = String.valueOf(string2);
            int n3 = string5.length();
            String string6 = String.valueOf(string3);
            int n4 = string6.length();
            String string7 = String.valueOf(string4);
            int n5 = string7.length();
            String string8 = String.valueOf(object);
            int n6 = string8.length();
            StringBuilder stringBuilder = new StringBuilder(n3 + 25 + n4 + n5 + n6);
            stringBuilder.append("AssumedSupport [");
            stringBuilder.append(string2);
            stringBuilder.append("] [");
            stringBuilder.append(string3);
            stringBuilder.append(", ");
            stringBuilder.append(string4);
            stringBuilder.append("] [");
            stringBuilder.append((String)object);
            stringBuilder.append("]");
            Log.d((String)"MediaCodecInfo", (String)stringBuilder.toString());
        }
        return true;
    }

    @TargetApi(value=21)
    public final boolean zzf(int n) {
        Object object = this.zzf;
        if (object == null) {
            this.zzh("sampleRate.caps");
            return false;
        }
        if ((object = object.getAudioCapabilities()) == null) {
            this.zzh("sampleRate.aCaps");
            return false;
        }
        if (!object.isSampleRateSupported(n)) {
            object = new StringBuilder(31);
            ((StringBuilder)object).append("sampleRate.support, ");
            ((StringBuilder)object).append(n);
            this.zzh(((StringBuilder)object).toString());
            return false;
        }
        return true;
    }

    @TargetApi(value=21)
    public final boolean zzg(int n) {
        Object object = this.zzf;
        if (object == null) {
            this.zzh("channelCount.caps");
            return false;
        }
        if ((object = object.getAudioCapabilities()) == null) {
            this.zzh("channelCount.aCaps");
            return false;
        }
        if (object.getMaxInputChannelCount() < n) {
            object = new StringBuilder(33);
            ((StringBuilder)object).append("channelCount.support, ");
            ((StringBuilder)object).append(n);
            this.zzh(((StringBuilder)object).toString());
            return false;
        }
        return true;
    }

    private final void zzh(String string2) {
        String string3 = ((zzaqy)((Object)string4)).zza;
        String string4 = ((zzaqy)((Object)string4)).zze;
        String string5 = zzauw.zze;
        String string6 = String.valueOf(string2);
        int n = string6.length();
        String string7 = String.valueOf(string3);
        int n2 = string7.length();
        String string8 = String.valueOf(string4);
        int n3 = string8.length();
        String string9 = String.valueOf(string5);
        int n4 = string9.length();
        StringBuilder stringBuilder = new StringBuilder(n + 20 + n2 + n3 + n4);
        stringBuilder.append("NoSupport [");
        stringBuilder.append(string2);
        stringBuilder.append("] [");
        stringBuilder.append(string3);
        stringBuilder.append(", ");
        stringBuilder.append(string4);
        stringBuilder.append("] [");
        stringBuilder.append(string5);
        stringBuilder.append("]");
        Log.d((String)"MediaCodecInfo", (String)stringBuilder.toString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @TargetApi(value=21)
    private static boolean zzi(MediaCodecInfo.VideoCapabilities videoCapabilities, int n, int n2, double d) {
        if (d == -1.0) return videoCapabilities.isSizeSupported(n, n2);
        if (!(d <= 0.0)) return videoCapabilities.areSizeAndRateSupported(n, n2, d);
        return videoCapabilities.isSizeSupported(n, n2);
    }
}

