/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzr;
import com.google.android.gms.ads.internal.zzs;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbgu;
import com.google.android.gms.internal.ads.zzblf;
import com.google.android.gms.internal.ads.zzblt;
import com.google.android.gms.internal.ads.zzbro;
import com.google.android.gms.internal.ads.zzbrs;
import com.google.android.gms.internal.ads.zzchf;
import com.google.android.gms.internal.ads.zzcww;
import com.google.android.gms.internal.ads.zzdlx;
import com.google.android.gms.internal.ads.zzdmc;
import com.google.android.gms.internal.ads.zzdpw;
import com.google.android.gms.internal.ads.zzdpx;
import com.google.android.gms.internal.ads.zzfjz;
import java.util.Collections;

public final class zzdpy
extends zzbro
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzblf {
    private View zza;
    private zzbgu zzb;
    private zzdlx zzc;
    private boolean zzd;
    private boolean zze;

    public zzdpy(zzdlx zzdlx2, zzdmc zzdmc2) {
        this.zza = zzdmc2.zzH();
        this.zzb = zzdmc2.zzw();
        this.zzc = zzdlx2;
        this.zzd = false;
        this.zze = false;
        if (zzdmc2.zzR() != null) {
            zzdmc2.zzR().zzaw(this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzd(IObjectWrapper object, zzbrs zzbrs2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdpy)object2).zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Instream ad can not be shown after destroy().");
            zzdpy.zzi(zzbrs2, 2);
            return;
        }
        View view = ((zzdpy)object2).zza;
        if (view == null || ((zzdpy)object2).zzb == null) {
            Object object2 = view == null ? "can not get video view." : "can not get video controller.";
            object = "Instream internal error: ";
            object2 = ((String)object2).length() != 0 ? ((String)object).concat((String)object2) : new String((String)object);
            com.google.android.gms.ads.internal.util.zze.zzf((String)object2);
            zzdpy.zzi(zzbrs2, 0);
            return;
        }
        if (((zzdpy)object2).zze) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Instream ad should not be used again.");
            zzdpy.zzi(zzbrs2, 1);
            return;
        }
        ((zzdpy)object2).zze = true;
        super.zzg();
        object = ObjectWrapper.unwrap((IObjectWrapper)object);
        object = (ViewGroup)object;
        view = ((zzdpy)object2).zza;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        object.addView(view, layoutParams);
        zzs.zzz();
        zzchf.zza(((zzdpy)object2).zza, (ViewTreeObserver.OnGlobalLayoutListener)object2);
        zzs.zzz();
        zzchf.zzb(((zzdpy)object2).zza, (ViewTreeObserver.OnScrollChangedListener)object2);
        super.zzh();
        try {
            zzbrs2.zze();
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzdpx zzdpx2 = new zzdpx(this);
        this.zzd(iObjectWrapper, (zzbrs)zzdpx2);
    }

    public final zzbgu zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    public final zzblt zzf() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdlx zzdlx2 = this.zzc;
        if (zzdlx2 != null && zzdlx2.zzH() != null) {
            return this.zzc.zzH().zza();
        }
        return null;
    }

    public final void zzc() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzg();
        zzdlx zzdlx2 = this.zzc;
        if (zzdlx2 != null) {
            ((zzcww)zzdlx2).zzT();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view = this.zza;
        if (view == null) {
            return;
        }
        if ((view = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)view).removeView(this.zza);
            return;
        }
    }

    public final void onGlobalLayout() {
        this.zzh();
    }

    public final void onScrollChanged() {
        this.zzh();
    }

    @Override
    public final void zza() {
        zzfjz zzfjz2 = zzr.zza;
        zzdpw zzdpw2 = new zzdpw(this);
        zzfjz2.post((Runnable)zzdpw2);
    }

    private final void zzh() {
        View view;
        zzdlx zzdlx2 = this.zzc;
        if (zzdlx2 != null && (view = this.zza) != null) {
            zzdlx2.zzp(view, Collections.emptyMap(), Collections.emptyMap(), zzdlx.zzA(this.zza));
            return;
        }
    }

    private static final void zzi(zzbrs zzbrs2, int n) {
        try {
            zzbrs2.zzf(n);
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

