/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzfhh;
import com.google.android.gms.internal.ads.zzfhj;
import com.google.android.gms.internal.ads.zzfhp;
import com.google.android.gms.internal.ads.zzfhu;
import com.google.android.gms.internal.ads.zzfhv;
import com.google.android.gms.internal.ads.zzfhw;
import com.google.android.gms.internal.ads.zzfhx;
import com.google.android.gms.internal.ads.zzfhy;
import com.google.android.gms.internal.ads.zzfhz;
import com.google.android.gms.internal.ads.zzjx;
import com.google.android.gms.internal.ads.zzkl;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzfia {
    private final Context zza;
    private final Executor zzb;
    private final zzfhh zzc;
    private final zzfhj zzd;
    private final zzfhz zze;
    private final zzfhz zzf;
    private Task<zzkl> zzg;
    private Task<zzkl> zzh;

    @VisibleForTesting
    zzfia(Context context, Executor executor, zzfhh zzfhh2, zzfhj zzfhj2, zzfhx zzfhx2, zzfhy zzfhy2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzfhh2;
        this.zzd = zzfhj2;
        this.zze = zzfhx2;
        this.zzf = zzfhy2;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static zzfia zza(@NonNull Context object, @NonNull Executor executor, @NonNull zzfhh zzfhh2, @NonNull zzfhj zzfhj2) {
        void var3_6;
        void var2_5;
        void var1_4;
        zzfhx zzfhx2 = new zzfhx();
        zzfhy zzfhy2 = new zzfhy();
        zzfia zzfia2 = new zzfia((Context)object, (Executor)var1_4, (zzfhh)var2_5, (zzfhj)var3_6, zzfhx2, zzfhy2);
        if (zzfia2.zzd.zzb()) {
            zzfhu zzfhu2 = new zzfhu(zzfia2);
            zzfia2.zzg = zzfia2.zzg(zzfhu2);
        } else {
            zzfia2.zzg = Tasks.forResult((Object)zzfia2.zze.zza());
        }
        zzfhv zzfhv2 = new zzfhv(zzfia2);
        zzfia2.zzh = zzfia2.zzg(zzfhv2);
        return zzfia2;
    }

    public final zzkl zzb() {
        return zzfia.zzh(this.zzg, this.zze.zza());
    }

    public final zzkl zzc() {
        return zzfia.zzh(this.zzh, this.zzf.zza());
    }

    private final Task<zzkl> zzg(@NonNull Callable<zzkl> task) {
        Executor executor = this.zzb;
        task = Tasks.call((Executor)executor, task);
        executor = this.zzb;
        zzfhw zzfhw2 = new zzfhw(this);
        return task.addOnFailureListener(executor, (OnFailureListener)zzfhw2);
    }

    private static zzkl zzh(@NonNull Task<zzkl> task, @NonNull zzkl zzkl2) {
        if (!task.isSuccessful()) {
            return zzkl2;
        }
        return (zzkl)task.getResult();
    }

    final /* synthetic */ void zzd(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzc(2025, -1L, exception);
    }

    final /* synthetic */ zzkl zze() throws Exception {
        zzfia zzfia2 = zzfia2.zza;
        PackageManager packageManager = zzfia2.getPackageManager();
        String string2 = zzfia2.getPackageName();
        packageManager = packageManager.getPackageInfo(string2, 0);
        return zzfhp.zza((Context)zzfia2, zzfia2.getPackageName(), Integer.toString(packageManager.versionCode));
    }

    final /* synthetic */ zzkl zzf() throws Exception {
        Object object = ((zzfia)object).zza;
        zzjx zzjx2 = zzkl.zzi();
        AdvertisingIdClient advertisingIdClient = new AdvertisingIdClient((Context)object);
        advertisingIdClient.start();
        advertisingIdClient = advertisingIdClient.getInfo();
        object = advertisingIdClient.getId();
        if (object != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzjx2.zzS((String)object);
            zzjx2.zzT(advertisingIdClient.isLimitAdTrackingEnabled());
            zzjx2.zzaa(6);
        }
        return (zzkl)zzjx2.zzah();
    }
}

