/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzfun;
import com.google.android.gms.internal.ads.zzfvt;
import com.google.android.gms.internal.ads.zzgcf;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Mac;

public final class zzgcg
implements zzfvt {
    private final ThreadLocal<Mac> zza;
    private final String zzb;
    private final Key zzc;
    private final int zzd;

    /*
     * Enabled aggressive block sorting
     */
    public zzgcg(String string2, Key key) throws GeneralSecurityException {
        block18: {
            Object object;
            block17: {
                int n;
                block16: {
                    zzgcf zzgcf2;
                    ((zzgcg)object).zza = zzgcf2 = new zzgcf((zzgcg)object);
                    if (!zzfun.zza(2)) {
                        object = new GeneralSecurityException("Can not use HMAC in FIPS-mode, as BoringCrypto module is not available.");
                        throw object;
                    }
                    ((zzgcg)object).zzb = string2;
                    ((zzgcg)object).zzc = key;
                    if (key.getEncoded().length < 16) {
                        object = new InvalidAlgorithmParameterException("key size too small, need at least 16 bytes");
                        throw object;
                    }
                    switch (string2.hashCode()) {
                        case 392317873: {
                            if (!string2.equals("HMACSHA512")) break;
                            n = 4;
                            break block16;
                        }
                        case 392316170: {
                            if (!string2.equals("HMACSHA384")) break;
                            n = 3;
                            break block16;
                        }
                        case 392315118: {
                            if (!string2.equals("HMACSHA256")) break;
                            n = 2;
                            break block16;
                        }
                        case 392315023: {
                            if (!string2.equals("HMACSHA224")) break;
                            n = 1;
                            break block16;
                        }
                        case -1823053428: {
                            if (!string2.equals("HMACSHA1")) break;
                            n = 0;
                            break block16;
                        }
                    }
                    n = -1;
                }
                switch (n) {
                    default: {
                        object = "unknown Hmac algorithm: ";
                        if (string2.length() == 0) break block17;
                        object = ((String)object).concat(string2);
                        break block18;
                    }
                    case 4: {
                        ((zzgcg)object).zzd = 64;
                        break;
                    }
                    case 3: {
                        ((zzgcg)object).zzd = 48;
                        break;
                    }
                    case 2: {
                        ((zzgcg)object).zzd = 32;
                        break;
                    }
                    case 1: {
                        ((zzgcg)object).zzd = 28;
                        break;
                    }
                    case 0: {
                        ((zzgcg)object).zzd = 20;
                        break;
                    }
                }
                ((zzgcg)object).zza.get();
                return;
            }
            string2 = new String((String)object);
            object = string2;
        }
        NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException((String)object);
        throw noSuchAlgorithmException;
    }

    @Override
    public final byte[] zza(byte[] byArray, int n) throws GeneralSecurityException {
        if (n > ((zzgcg)object).zzd) {
            Object object = new InvalidAlgorithmParameterException("tag size too big");
            throw object;
        }
        ((zzgcg)object).zza.get().update(byArray);
        return Arrays.copyOf(((zzgcg)object).zza.get().doFinal(), n);
    }

    static /* synthetic */ String zzb(zzgcg zzgcg2) {
        return zzgcg2.zzb;
    }

    static /* synthetic */ Key zzc(zzgcg zzgcg2) {
        return zzgcg2.zzc;
    }
}

