/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.content.ContextWrapper;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.View;
import com.google.android.gms.internal.ads.zzgcu;
import com.google.android.gms.internal.ads.zzla;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.UUID;

public final class zzng {
    private static final char[] zza = "0123456789abcdef".toCharArray();

    public static String zza(String object) {
        if (object != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            return zzla.zza(byArray, true);
        }
        return object;
    }

    public static String zzb(byte[] object) {
        int n = ((byte[])object).length;
        char[] cArray = new char[n + n];
        for (n = 0; n < ((byte[])object).length; ++n) {
            int n2 = object[n] & 0xFF;
            int n3 = n + n;
            cArray[n3] = zza[n2 >>> 4];
            cArray[n3 + 1] = zza[n2 & 0xF];
        }
        object = new String;
        object(cArray);
        return object;
    }

    public static byte[] zzc(String object) {
        int n = ((String)object).length();
        if (n % 2 != 0) {
            object = new IllegalArgumentException("String must be of even-length");
            throw object;
        }
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(((String)object).charAt(i), 16) << 4) + Character.digit(((String)object).charAt(i + 1), 16));
        }
        return byArray;
    }

    public static String zzd(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        zzgcu.zzc((Throwable)throwable, (PrintWriter)printWriter);
        return stringWriter.toString();
    }

    public static boolean zze(String string2) {
        return string2 == null || string2.isEmpty();
    }

    public static boolean zzf() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean zzg(DisplayMetrics displayMetrics) {
        return displayMetrics != null && displayMetrics.density != 0.0f;
    }

    public static long zzh(double d, int n, DisplayMetrics displayMetrics) {
        return Math.round(d / (double)displayMetrics.density);
    }

    public static Activity zzi(View view) {
        View view2 = view.getRootView();
        if (view2 != null) {
            view = view2;
        }
        view2 = view.getContext();
        for (int i = 0; view2 instanceof ContextWrapper && i < 10; ++i) {
            if (view2 instanceof Activity) {
                return (Activity)view2;
            }
            view2 = ((ContextWrapper)view2).getBaseContext();
        }
        return null;
    }
}

