/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.PowerManager;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.google.android.gms.internal.ads.zzmt;
import com.google.android.gms.internal.ads.zzmw;
import com.google.android.gms.internal.ads.zzng;
import com.google.android.gms.internal.ads.zzni;
import com.google.android.gms.internal.ads.zznj;
import java.lang.ref.WeakReference;

public final class zznk
implements View.OnAttachStateChangeListener,
ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
Application.ActivityLifecycleCallbacks {
    private static final Handler zza;
    private final Context zzb;
    private Application zzc;
    @Nullable
    private final PowerManager zzd;
    @Nullable
    private final KeyguardManager zze;
    private BroadcastReceiver zzf;
    private final zzmw zzg;
    private WeakReference<ViewTreeObserver> zzh;
    @Nullable
    private WeakReference<View> zzi;
    private zzmt zzj;
    private byte zzk = (byte)-1;
    private int zzl = -1;
    private long zzm = -3L;

    public zznk(Context context, zzmw object) {
        this.zzb = context.getApplicationContext();
        this.zzg = object;
        this.zzd = (PowerManager)this.zzb.getSystemService("power");
        this.zze = (KeyguardManager)this.zzb.getSystemService("keyguard");
        context = this.zzb;
        if (context instanceof Application) {
            context = (Application)context;
            this.zzc = context;
            super((Application)context, this);
            this.zzj = object;
        }
        this.zza(null);
    }

    final void zza(View view) {
        Object object = this.zzb();
        if (object != null) {
            object.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzi((View)object);
        }
        this.zzi = object = new WeakReference(view);
        if (view != null) {
            if (view.getWindowToken() != null || view.getWindowVisibility() != 8) {
                this.zzh(view);
            }
            view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
            this.zzm = -2L;
            return;
        }
        this.zzm = -3L;
    }

    @Nullable
    final View zzb() {
        WeakReference<View> weakReference = ((zznk)((Object)weakReference)).zzi;
        if (weakReference != null) {
            return (View)weakReference.get();
        }
        return null;
    }

    private final void zze() {
        Handler handler = zza;
        zzni zzni2 = new zzni(this);
        handler.post((Runnable)zzni2);
    }

    public final void onViewAttachedToWindow(View view) {
        this.zzl = -1;
        this.zzh(view);
        this.zzg();
    }

    public final void onViewDetachedFromWindow(View view) {
        this.zzl = -1;
        this.zzg();
        this.zze();
        this.zzi(view);
    }

    private final void zzf(Activity activity, int n) {
        if (this.zzi == null) {
            return;
        }
        if ((activity = activity.getWindow()) == null) {
            return;
        }
        activity = activity.peekDecorView();
        View view = this.zzb();
        if (view != null && activity != null && view.getRootView() == activity.getRootView()) {
            this.zzl = n;
            return;
        }
    }

    public final void onActivityCreated(Activity activity, Bundle bundle) {
        this.zzf(activity, 0);
        this.zzg();
    }

    public final void onActivityStarted(Activity activity) {
        this.zzf(activity, 0);
        this.zzg();
    }

    public final void onActivityResumed(Activity activity) {
        this.zzf(activity, 0);
        this.zzg();
        this.zze();
    }

    public final void onActivityPaused(Activity activity) {
        this.zzf(activity, 4);
        this.zzg();
    }

    public final void onActivityStopped(Activity activity) {
        this.zzg();
    }

    public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        this.zzg();
    }

    public final void onActivityDestroyed(Activity activity) {
        this.zzg();
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final long zzc() {
        if (this.zzm <= -2L && this.zzb() == null) {
            this.zzm = -3L;
        }
        return this.zzm;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzg() {
        long l;
        long l2;
        Object object;
        if (this.zzi == null) {
            return;
        }
        View view = this.zzb();
        if (view == null) {
            this.zzm = -3L;
            this.zzk = (byte)-1;
            return;
        }
        byte by = view.getVisibility() != 0 ? (byte)1 : 0;
        if (!view.isShown()) {
            by |= 2;
        }
        if ((object = this.zzd) != null && !object.isScreenOn()) {
            by |= 4;
        }
        if (!(this.zzg.zza() || (object = this.zze) != null && object.inKeyguardRestrictedInputMode() && (object = zzng.zzi(view)) != null && (object = (object = object.getWindow()) == null ? null : object.getAttributes()) != null && (object.flags & 0x80000) != 0)) {
            by |= 8;
        }
        if (!view.getGlobalVisibleRect((Rect)(object = new Rect()))) {
            by |= 0x10;
        }
        if (!view.getLocalVisibleRect((Rect)(object = new Rect()))) {
            by |= 0x20;
        }
        int n = view.getWindowVisibility();
        int n2 = this.zzl;
        if (n2 != -1) {
            n = n2;
        }
        if (n != 0) {
            by |= 0x40;
        }
        if (this.zzk == by) {
            return;
        }
        this.zzk = by;
        long l3 = by == 0 ? (l2 = SystemClock.elapsedRealtime()) : (l = -3L - (long)by);
        this.zzm = l3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void zzh(View view) {
        if ((view = view.getViewTreeObserver()).isAlive()) {
            WeakReference<View> weakReference = new WeakReference<View>(view);
            this.zzh = weakReference;
            view.addOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
            view.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }
        if (this.zzf == null) {
            view = new IntentFilter();
            view.addAction("android.intent.action.SCREEN_ON");
            view.addAction("android.intent.action.SCREEN_OFF");
            view.addAction("android.intent.action.USER_PRESENT");
            zznj zznj2 = new zznj(this);
            this.zzf = zznj2;
            this.zzb.registerReceiver(this.zzf, (IntentFilter)view);
        }
        if ((view = this.zzc) == null) return;
        try {
            view.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private final void zzi(View view) {
        try {
            ViewTreeObserver viewTreeObserver = this.zzh;
            if (viewTreeObserver != null) {
                boolean bl;
                if ((viewTreeObserver = (ViewTreeObserver)viewTreeObserver.get()) != null && (bl = viewTreeObserver.isAlive())) {
                    viewTreeObserver.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                    viewTreeObserver.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                }
                this.zzh = null;
            }
        }
        catch (Exception exception) {}
        try {
            view = view.getViewTreeObserver();
            boolean bl = view.isAlive();
            if (bl) {
                view.removeOnScrollChangedListener((ViewTreeObserver.OnScrollChangedListener)this);
                view.removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
            }
        }
        catch (Exception exception) {}
        if ((view = this.zzf) != null) {
            try {
                Context context = this.zzb;
                context.unregisterReceiver((BroadcastReceiver)view);
            }
            catch (Exception exception) {}
            this.zzf = null;
        }
        if ((view = this.zzc) == null) return;
        try {
            view.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zzj);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static /* synthetic */ void zzd(zznk zznk2) {
        zznk2.zzg();
    }

    static {
        Handler handler;
        zza = handler = new Handler(Looper.getMainLooper());
    }
}

