/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbhc;
import com.google.android.gms.internal.ads.zzblq;
import com.google.android.gms.internal.ads.zzbme;
import com.google.android.gms.internal.ads.zzbrz;
import com.google.android.gms.internal.ads.zzbsd;
import com.google.android.gms.internal.ads.zzcht;
import com.google.android.gms.internal.ads.zzcxg;
import com.google.android.gms.internal.ads.zzdmh;
import com.google.android.gms.internal.ads.zzdmm;
import com.google.android.gms.internal.ads.zzdqg;
import com.google.android.gms.internal.ads.zzdqh;
import com.google.android.gms.internal.ads.zzfla;
import java.util.Collections;

public final class zzdqi
extends zzbrz
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzblq {
    private View zza;
    private zzbhc zzb;
    private zzdmh zzc;
    private boolean zzd;
    private boolean zze;

    public zzdqi(zzdmh zzdmh2, zzdmm zzdmm2) {
        this.zza = zzdmm2.zzH();
        this.zzb = zzdmm2.zzw();
        this.zzc = zzdmh2;
        this.zzd = false;
        this.zze = false;
        if (zzdmm2.zzR() != null) {
            zzdmm2.zzR().zzaw(this);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzd(IObjectWrapper object, zzbsd zzbsd2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdqi)object2).zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Instream ad can not be shown after destroy().");
            zzdqi.zzi(zzbsd2, 2);
            return;
        }
        View view = ((zzdqi)object2).zza;
        if (view == null || ((zzdqi)object2).zzb == null) {
            Object object2 = view == null ? "can not get video view." : "can not get video controller.";
            object = "Instream internal error: ";
            object2 = ((String)object2).length() != 0 ? ((String)object).concat((String)object2) : new String((String)object);
            com.google.android.gms.ads.internal.util.zze.zzf((String)object2);
            zzdqi.zzi(zzbsd2, 0);
            return;
        }
        if (((zzdqi)object2).zze) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"Instream ad should not be used again.");
            zzdqi.zzi(zzbsd2, 1);
            return;
        }
        ((zzdqi)object2).zze = true;
        super.zzg();
        object = ObjectWrapper.unwrap((IObjectWrapper)object);
        object = (ViewGroup)object;
        view = ((zzdqi)object2).zza;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        object.addView(view, layoutParams);
        zzt.zzz();
        zzcht.zza(((zzdqi)object2).zza, (ViewTreeObserver.OnGlobalLayoutListener)object2);
        zzt.zzz();
        zzcht.zzb(((zzdqi)object2).zza, (ViewTreeObserver.OnScrollChangedListener)object2);
        super.zzh();
        try {
            zzbsd2.zze();
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzdqh zzdqh2 = new zzdqh(this);
        this.zzd(iObjectWrapper, (zzbsd)zzdqh2);
    }

    public final zzbhc zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    public final zzbme zzf() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzf((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdmh zzdmh2 = this.zzc;
        if (zzdmh2 != null && zzdmh2.zzJ() != null) {
            return this.zzc.zzJ().zza();
        }
        return null;
    }

    public final void zzc() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzg();
        zzdmh zzdmh2 = this.zzc;
        if (zzdmh2 != null) {
            ((zzcxg)zzdmh2).zzT();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view = this.zza;
        if (view == null) {
            return;
        }
        if ((view = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)view).removeView(this.zza);
            return;
        }
    }

    public final void onGlobalLayout() {
        this.zzh();
    }

    public final void onScrollChanged() {
        this.zzh();
    }

    @Override
    public final void zza() {
        zzfla zzfla2 = zzs.zza;
        zzdqg zzdqg2 = new zzdqg(this);
        zzfla2.post((Runnable)zzdqg2);
    }

    private final void zzh() {
        View view;
        zzdmh zzdmh2 = this.zzc;
        if (zzdmh2 != null && (view = this.zza) != null) {
            zzdmh2.zzr(view, Collections.emptyMap(), Collections.emptyMap(), zzdmh.zzC(this.zza));
            return;
        }
    }

    private static final void zzi(zzbsd zzbsd2, int n) {
        try {
            zzbsd2.zzf(n);
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

