/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.os.RemoteException;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.dynamic.IObjectWrapper;
import com.google.android.gms.dynamic.ObjectWrapper;
import com.google.android.gms.internal.ads.zzbiz;
import com.google.android.gms.internal.ads.zzbnt;
import com.google.android.gms.internal.ads.zzbof;
import com.google.android.gms.internal.ads.zzbub;
import com.google.android.gms.internal.ads.zzbuf;
import com.google.android.gms.internal.ads.zzcjz;
import com.google.android.gms.internal.ads.zzdav;
import com.google.android.gms.internal.ads.zzdpx;
import com.google.android.gms.internal.ads.zzdqc;
import com.google.android.gms.internal.ads.zzdtx;
import java.util.Collections;

public final class zzdty
extends zzbub
implements ViewTreeObserver.OnGlobalLayoutListener,
ViewTreeObserver.OnScrollChangedListener,
zzbnt {
    private View zza;
    private zzbiz zzb;
    private zzdpx zzc;
    private boolean zzd;
    private boolean zze;

    public final zzbiz zzb() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        return this.zzb;
    }

    public final zzbof zzc() {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (this.zzd) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"getVideoController: Instream ad should not be used after destroyed");
            return null;
        }
        zzdpx zzdpx2 = this.zzc;
        if (zzdpx2 != null && zzdpx2.zza() != null) {
            return this.zzc.zza().zza();
        }
        return null;
    }

    public zzdty(zzdpx zzdpx2, zzdqc zzdqc2) {
        this.zza = zzdqc2.zzf();
        this.zzb = zzdqc2.zzj();
        this.zzc = zzdpx2;
        this.zzd = false;
        this.zze = false;
        if (zzdqc2.zzr() != null) {
            zzdqc2.zzr().zzao(this);
            return;
        }
    }

    public final void zzd() throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        this.zzh();
        zzdpx zzdpx2 = this.zzc;
        if (zzdpx2 != null) {
            ((zzdav)zzdpx2).zzT();
        }
        this.zzc = null;
        this.zza = null;
        this.zzb = null;
        this.zzd = true;
    }

    private final void zzg() {
        View view;
        zzdpx zzdpx2 = this.zzc;
        if (zzdpx2 != null && (view = this.zza) != null) {
            zzdpx2.zzv(view, Collections.emptyMap(), Collections.emptyMap(), zzdpx.zzP(this.zza));
            return;
        }
    }

    private final void zzh() {
        View view = this.zza;
        if (view == null) {
            return;
        }
        if ((view = view.getParent()) instanceof ViewGroup) {
            ((ViewGroup)view).removeView(this.zza);
            return;
        }
    }

    public final void onGlobalLayout() {
        this.zzg();
    }

    public final void onScrollChanged() {
        this.zzg();
    }

    public final void zze(IObjectWrapper iObjectWrapper) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        zzdtx zzdtx2 = new zzdtx(this);
        this.zzf(iObjectWrapper, (zzbuf)zzdtx2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzf(IObjectWrapper object, zzbuf zzbuf2) throws RemoteException {
        Preconditions.checkMainThread((String)"#008 Must be called on the main UI thread.");
        if (((zzdty)object2).zzd) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Instream ad can not be shown after destroy().");
            zzdty.zzi(zzbuf2, 2);
            return;
        }
        View view = ((zzdty)object2).zza;
        if (view == null || ((zzdty)object2).zzb == null) {
            Object object2 = view == null ? "can not get video view." : "can not get video controller.";
            object = "Instream internal error: ";
            object2 = ((String)object2).length() != 0 ? ((String)object).concat((String)object2) : new String((String)object);
            com.google.android.gms.ads.internal.util.zze.zzg((String)object2);
            zzdty.zzi(zzbuf2, 0);
            return;
        }
        if (((zzdty)object2).zze) {
            com.google.android.gms.ads.internal.util.zze.zzg((String)"Instream ad should not be used again.");
            zzdty.zzi(zzbuf2, 1);
            return;
        }
        ((zzdty)object2).zze = true;
        super.zzh();
        object = ObjectWrapper.unwrap((IObjectWrapper)object);
        object = (ViewGroup)object;
        view = ((zzdty)object2).zza;
        ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(-1, -1);
        object.addView(view, layoutParams);
        zzt.zzx();
        zzcjz.zza(((zzdty)object2).zza, (ViewTreeObserver.OnGlobalLayoutListener)object2);
        zzt.zzx();
        zzcjz.zzb(((zzdty)object2).zza, (ViewTreeObserver.OnScrollChangedListener)object2);
        super.zzg();
        try {
            zzbuf2.zzf();
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }

    private static final void zzi(zzbuf zzbuf2, int n) {
        try {
            zzbuf2.zze(n);
            return;
        }
        catch (RemoteException remoteException) {
            com.google.android.gms.ads.internal.util.zze.zzl((String)"#007 Could not call remote method.", (Throwable)remoteException);
            return;
        }
    }
}

