/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzghc;
import com.google.android.gms.internal.ads.zzghz;
import com.google.android.gms.internal.ads.zzgig;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

abstract class zzghe
implements zzghz {
    private static final int[] zzb;
    int[] zza;
    private final int zzc;

    abstract int zzb();

    final ByteBuffer zzd(byte[] objectArray, int n) {
        objectArray = this.zzc(zzghe.zzi(objectArray), n);
        int[] nArray = (int[])objectArray.clone();
        zzghe.zzh(nArray);
        for (int i = 0; i < 16; ++i) {
            objectArray[i] = objectArray[i] + nArray[i];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put((int[])objectArray, 0, 16);
        return byteBuffer;
    }

    static {
        byte[] byArray = new byte[]{101, 120, 112, 97, 110, 100, 32, 51, 50, 45, 98, 121, 116, 101, 32, 107};
        zzb = zzghe.zzi(byArray);
    }

    zzghe(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length != 32) {
            Object object = new InvalidKeyException("The key length in bytes must be 32.");
            throw object;
        }
        ((zzghe)object).zza = zzghe.zzi(byArray);
        ((zzghe)object).zzc = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zze(ByteBuffer byteBuffer, byte[] byArray) throws GeneralSecurityException {
        if (byteBuffer.remaining() - ((zzghe)object).zzb() < byArray.length) {
            Object object = new IllegalArgumentException("Given ByteBuffer output is too small");
            throw object;
        }
        byte[] byArray2 = zzgig.zza(((zzghe)object).zzb());
        byteBuffer.put(byArray2);
        ByteBuffer byteBuffer2 = ByteBuffer.wrap(byArray);
        int n = byteBuffer2.remaining();
        int n2 = n / 64 + 1;
        int n3 = 0;
        while (n3 < n2) {
            ByteBuffer byteBuffer3 = ((zzghe)object).zzd(byArray2, n3 + ((zzghe)object).zzc);
            if (n3 == n2 + -1) {
                zzghc.zza(byteBuffer, byteBuffer2, byteBuffer3, n % 64);
            } else {
                zzghc.zza(byteBuffer, byteBuffer2, byteBuffer3, 64);
            }
            ++n3;
        }
        return;
    }

    static void zzf(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        nArray[n] = n5 = nArray[n] + nArray[n2];
        n5 = nArray[n4] ^ n5;
        nArray[n4] = n5 = n5 << 16 | n5 >>> -16;
        nArray[n3] = n5 = nArray[n3] + n5;
        n5 = nArray[n2] ^ n5;
        nArray[n2] = n5 = n5 << 12 | n5 >>> -12;
        nArray[n] = n5 = nArray[n] + n5;
        n = nArray[n4] ^ n5;
        nArray[n4] = n = n << 8 | n >>> -8;
        nArray[n3] = n = nArray[n3] + n;
        n = nArray[n2] ^ n;
        nArray[n2] = n << 7 | n >>> -7;
    }

    static void zzg(int[] nArray, int[] nArray2) {
        System.arraycopy(zzb, 0, nArray, 0, zzb.length);
        System.arraycopy(nArray2, 0, nArray, zzb.length, 8);
    }

    static void zzh(int[] nArray) {
        for (int i = 0; i < 10; ++i) {
            zzghe.zzf(nArray, 0, 4, 8, 12);
            zzghe.zzf(nArray, 1, 5, 9, 13);
            zzghe.zzf(nArray, 2, 6, 10, 14);
            zzghe.zzf(nArray, 3, 7, 11, 15);
            zzghe.zzf(nArray, 0, 5, 10, 15);
            zzghe.zzf(nArray, 1, 6, 11, 12);
            zzghe.zzf(nArray, 2, 7, 8, 13);
            zzghe.zzf(nArray, 3, 4, 9, 14);
        }
    }

    @Override
    public final byte[] zza(byte[] byArray) throws GeneralSecurityException {
        int n = byArray.length;
        if (n > Integer.MAX_VALUE - ((zzghe)object).zzb()) {
            Object object = new GeneralSecurityException("plaintext too long");
            throw object;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(((zzghe)object).zzb() + n);
        ((zzghe)object).zze(byteBuffer, byArray);
        return byteBuffer.array();
    }

    abstract int[] zzc(int[] var1, int var2);

    static int[] zzi(byte[] object) {
        object = ByteBuffer.wrap((byte[])object).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int[] nArray = new int[((Buffer)object).remaining()];
        ((IntBuffer)object).get(nArray);
        return nArray;
    }
}

