/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.ads.nonagon.signalgeneration;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.android.gms.ads.AdFormat;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.internal.util.client.zzm;
import com.google.android.gms.ads.internal.zzu;
import com.google.android.gms.ads.nonagon.signalgeneration.zzay;
import com.google.android.gms.ads.nonagon.signalgeneration.zzaz;
import com.google.android.gms.ads.nonagon.signalgeneration.zzba;
import com.google.android.gms.ads.nonagon.signalgeneration.zzbb;
import com.google.android.gms.ads.nonagon.signalgeneration.zzbe;
import com.google.android.gms.ads.nonagon.signalgeneration.zze;
import com.google.android.gms.ads.nonagon.signalgeneration.zzp;
import com.google.android.gms.ads.query.QueryInfo;
import com.google.android.gms.ads.query.QueryInfoGenerationCallback;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.ads.zzaxd;
import com.google.android.gms.internal.ads.zzaxe;
import com.google.android.gms.internal.ads.zzbeg;
import com.google.android.gms.internal.ads.zzbep;
import com.google.android.gms.internal.ads.zzbgp;
import com.google.android.gms.internal.ads.zzcci;
import com.google.android.gms.internal.ads.zzdvh;
import com.google.android.gms.internal.ads.zzfhs;
import com.google.android.gms.internal.ads.zzfoe;
import com.google.android.gms.internal.ads.zzgge;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.json.JSONException;
import org.json.JSONObject;

final class TaggingLibraryJsInterface {
    private final Context zza;
    private final WebView zzb;
    private final zzaxd zzc;
    private final zzfhs zzd;
    private final int zze;
    private final zzdvh zzf;
    private final boolean zzg;
    private final zzgge zzh = zzcci.zze;
    private final zzfoe zzi;
    private final zze zzj;

    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getClickSignals(String clickString) {
        String string2;
        block4: {
            long l;
            try {
                l = zzu.zzB().currentTimeMillis();
                string2 = this.zzc.zzc().zze(this.zza, string2, (View)this.zzb);
                boolean bl = this.zzg;
                if (!bl) break block4;
            }
            catch (RuntimeException runtimeException) {
                zzm.zzh((String)"Exception getting click signals. ", (Throwable)runtimeException);
                string2 = "TaggingLibraryJsInterface.getClickSignals";
                zzu.zzo().zzw(runtimeException, string2);
                return "";
            }
            long l2 = zzu.zzB().currentTimeMillis();
            long l3 = l2 - l;
            zzp.zzd(this.zzf, null, "csg", new Pair((Object)"clat", (Object)String.valueOf(l3)));
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getClickSignalsWithTimeout(String clickString, int timeoutMs) {
        String string2;
        void var2_3;
        if (timeoutMs <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid timeout for getting click signals. Timeout=");
            stringBuilder.append((int)var2_3);
            zzm.zzg((String)stringBuilder.toString());
            return "";
        }
        Object object = zzcci.zza.zzb(new zzba((TaggingLibraryJsInterface)object, string2));
        long l = Math.min((int)var2_3, ((TaggingLibraryJsInterface)object).zze);
        try {
            object = (String)object.get(l, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            zzm.zzh((String)"Exception getting click signals with timeout. ", (Throwable)exception);
            string2 = "TaggingLibraryJsInterface.getClickSignalsWithTimeout";
            zzu.zzo().zzw(exception, string2);
            if (exception instanceof TimeoutException) {
                return "17";
            }
            return "";
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getQueryInfo() {
        zzu.zzp();
        String string2 = UUID.randomUUID().toString();
        Bundle bundle = new Bundle();
        bundle.putString("query_info_type", "requester_type_6");
        zzbe zzbe2 = new zzbe(this, string2);
        if (((Boolean)zzbgp.zza.zze()).booleanValue()) {
            this.zzj.zzg(this.zzb, zzbe2);
            return string2;
        }
        zzbeg zzbeg2 = zzbep.zzjF;
        if (((Boolean)com.google.android.gms.ads.internal.client.zzba.zzc().zza(zzbeg2)).booleanValue()) {
            this.zzh.execute(new zzbb(this, bundle, zzbe2));
            return string2;
        }
        QueryInfo.generate((Context)this.zza, (AdFormat)AdFormat.BANNER, (AdRequest)((AdRequest.Builder)new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, bundle)).build(), (QueryInfoGenerationCallback)zzbe2);
        return string2;
    }

    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getViewSignals() {
        String string2;
        block4: {
            long l;
            try {
                l = zzu.zzB().currentTimeMillis();
                string2 = this.zzc.zzc().zzh(this.zza, (View)this.zzb, null);
                boolean bl = this.zzg;
                if (!bl) break block4;
            }
            catch (RuntimeException runtimeException) {
                zzm.zzh((String)"Exception getting view signals. ", (Throwable)runtimeException);
                string2 = "TaggingLibraryJsInterface.getViewSignals";
                zzu.zzo().zzw(runtimeException, string2);
                return "";
            }
            long l2 = zzu.zzB().currentTimeMillis();
            long l3 = l2 - l;
            zzp.zzd(this.zzf, null, "vsg", new Pair((Object)"vlat", (Object)String.valueOf(l3)));
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public String getViewSignalsWithTimeout(int timeoutMs) {
        void var1_2;
        if (timeoutMs <= 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Invalid timeout for getting view signals. Timeout=");
            stringBuilder.append((int)var1_2);
            zzm.zzg((String)stringBuilder.toString());
            return "";
        }
        Object object = zzcci.zza.zzb(new zzay((TaggingLibraryJsInterface)object));
        long l = Math.min((int)var1_2, ((TaggingLibraryJsInterface)object).zze);
        try {
            object = (String)object.get(l, TimeUnit.MILLISECONDS);
            return object;
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            zzm.zzh((String)"Exception getting view signals with timeout. ", (Throwable)exception);
            String string2 = "TaggingLibraryJsInterface.getViewSignalsWithTimeout";
            zzu.zzo().zzw(exception, string2);
            if (exception instanceof TimeoutException) {
                return "17";
            }
            return "";
        }
    }

    /*
     * WARNING - void declaration
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public void recordClick(String clickUrl) {
        void var1_1;
        zzbeg zzbeg2 = zzbep.zzjH;
        if (!((Boolean)com.google.android.gms.ads.internal.client.zzba.zzc().zza(zzbeg2)).booleanValue() || TextUtils.isEmpty((CharSequence)var1_1)) {
            return;
        }
        zzcci.zza.execute(new zzaz(this, (String)var1_1));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JavascriptInterface
    @KeepForSdk
    @TargetApi(value=21)
    public void reportTouchEvent(String touchJson) {
        String string2;
        JSONObject jSONObject = new JSONObject(string2);
        int n = jSONObject.getInt("x");
        int n2 = jSONObject.getInt("y");
        int n3 = jSONObject.getInt("duration_ms");
        double d = jSONObject.getDouble("force");
        float f = (float)d;
        int n4 = jSONObject.getInt("type");
        switch (n4) {
            default: {
                n4 = -1;
                break;
            }
            case 3: {
                n4 = 3;
                break;
            }
            case 2: {
                n4 = 2;
                break;
            }
            case 1: {
                n4 = 1;
                break;
            }
            case 0: {
                n4 = 0;
            }
        }
        try {
            MotionEvent motionEvent = MotionEvent.obtain((long)0L, (long)n3, (int)n4, (float)n, (float)n2, (float)f, (float)1.0f, (int)0, (float)1.0f, (float)1.0f, (int)0, (int)0);
            this.zzc.zzd(motionEvent);
            return;
        }
        catch (RuntimeException | JSONException throwable) {
            zzm.zzh((String)"Failed to parse the touch string. ", (Throwable)throwable);
            string2 = "TaggingLibraryJsInterface.reportTouchEvent";
            zzu.zzo().zzw(throwable, string2);
            return;
        }
    }

    static /* bridge */ /* synthetic */ WebView zza(TaggingLibraryJsInterface taggingLibraryJsInterface) {
        return taggingLibraryJsInterface.zzb;
    }

    static /* bridge */ /* synthetic */ zzgge zzb(TaggingLibraryJsInterface taggingLibraryJsInterface) {
        return taggingLibraryJsInterface.zzh;
    }

    TaggingLibraryJsInterface(WebView webView, zzaxd zzaxd2, zzdvh zzdvh2, zzfoe zzfoe2, zzfhs zzfhs2, zze zze2) {
        this.zzb = webView;
        this.zza = webView.getContext();
        this.zzc = zzaxd2;
        this.zzf = zzdvh2;
        zzbep.zza((Context)this.zza);
        webView = zzbep.zzjC;
        this.zze = (Integer)com.google.android.gms.ads.internal.client.zzba.zzc().zza((zzbeg)webView);
        webView = zzbep.zzjD;
        this.zzg = (Boolean)com.google.android.gms.ads.internal.client.zzba.zzc().zza((zzbeg)webView);
        this.zzi = zzfoe2;
        this.zzd = zzfhs2;
        this.zzj = zze2;
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzc(Bundle bundle, QueryInfoGenerationCallback queryInfoGenerationCallback) {
        CookieManager cookieManager = zzu.zzq().zza(this.zza);
        boolean bl = cookieManager != null ? cookieManager.acceptThirdPartyCookies(this.zzb) : false;
        bundle.putBoolean("accept_3p_cookie", bl);
        QueryInfo.generate((Context)this.zza, (AdFormat)AdFormat.BANNER, (AdRequest)((AdRequest.Builder)new AdRequest.Builder().addNetworkExtrasBundle(AdMobAdapter.class, bundle)).build(), (QueryInfoGenerationCallback)queryInfoGenerationCallback);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ void zzd(String string2) {
        string2 = Uri.parse((String)string2);
        try {
            zzfhs zzfhs2;
            zzbeg zzbeg2 = zzbep.zzlW;
            Object object = com.google.android.gms.ads.internal.client.zzba.zzc().zza(zzbeg2);
            boolean bl = (Boolean)object;
            if (bl && (zzfhs2 = this.zzd) != null) {
                string2 = zzfhs2.zza((Uri)string2, this.zza, (View)this.zzb, null);
            } else {
                zzaxd zzaxd2 = this.zzc;
                Context context = this.zza;
                WebView webView = this.zzb;
                string2 = zzaxd2.zza((Uri)string2, context, (View)webView, null);
            }
        }
        catch (zzaxe zzaxe2) {
            zzm.zzf((String)"Failed to append the click signal to URL: ", (Throwable)zzaxe2);
            String string3 = "TaggingLibraryJsInterface.recordClick";
            zzu.zzo().zzw(zzaxe2, string3);
        }
        this.zzi.zzc(string2.toString(), null);
    }
}

