/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgiv;
import com.google.android.gms.internal.ads.zzgix;
import com.google.android.gms.internal.ads.zzgiy;
import com.google.android.gms.internal.ads.zzgja;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import javax.annotation.Nullable;

public final class zzgiw {
    @Nullable
    private Integer zza = null;
    @Nullable
    private Integer zzb = null;
    @Nullable
    private Integer zzc = null;
    @Nullable
    private Integer zzd = null;
    private zzgix zze = null;
    private zzgiy zzf = zzgiy.zzc;

    public final zzgiw zza(int n) throws GeneralSecurityException {
        if (n != 16 && n != 24 && n != 32) {
            Object[] objectArray = new Object[]{n};
            throw new InvalidAlgorithmParameterException(String.format("Invalid key size %d; only 16-byte, 24-byte and 32-byte AES keys are supported", objectArray));
        }
        objectArray.zza = n;
        return objectArray;
    }

    public final zzgiw zzb(zzgix zzgix2) {
        this.zze = zzgix2;
        return this;
    }

    public final zzgiw zzc(int n) throws GeneralSecurityException {
        if (n < 16) {
            Object[] objectArray = new Object[]{n};
            throw new InvalidAlgorithmParameterException(String.format("Invalid key size in bytes %d; HMAC key must be at least 16 bytes", objectArray));
        }
        objectArray.zzb = n;
        return objectArray;
    }

    public final zzgiw zzd(int n) throws GeneralSecurityException {
        if (n < 12 || n > 16) {
            Object[] objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid IV size in bytes %d; IV size must be between 12 and 16 bytes", objectArray));
        }
        objectArray.zzc = n;
        return objectArray;
    }

    public final zzgiw zze(int n) throws GeneralSecurityException {
        if (n < 10) {
            Object[] objectArray = new Object[]{n};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; must be at least 10 bytes", objectArray));
        }
        objectArray.zzd = n;
        return objectArray;
    }

    public final zzgiw zzf(zzgiy zzgiy2) {
        this.zzf = zzgiy2;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzgja zzg() throws GeneralSecurityException {
        Object[] objectArray;
        if (objectArray.zza == null) {
            throw new GeneralSecurityException("AES key size is not set");
        }
        if (objectArray.zzb == null) {
            throw new GeneralSecurityException("HMAC key size is not set");
        }
        if (objectArray.zzc == null) {
            throw new GeneralSecurityException("iv size is not set");
        }
        Integer n = objectArray.zzd;
        if (n == null) {
            throw new GeneralSecurityException("tag size is not set");
        }
        if (objectArray.zze == null) {
            throw new GeneralSecurityException("hash type is not set");
        }
        if (objectArray.zzf == null) {
            throw new GeneralSecurityException("variant is not set");
        }
        int n2 = n;
        zzgix zzgix2 = objectArray.zze;
        if (zzgix2 == zzgix.zza) {
            if (n2 <= 20) return new zzgja(objectArray.zza, objectArray.zzb, objectArray.zzc, objectArray.zzd, objectArray.zzf, objectArray.zze, null);
            objectArray = new Object[]{n2};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 20 bytes for SHA1", objectArray));
        }
        if (zzgix2 == zzgix.zzb) {
            if (n2 <= 28) return new zzgja(objectArray.zza, objectArray.zzb, objectArray.zzc, objectArray.zzd, objectArray.zzf, objectArray.zze, null);
            objectArray = new Object[]{n2};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 28 bytes for SHA224", objectArray));
        }
        if (zzgix2 == zzgix.zzc) {
            if (n2 <= 32) return new zzgja(objectArray.zza, objectArray.zzb, objectArray.zzc, objectArray.zzd, objectArray.zzf, objectArray.zze, null);
            objectArray = new Object[]{n2};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 32 bytes for SHA256", objectArray));
        }
        if (zzgix2 == zzgix.zzd) {
            if (n2 <= 48) return new zzgja(objectArray.zza, objectArray.zzb, objectArray.zzc, objectArray.zzd, objectArray.zzf, objectArray.zze, null);
            objectArray = new Object[]{n2};
            throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 48 bytes for SHA384", objectArray));
        }
        if (zzgix2 != zzgix.zze) {
            throw new GeneralSecurityException("unknown hash type; must be SHA1, SHA224, SHA256, SHA384 or SHA512");
        }
        if (n2 <= 64) {
            return new zzgja(objectArray.zza, objectArray.zzb, objectArray.zzc, objectArray.zzd, objectArray.zzf, objectArray.zze, null);
        }
        objectArray = new Object[]{n2};
        throw new GeneralSecurityException(String.format("Invalid tag size in bytes %d; can be at most 64 bytes for SHA512", objectArray));
    }

    private zzgiw() {
    }

    /* synthetic */ zzgiw(zzgiv zzgiv2) {
    }
}

