/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgoc;
import com.google.android.gms.internal.ads.zzgsz;
import com.google.android.gms.internal.ads.zzgts;
import com.google.android.gms.internal.ads.zzgyd;
import com.google.android.gms.internal.ads.zzgyn;
import com.google.android.gms.internal.ads.zzgzc;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public final class zzgyy
implements zzgts {
    private final SecretKey zza;
    private final byte[] zzb;
    private final byte[] zzc;

    private static Cipher zzb() throws GeneralSecurityException {
        if (!zzgoc.zza(1)) {
            throw new GeneralSecurityException("Can not use AES-CMAC in FIPS-mode.");
        }
        return (Cipher)zzgyn.zza.zza("AES/ECB/NoPadding");
    }

    public zzgyy(byte[] byArray) throws GeneralSecurityException {
        zzgzc.zza(byArray.length);
        String string2 = "AES";
        this.zza = new SecretKeySpec(byArray, string2);
        Cipher cipher = zzgyy.zzb();
        cipher.init(1, this.zza);
        this.zzb = zzgsz.zza(cipher.doFinal(new byte[16]));
        this.zzc = zzgsz.zza(this.zzb);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public final byte[] zza(byte[] byArray, int n) throws GeneralSecurityException {
        Object object;
        if (n > 16) {
            throw new InvalidAlgorithmParameterException("outputLength too large, max is 16 bytes");
        }
        SecretKey secretKey = ((zzgyy)object).zza;
        Cipher cipher = zzgyy.zzb();
        cipher.init(1, secretKey);
        int n2 = byArray.length;
        int n3 = Math.max(1, (int)Math.ceil((double)n2 / 16.0));
        int n4 = n3 + -1;
        int n5 = n4 * 16;
        if (n3 * 16 == n2) {
            object = zzgyd.zzd(byArray, n5, ((zzgyy)object).zzb, 0, 16);
        } else {
            byte[] byArray2 = Arrays.copyOfRange(byArray, n5, n2);
            if ((n5 = byArray2.length) >= 16) {
                throw new IllegalArgumentException("x must be smaller than a block.");
            }
            byte[] byArray3 = Arrays.copyOf(byArray2, 16);
            byArray3[n5] = -128;
            object = zzgyd.zzc(byArray3, ((zzgyy)object).zzc);
        }
        byte[] byArray4 = new byte[16];
        n5 = 0;
        while (n5 < n4) {
            byArray4 = cipher.doFinal(zzgyd.zzd(byArray4, 0, byArray, n5 * 16, 16));
            ++n5;
        }
        return Arrays.copyOf(cipher.doFinal(zzgyd.zzc((byte[])object, byArray4)), n);
    }
}

